<?php
/**
* Plugin Name: Minimum Checkout Amount for WooCommerce
* Plugin URI: https://aispdev.com/minimum-checkout-amount-for-woocommerce/
* Author URI: https://aispdev.com
* Description: Enforces a minimum checkout amount.
* Version: 1.2.3
* Author: AISP Dev
* Text Domain: minimum-checkout-amount
* License: GPLv2 or later
* License URI: https://www.gnu.org/licenses/gpl-2.0.html
* Requires Plugins: woocommerce
*/

if (!defined('ABSPATH')) {
    exit;
}


if (!in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')), true)) {
    add_action('admin_notices', function () {
        ?>
        <div class="notice notice-error">
            <p><?php esc_html_e('Minimum Checkout Amount requires WooCommerce to be installed and active.', 'minimum-checkout-amount'); ?></p>
        </div>
        <?php
    });
    return;
}



require_once plugin_dir_path(__FILE__) . 'includes/settings.php';   
require_once plugin_dir_path(__FILE__) . 'includes/notices.php';   
require_once plugin_dir_path(__FILE__) . 'includes/helpers.php';   


add_action( 'before_woocommerce_init', function() {
    if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility(
            'custom_order_tables',
            __FILE__,
            true
        );
    }
});


add_filter('woocommerce_admin_field_excluded_users_selector', 'minimumcheckoutaccount_render_user_selector_field');

function minimumcheckoutaccount_render_user_selector_field($value) {
    $selected_users = (array) get_option($value['id'], []);
    echo '<tr valign="top">';
    echo '<th scope="row" class="titledesc">';
    echo '<label for="' . esc_attr($value['id']) . '">' . esc_html($value['name']) . '</label>';
    echo '</th><td class="forminp">';

    echo '<select multiple name="' . esc_attr($value['id']) . '[]" id="' . esc_attr($value['id']) . '" class="wc-customer-search" data-placeholder="' . esc_attr__('Search users...', 'minimum-checkout-amount') . '" data-allow_clear="true" data-selected="' . esc_attr(json_encode($selected_users)) . '" style="min-width:300px;">';

    foreach ($selected_users as $user_id) {
        $user = get_user_by('ID', $user_id);
        if ($user) {
            echo '<option value="' . esc_attr($user->ID) . '" selected="selected">' . esc_html($user->display_name) . ' (ID: ' . esc_html($user->ID) . ')</option>';
        }
    }

    echo '</select>';
    echo '<p class="description">' . esc_html($value['desc']) . '</p>';
    echo '</td></tr>';
}



