<?php
if (!defined('ABSPATH')) {
    exit;
}


add_filter('woocommerce_settings_tabs_array', 'minimumcheckoutaccount_add_woocommerce_tab', 50);

function minimumcheckoutaccount_add_woocommerce_tab($tabs) {
    $tabs['minimum_checkout_amount'] = esc_html__('Minimum Checkout Amount', 'minimum-checkout-amount');
    return $tabs;
}


add_action('woocommerce_settings_tabs_minimum_checkout_amount', 'minimumcheckoutaccount_render_woocommerce_tab_content');

function minimumcheckoutaccount_render_woocommerce_tab_content() {
    woocommerce_admin_fields(minimumcheckoutaccount_get_settings());
}


function minimumcheckoutaccount_get_settings() {
    $settings = [
        'section_start' => [
            'name' => esc_html__('Minimum Checkout Amount Settings', 'minimum-checkout-amount'),
            'type' => 'title',
            'desc' => esc_html__('Configure the minimum checkout amount requirements.', 'minimum-checkout-amount'),
            'id' => 'minimumcheckoutaccount_section_start',
        ],
        'minimum_amount' => [
            'name' => esc_html__('Minimum Amount', 'minimum-checkout-amount'),
            'type' => 'number',
            'id' => 'minimumcheckoutaccount_minimum_amount',
            'default' => '50',
            'desc' => esc_html__('Set the minimum checkout amount required.', 'minimum-checkout-amount'),
        ],
        'include_taxes' => [
            'name' => esc_html__('Include Taxes', 'minimum-checkout-amount'),
            'type' => 'checkbox',
            'id' => 'minimumcheckoutaccount_include_taxes',
            'default' => 'no',
            'desc' => esc_html__('Include taxes in the minimum amount calculation.', 'minimum-checkout-amount'),
        ],
			[
			'title'       => __( 'Minimum cart message', 'aisp-minimum-checkout' ),

			'desc' => __(
			'Customize the warning message shown when the cart total is below the minimum amount.<br><strong>Available placeholder:</strong> {amount} {difference}',
			'aisp-minimum-checkout'
		),


			'desc_tip'    => false,

			'id'          => 'aisp_min_checkout_message',
			'type'        => 'text',

			'default'     => __( 'The minimum order amount is {amount}. You need to add {difference} more to your cart.
', 'aisp-minimum-checkout' ),

			'placeholder' => __( 'The minimum order amount is {amount}. You need to add {difference} more to your cart.
', 'aisp-minimum-checkout' ),

			'css'         => 'width:600px;',
		],


        'excluded_users' => [
           'name'     => esc_html__('Excluded Users', 'minimum-checkout-amount'),
           'type'     => 'excluded_users_selector', // Custom field type we'll define
           'desc'     => esc_html__('Select users who should be excluded from the minimum checkout requirement.', 'minimum-checkout-amount'),
           'id'       => 'minimumcheckoutaccount_excluded_users',
		],
		
		'uninstall_delete_data' => [
    'name' => esc_html__('Delete data on uninstall', 'minimum-checkout-amount'),
    'type' => 'checkbox',
    'desc' => esc_html__('If enabled, all plugin data will be removed when the plugin is uninstalled.', 'minimum-checkout-amount'),
    'id'   => 'minimumcheckoutaccount_uninstall_delete_data',
    'default' => 'no',
		],

        'section_end' => [
            'type' => 'sectionend',
            'id' => 'minimumcheckoutaccount_section_end',
        ],
    ];
    return apply_filters('minimumcheckoutaccount_settings', $settings);
}


add_action('woocommerce_update_options_minimum_checkout_amount', 'minimumcheckoutaccount_save_settings');

function minimumcheckoutaccount_save_settings() {
    woocommerce_update_options(minimumcheckoutaccount_get_settings());
}