<?php
if (!defined('ABSPATH')) {
    exit;
}


add_action('woocommerce_check_cart_items', 'minimumcheckoutaccount_enforce_minimum_checkout_amount');

function minimumcheckoutaccount_enforce_minimum_checkout_amount() {
    $current_user_id = get_current_user_id();
    $excluded_users = (array) get_option('minimumcheckoutaccount_excluded_users', []);

    
    $current_user = wp_get_current_user();
    $auto_excluded_roles = ['administrator', 'shop_manager'];
    if ($current_user && !empty($current_user->roles) && array_intersect($current_user->roles, $auto_excluded_roles)) {
        return; 
    }

    
    if (in_array($current_user_id, $excluded_users)) {
        return;
    }

    if (WC()->cart->is_empty()) {
        return; 
    }

    if (isset($_GET['pay_for_order']) && $_GET['pay_for_order'] === 'true') {
        if (!isset($_GET['_wpnonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['_wpnonce'])), 'woocommerce-pay')) {
            wc_add_notice(__('Security verification failed. Please try again.', 'minimum-checkout-amount'), 'error');
            return;
        }
        return;
    }

    $minimum_amount = floatval(get_option('minimumcheckoutaccount_minimum_amount', 50));
    $include_taxes = get_option('minimumcheckoutaccount_include_taxes', 'no') === 'yes';

    $total = $include_taxes 
        ? floatval(WC()->cart->get_total('edit')) 
        : floatval(WC()->cart->get_subtotal());

    if ($total < $minimum_amount) {

    wc_clear_notices();

    $message = minimumcheckoutaccount_get_minimum_checkout_message(
    $minimum_amount,
    $total
);

wc_add_notice( $message, 'error' );

}

}


function minimumcheckoutaccount_disable_place_order_button($button_html) {
    $current_user_id = get_current_user_id();
    $excluded_users = (array) get_option('minimumcheckoutaccount_excluded_users', []);

    
    $current_user = wp_get_current_user();
    $auto_excluded_roles = ['administrator', 'shop_manager'];
    if ($current_user && !empty($current_user->roles) && array_intersect($current_user->roles, $auto_excluded_roles)) {
        return $button_html; 
    }

    
    if (in_array($current_user_id, $excluded_users)) {
        return $button_html;
    }

    if (WC()->cart->is_empty()) {
        return $button_html;
    }

    if (isset($_GET['pay_for_order']) && $_GET['pay_for_order'] === 'true') {
        if (!isset($_GET['_wpnonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['_wpnonce'])), 'woocommerce-pay')) {
            return $button_html;
        }
        return $button_html;
    }

    $minimum_amount = floatval(get_option('minimumcheckoutaccount_minimum_amount', 50));
    $include_taxes = get_option('minimumcheckoutaccount_include_taxes', 'no') === 'yes';

    $total = $include_taxes 
        ? floatval(WC()->cart->get_total('edit')) 
        : floatval(WC()->cart->get_subtotal());

    if ($total < $minimum_amount) {
        $difference = $minimum_amount - $total;

        $message = sprintf(
            esc_html__('You need to add %1$s more to your cart to reach the minimum checkout amount of %2$s.', 'minimum-checkout-amount'),
            wc_price($difference),
            wc_price($minimum_amount)
        );

        $button_html = '<p class="minimumcheckoutaccount-disabled-message">' . $message . '</p>';
        $button_html .= str_replace('<button', '<button disabled="disabled"', $button_html);
    }

    return $button_html;
}

add_action('wp', 'minimumcheckoutaccount_redirect_to_cart_if_minimum_not_met');

function minimumcheckoutaccount_redirect_to_cart_if_minimum_not_met() {
    $current_user_id = get_current_user_id();
    $excluded_users = (array) get_option('minimumcheckoutaccount_excluded_users', []);

    
    $current_user = wp_get_current_user();
    $auto_excluded_roles = ['administrator', 'shop_manager'];
    if ($current_user && !empty($current_user->roles) && array_intersect($current_user->roles, $auto_excluded_roles)) {
        return; 
    }

    
    if (in_array($current_user_id, $excluded_users)) {
        return;
    }

    if (!function_exists('WC') || !WC()->cart) {
        return;
    }

    if (WC()->cart->is_empty()) {
        return;
    }

    if (isset($_GET['pay_for_order']) && $_GET['pay_for_order'] === 'true') {
        if (!isset($_GET['_wpnonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['_wpnonce'])), 'woocommerce-pay')) {
            return;
        }
        return;
    }

    if (is_checkout() && !is_cart()) {
        $minimum_amount = floatval(get_option('minimumcheckoutaccount_minimum_amount', 50));
        $include_taxes = get_option('minimumcheckoutaccount_include_taxes', 'no') === 'yes';

        $total = $include_taxes 
            ? floatval(WC()->cart->get_total('edit')) 
            : floatval(WC()->cart->get_subtotal());

        if ($total < $minimum_amount) {
            $difference = $minimum_amount - $total;

            wc_clear_notices();

            $message = sprintf(
                esc_html__('Your cart total (%1$s) does not meet the minimum checkout amount of %2$s. Please add %3$s more to proceed.', 'minimum-checkout-amount'),
                wc_price($total),
                wc_price($minimum_amount),
                wc_price($difference)
            );
            wc_add_notice($message, 'error');

            wp_safe_redirect(wc_get_cart_url());
            exit;
        }
    }
}
