<?php
if (!defined('ABSPATH')) {
    exit;
}


function minimumcheckoutaccount_calculate_difference($total, $minimum_amount) {
    return max(0, $minimum_amount - $total);
}

function minimumcheckoutaccount_get_minimum_checkout_message( $minimum_amount, $total = null ) {

    if ( $total === null && function_exists('WC') && WC()->cart ) {
        $total = floatval( WC()->cart->get_subtotal() );
    }

    $difference = max( 0, $minimum_amount - $total );

    $message = get_option( 'aisp_min_checkout_message', '' );

    if ( empty( trim( $message ) ) ) {
        $message = __( 
            'The minimum order amount is {amount}. You need to add {difference} more to your cart.',
            'aisp-minimum-checkout'
        );
    }

    $message = str_replace(
        ['{amount}', '{difference}'],
        [ wc_price( $minimum_amount ), wc_price( $difference ) ],
        $message
    );

    return wp_kses_post( $message );
}
