<?php

if (! defined('ABSPATH')) exit;

function minicomerce_uninstallProcess()
{
    try {
        $uninstall_list_options = array(
            'minicomerce_essential',
            'minicomerce_translation',
            'minicomerce_reports',
            'minicomerce_customers_filter_type',
            'minicomerce_paypal_urls'
        );

        foreach ($uninstall_list_options as $option) {
            if (get_option($option)) {
                delete_option($option);
            }
        }

        $remove_database = function () {
            global $wpdb;
            $table_name = esc_sql($wpdb->prefix . MINICOMERCE_CUSTOMERS);
            $wpdb->query($wpdb->prepare("DROP TABLE IF EXISTS %i" ,$table_name));
        };

        if (is_callable($remove_database)) {
            $remove_database();
        }
    } catch (Exception $e) {
        wp_die('Error: ' . esc_html(  $e->getMessage() , 'minicomerce' ) );
    }
}
