<?php

if (! defined('ABSPATH')) exit;


function minicomerce_save_translation_process()
{
 
    echo wp_json_encode( minicomerce_save_translation_execute() );
    wp_die();
}

function minicomerce_save_translation_execute()
{
    try {

        if (!isset($_POST['minicomerce_read_more']) || 
           !isset($_POST['minicomerce_variations']) || 
           !isset($_POST['minicomerce_buy_now']) ||
           !isset($_POST['minicomerce_shipping'])  || 
           !isset($_POST['minicomerce_aceptance']) || 
           !isset($_POST['minicomerce_privacy']) ||
           !isset($_POST['minicomerce_quiz']) ||
           !isset($_POST['minicomerce_backBTN']) ||
           !isset($_POST['minicomerce_payBTN']) || //
            empty($_POST['minicomerce_read_more']) ||
            empty($_POST['minicomerce_variations']) ||
            empty($_POST['minicomerce_buy_now']) ||
            empty($_POST['minicomerce_shipping']) ||
            empty($_POST['minicomerce_aceptance']) ||
            empty($_POST['minicomerce_privacy']) ||
            empty($_POST['minicomerce_quiz']) ||
            empty($_POST['minicomerce_backBTN']) ||
            empty($_POST['minicomerce_payBTN'])   ) {
            throw new Exception(esc_html__('Please fill all the fields or token is not valid or you don\'t have permission', 'minicomerce'));
            }

            if(!isset($_POST['minicomerce_nonce_translation_field']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['minicomerce_nonce_translation_field'])) , 'minicomerce_nonce_translation')){
                throw new Exception(esc_html__('Nonce is not valid', 'minicomerce'));
            }

            if( !current_user_can('update_plugins') ){
                throw new Exception(esc_html__('You don\'t have permission to update the plugin', 'minicomerce'));
            }



        $minicomerce_read_more = sanitize_text_field(wp_unslash($_POST['minicomerce_read_more']));
        $minicomerce_variations = sanitize_textarea_field(wp_unslash($_POST['minicomerce_variations']));
        $minicomerce_buy_now = sanitize_text_field(wp_unslash($_POST['minicomerce_buy_now']));
        $minicomerce_shipping = sanitize_text_field(wp_unslash($_POST['minicomerce_shipping']));
        $minicomerce_aceptance = sanitize_text_field(wp_unslash($_POST['minicomerce_aceptance']));
        $minicomerce_privacy = sanitize_text_field(wp_unslash($_POST['minicomerce_privacy']));
        $minicomerce_quiz = sanitize_text_field(wp_unslash($_POST['minicomerce_quiz']));
        $minicomerce_backBTN = sanitize_text_field(wp_unslash($_POST['minicomerce_backBTN']));
        $minicomerce_payBTN = sanitize_text_field(wp_unslash($_POST['minicomerce_payBTN']));
       
         
        $minicomerce_translation_unserialized = array(
             $minicomerce_read_more,
             $minicomerce_variations,
             $minicomerce_buy_now,
             $minicomerce_shipping,
             $minicomerce_aceptance,
             $minicomerce_privacy,
                $minicomerce_quiz,
             $minicomerce_backBTN,
             $minicomerce_payBTN
        );


        $minicomerce_translation = serialize($minicomerce_translation_unserialized);
        null !== get_option(MINICOMERCE_TRANSLATIONS) ? update_option(MINICOMERCE_TRANSLATIONS, $minicomerce_translation ) : add_option(MINICOMERCE_TRANSLATIONS,$minicomerce_translation);
 
        return array(
            'status' => 200,
            'message' => esc_html__('Translations saved successfully', 'minicomerce')
        );
        die();
    } catch (\Throwable $th) {
        return array(
            'status' => 404,
            'message' => esc_html__('We have some problem saving those data', 'minicomerce')
        );
        die();
    }
} 