<?php

if (! defined('ABSPATH')) exit;

function minicomerce_save_settings_process(){
    echo wp_json_encode(minicomerce_save_settings_process_on_database());
    wp_die();
}
function minicomerce_save_settings_process_on_database()

{
    try {

        if (
            !isset($_POST['minicomerce_product_name']) ||
            !isset($_POST['minicomerce_product_description']) ||
            !isset($_POST['minicomerce_product_productPage']) ||
            !isset($_POST['minicomerce_product_variations'])  ||
            !isset($_POST['minicomerce_shiping_disponibility'])  ||
            !isset($_POST['minicomerce_product_currency']) ||
            !isset($_POST['minicomerce_product_price']) ||
            !isset($_POST['minicomerce_product_privacyPolicy']) ||
            !isset($_POST['minicomerce_paypal_id']) ||
            !isset($_POST['minicomerce_paypal_secret']) ||
            !isset($_POST['minicomerce_images']) ||
            !isset($_POST['minicomerce_theme']) ||

            empty($_POST['minicomerce_product_privacyPolicy']) ||
            empty($_POST['minicomerce_product_name']) ||
            empty($_POST['minicomerce_product_description']) ||
            empty($_POST['minicomerce_product_productPage']) ||
            empty($_POST['minicomerce_product_variations']) ||
            empty($_POST['minicomerce_shiping_disponibility']) ||
            empty($_POST['minicomerce_product_currency']) ||
            empty($_POST['minicomerce_product_price']) ||
            empty($_POST['minicomerce_paypal_id']) ||
            empty($_POST['minicomerce_paypal_secret']) ||
            empty($_POST['minicomerce_images']) ||
            empty($_POST['minicomerce_theme'])  
        ) {
            throw new Exception(__('Please fill all the fields', 'minicomerce'));
        }

        if(!isset($_POST['minicomerce_nonce_field']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['minicomerce_nonce_field'])) , 'minicomerce_nonce')){
            throw new Exception(esc_html__('Nonce is not valid', 'minicomerce'));
        }

        if( !current_user_can('update_plugins') ){
            throw new Exception(esc_html__('You don\'t have permission to update the plugin', 'minicomerce'));
        }



        $minicomerce_product_name          = sanitize_text_field(wp_unslash($_POST['minicomerce_product_name']));
        $minicomerce_product_description   = sanitize_textarea_field(wp_unslash($_POST['minicomerce_product_description']));
        $minicomerce_product_productPage   = sanitize_text_field(wp_unslash($_POST['minicomerce_product_productPage']));
        $minicomerce_product_privacyPolicy = sanitize_text_field(wp_unslash($_POST['minicomerce_product_privacyPolicy']));
        $minicomerce_product_variations    = sanitize_text_field(wp_unslash($_POST['minicomerce_product_variations']));
        $minicomerce_shiping_disponibility = sanitize_text_field(wp_unslash($_POST['minicomerce_shiping_disponibility']));
        $minicomerce_product_currency      = sanitize_text_field(wp_unslash($_POST['minicomerce_product_currency']));
        $minicomerce_product_price         = sanitize_text_field(wp_unslash($_POST['minicomerce_product_price']));
        $minicomerce_images                = sanitize_text_field(wp_unslash($_POST['minicomerce_images']));
        $minicomerce_paypal_id             = sanitize_text_field(wp_unslash($_POST['minicomerce_paypal_id']));
        $minicomerce_paypal_secret         = sanitize_text_field(wp_unslash($_POST['minicomerce_paypal_secret']));
        $minicomerce_theme                 = sanitize_hex_color(wp_unslash($_POST['minicomerce_theme']));
        $minicomerce_sandbox             = isset($_POST['minicomerce_sandbox']) ? sanitize_text_field(wp_unslash($_POST['minicomerce_sandbox'])) : '0';



        $minicomerce_essential_unserialized = array(
            $minicomerce_product_name,
            $minicomerce_product_description,
            $minicomerce_product_productPage,
            $minicomerce_product_privacyPolicy,
            $minicomerce_product_variations,
            $minicomerce_shiping_disponibility,
            $minicomerce_product_currency,
            $minicomerce_product_price,
            $minicomerce_images,
            $minicomerce_paypal_id,
            $minicomerce_paypal_secret,
            $minicomerce_theme,
            $minicomerce_sandbox
        );

        

        $minicomerce_essential = serialize($minicomerce_essential_unserialized);
        null !== get_option(MINICOMERCE_ESSENTIAL) ? update_option(MINICOMERCE_ESSENTIAL, $minicomerce_essential) : add_option(MINICOMERCE_ESSENTIAL, $minicomerce_essential);

         return array(
            'status' => 200,
            'message' => esc_html__('Settings saved successfully', 'minicomerce')
        );

        exit;
    } catch (\Throwable $th) {
        return array(
            'status' => 404,
            'message' => $th->getMessage()
        );
    }
}
