<?php

if (! defined("ABSPATH")) exit;

function minicomerce_removeItem()
{

    echo wp_json_encode(minicomerce_removeItemOnDatabase());
    wp_die();
}

function minicomerce_removeItemOnDatabase()
{
    try {

        if (
            !isset($_POST['id']) || empty($_POST['id']) 
        ) {
            return array("status" => 400, "message" => "Error: Invalid id");
        }

        if(!isset($_POST['nonce']) || wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['nonce'])) , 'customers_nonce')){
            return array("status" => 400, "message" => "Error: Invalid nonce or token");
        }


        $sanitize_id = sanitize_text_field(wp_unslash($_POST['id']));


        global $wpdb;
        $table_name = esc_sql($wpdb->prefix . MINICOMERCE_REPORTS);
        $result = $wpdb->delete($table_name, array('id' => $sanitize_id));
        return array("status" => 200, "message" => $result);
    } catch (Exception $e) {
        return array("status" => 400, "message" => $e->getMessage());
    }
}
