<?php

if (! defined('ABSPATH')) exit;

function minicomerce_record_data_on_database($data)
{
    try {

        global $wpdb;
        $minicomerce_customers = $wpdb->prefix . MINICOMERCE_REPORTS;
        $essential_data = (null !==  get_option(MINICOMERCE_ESSENTIAL)) ? unserialize(get_option(MINICOMERCE_ESSENTIAL)) : null;

        $result =  $wpdb->insert(
            $minicomerce_customers,
            array(
                'currency'   => $essential_data[6],
                'price'      => $data[0],
                'product'    => $data[1],
                'name'       => $data[2],
                'surname'    => $data[3],
                'tel'        => $data[4],
                'city'       => $data[5],
                'email'      => $data[6], 
                'address'    => $data[7],
                'postalCode' => $data[8],
                'note'       => $data[9]
            ),
            array(
                '%s',
                '%s',
                '%s',
                '%s',
                '%s', 
                '%s',
                '%s',
                '%s',
                '%s',
                '%d',
                '%s',
            )
        );

        if (false === $result) { 
            return array(  'status' => 400, 'message' => 'Error inserting data into the database' );
        } else {
            return array(
                'status'  => 200,
                'message' =>  $result,
                'data'    => array("id" => $wpdb->insert_id, "currency" => $essential_data[6],"price" => $data[0], "product_name" =>$essential_data[0], "variation" => $data[1], "user_name" => $data[2], 
                "description" => $essential_data[1])
            );
        }


       
    } catch (Exception $e) {

        return array(
            'status' => 400,
            'message' => 'Error inserting data into the database: ' . $e->getMessage()
        );
    }
}
