<?php

if (! defined('ABSPATH')) exit;

require_once plugin_dir_path(__FILE__) . './minicomerce_save_order_id.php';

function minicomerce_process_checkout($token, $userData, $url)
{ 
      $body = array(
        'intent' => 'CAPTURE',
        'payment_source' => [
            'paypal' => [
                'experience_context' => [
                    'payment_method_preference' => 'IMMEDIATE_PAYMENT_REQUIRED',
                    'landing_page' => 'LOGIN',
                    'shipping_preference' => 'GET_FROM_FILE',
                    'user_action' => 'PAY_NOW',
                     'return_url' => $userData['urlSucess'],
                    'cancel_url' => $userData['urlError'],
                ],
            ],
        ],
        'purchase_units' => [
            [
                'invoice_id' => $userData['id'], 
                'amount' => [
                    'currency_code' => $userData['currency'],  
                    'value' => $userData['price'], 
                    'breakdown' => [
                        'item_total' => [
                            'currency_code' =>  $userData['currency'],  
                            'value' => $userData['price'],  
                        ],
                    ],
                ],
                'item' => [
                    [
                        'name' => $userData['product_name'],  
                        'description' => $userData['description'],  
                        'unit_amount' => [
                            'currency_code' => $userData['currency'],  
                            'value' => $userData['price'],  
                        ],
                        'quantity' => '1',
                        'category' => $userData['variation'],  
                        'sku' => $userData['variation'],   
                    ],
                ],
            ],
        ],
    );


      $args = array(
        "method"      => 'POST',
        "redirect"   => 'follow',
        "timeout"     => 45,
        "headers" => array(
            "Content-Type" => 'application/json',
            "Authorization" => 'Bearer ' .  $token
        ),
        "body" => json_encode($body)
    );


    $checkout_response = wp_remote_post($url, $args);

    if (is_wp_error($checkout_response)) {
        return array("status" => 404, "message" => "Error: " . $checkout_response->get_error_message());
    }

    $response_code = wp_remote_retrieve_response_code($checkout_response);
    if ($response_code != 200) {
        return array("status" => 404, "message" => "Error: " . $response_code);
    }

    $checkout_response_body = wp_remote_retrieve_body($checkout_response);
    $checkout_data = json_decode($checkout_response_body, true);
 
    if($checkout_data['status'] == 'PAYER_ACTION_REQUIRED'){
        
        $save_paypalid = minicomerce_save_order_id($checkout_data['id'], $userData['id']);

        if($save_paypalid['status'] !== 200){
            return array("status" => 404, "message" => "Error: " . $save_paypalid['message']);
        }
       return array("status" => 200, "message" => "success", "url" => $checkout_data['links'][1]['href'], "paypalId" => $checkout_data['id']);
    
    }
     

}
 