<?php 

if (! defined('ABSPATH')) exit;
 
function minicomerce_getCustomersFliltred()
{

    if (! current_user_can('manage_options')) {
        wp_die(esc_html__('You do not have sufficient permissions to access this page.', 'minicomerce'));
     }


   global $wpdb;
   $table_name = esc_sql($wpdb->prefix . MINICOMERCE_REPORTS);
   $filterType = null !== get_option(MINICOMERCE_CUSTOMERS_FILTER_TYPE)  ? get_option(MINICOMERCE_CUSTOMERS_FILTER_TYPE) : 'all';
   switch ($filterType) {
      case 'all':
         return $wpdb->get_results($wpdb->prepare("SELECT * FROM %i", $table_name));
         break;
      case 'assendent':
         return $wpdb->get_results($wpdb->prepare("SELECT * FROM %i ORDER BY dateIncoming ASC", $table_name));
         break;
      case 'desendent':
         return $wpdb->get_results($wpdb->prepare("SELECT * FROM %i ORDER BY dateIncoming DESC", $table_name));
         break;
      case 'verified':
         return $wpdb->get_results($wpdb->prepare("SELECT * FROM %i WHERE verified = 1", $table_name));
         break;
      case 'payReceived':
         return $wpdb->get_results($wpdb->prepare("SELECT * FROM %i WHERE payReceived = 1", $table_name));
         break;
      case 'unpaid':
         return $wpdb->get_results($wpdb->prepare("SELECT * FROM %i WHERE payReceived = 0", $table_name));
         break;
      default:
         return $wpdb->get_results($wpdb->prepare("SELECT * FROM %i", $table_name));
         break;
   }
}