<?php

function minicomerce_customers_order_action(){ 
    if ( !isset($_POST['minicomerce_order']) || empty($_POST['minicomerce_order']) ) {
        wp_die(esc_html__('Field is empty', 'minicomerce'));  
    }

    if( !isset($_POST['minicomerce_nonce_order']) || wp_verify_nonce(sanitize_text_field( wp_unslash($_POST['minicomerce_nonce_order'], 'minicomerce_nonce')))) {
        wp_die(esc_html__('Nonce verification failed', 'minicomerce'));
    }

    if (! current_user_can('manage_options')) {
        wp_die(esc_html__('You do not have sufficient permissions to access this page.', 'minicomerce'));
    }

    $minicomerce_customers_order = sanitize_text_field( wp_unslash( $_POST['minicomerce_order'] ) );


    if(null !== get_option(MINICOMERCE_CUSTOMERS_FILTER_TYPE)){
        update_option(MINICOMERCE_CUSTOMERS_FILTER_TYPE, $minicomerce_customers_order);
    }else{
        add_option(MINICOMERCE_CUSTOMERS_FILTER_TYPE, 'all');
    }
    wp_redirect(
        admin_url( 'admin.php?page=minicomerce_customers' )
    );
    exit; 
    
}



