<?php

if (! defined("ABSPATH")) exit;

require_once ABSPATH . "wp-admin/includes/upgrade.php";

function minicomerce_activation_process()
{ 
    try {

        global $wpdb;
        $minicomerce_reports = $wpdb->prefix . MINICOMERCE_REPORTS;
        $charset_collate_utf8 = $wpdb->get_charset_collate();

        $minicomerce_table =  "CREATE TABLE IF NOT EXISTS $minicomerce_reports  (
    id int(50) NOT NULL AUTO_INCREMENT,
    currency varchar(50) NOT NULL,
    price decimal(50) NOT NULL,
    product varchar(150) NOT NULL,
    name varchar(150) NOT NULL,
    surname varchar(150) NOT NULL,
    tel varchar(150) NOT NULL,
    city varchar(150) NOT NULL,
    email varchar(150) NOT NULL, 
    address varchar(150) NOT NULL,
    postalCode int(50) NOT NULL,
    note varchar(550) NOT NULL default 'null',
    payReceived tinyint(1) NOT NULL DEFAULT 0,
    shiped tinyint(1) NOT NULL DEFAULT 0,
    payerId varchar(150) NOT NULL DEFAULT 'null',
    verified boolean NOT NULL DEFAULT 0,
    processCompleted tinyint(1) NOT NULL DEFAULT 0, 
    id_salePaypal varchar(150) NOT NULL DEFAULT 'null', 
    dateIncoming timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
     
    PRIMARY KEY  (id)
  ) $charset_collate_utf8;";



$minicomerce_translation_unserialized = array(
    "- Read more -",
    "Variations of product",
    "Start to Buy!",
    "Shiping Informations",
    "You agree to the handling of your data for the processing of the purchase in accordance with our: ",
    "Privacy Policych",
    "Push stop to try to stop the ball on the white area",
    "Back",
    "Pay now"
);

$minicomerce_translation = serialize($minicomerce_translation_unserialized);
null == get_option(MINICOMERCE_TRANSLATIONS) &&  add_option(MINICOMERCE_TRANSLATIONS,$minicomerce_translation);


$minicomerce_paypal_urls = array(
    "https://api-m.sandbox.paypal.com/v2/checkout/orders",
    "https://api-m.sandbox.paypal.com/v1/oauth2/token",
    "https://www.sandbox.paypal.com/checkoutnow?token",
    "https://api-m.paypal.com/v2/checkout/orders",
    "https://api-m.paypal.com/v1/oauth2/token",
    "https://www.paypal.com/checkoutnow?token"
);

$minicomerce_paypal_urls_serialized = serialize($minicomerce_paypal_urls);
null == get_option(MINICOMERCE_PAYPAL_URLS) &&  add_option(MINICOMERCE_PAYPAL_URLS,$minicomerce_paypal_urls_serialized);

null == get_option(MINICOMERCE_CUSTOMERS_FILTER_TYPE) && add_option(MINICOMERCE_CUSTOMERS_FILTER_TYPE, 'all'); 

dbDelta($minicomerce_table);


    } catch (Exception $e) {
        wp_die('Error: ' .  esc_html(  $e->getMessage() , 'minicomerce' ) );
    }
}
