<?php

/**
 * @package minicomerce
 * @version 0.0.1
 * @author Ricardo P Lavour
 * @param none 
 * @return none
 */

 if ( ! defined( 'ABSPATH' ) ) exit;

define('MINICOMERCE_ESSENTIAL', 'minicomerce_essential');
define('MINICOMERCE_TRANSLATIONS', 'minicomerce_translation');
define('MINICOMERCE_REPORTS', 'minicomerce_reports');
define('MINICOMERCE_PAYPAL_URLS', 'minicomerce_paypal_urls');
define('MINICOMERCE_CUSTOMERS', 'minicomerce_customers');
define('MINICOMERCE_CUSTOMERS_FILTER_TYPE', 'minicomerce_customers_filter_type');
define('MINICOMERCE_RESUME_CACHED', 'minicomerce_resume_cached');



require_once plugin_dir_path(__FILE__) . 'minicomerce_save_customers_data.php';

require_once plugin_dir_path(__FILE__) . 'minicomerce_getToken.php'; 

require_once plugin_dir_path(__FILE__) . 'minicomerce_removeItem.php';   
  
require_once plugin_dir_path(__FILE__) . '../front/minicomerce_shortcode.php';
 
require_once plugin_dir_path(__FILE__) . '../utils/minicomerce_menu.php';

require_once plugin_dir_path(__FILE__) . '../utils/minicomerce_translation_submenu.php';

require_once plugin_dir_path(__FILE__) . '../utils/minicomerce_customers_submenu.php';
 
require_once plugin_dir_path(__FILE__) . '../utils/minicomerce_save_settings_process.php';

require_once plugin_dir_path(__FILE__) . '../utils/minicomerce_save_translation_process.php';

require_once plugin_dir_path(__FILE__) . '../utils/minicomerce_script_styles_files.php';
   
require_once plugin_dir_path(__FILE__) . '../utils/minicomerce_activation_process.php';
 
require_once plugin_dir_path(__FILE__) . '../utils/minicomerce_uninstallProcess.php';

require_once plugin_dir_path(__FILE__) . '../utils/minicomerce_customers_order_action.php';
 
require_once plugin_dir_path(__FILE__) . '../utils/minicomerce_customers_verify_action.php';

 
 
if(function_exists('minicomerce_shortcode')){
  add_shortcode('minicomerce', 'minicomerce_shortcode'); 
}
 

if(function_exists('minicomerce_menu')){
    add_action('admin_menu', 'minicomerce_menu');
}

if(function_exists('minicomerce_translation_submenu')){
  add_action('admin_menu', 'minicomerce_translation_submenu');
}

if(function_exists('minicomerce_customers_submenu')){
  add_action('admin_menu', 'minicomerce_customers_submenu');
}
 
 

// # this for add css and js for the backen 
if(function_exists('minicomerce_script_styles_files')){
add_action('admin_enqueue_scripts', 'minicomerce_script_styles_files');
}

# this for add css and js for the front
if(function_exists('minicomerce_script_styles_files_front')){
add_action('wp_enqueue_scripts', 'minicomerce_script_styles_files_front');
}

# add this action when activate the plg
if(function_exists('minicomerce_activation_process')){
  add_action("activate_plugin", "minicomerce_activation_process", 10, 1);
  }
 
# add images when active the plugion
if(function_exists('minicomerce_uninstallProcess')){
register_uninstall_hook( plugin_dir_path(__DIR__). 'minicomerce.php' , 'minicomerce_uninstallProcess' );
}

  
add_action( 'wp_ajax_nopriv_processCustomersData', 'minicomerce_save_customers_data' );
add_action( 'wp_ajax_processCustomersData', 'minicomerce_save_customers_data' );

add_action( 'wp_ajax_nopriv_getToken', 'minicomerce_getToken' );
add_action( 'wp_ajax_getToken', 'minicomerce_getToken' );
 
 
add_action( 'wp_ajax_translate', 'minicomerce_save_translation_process' );  
add_action( 'wp_ajax_settings', 'minicomerce_save_settings_process' ); 

 
add_action( 'wp_ajax_removeItem', 'minicomerce_removeItem' );

add_action( 'admin_post_minicomerce_customers_order', 'minicomerce_customers_order_action' );

add_action( 'admin_post_minicomerce_customers_verify', 'minicomerce_customers_verify_action' );