<?php
if (! defined('ABSPATH')) exit;

require_once plugin_dir_path(__FILE__) . '../../helpers/minicomerce_currency.php';

function minicomerce_details()
{

  $essential_data = (null !==  get_option(MINICOMERCE_ESSENTIAL)) ? unserialize(get_option(MINICOMERCE_ESSENTIAL)) : null;
  $translation_data = (null !==  get_option(MINICOMERCE_TRANSLATIONS)) ? unserialize(get_option(MINICOMERCE_TRANSLATIONS)) : null;


  $mincomerce_output = '<div class="minicomerce_wrapper_userData_wrapper_details minicomerceActive">';
  $mincomerce_output .= '<h1 class="minicomerce_wrapper_userData_wrapper_details_title">' . esc_html($essential_data[0], "minicomerce")  . '</h1>';

  $mincomerce_output .= '<p class="minicomerce_wrapper_userData_wrapper_details_paragrap">';
  $mincomerce_output .= esc_html($essential_data[1], "minicomerce");

  if ('n/a' !== $essential_data[7]) {
    $mincomerce_output .= '<a style="color:' . esc_html($essential_data[11], 'minicomerce')  . '" class="minicomerce_wrapper_userData_wrapper_details_paragrap_link" href="' . esc_html($essential_data[2], 'minicomerce')  . '">';
    $mincomerce_output .= esc_html($translation_data[0], "minicomerce");
    $mincomerce_output .= '</a>';
  }
  $mincomerce_output .= '</p>';

  $mincomerce_output .= '<div class="minicomerce_wrapper_userData_wrapper_details_variations_wrapper">';
  $mincomerce_output .= '<div class="minicomerce_wrapper_userData_wrapper_details_variations">';
  $mincomerce_output .= '<h3 class="minicomerce_wrapper_userData_wrapper_details_variations_h3">';
  $mincomerce_output .= esc_html($translation_data[1], "minicomerce");
  $mincomerce_output .= '</h3>';

  $mincomerce_output .= '<ul class="minicomerce_wrapper_userData_wrapper_details_variations_ul">';

  $variations = explode(",", $essential_data[4]);

  foreach ($variations as $variation) {

    $mincomerce_output .= '<li class="minicomerce_wrapper_userData_wrapper_details_variations_ul_li">';
    $mincomerce_output .= esc_html($variation, "minicomerce");
    $mincomerce_output .= '</li>';
  }

  $mincomerce_output .= '</ul>';
  $mincomerce_output .= '</div>';
  $mincomerce_output .= '<div class="minicomerce_wrapper_userData_wrapper_details_price">';
  $mincomerce_output .= '<h2>';
  $mincomerce_output .= '<i>' . esc_html( minicomerce_currency()[$essential_data[6]] . ' ' , 'minicomerce') . '</i>';
  $mincomerce_output .= esc_html($essential_data[7], 'minicomerce');
  $mincomerce_output .= '</h2>';
  $mincomerce_output .= '</div>';

  $mincomerce_output .= '<div class="minicomerce_wrapper_userData_wrapper_details_button">';
  $mincomerce_output .= '<button style="background-color:'. esc_html($essential_data[11] . ' ' , 'minicomerce') .'" class="minicomerce_wrapper_userData_wrapper_details_button_button">';
  $mincomerce_output .=  esc_html($translation_data[2], "minicomerce");
  $mincomerce_output .= '</button>';
  $mincomerce_output .= '</div>'; 
  $mincomerce_output .= '</div>'; 
  $mincomerce_output .= '</div>'; 

  return $mincomerce_output;
}