<?php

if (! defined('ABSPATH')) exit;

require_once plugin_dir_path(__FILE__) . './modules/minicomerce_details.php';
require_once plugin_dir_path(__FILE__) . './modules/minicomerce_checkout.php';
   
function minicomerce_shortcode()
{ 
 
  $essential_data = (null !==  get_option(MINICOMERCE_ESSENTIAL)) ? unserialize(get_option(MINICOMERCE_ESSENTIAL)) : null;
  $translation_data = (null !==  get_option(MINICOMERCE_TRANSLATIONS)) ? unserialize(get_option(MINICOMERCE_TRANSLATIONS)) : null;

  if($essential_data == null){
    return '[minicomerce]';
  }

  $images = explode( "," , $essential_data[8]);
  $bg_color = $essential_data[11]; 
  
  $minicomerce_output = '<section class="minicomerce">';
  $minicomerce_output .= '<div class="minicomerce_wrapper">';
  $minicomerce_output .= '<div class="minicomerce_wrapper_slider">';
  $minicomerce_output .= '<section class="splide" aria-label="Splide Basic HTML Example">';
  $minicomerce_output .= '<div class="splide__track">'; 
  $minicomerce_output .= '<ul class="splide__list">'; 
       
        foreach ($images as $image) { 
              $image_url = wp_upload_dir()['baseurl'] . '/' . wp_get_attachment_metadata( $image  )['file'];
              $image_meta = get_post_meta($image, '_wp_attachment_image_alt', true);
              $minicomerce_output .=  '<li class="splide__slide"><span style="background-color:' . esc_html( $bg_color , "minicomerce")  . '" class="minicomerce_wrapper_slider_span">' . $image_meta . '</span><img src="' . $image_url  .'"  class="minicomerce_wrapper_slider_img" /></li>';
              
            }
             
$minicomerce_output .= '</ul>';
$minicomerce_output .= '</div>';
$minicomerce_output .= '</section>';
$minicomerce_output .= '</div>';
$minicomerce_output .= '<div class="minicomerce_wrapper_userData">';
$minicomerce_output .= '<section class="minicomerce_wrapper_userData_loader">';
$minicomerce_output .= '<div class="minicomerce_wrapper_userData_loader_wrapper">';
$minicomerce_output .= '<div style="display: none; background-color:'. esc_html( $bg_color , 'minicomerce')  .';" class="minicomerce_wrapper_userData_loader_wrapper_animation">';
$minicomerce_output .= '<span></span>'; 
$minicomerce_output .= '</div>';
$minicomerce_output .= '<div style="display: none;" class="minicomerce_wrapper_userData_wrapper_message">';
$minicomerce_output .= '<a>' . __( "Back ", "minicomerce" ) .  '</a>';
$minicomerce_output .= '<span>' . __( " Confirmed!", "minicomerce" ) . '</span>';
$minicomerce_output .= '</div>';
$minicomerce_output .= '<div style="display: none;" class="minicomerce_wrapper_userData_wrapper_message_error">';
$minicomerce_output .= '<a>' .  __( "Back ", "minicomerce" ) .  '</a> <span>' . __( " Nothing to do!", "minicomerce" )  . '</span>';
$minicomerce_output .= '</div>'; 
$minicomerce_output .= '<div style="display: none;" class="minicomerce_wrapper_userData_loader_wrapper_actions">';
$minicomerce_output .= '<button class="minicomerce_wrapper_userData_loader_wrapper_actions_cancelProcess">';  
$minicomerce_output .= '<a>' . __('Cancel', 'minicomerce') .'</a>';
$minicomerce_output .= '</button>';   
$minicomerce_output .= '<button style="background-color:' . esc_html( $bg_color , "minicomerce")  . '"  class="minicomerce_wrapper_userData_loader_wrapper_actions_tryAgain">';
$minicomerce_output .= '<a class="minicomerce_wrapper_userData_loader_wrapper_actions_cancelProcess">' . __('Try Again', 'minicomerce') . '</a>';
$minicomerce_output .= '</button>';
$minicomerce_output .= '</div>';
$minicomerce_output .= '</div>';

$minicomerce_output .= '<div style="display: none;" class="minicomerce_wrapper_userData_loader_wrapper_quiz">';
$minicomerce_output .= '<span class="minicomerce_wrapper_userData_loader_wrapper_quiz_title">';
$minicomerce_output .= esc_html( $translation_data[6]  , "minicomerce" )  ;
$minicomerce_output .= '</span>';
$minicomerce_output .= '<div class="minicomerce_wrapper_userData_loader_wrapper_quiz_area">';
$minicomerce_output .= '<div style="background-color:' . esc_html( $bg_color , "minicomerce")  . '" class="minicomerce_wrapper_userData_loader_wrapper_quiz_area_bar">';
$minicomerce_output .= '<div class="minicomerce_wrapper_userData_loader_wrapper_quiz_area_bar_whiteArea">';
$minicomerce_output .= '</div>';
$minicomerce_output .= '<div class="minicomerce_wrapper_userData_loader_wrapper_quiz_area_bar_ball">';
$minicomerce_output .= '</div>';
$minicomerce_output .= '</div>';
$minicomerce_output .= '<button class="minicomerce_wrapper_userData_loader_wrapper_quiz_area_stop">';
$minicomerce_output .=  esc_html( 'stop' , "minicomerce" ) ;
$minicomerce_output .= '</button>';
$minicomerce_output .= '</div>';
$minicomerce_output .= '<span class="minicomerce_wrapper_userData_loader_wrapper_quiz_hits">';
$minicomerce_output .= '</span>';
$minicomerce_output .= '</div>';

$minicomerce_output .= '</section>';
$minicomerce_output .= '<div class="minicomerce_wrapper_userData_wrapper">';
$minicomerce_output .= minicomerce_details(); 
$minicomerce_output .= minicomerce_checkout(); 
$minicomerce_output .= '</div>';
$minicomerce_output .= '</div>';
$minicomerce_output .= '</div>';
$minicomerce_output .= '</div>';
$minicomerce_output .= '</section>';

return $minicomerce_output;
 
}