<?php

if (! defined('ABSPATH')) exit;

require_once plugin_dir_path(__FILE__) . '../../utils/minicomerce_addmin_notice.php';
   
  function minicomerce_translation_module()
  { 
    if (! current_user_can('manage_options')) {
        wp_die(  esc_html__('You do not have sufficient permissions to access this page.', 'minicomerce'));
    }

    if( null !==  get_option(MINICOMERCE_TRANSLATIONS) ){
      $translation_data =  unserialize(get_option(MINICOMERCE_TRANSLATIONS));
    }
 
?>
  <section class="minicomerce_module">
    <div class="minicomerce_module_wrapper">
      <div class="minicomerce_module_wrapper_message">
      </div>
      <h1 class="minicomerce_module_wrapper_h1"><?php echo esc_html__('Mini-Comerce Settings translation', 'minicomerce'); ?></h1>
      <span class="minicomerce_module_wrapper_description">
        <?php echo esc_html__('Configure the words to translate client view.', 'minicomerce'); ?> 
      </span>

      <form id="translation_form" class="minicomerce_module_wrapper_form">
        <table class="minicomerce_module_wrapper_form_table">
          <tr class="minicomerce_module_wrapper_form_table_tr">
            <td class="minicomerce_module_wrapper_form_table_tr_tdTitle">
              <label for="minicomerce_product_name">
                <?php echo esc_html__('Read More *', 'minicomerce'); ?>
              </label>
            </td>
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <input type="text" name="minicomerce_read_more" value="<?php echo (isset($translation_data[0])) ? esc_attr($translation_data[0], 'minicomerce') : esc_attr('- Read more -', 'minicomerce'); ?>" id="minicomerce_product_name" required>
            </td>
          </tr>

          <tr class="minicomerce_module_wrapper_form_table_tr">
            <td class="minicomerce_module_wrapper_form_table_tr_tdTitle">
              <label for="minicomerce_product_description">
                <?php echo esc_html__('Variations', 'minicomerce'); ?>
              </label>
            </td>
            <td class="minicomerce_module_wrapper_form_table_tr_td">

              <input type="text" name="minicomerce_variations" value="<?php echo (isset($translation_data[1])) ? esc_attr($translation_data[1], 'minicomerce') : esc_attr('Variations', 'minicomerce'); ?>" id="minicomerce_product_productPage" required>

            </td>
          </tr>


          <tr class="minicomerce_module_wrapper_form_table_tr">
            <td class="minicomerce_module_wrapper_form_table_tr_tdTitle">
              <label for="minicomerce_product_productPage">
                <?php echo esc_html__('Buy now', 'minicomerce'); ?>
              </label>
            </td>
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <input type="text" name="minicomerce_buy_now" value="<?php echo (isset($translation_data[2])) ? esc_attr($translation_data[2], 'minicomerce') : esc_attr('Buy Now', 'minicomerce');  ?>" id="minicomerce_product_productPage" required>

            </td>
          </tr>


          <tr class="minicomerce_module_wrapper_form_table_tr">
            <td class="minicomerce_module_wrapper_form_table_tr_tdTitle">
              <label for="minicomerce_product_privacyPolicy">
                <?php echo esc_html__('Shipping information', 'minicomerce'); ?>
              </label>
            </td>
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <input type="text" name="minicomerce_shipping" value="<?php echo (isset($translation_data[3])) ? esc_attr($translation_data[3], 'minicomerce') : esc_attr('Shiping Information', 'minicomerce');  ?>" id="minicomerce_product_privacyPolicy" required>

            </td>
          </tr>



          <tr class="minicomerce_module_wrapper_form_table_tr">
            <td class="minicomerce_module_wrapper_form_table_tr_tdTitle">
              <label for="minicomerce_product_variations">
                <?php echo esc_html__('Text for aceptannce ', 'minicomerce'); ?>
              </label>
            </td>
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <input type="text" name="minicomerce_aceptance" value="<?php echo (isset($translation_data[4])) ? esc_attr($translation_data[4], 'minicomerce') : esc_attr('You agree to the handling of your data for the processing of the purchase in accordance with our ', 'minicomerce');  ?>" id="minicomerce_product_variations" required>


            </td>
          </tr>

          <tr class="minicomerce_module_wrapper_form_table_tr">
            <td class="minicomerce_module_wrapper_form_table_tr_tdTitle">
              <label for="minicomerce_product_currency">
                <?php echo esc_html__('Privacy policy', 'minicomerce'); ?>
              </label>
            </td>
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <input type="text" name="minicomerce_privacy" value="<?php echo (isset($translation_data[5])) ? esc_attr($translation_data[5], 'minicomerce') : esc_attr('Privacy Policy', 'minicomerce'); ?>" id="minicomerce_product_currency" required>
            </td>
          </tr>

          <tr class="minicomerce_module_wrapper_form_table_tr">
            <td class="minicomerce_module_wrapper_form_table_tr_tdTitle">
              <label for="minicomerce_product_quiz">
                <?php echo esc_html__('Text for quiz', 'minicomerce'); ?>
              </label>
            </td>
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <input type="text" name="minicomerce_quiz" value="<?php echo (isset($translation_data[6])) ? esc_attr($translation_data[6], 'minicomerce') : esc_attr('Try to stop the ball on the white area', 'minicomerce'); ?>" id="minicomerce_product_quiz" required>
            </td>
          </tr>

          <tr class="minicomerce_module_wrapper_form_table_tr">
            <td class="minicomerce_module_wrapper_form_table_tr_tdTitle">
              <label for="minicomerce_product_price">
                <?php echo esc_html__('Back Button', 'minicomerce'); ?>
              </label>
            </td>
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <input type="text" name="minicomerce_backBTN" value="<?php echo (isset($translation_data[7])) ? esc_attr($translation_data[7], 'minicomerce') : esc_attr('Back', 'minicomerce'); ?>" id="minicomerce_product_price" required>
            </td>
          </tr>

          <tr class="minicomerce_module_wrapper_form_table_tr">
            <td class="minicomerce_module_wrapper_form_table_tr_tdTitle">
              <label for="minicomerce_product_price">
                <?php echo esc_html__('Pay Button', 'minicomerce'); ?>
              </label>
            </td>
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <input type="text" name="minicomerce_payBTN" value="<?php echo (isset($translation_data[8])) ? esc_attr($translation_data[8], 'minicomerce') : esc_attr('Pay with paypal', 'minicomerce'); ?>" id="minicomerce_product_price" required>
            </td>
          </tr>

          <tr class="minicomerce_module_wrapper_form_table_tr">
            <td class="minicomerce_module_wrapper_form_table_tr_tdTitle">
              <label for="minicomerce_save">
                <?php echo esc_html__('Save or eddit settings', 'minicomerce'); ?>
              </label>
            </td>
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <input type="submit" class="minicomerce_save" id="minicomerce_save">
            </td>
          </tr>
        </table>
        <?php wp_nonce_field('minicomerce_nonce_translation', 'minicomerce_nonce_translation_field');  ?>
         
      </form> 
    </div>
  </section>

<?php
}
