<?php

if (! defined('ABSPATH')) exit;
require_once plugin_dir_path(__FILE__) . '../../utils/minicomerce_addmin_notice.php';
require_once plugin_dir_path(__FILE__) . '../../helpers/minicomerce_currency.php';
 
 
function minicomerce_module()
{

  if (! current_user_can('manage_options')) {
      wp_die(  esc_html__('You do not have sufficient permissions to access this page.', 'minicomerce'));
  }
  if( null !==  get_option(MINICOMERCE_ESSENTIAL) ){
    $essential_data =  unserialize(get_option(MINICOMERCE_ESSENTIAL));
  } 
 
  $currency = [];  
   if( $essential_data[6] !== null){
     
   foreach (minicomerce_currency() as $code => $name) {
    if ($code == $essential_data[6]) {
       $currency[] = array($code => $name);
    }
  }
} 
  
?>
  <section class="minicomerce_module">
    <div class="minicomerce_module_wrapper">
     <div class="minicomerce_module_wrapper_message">
      </div>
      <h1 class="minicomerce_module_wrapper_h1"><?php echo esc_html__('Mini-Comerce Settings essential: [minicomerce] ', 'minicomerce'); ?></h1>
      <span class="minicomerce_module_wrapper_description">
        <?php echo esc_html__('Configure the settings of the plugin', 'minicomerce'); ?>
      </span> 
      
      <?php
       if($essential_data[12] == 'on'){
        echo '<pre class="minicomerce_module_wrapper_sandbox">';
        echo esc_html__('Sandbox mode active', 'minicomerce');
        echo '</pre>'; 
       } 
      ?>

      <form id="settings_data" class="minicomerce_module_wrapper_form">
        <table class="minicomerce_module_wrapper_form_table">
          <tr class="minicomerce_module_wrapper_form_table_tr">
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <label for="minicomerce_product_name">
                <?php echo esc_html__('Product Name *', 'minicomerce'); ?>
              </label>
            </td>
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <input type="text" name="minicomerce_product_name" value="<?php echo (isset($essential_data[0])) ? esc_attr( $essential_data[0], 'minicomerce' ) : ''; ?>" id="minicomerce_product_name" required>
            </td>
          </tr>

          <tr class="minicomerce_module_wrapper_form_table_tr">
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <label for="minicomerce_product_description">
                <?php echo esc_html__('Product Description *', 'minicomerce'); ?>
              </label>
            </td>
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <textarea type="text" name="minicomerce_product_description" id="minicomerce_product_description" required>
               <?php echo (isset($essential_data[1])) ? esc_attr( $essential_data[1], 'minicomerce' ) : ''; ?></textarea>
              <span class="minicomerce_module_wrapper_form_table_tr_td_span">
                <?php echo esc_html__('Take care wich the length of the description, try to adapt this to the space disponible.', 'minicomerce'); ?>
              </span>
            </td>
          </tr>


          <tr class="minicomerce_module_wrapper_form_table_tr">
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <label for="minicomerce_product_productPage">
                <?php echo esc_html__('Product Page', 'minicomerce'); ?>
              </label>
            </td>
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <input type="text" name="minicomerce_product_productPage" value="<?php echo (isset($essential_data[2])) ? esc_attr( $essential_data[2], 'minicomerce' ) : 'n/a'; ?>" id="minicomerce_product_productPage" required>
              <span class="minicomerce_module_wrapper_form_table_tr_td_span">
                <?php echo esc_html__('If have a page with more information about the product, this is show like -read more- on the description.', 'minicomerce'); ?>
              </span>
            </td>
          </tr>


          <tr class="minicomerce_module_wrapper_form_table_tr">
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <label for="minicomerce_product_privacyPolicy">
                <?php echo esc_html__('Product Privacy Policy', 'minicomerce'); ?>
              </label>
            </td>
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <input type="text" name="minicomerce_product_privacyPolicy" value="<?php echo (isset($essential_data[3])) ? esc_attr( $essential_data[3], 'minicomerce' ) : 'n/a'; ?>" id="minicomerce_product_privacyPolicy" required>
              <span class="minicomerce_module_wrapper_form_table_tr_td_span">
                <?php echo esc_html__('If have a page with the privacy policy of use.', 'minicomerce'); ?>
              </span>
            </td>
          </tr>



          <tr class="minicomerce_module_wrapper_form_table_tr">
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <label for="minicomerce_product_variations">
                <?php echo esc_html__('Product variations', 'minicomerce'); ?>
              </label>
            </td>
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <input type="text" name="minicomerce_product_variations" value="<?php echo (isset($essential_data[4])) ? esc_attr( $essential_data[4], 'minicomerce' ) : 'n/a'; ?>" id="minicomerce_product_variations" required>
              <span class="minicomerce_module_wrapper_form_table_tr_td_span">
                <?php echo esc_html__('If have diferent colors or sizes, this is show like -select product- checkout section. Led empty means not have variations.', 'minicomerce'); ?>
              </span>
              <span class="minicomerce_module_wrapper_form_table_tr_td_i">
                <?php echo esc_html__('To separate the values use a comma (,)', 'minicomerce'); ?>
              </span>
            </td>
          </tr>


          <tr class="minicomerce_module_wrapper_form_table_tr">
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <label for="minicomerce_shiping_disponibility">
                <?php echo esc_html__('Shiping Disponibility', 'minicomerce'); ?>
              </label>
            </td>
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <input type="text" name="minicomerce_shiping_disponibility" value="<?php echo (isset($essential_data[5])) ? esc_attr( $essential_data[5], 'minicomerce' ) : 'n/a'; ?>" id="minicomerce_shiping_disponibility" required>
              <span class="minicomerce_module_wrapper_form_table_tr_td_span">
                <?php echo esc_html__('Set the citys where can be able to ship the product.', 'minicomerce'); ?>
              </span>
              <span class="minicomerce_module_wrapper_form_table_tr_td_i">
                <?php echo esc_html__('To separate the values use a comma (,)', 'minicomerce'); ?>
              </span>
            </td>
          </tr>

          <tr class="minicomerce_module_wrapper_form_table_tr">
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <label for="minicomerce_product_currency">
                <?php echo esc_html__('Product currency *', 'minicomerce'); ?>
              </label>
            </td>
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <select type="text" name="minicomerce_product_currency" value="<?php echo esc_attr( $currency[0][$essential_data[6]] ? $currency[0][$essential_data[6]] : 'USD', 'minicomerce' ); ?>" id="minicomerce_product_currency" required>
                <option> <?php echo esc_attr( $currency[0][$essential_data[6]] ? $currency[0][$essential_data[6]] : 'USD', 'minicomerce' ); ?></option>
               <?php
                 foreach (minicomerce_currency() as $code => $name) {
                   ?>  
                  <option value="<?php echo esc_attr( $code , 'minicomerce' ); ?>"><?php echo esc_attr( $name . ' - ' . $code , 'minicomerce' ); ?> </option>;
               <?php
                }
               ?>
            </select>  
              <span class="minicomerce_module_wrapper_form_table_tr_td_span">
                <?php echo esc_html__('Set the simbol of the currency. Ex: EUR , DOP, RUB', 'minicomerce');  ?>
              </span>
            </td>
          </tr>

          <tr class="minicomerce_module_wrapper_form_table_tr">
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <label for="minicomerce_product_price">
                <?php echo esc_html__('Product Price *', 'minicomerce'); ?>
              </label>
            </td>
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <input type="text" name="minicomerce_product_price" value="<?php echo (isset($essential_data[7])) ? esc_attr( $essential_data[7], 'minicomerce' ) : ''; ?>" id="minicomerce_product_price" required>
            </td>
          </tr>

          <tr class="minicomerce_module_wrapper_form_table_tr">
            <td class="minicomerce_module_wrapper_form_table_tr_td images">
              <label for="minicomerce_paypal_secret">
                <?php echo esc_html__('Select images', 'minicomerce'); ?>
              </label> 
            </td>
            <td class="minicomerce_module_wrapper_form_table_tr_td imagesContainner">
              <input type="text" name="minicomerce_images" value="<?php echo (isset($essential_data[8])) ? esc_attr( $essential_data[8], 'minicomerce' ) : ''; ?>" id="minicomerce_images" required> 
             <div class="minicomerce_images_container"> 
             </div>
              <span class="minicomerce_module_wrapper_form_table_tr_td_span">
                <i id="select_images"><?php echo esc_html__('( Click here ) ', 'minicomerce'); ?></i>
                <?php echo esc_html__('to select images of the product (1080x1080) Recomended', 'minicomerce'); ?>
              </span>
            </td>
          </tr>

          <tr class="minicomerce_module_wrapper_form_table_tr">
            <td class="minicomerce_module_wrapper_form_table_tr_paypal_id">
              <label for="minicomerce_paypal_id">
                <?php echo esc_html__('paypal_id *', 'minicomerce'); ?>
              </label> 
            </td>
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <input type="password" name="minicomerce_paypal_id" value="<?php echo (isset($essential_data[9])) ? esc_attr( $essential_data[9], 'minicomerce' ) : ''; ?>" id="minicomerce_paypal_id" required>
              <span class="minicomerce_module_wrapper_form_table_tr_td_span">
                <?php echo esc_html__('Set paypal client ID', 'minicomerce'); ?>
              </span>
            </td>
          </tr>


          <tr class="minicomerce_module_wrapper_form_table_tr">
            <td class="minicomerce_module_wrapper_form_table_tr_paypal_secret">
              <label for="minicomerce_paypal_secret">
                <?php echo esc_html__('paypal_secret *', 'minicomerce'); ?>
              </label> 
            </td>
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <input type="password" name="minicomerce_paypal_secret" value="<?php echo (isset($essential_data[10])) ? esc_attr( $essential_data[10], 'minicomerce' ) : ''; ?>" id="minicomerce_paypal_secret" required>
              <span class="minicomerce_module_wrapper_form_table_tr_td_span">
                <?php echo esc_html__('Set your secret key of paypal', 'minicomerce'); ?>
              </span>
            </td>
          </tr>
 
 
          <tr class="minicomerce_module_wrapper_form_table_tr">
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <label for="minicomerce_theme">
                <?php echo esc_html__('Color theme', 'minicomerce'); ?>
              </label>
            </td>
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <input type="color" name="minicomerce_theme" value="<?php echo (isset($essential_data[11])) ? esc_attr( $essential_data[11], 'minicomerce' ) : '#2698a4'; ?>" class="minicomerce_color_theme" id="minicomerce_theme">
              <span class="minicomerce_module_wrapper_form_table_tr_td_span">
                <?php echo esc_html__('Set the color theme for your store', 'minicomerce'); ?>
              </span>
              <br>
            </td>
          </tr>


          <tr class="minicomerce_module_wrapper_form_table_tr">
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <label for="minicomerce_sandbox">
                <?php echo esc_html__('Active Sandbox', 'minicomerce'); ?>
              </label>
            </td>
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <input type="checkbox" name="minicomerce_sandbox" <?php echo (isset($essential_data[12]) && $essential_data[12] == 'on') ? esc_attr( 'checked', 'minicomerce' ) : null; ?> class="minicomerce_checkbox" id="minicomerce_sandbox">
              <span class="minicomerce_module_wrapper_form_table_tr_td_span">
                <?php echo esc_html__('Check if you want to use sandbox', 'minicomerce'); ?>
              </span>
            </td>
          </tr>


          <tr class="minicomerce_module_wrapper_form_table_tr">
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <label for="minicomerce_save">
                <?php echo esc_html__('Save or eddit settings', 'minicomerce'); ?>
              </label>
            </td>
            <td class="minicomerce_module_wrapper_form_table_tr_td">
              <input type="submit" class="minicomerce_save" id="minicomerce_save">
            </td>
          </tr>

        </table>
         <?php wp_nonce_field('minicomerce_nonce', 'minicomerce_nonce_field');  ?> 
      </form>
    </div>
  </section>

<?php
}