<?php

if (! defined('ABSPATH')) exit;

require_once plugin_dir_path(__FILE__) . '../../utils/minicomerce_getCustomersFliltred.php';
require_once plugin_dir_path(__FILE__) . '../../utils/minicomerce_customers_resume.php';

function minicomerce_customers_module()
{
   if (! current_user_can('manage_options')) {
      wp_die(esc_html__('You do not have sufficient permissions to access this page.', 'minicomerce'));
   }

?>
   <div class="minicomerce_customers">
      <div class="minicomerce_customers_wrapper">
         <h2><?php echo esc_html__('Sales and Customers status', 'minicomerce'); ?></h2>
         <div class="minicomerce_customers_wrapper_lectures">
            <span class='dashicons dashicons-awards'></span>
            <i><?php echo esc_html__(': Paid process with paypal acepted', 'minicomerce'); ?></i>
            <br>
            <span class="dashicons dashicons-dismiss"></span>
            <i><?php echo esc_html__(': Paid process with paypal not acepted', 'minicomerce'); ?></i>
            <br>
            <span> <?php echo esc_html("⬇️", 'minicomerce'); ?> </span>
            <i><?php echo esc_html__(': Show more data', 'minicomerce'); ?></i>
         </div>
         <div class="minicomerce_customers_wrapper_filter">
            <div class="minicomerce_customers_wrapper_filter_automateReport">
               <?php

               if( wp_cache_get(MINICOMERCE_RESUME_CACHED)){
                  $resume = wp_cache_get(MINICOMERCE_RESUME_CACHED);
               } else {
                  $resume = minicomerce_customers_resume();
                  wp_cache_set(MINICOMERCE_RESUME_CACHED, $resume,   '',  900); 
               } 
               
               foreach ($resume as $key => $value) { 
               ?>
                  <div class="minicomerce_customers_wrapper_filter_automateReport_wrapper">
                     <span class="minicomerce_customers_wrapper_filter_automateReport_wrapper_span">
                        <?php echo esc_attr($key, 'minicomerce'); ?>
                     </span>
                     <b class="minicomerce_customers_wrapper_filter_automateReport_wrapper_pre">
                        <?php echo esc_html('(' . $value . ')'); ?>
                     </b>
                  </div>
               <?php
               }
               ?>
            </div>
         </div>
         

            <div class="minicomerce_customers_wrapper_order">
               <form action="<?php echo esc_url(admin_url('admin-post.php')); ?>" method="post">
                  <?php if (null !== get_option(MINICOMERCE_CUSTOMERS_FILTER_TYPE)) {
                     $actualOrder = get_option(MINICOMERCE_CUSTOMERS_FILTER_TYPE);
                  } ?>
                  <select name="minicomerce_order" id="minicomerce_order">
                     <option selected> <?php echo esc_html( $actualOrder , 'minicomerce'); ?> </option>
                     <option value="all"> <?php echo esc_html__('all', 'minicomerce'); ?> </option>
                     <option value="assendent"> <?php echo esc_html__('assendent', 'minicomerce'); ?> </option>
                     <option value="desendent"> <?php echo esc_html__('desendent', 'minicomerce'); ?> </option>
                     <option value="verified"> <?php echo esc_html__('verified', 'minicomerce'); ?> </option>
                     <option value="payReceived"> <?php echo esc_html__('payReceived', 'minicomerce'); ?> </option>
                     <option value="unpaid"> <?php echo esc_html__('unpaid', 'minicomerce'); ?> </option>
                  </select>
                  <input type="submit" value="filter">
                  <input type="hidden" name="action" value="minicomerce_customers_order">
                  <?php wp_nonce_field('minicomerce_nonce', 'minicomerce_nonce_order');  ?>
               </form>
            </div>

            <div class="minicomerce_customers_wrapper_verify">
            <div class="minicomerce_customers_wrapper_verify_animation">
            <span style="display: none;" class="dashicons dashicons-image-rotate"></span>
               </div>
               <form class="minicomerce_customers_wrapper_verify_form" action="<?php echo esc_url(admin_url('admin-post.php')); ?>" method="post">
                  <button class="minicomerce_customers_wrapper_verify_form_submit" type="submit"><?php echo esc_html__('Verify', 'minicomerce'); ?></button>
                  <input type="hidden" name="action" value="minicomerce_customers_verify">
                  <?php wp_nonce_field('minicomerce_nonce', 'minicomerce_nonce_verify');  ?>
               </form>
            </div>


            <div class="minicomerce_customers_wrapper_tables">
               <table class="minicomerce_customers_wrapper_tables_top">
                  <tr>
                     <td width="5%"><span><?php echo esc_html__('show', 'minicomerce'); ?></span></td>
                     <td width="20%"><span><?php echo esc_html__('Product', 'minicomerce'); ?></span></td>
                     <td width="25%"><span><?php echo esc_html__('Name', 'minicomerce'); ?></span></td>
                     <td width="25%"><span><?php echo esc_html__('Email', 'minicomerce'); ?></span></td>
                     <td width="13%"><span><?php echo esc_html__('City', 'minicomerce'); ?></span></td>
                     <td width="12%"><span><?php echo esc_html__('Date', 'minicomerce'); ?></span></td>
                  </tr>
               </table>

               <?php
               $customers = wp_cache_get(MINICOMERCE_CUSTOMERS);
               if ($customers === false) {
                  // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery -- Direct query is required for custom table 
                  $customers = minicomerce_getCustomersFliltred();
                  wp_cache_set(MINICOMERCE_CUSTOMERS, $customers,   '',  600);
               }
               foreach ($customers as $customer) {
               ?>
                  <div id="<?php echo esc_attr("minicomerce_" . $customer->id); ?>" class="minicomerce_customers_wrapper_tables_modules">

                     <ul class="minicomerce_customers_wrapper_tables_modules_data">
                        <li style="width:5%">

                           <?php if ($customer->payReceived) {
                           ?>
                              <span style="color: #2371b1;" class='dashicons dashicons-awards'></span>
                           <?php
                           } else {
                           ?>
                              <span style="color: #ff3b00;" class="dashicons dashicons-dismiss"></span>
                           <?php
                           }
                           ?>
                           <button onclick="showExtraData('<?php echo esc_attr($customer->id); ?>')" class="<?php echo esc_attr("DetailTriguer_" . $customer->id); ?>"><?php echo esc_html("⬇️", 'minicomerce'); ?></button>
                        </li>
                        <li style="width:20%"><?php echo esc_html($customer->product, 'minicomerce'); ?></li>
                        <li style="width:25%"><?php echo esc_html($customer->name . " " . $customer->surname, 'minicomerce'); ?></li>
                        <li style="width:25%"><?php echo esc_html($customer->email, 'minicomerce'); ?></li>
                        <li style="width:13%"><?php echo esc_html($customer->city, 'minicomerce'); ?></td>
                        <li style="width:12%"><?php echo esc_html($customer->dateIncoming, 'minicomerce'); ?></li>

                     </ul>
                     <div class="minicomerce_customers_wrapper_tables_modules_extraData <?php echo esc_attr("Detail_" . $customer->id); ?>">

                        <div class="minicomerce_customers_wrapper_tables_modules_extraData_userdata">
                           <h2><?php echo esc_html('User data', 'minicomerce'); ?></h2>
                           <span><?php echo esc_html('Phone:', 'minicomerce'); ?></span>
                           <i><?php echo esc_html($customer->tel, 'minicomerce'); ?></i>
                           <span><?php echo esc_html('Address:', 'minicomerce'); ?></span>
                           <i><?php echo esc_html($customer->address, 'minicomerce'); ?></i>
                           <span><?php echo esc_html('Postal Code:', 'minicomerce'); ?></span>
                           <i><?php echo esc_html($customer->postalCode, 'minicomerce'); ?></i>
                        </div>

                        <div class="minicomerce_customers_wrapper_tables_modules_extraData_status">
                           <h2><?php echo esc_html('Buy Status', 'minicomerce'); ?></h2>
                           <span><?php echo esc_html('Transation Id:', 'minicomerce'); ?></span>
                           <i><?php echo esc_html($customer->id_salePaypal, 'minicomerce'); ?></i>
                           <span><?php echo esc_html('Paid:', 'minicomerce'); ?></span>
                           <i><?php echo esc_html($customer->payReceived > 0 ? 'yes' : 'no', 'minicomerce'); ?></i>
                           <span><?php echo esc_html('Shiped:', 'minicomerce'); ?></span>
                           <i><?php echo esc_html($customer->shiped > 0 ? 'yes' : 'no', 'minicomerce'); ?></i>
                           <span><?php echo esc_html('Process Completed:', 'minicomerce'); ?></span>
                           <i><?php echo esc_html($customer->processCompleted > 0 ? 'yes' : 'no', 'minicomerce'); ?></i>
                        </div>
                        <div class="minicomerce_customers_wrapper_tables_modules_extraData_note">
                           <h2><?php echo esc_html('Note', 'minicomerce'); ?></h2>
                           <p><?php echo esc_html($customer->note, 'minicomerce'); ?></p>
                        </div>
                        <div class="minicomerce_customers_wrapper_tables_modules_extraData_actions">
                           <h2><?php echo esc_html('Change Status', 'minicomerce'); ?></h2>
                           <button><?php echo esc_html('Change to shiped', 'minicomerce'); ?></button>
                           <button><?php echo esc_html('Change to Process Completed', 'minicomerce'); ?></button>
                           <button onclick="minicomerce_removeItem('<?php echo esc_attr($customer->id); ?>')" class="remove itemId<?php echo esc_attr("_" . $customer->id); ?>"><?php echo esc_html('Remove item', 'minicomerce'); ?></button>
                        </div>
                     </div>


                  </div>
               <?php
               }
               ?>

               <table class="minicomerce_customers_wrapper_tables_top">
                  <tr>
                     <td width="5%"><span><?php echo esc_html__('show', 'minicomerce'); ?></span></td>
                     <td width="20%"><span><?php echo esc_html__('Product', 'minicomerce'); ?></span></td>
                     <td width="25%"><span><?php echo esc_html__('Name', 'minicomerce'); ?></span></td>
                     <td width="25%"><span><?php echo esc_html__('Email', 'minicomerce'); ?></span></td>
                     <td width="13%"><span><?php echo esc_html__('City', 'minicomerce'); ?></span></td>
                     <td width="12%"><span><?php echo esc_html__('Date', 'minicomerce'); ?></span></td>
                  </tr>
               </table>

            </div>
         </div>
      </div>

   <?php
} 