<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
add_action( 'init', 'mbgmnew_gallery_post' );
function mbgmnew_gallery_post() {
	$labels = array(
		'name'               => _x( 'MB Gallery', 'post type general name', 'meta-box-gallerymeta' ),
		'singular_name'      => _x( 'MB Gallery', 'post type singular name', 'meta-box-gallerymeta' ),
		'menu_name'          => _x( 'MB Gallery', 'admin menu', 'meta-box-gallerymeta' ),
		'name_admin_bar'     => _x( 'MB Gallery', 'add new on admin bar', 'meta-box-gallerymeta' ),
		'add_new'            => _x( 'Add New', 'MB Gallery', 'meta-box-gallerymeta' ),
		'add_new_item'       => __( 'Add New MBG', 'meta-box-gallerymeta' ),
		'new_item'           => __( 'New MBG', 'meta-box-gallerymeta' ),
		'edit_item'          => __( 'Edit MBG', 'meta-box-gallerymeta' ),
		'view_item'          => __( 'View MBG', 'meta-box-gallerymeta' ),
		'all_items'          => __( 'Gallery', 'meta-box-gallerymeta' ),
		'search_items'       => __( 'Search MBG', 'meta-box-gallerymeta' ),
		'parent_item_colon'  => __( 'Parent MBG:', 'meta-box-gallerymeta' ),
		'not_found'          => __( 'No MBG found.', 'meta-box-gallerymeta' ),
		'not_found_in_trash' => __( 'No MBG found in Trash.', 'meta-box-gallerymeta' )
	);
	$args = array(
		'labels'             => $labels,
        'description'        => __( 'Description.', 'meta-box-gallerymeta' ),
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => false,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => 'mb_gallery' ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => 20,
		'menu_icon'           => 'dashicons-schedule',
		'supports'           => array( 'title', 'editor', 'thumbnail', )
	);
	register_post_type( 'mb_gallery', $args );
}
//mbg slider
add_action( 'init', 'mbgmnew_Slider_post' );
function mbgmnew_Slider_post() {
	$labels = array(
		'name'               => _x( 'Sliders', 'post type general name', 'meta-box-gallerymeta' ),
		'singular_name'      => _x( 'Slider', 'post type singular name', 'meta-box-gallerymeta' ),
		'menu_name'          => _x( 'Slider', 'admin menu', 'meta-box-gallerymeta' ),
		'name_admin_bar'     => _x( 'Slider', 'add new on admin bar', 'meta-box-gallerymeta' ),
		'add_new'            => _x( 'Add New', 'Slider', 'meta-box-gallerymeta' ),
		'add_new_item'       => __( 'Add New Slider', 'meta-box-gallerymeta' ),
		'new_item'           => __( 'New Slider', 'meta-box-gallerymeta' ),
		'edit_item'          => __( 'Edit Slider', 'meta-box-gallerymeta' ),
		'view_item'          => __( 'View Slider', 'meta-box-gallerymeta' ),
		'all_items'          => __( 'All Sliders', 'meta-box-gallerymeta' ),
		'search_items'       => __( 'Search Slider', 'meta-box-gallerymeta' ),
		'parent_item_colon'  => __( 'Parent Slider:', 'meta-box-gallerymeta' ),
		'not_found'          => __( 'No Slider found.', 'meta-box-gallerymeta' ),
		'not_found_in_trash' => __( 'No Slider found in Trash.', 'meta-box-gallerymeta' )
	);
	$args = array(
		'labels'             => $labels,
        'description'        => __( 'Description.', 'meta-box-gallerymeta' ),
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => false,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => 'mb_slider' ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => 20,
		'menu_icon'           => 'dashicons-schedule',
		'supports'           => array( 'title', 'editor', 'thumbnail', )
	);
	register_post_type( 'mb_slider', $args );
}
?>