<?php
if ( ! defined( 'ABSPATH' ) )
    exit;

$attributes = $attributes ?? [
    'email_txt' => __('Email', "messengeros-for-woocommerce"),
    'btn_txt' => __('Submit', "messengeros-for-woocommerce"),
    'success_txt' => __('Success!', "messengeros-for-woocommerce"),
    'fail_txt' => __('Failed!', "messengeros-for-woocommerce"),
];


// First check forms settings, then fall back to API settings for backward compatibility
$forms_settings = get_option('messos_woocommerce_forms_settings', []);
$api_settings = get_option('messos_woocommerce_api_settings', []);

$form_html = isset($forms_settings['form_template']) && !empty($forms_settings['form_template']) 
    ? $forms_settings['form_template'] 
    : ($api_settings['form'] ?? '');

// If no form template is configured, use default template
if (empty($form_html)) {
    $form_html = '<div id="messos-woocommerce-newsletter-form-container">
    <form id="messos-woocommerce-newsletter-form" class="messos-woocommerce-newsletter-form-wrapper">
        <label for="messos-woocommerce-email">%email_txt%:</label>
        <input type="email" id="messos-woocommerce-email" name="messos-woocommerce-email" required>
        <label>
            <input type="checkbox" id="messos-woocommerce-terms" name="messos-woocommerce-terms" required>
            I agree with the terms and conditions
        </label><br />
        <div id="messos-woocommerce-error-message" style="display: none;">%fail_txt%</div>
        <button type="submit" id="messos-woocommerce-submit-button" disabled>%btn_txt%</button>
    </form>
    <div id="messos-woocommerce-success-message" style="display: none;">%success_txt%</div>
</div>';
}

// Decode escaped characters
$form_html = html_entity_decode(stripslashes($form_html));

// Replace placeholders
$form_html = str_replace(
    ['%email_txt%', '%btn_txt%', '%success_txt%', '%fail_txt%'],
    [
        esc_html($attributes["email_txt"]),
        esc_html($attributes["btn_txt"]),
        wp_kses_post($attributes["success_txt"]),
        esc_html($attributes["fail_txt"]),
    ],
    $form_html
);

// Insert nonce before </form>, if </form> exists
$nonce_field = wp_nonce_field("messos_woocommerce_newsletter_form_action", "messos-woocommerce-nonce", true, false);
$form_html = preg_replace('/<\/form>/i', $nonce_field . '</form>', $form_html, 1);

echo wp_kses( $form_html, MessengerOS_WooCommerce::messos_woocommerce_get_allowed_html() );
