<?php
if ( ! defined( 'ABSPATH' ) )
    exit;
function messos_woocommerce_send_subscriber() {
    // Check nonce
    if ( (!isset( $_POST['messos-woocommerce-nonce'] ) || ! wp_verify_nonce( sanitize_text_field(wp_unslash($_POST['messos-woocommerce-nonce'])), 'messos_woocommerce_newsletter_form_action' ) ) ) {
        wp_send_json_error( __( 'Invalid nonce.', "messengeros-for-woocommerce" ) );
    }

    $to = isset($_POST['messos-woocommerce-email']) ? sanitize_email(wp_unslash($_POST['messos-woocommerce-email'])) : '';
    if ( ! $to || ! is_email( $to ) ) {
        wp_send_json_error(  __( 'Please enter a valid email address.', "messengeros-for-woocommerce" ) );
    }

    if ( ! isset( $_POST['messos-woocommerce-terms'] ) || $_POST['messos-woocommerce-terms'] !== 'on' ) {
        wp_send_json_error( __( 'You must agree to the terms and conditions.', "messengeros-for-woocommerce" ) );
    }

	if ( $to ) {
		$request_body = [
			"subscription" => [
                [
                    "email" => $to,
                ]
			],
		];
        $settings = get_option( 'messos_woocommerce_api_settings', [] );
        $api_key = isset( $settings['api_key'] ) ? sanitize_text_field( $settings['api_key'] ) : '';


        if(!empty($settings['project'])) {
            $request_body['project'] = sanitize_text_field($settings['project']);
        }

        if(!empty($settings['list'])) {
            $request_body['subscription'][0]['distribution_lists'] = [sanitize_text_field($settings['list'])];
        }

        $response_body = null;
		$response = wp_remote_post( 'https://inbound.messengeros.com/2.0/subscribe', [
			'method'  => 'POST',
			'headers' => [
				'Content-Type' => 'application/json',
                'x-api-key' => $api_key,
			],
			'body'    => json_encode( $request_body ),
            'timeout' => 15,
		] );

		if ( is_wp_error( $response ) ) {
			$success = false;
		} else {
			$response_body = json_decode( wp_remote_retrieve_body( $response ), true );
			if ( isset( $response_body['status'] ) && $response_body['status'] === 'received' ) {
				$success = true;
			} else {
				$success = false;
			}
		}
	} else {
		$success = false;
	}

    wp_send_json( [
        'success' => $success,
        'request' => $request_body ?? 'none',
        'remote'  => $response_body ?? 'none',
        'nonce'   => 'correct',
    ] );
    wp_die();
}
