if (typeof jQuery === 'undefined') {
    console.error('jQuery is not loaded!');
} else {
    console.log('jQuery version:', jQuery.fn.jquery);
}

jQuery(document).ready(function($) {
    console.log('Product sync JS loaded');
    let syncInProgress = false;
    
    // Handle sync button click
    console.log('Looking for button:', $('#messos-woocommerce-sync-products').length);
    $('#messos-woocommerce-sync-products').on('click', function(e) {
        console.log('Sync button clicked');
        e.preventDefault();
        
        if (syncInProgress) {
            return;
        }
        
        const syncType = $('input[name="sync_type"]:checked').val();
        const $button = $(this);
        const $spinner = $button.next('.spinner');
        const $progress = $('#sync-progress');
        const $results = $('#sync-results');
        
        // Reset UI
        syncInProgress = true;
        $button.prop('disabled', true);
        $spinner.addClass('is-active');
        $progress.show();
        $results.hide();
        $('.progress-bar-fill').css('width', '0%');
        $('.progress-text').text('Starting sync...');
        
        // Start sync
        syncProducts(1, syncType === 'full');
    });
    
    function syncProducts(page, fullSync) {
        $.ajax({
            url: messosWoocommerceSync.ajaxUrl,
            type: 'POST',
            data: {
                action: 'messos_woocommerce_sync_products',
                page: page,
                full_sync: fullSync,
                _wpnonce: messosWoocommerceSync.nonce
            },
            success: function(response) {
                console.log('Sync response:', response);
                
                if (response.success !== false) {
                    // Handle the response data properly
                    const data = response.data || response;
                    
                    if (data.current_page && data.pages) {
                        updateProgress(data);
                        
                        // Continue to next page if needed
                        if (data.current_page < data.pages) {
                            syncProducts(data.current_page + 1, fullSync);
                        } else {
                            // Sync complete
                            completeSyncSuccess(data);
                        }
                    } else {
                        // Single response without pagination
                        completeSyncSuccess(data);
                    }
                } else {
                    completeSyncError(response.data || response);
                }
            },
            error: function() {
                completeSyncError({ errors: ['Network error occurred'] });
            }
        });
    }
    
    function updateProgress(data) {
        if (!data || typeof data.current_page === 'undefined' || typeof data.pages === 'undefined') {
            console.error('Invalid sync data:', data);
            return;
        }
        const progress = (data.current_page / data.pages) * 100;
        $('.progress-bar-fill').css('width', progress + '%');
        $('.progress-text').text(`Syncing page ${data.current_page} of ${data.pages}...`);
    }
    
    function completeSyncSuccess(data) {
        syncInProgress = false;
        $('#messos-woocommerce-sync-products').prop('disabled', false);
        $('.spinner').removeClass('is-active');
        $('#sync-progress').hide();
        
        // Show results
        $('#sync-results').show();
        let resultsHtml = '';
        
        // Handle success message
        if (data && typeof data.synced !== 'undefined') {
            resultsHtml += '<div class="notice notice-success"><p>';
            resultsHtml += `Successfully synced ${data.synced} products!`;
            if (data.failed && data.failed > 0) {
                resultsHtml += ` (${data.failed} failed)`;
            }
            resultsHtml += '</p></div>';
        } else {
            resultsHtml += '<div class="notice notice-success"><p>Sync completed!</p></div>';
        }
        
        // Handle errors if present
        if (data && data.errors && data.errors.length > 0) {
            resultsHtml += '<div class="notice notice-warning"><p>';
            resultsHtml += 'Some errors occurred:<br>';
            data.errors.forEach(function(error) {
                resultsHtml += error + '<br>';
            });
            resultsHtml += '</p></div>';
        }
        
        $('.sync-results-content').html(resultsHtml);
        
        // Reload page after 3 seconds to update status
        setTimeout(function() {
            location.reload();
        }, 3000);
    }
    
    function completeSyncError(data) {
        syncInProgress = false;
        $('#messos-woocommerce-sync-products').prop('disabled', false);
        $('.spinner').removeClass('is-active');
        $('#sync-progress').hide();
        
        // Show error
        $('#sync-results').show();
        let errorHtml = '<div class="notice notice-error"><p>';
        
        if (data && data.errors && data.errors.length > 0) {
            errorHtml += 'Sync failed with errors:<br>';
            data.errors.forEach(function(error) {
                errorHtml += error + '<br>';
            });
        } else if (data && data.message) {
            errorHtml += data.message;
        } else {
            errorHtml += messosWoocommerceSync.strings.error || 'An error occurred during sync.';
        }
        
        errorHtml += '</p></div>';
        $('.sync-results-content').html(errorHtml);
    }
    
    // Get sync status periodically
    function updateSyncStatus() {
        $.ajax({
            url: messosWoocommerceSync.ajaxUrl,
            type: 'POST',
            data: {
                action: 'messos_woocommerce_get_sync_status',
                _wpnonce: messosWoocommerceSync.nonce
            },
            success: function(response) {
                if (response.success) {
                    // Update status display if needed
                }
            }
        });
    }
});