document.addEventListener('DOMContentLoaded', function () {
    const form = document.getElementById('messos-woocommerce-newsletter-form');
    if (!form) return;

    const emailInput = document.getElementById('messos-woocommerce-email');
    const termsCheckbox = document.getElementById('messos-woocommerce-terms');
    const submitButton = document.getElementById('messos-woocommerce-submit-button');
    const errorMessage = document.getElementById('messos-woocommerce-error-message');

    function updateSubmitButton() {
        if (emailInput && submitButton) {
            const emailValid = emailInput.checkValidity();
            const termsChecked = !termsCheckbox || termsCheckbox.checked;
            submitButton.disabled = !(emailValid && termsChecked);
        }
    }

    if (emailInput) {
        emailInput.addEventListener('input', updateSubmitButton);
    }
    if (termsCheckbox) {
        termsCheckbox.addEventListener('change', updateSubmitButton);
    }

    form.addEventListener('submit', function (event) {
        event.preventDefault();

        errorMessage.style.display = 'none';
        errorMessage.textContent = '';

        const formData = new FormData(form);
        formData.append('action', 'messos_woocommerce_send_subscriber');
        // The nonce is already in the form from wp_nonce_field

        fetch(messosWoocommerceData.ajax_url, {
            method: 'POST',
            body: formData
        })
            .then(response => response.json())
            .then(data => {
                if (data.success == true) {
                    form.style.display = 'none';
                    document.getElementById('messos-woocommerce-success-message').style.display = 'block';
                } else {
                    errorMessage.style.display = 'block';
                    errorMessage.innerHTML = data.data;
                }
            })
            .catch(() => {
                form.style.display = 'none';
                errorMessage.style.display = 'block';
            });
    });
});
