jQuery(document).ready(function($) {
    console.log('Forms admin JS loaded');
    
    // Handle form submission
    $(document).on('submit', '#messos-woocommerce-forms-settings-form', function(e) {
        e.preventDefault();
        e.stopPropagation();
        console.log('Form submit intercepted');
        
        var $form = $(this);
        var $submitButton = $form.find('input[type="submit"]');
        var $messageDiv = $('#messos-woocommerce-forms-settings-message');
        
        // Clear previous messages
        $messageDiv.empty().removeClass('notice notice-success notice-error is-dismissible');
        
        // Disable submit button
        $submitButton.prop('disabled', true).val('Saving...');
        
        // Get form data
        var formData = $form.serializeArray();
        console.log('Form data:', formData);
        
        // Send AJAX request
        $.ajax({
            url: messosWoocommerceFormsAjax.ajax_url,
            type: 'POST',
            data: {
                action: 'messos_woocommerce_save_forms_settings',
                nonce: messosWoocommerceFormsAjax.nonce,
                settings: formData
            },
            success: function(response) {
                if (response.success) {
                    $messageDiv.addClass('notice notice-success is-dismissible').html('<p>Settings saved successfully!</p>');
                } else {
                    var errorMessage = response.data.message || 'An error occurred while saving settings.';
                    if (response.data.errors) {
                        errorMessage += '<br>';
                        response.data.errors.forEach(function(error) {
                            errorMessage += '<br>' + error.message;
                        });
                    }
                    $messageDiv.addClass('notice notice-error is-dismissible').html('<p>' + errorMessage + '</p>');
                }
            },
            error: function() {
                $messageDiv.addClass('notice notice-error is-dismissible').html('<p>An error occurred while saving settings.</p>');
            },
            complete: function() {
                // Re-enable submit button
                $submitButton.prop('disabled', false).val('Save Changes');
                
                // Scroll to message
                $('html, body').animate({
                    scrollTop: $messageDiv.offset().top - 50
                }, 500);
            }
        });
    });
});