jQuery(document).ready(function ($) {
    $('#messos-woocommerce-settings-form').on('submit', function (e) {
        e.preventDefault();

        const form = $(this);
        const messageBox = $('#messos-woocommerce-settings-message');

        const data = {
            action: 'messos_woocommerce_save_settings',
            nonce: messosWoocommerceAjax.nonce,
            settings: form.serializeArray()
        };

        $.post(messosWoocommerceAjax.ajax_url, data, function (response) {
            messageBox.empty(); // clear previous messages

            if (response.success) {
                messageBox.html('<div class="messos-woocommerce-custom-alert messos-woocommerce-custom-alert-success">✅ Settings saved successfully. &nbsp; <button type="button" class="custom-close" onclick="this.parentElement.style.display=\'none\';">&times;</button></div>');
            } else {
                let errors = response.data?.errors;
                let html = `
                    <div class="messos-woocommerce-custom-alert messos-woocommerce-custom-alert-danger">
                        <strong>We were unable to save your settings.</strong> <button type="button" class="custom-close" onclick="this.parentElement.style.display='none';">&times;</button><br /><br />
                        Please fix the following issues:<br />
                        <ul id="admin-form-save-response-items">
                `;

                if (errors && errors.length) {
                    errors.forEach(function (err) {
                        html += `<li>${err.message}</li>`;
                    });
                } else {
                    html += `<li>${response.data.message}</li>`;
                }

                html += '</ul></div>';
                messageBox.html(html);
            }
        });
    });
    
    // Handle OAuth disconnect
    $('#messos-woocommerce-disconnect-oauth').on('click', function(e) {
        e.preventDefault();
        
        if (!confirm('Are you sure you want to disconnect from MessengerOS?')) {
            return;
        }
        
        const button = $(this);
        button.prop('disabled', true).text('Disconnecting...');
        
        $.post(messosWoocommerceAjax.ajax_url, {
            action: 'messos_woocommerce_disconnect_oauth',
            nonce: messosWoocommerceAjax.nonce
        }, function(response) {
            if (response.success) {
                window.location.reload();
            } else {
                alert('Failed to disconnect. Please try again.');
                button.prop('disabled', false).text('Disconnect');
            }
        });
    });
});
