<?php
/**
 * SVG icons used in Merchant.
 *
 * @package Merchant
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'Merchant_SVG_Icons' ) ) {

	/**
	 * Get a svg icon
	 */
	class Merchant_SVG_Icons {

		public static function get_svg_icon( $icon ) {
			/**
			 * Filter the svg icons.
			 *
			 * @since 1.8.3
			 */
			$icons    = apply_filters( 'merchant_svg_icon', self::$svg_icons );
			$svg_code = isset( $icons[ $icon ] ) ? $icons[ $icon ] : '';

			return $svg_code;
		}

		public static $svg_icons = array(
			'complementary-products' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M5.99961 3.59998C4.67413 3.59998 3.59961 4.67449 3.59961 5.99998V8.39998C3.59961 9.72546 4.67413 10.8 5.99961 10.8H8.39961C9.72509 10.8 10.7996 9.72546 10.7996 8.39998V5.99998C10.7996 4.67449 9.72509 3.59998 8.39961 3.59998H5.99961ZM5.39961 5.99998C5.39961 5.6686 5.66824 5.39998 5.99961 5.39998H8.39961C8.73098 5.39998 8.99961 5.6686 8.99961 5.99998V8.39998C8.99961 8.73135 8.73098 8.99998 8.39961 8.99998H5.99961C5.66824 8.99998 5.39961 8.73135 5.39961 8.39998V5.99998Z" fill="#4A4A4A"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M5.99961 13.2C4.67413 13.2 3.59961 14.2745 3.59961 15.6V18C3.59961 19.3255 4.67413 20.4 5.99961 20.4H8.39961C9.72509 20.4 10.7996 19.3255 10.7996 18V15.6C10.7996 14.2745 9.72509 13.2 8.39961 13.2H5.99961ZM5.39961 15.6C5.39961 15.2686 5.66824 15 5.99961 15H8.39961C8.73098 15 8.99961 15.2686 8.99961 15.6V18C8.99961 18.3313 8.73098 18.6 8.39961 18.6H5.99961C5.66824 18.6 5.39961 18.3313 5.39961 18V15.6Z" fill="#4A4A4A"/>
<path d="M11.9996 5.69998C11.9996 5.20292 12.4026 4.79998 12.8996 4.79998H19.4996C19.9967 4.79998 20.3996 5.20292 20.3996 5.69998C20.3996 6.19703 19.9967 6.59998 19.4996 6.59998H12.8996C12.4026 6.59998 11.9996 6.19703 11.9996 5.69998Z" fill="#4A4A4A"/>
<path d="M12.8996 7.79998C12.4026 7.79998 11.9996 8.20292 11.9996 8.69998C11.9996 9.19703 12.4026 9.59998 12.8996 9.59998H18.2996C18.7967 9.59998 19.1996 9.19703 19.1996 8.69998C19.1996 8.20292 18.7967 7.79998 18.2996 7.79998H12.8996Z" fill="#4A4A4A"/>
<path d="M11.9996 15.3C11.9996 14.8029 12.4026 14.4 12.8996 14.4H19.4996C19.9967 14.4 20.3996 14.8029 20.3996 15.3C20.3996 15.797 19.9967 16.2 19.4996 16.2H12.8996C12.4026 16.2 11.9996 15.797 11.9996 15.3Z" fill="#4A4A4A"/>
<path d="M12.8996 17.4C12.4026 17.4 11.9996 17.8029 11.9996 18.3C11.9996 18.797 12.4026 19.2 12.8996 19.2H17.0996C17.5967 19.2 17.9996 18.797 17.9996 18.3C17.9996 17.8029 17.5967 17.4 17.0996 17.4H12.8996Z" fill="#4A4A4A"/>
</svg>',
			'recent-sales-notifications' => '<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M5.70263 14.3086L2.76752 13.9712C0.541918 13.7154 -0.0892949 10.7812 1.83425 9.63284L1.91216 9.58633C2.9594 8.96111 3.60074 7.83128 3.60074 6.6116V5.99998C3.60074 3.01764 6.0184 0.599976 9.00074 0.599976C11.9831 0.599976 14.4007 3.01764 14.4007 5.99998V6.6116C14.4007 7.83128 15.0421 8.96111 16.0893 9.58633L16.1672 9.63284C18.0908 10.7812 17.4596 13.7154 15.234 13.9712L12.1826 14.322V14.76C12.1826 16.5494 10.732 18 8.94263 18C7.15323 18 5.70263 16.5494 5.70263 14.76V14.3086ZM10.3826 14.4H7.50263V14.76C7.50263 15.5553 8.14734 16.2 8.94263 16.2C9.73792 16.2 10.3826 15.5553 10.3826 14.76V14.4ZM6.60074 12.6H11.4007L15.0284 12.183C15.5438 12.1238 15.69 11.4443 15.2445 11.1784L15.1666 11.1318C15.0712 11.0749 14.9779 11.0151 14.887 10.9528C14.7009 10.8251 14.5245 10.6865 14.3583 10.5381C14.3288 10.5118 14.2997 10.4852 14.2708 10.4582C13.2175 9.47395 12.6007 8.08598 12.6007 6.6116V5.99998C12.6007 4.01175 10.989 2.39998 9.00074 2.39998C7.01251 2.39998 5.40074 4.01175 5.40074 5.99998V6.6116C5.40074 8.08598 4.78401 9.47395 3.73065 10.4582C3.70182 10.4852 3.67267 10.5118 3.64319 10.5381C3.47701 10.6865 3.30055 10.8251 3.11447 10.9528C3.02354 11.0151 2.93031 11.0749 2.83486 11.1318L2.75694 11.1784C2.31151 11.4443 2.45768 12.1238 2.97306 12.183L6.60074 12.6Z" fill="#4A4A4A"/>
</svg>',
			'module-side-cart' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="white" xmlns="http://www.w3.org/2000/svg">
<rect width="24" height="24" rx="2" fill="#fff"/>
<g clip-path="url(#clip0_2268_9721)" fill="white">
<rect x="2.99902" y="3" width="18" height="18" rx="1" fill="white" stroke="#4A4A4A" stroke-width="2"/>
<path d="M19.041 4.9707L19.041 18.1105C19.041 18.6628 18.5933 19.1105 18.041 19.1105L14.3413 19.1105C13.789 19.1105 13.3413 18.6628 13.3413 18.1105L13.3413 4.9707L19.041 4.9707Z" fill="#4A4A4A"/>
</g>
<defs>
<clipPath id="clip0_2268_9721" fill="white">
	<rect width="20" height="20" fill="white" transform="translate(2 2)"/>
</clipPath>
</defs>
</svg>',
			'free-shipping-progress-bar' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M3.93548 5.96774C3.93548 5.43327 4.36876 5 4.90323 5H13.9244C15.5087 5 16.901 6.05024 17.3362 7.57357L17.8871 9.50144C17.9187 9.61229 18.0072 9.69781 18.119 9.72577L20.2896 10.2684C21.2948 10.5197 22 11.4229 22 12.4591V14.0323C22 14.9494 21.4532 15.7388 20.6679 16.0923C20.6954 16.2618 20.7097 16.4357 20.7097 16.6129C20.7097 18.3945 19.2654 19.8387 17.4839 19.8387C15.7023 19.8387 14.2581 18.3945 14.2581 16.6129C14.2581 16.504 14.2635 16.3964 14.274 16.2903H10.3712C10.3817 16.3964 10.3871 16.504 10.3871 16.6129C10.3871 18.3945 8.94285 19.8387 7.16129 19.8387C5.37973 19.8387 3.93548 18.3945 3.93548 16.6129C3.93548 16.1541 4.03126 15.7177 4.2039 15.3226H3.6129C3.07843 15.3226 2.64516 14.8893 2.64516 14.3548C2.64516 13.8204 3.07843 13.3871 3.6129 13.3871H6.83871C6.87726 13.3871 6.91529 13.3894 6.95266 13.3937C7.02164 13.3893 7.0912 13.3871 7.16129 13.3871C8.06368 13.3871 8.87952 13.7576 9.46498 14.3548H15.1802C15.7656 13.7576 16.5815 13.3871 17.4839 13.3871C18.3848 13.3871 19.1995 13.7565 19.7848 14.352C19.9427 14.3311 20.0645 14.1959 20.0645 14.0323V12.4591C20.0645 12.311 19.9638 12.182 19.8202 12.1461L17.6496 11.6035C16.8667 11.4077 16.2477 10.8091 16.026 10.0332L15.4752 8.10529C15.2774 7.41287 14.6445 6.93548 13.9244 6.93548H4.90323C4.36876 6.93548 3.93548 6.50221 3.93548 5.96774ZM7.16129 17.9032C7.87392 17.9032 8.45161 17.3255 8.45161 16.6129C8.45161 15.9003 7.87392 15.3226 7.16129 15.3226C6.44866 15.3226 5.87097 15.9003 5.87097 16.6129C5.87097 17.3255 6.44866 17.9032 7.16129 17.9032ZM17.4839 17.9032C18.1965 17.9032 18.7742 17.3255 18.7742 16.6129C18.7742 15.9003 18.1965 15.3226 17.4839 15.3226C16.7712 15.3226 16.1935 15.9003 16.1935 16.6129C16.1935 17.3255 16.7712 17.9032 17.4839 17.9032Z" fill="#4A4A4A"/>
<path d="M2.96774 9.51613C2.43327 9.51613 2 9.9494 2 10.4839C2 11.0183 2.43327 11.4516 2.96774 11.4516H9.41935C9.95382 11.4516 10.3871 11.0183 10.3871 10.4839C10.3871 9.9494 9.95382 9.51613 9.41935 9.51613H2.96774Z" fill="#4A4A4A"/>
</svg>
',
			'added-to-cart-popup' => '<svg width="18" height="17" viewBox="0 0 18 17" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M0 1.09995C0 0.602895 0.402944 0.199951 0.9 0.199951H14.1C14.5971 0.199951 15 0.602895 15 1.09995V3.19995H17.1C17.5971 3.19995 18 3.60289 18 4.09995V8.59995C18 9.09701 17.5971 9.49995 17.1 9.49995C16.6029 9.49995 16.2 9.09701 16.2 8.59995V7.99995H4.8V11.9V14H9.6C10.0971 14 10.5 14.4029 10.5 14.9C10.5 15.397 10.0971 15.8 9.6 15.8H3.9C3.40294 15.8 3 15.397 3 14.9V12.8H0.9C0.402944 12.8 0 12.397 0 11.9V1.09995ZM16.2 4.99995V6.19995H4.8V4.99995H16.2ZM13.2 1.99995V3.19995H3.9C3.40294 3.19995 3 3.60289 3 4.09995V11H1.8V1.99995H13.2ZM12.0782 9.75122C11.874 9.70044 11.658 9.7604 11.5092 9.90923C11.3604 10.0581 11.3004 10.274 11.3512 10.4782L12.6968 15.8907C12.7489 16.1007 12.9101 16.2662 13.1185 16.3241C13.3269 16.382 13.5503 16.3232 13.7033 16.1702L15.1004 14.7732L16.1095 15.7824C16.3439 16.0167 16.7238 16.0167 16.9581 15.7824L17.3823 15.3581C17.6166 15.1238 17.6166 14.7439 17.3823 14.5096L16.3731 13.5004L17.7702 12.1033C17.9232 11.9504 17.9819 11.727 17.9241 11.5185C17.8662 11.3101 17.7006 11.149 17.4907 11.0968L12.0782 9.75122Z" fill="#4A4A4A"/>
</svg>',
			'module-product-bundles' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M2.79173 1.46071C3.44069 0.544528 4.49369 0 5.61643 0H14.5342C15.6916 0 16.7724 0.578427 17.4144 1.54142L19.2894 4.35404C19.7528 5.04902 20 5.86559 20 6.70085V17.3077C20 18.7946 18.7946 20 17.3077 20H2.69231C1.20539 20 0 18.7946 0 17.3077V6.74858C0 5.8725 0.271969 5.01802 0.778358 4.30312L2.79173 1.46071ZM5.61643 2.30769C5.24219 2.30769 4.89118 2.4892 4.67486 2.7946L3.38514 4.61538H8.84615V2.30769H5.61643ZM11.1538 4.61538H16.6902L15.4943 2.8215C15.2803 2.5005 14.92 2.30769 14.5342 2.30769H11.1538V4.61538ZM17.6923 6.92308H2.30769V17.3077C2.30769 17.5201 2.47989 17.6923 2.69231 17.6923H17.3077C17.5201 17.6923 17.6923 17.5201 17.6923 17.3077V6.92308Z" fill="#4A4A4A"/>
</svg>',
			'module-storewide-sale' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M13.5515 7.80334C13.9256 7.42921 13.9256 6.82263 13.5515 6.44849C13.1773 6.07436 12.5708 6.07436 12.1966 6.44849L6.44849 12.1966C6.07436 12.5708 6.07436 13.1773 6.44849 13.5515C6.82263 13.9256 7.42921 13.9256 7.80334 13.5515L13.5515 7.80334Z" fill="#4A4A4A"/>
<path d="M8.72262 7.44526C8.72262 8.15073 8.15073 8.72262 7.44526 8.72262C6.73979 8.72262 6.1679 8.15073 6.1679 7.44526C6.1679 6.73979 6.73979 6.1679 7.44526 6.1679C8.15073 6.1679 8.72262 6.73979 8.72262 7.44526Z" fill="#4A4A4A"/>
<path d="M12.5547 13.8321C13.2602 13.8321 13.8321 13.2602 13.8321 12.5547C13.8321 11.8492 13.2602 11.2774 12.5547 11.2774C11.8492 11.2774 11.2774 11.8492 11.2774 12.5547C11.2774 13.2602 11.8492 13.8321 12.5547 13.8321Z" fill="#4A4A4A"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M12.6752 1.71552C11.6251 -0.571841 8.37486 -0.571841 7.32478 1.71552C7.10051 2.20403 6.53767 2.43717 6.03366 2.25032C3.67373 1.37543 1.37543 3.67373 2.25032 6.03366C2.43717 6.53767 2.20403 7.10051 1.71552 7.32478C-0.571841 8.37486 -0.571842 11.6251 1.71552 12.6752C2.20403 12.8995 2.43717 13.4623 2.25032 13.9663C1.37543 16.3263 3.67373 18.6246 6.03366 17.7497C6.53767 17.5628 7.10051 17.796 7.32478 18.2845C8.37486 20.5718 11.6251 20.5718 12.6752 18.2845C12.8995 17.796 13.4623 17.5628 13.9663 17.7497C16.3263 18.6246 18.6246 16.3263 17.7497 13.9663C17.5628 13.4623 17.796 12.8995 18.2845 12.6752C20.5718 11.6251 20.5718 8.37486 18.2845 7.32478C17.796 7.10051 17.5628 6.53767 17.7497 6.03366C18.6246 3.67373 16.3263 1.37543 13.9663 2.25032C13.4623 2.43717 12.8995 2.20403 12.6752 1.71552ZM9.06609 2.51493C9.43267 1.71642 10.5673 1.71642 10.9339 2.51493C11.5763 3.91428 13.1886 4.58212 14.6324 4.04688C15.4562 3.74146 16.2585 4.54379 15.9531 5.36763C15.4179 6.81138 16.0857 8.42368 17.4851 9.06609C18.2836 9.43267 18.2836 10.5673 17.4851 10.9339C16.0857 11.5763 15.4179 13.1886 15.9531 14.6324C16.2585 15.4562 15.4562 16.2585 14.6324 15.9531C13.1886 15.4179 11.5763 16.0857 10.9339 17.4851C10.5673 18.2836 9.43267 18.2836 9.06609 17.4851C8.42368 16.0857 6.81138 15.4179 5.36763 15.9531C4.54379 16.2585 3.74146 15.4562 4.04688 14.6324C4.58212 13.1886 3.91428 11.5763 2.51493 10.9339C1.71642 10.5673 1.71642 9.43267 2.51493 9.06609C3.91428 8.42368 4.58212 6.81138 4.04688 5.36763C3.74146 4.54379 4.54379 3.74146 5.36763 4.04688C6.81138 4.58212 8.42368 3.91428 9.06609 2.51493Z" fill="#4A4A4A"/>
</svg>',
			'module-agree-to-terms-checkbox' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M1.62337 2.2534L1.01414 5.8356C0.910472 6.44513 1.39012 7 2.02069 7H2.93141C3.51118 7 4.04118 6.679 4.30046 6.17082L4.89784 5L5.49521 6.17082C5.75449 6.679 6.28449 7 6.86426 7H8.03357C8.61334 7 9.14335 6.679 9.40263 6.17082L10 5L10.5974 6.17082C10.8567 6.679 11.3867 7 11.9664 7H13.1357C13.7155 7 14.2455 6.679 14.5048 6.17082L15.1022 5L15.6995 6.17082C15.9588 6.679 16.4888 7 17.0686 7H17.9793C18.6099 7 19.0895 6.44513 18.9859 5.8356L18.3766 2.2534C18.2536 1.53012 17.615 1 16.8668 1H3.13319C2.38495 1 1.74638 1.53012 1.62337 2.2534Z" fill="#4A4A4A"/>
<path d="M13.7071 9.29289C14.0976 9.68342 14.0976 10.3166 13.7071 10.7071L9.70711 14.7071C9.31658 15.0976 8.68342 15.0976 8.29289 14.7071L6.29289 12.7071C5.90237 12.3166 5.90237 11.6834 6.29289 11.2929C6.68342 10.9024 7.31658 10.9024 7.70711 11.2929L9 12.5858L12.2929 9.29289C12.6834 8.90237 13.3166 8.90237 13.7071 9.29289Z" fill="#4A4A4A"/>
<path d="M4 9H2V17.5C2 18.3284 2.67157 19 3.5 19H16.5C17.3284 19 18 18.3284 18 17.5V9H16V17H4V9Z" fill="#4A4A4A"/>
</svg>',
			'module-trust-badges' => '<svg width="18" height="20" viewBox="0 0 18 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M6.42519 8.29248C6.03041 7.8977 5.39034 7.8977 4.99556 8.29248C4.60078 8.68726 4.60078 9.32733 4.99556 9.72211L7.08219 11.8087C7.47698 12.2035 8.11704 12.2035 8.51183 11.8087L12.5046 7.81594C12.8994 7.42116 12.8994 6.78109 12.5046 6.38631C12.1099 5.99153 11.4698 5.99153 11.075 6.38631L7.79701 9.6643L6.42519 8.29248Z" fill="#4A4A4A"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M10.2166 0.516881C9.35515 -0.172293 8.13105 -0.172294 7.26959 0.51688L6.84243 0.858603C5.51288 1.92224 4.05633 2.81657 2.50624 3.52102L1.3648 4.03976C0.530978 4.4187 -0.0411095 5.26795 0.0023133 6.23358C0.381083 14.6567 5.90704 18.4285 7.73017 19.4453C8.36269 19.7981 9.12339 19.798 9.75583 19.4455C11.5781 18.4299 17.1063 14.6614 17.484 6.25905C17.5272 5.29851 16.9611 4.45269 16.1339 4.07094L14.9206 3.51096C13.4112 2.81431 11.9919 1.93711 10.6938 0.898607L10.2166 0.516881ZM8.5326 2.09564C8.65566 1.99719 8.83053 1.99719 8.9536 2.09565L9.43076 2.47737C10.8566 3.61803 12.4155 4.5815 14.0734 5.34667L15.2867 5.90666C15.4143 5.96554 15.4683 6.07838 15.4643 6.16826C15.1317 13.5669 10.3049 16.8249 8.77153 17.6795C8.75831 17.6869 8.74902 17.6881 8.74318 17.6881C8.73734 17.6881 8.7281 17.6869 8.71496 17.6796C7.18299 16.8251 2.35581 13.5643 2.02208 6.14276C2.01801 6.05228 2.07267 5.93886 2.2013 5.8804L3.34274 5.36166C5.0453 4.58792 6.64512 3.60563 8.10544 2.43737L8.5326 2.09564Z" fill="#4A4A4A"/>
</svg>',
			'module-payment-logos' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M7.12623 8.82225e-07H12.6238C13.2022 -1.78758e-05 13.7012 -3.40568e-05 14.1121 0.0335443C14.5459 0.0689856 14.9774 0.147235 15.3925 0.358773C16.0119 0.674356 16.5155 1.17792 16.831 1.79728C17.0426 2.21245 17.1208 2.6439 17.1563 3.07768C17.1899 3.48866 17.1898 3.98763 17.1898 4.56602V10.1493C18.6884 10.7345 19.75 12.1923 19.75 13.8981V16.8241C19.75 18.238 18.6038 19.3843 17.1898 19.3843H2.56018C1.14623 19.3843 0 18.238 0 16.8241V13.8981C0 12.1923 1.06162 10.7345 2.56019 10.1493L2.56019 4.56605C2.56017 3.98765 2.56015 3.48867 2.59373 3.07768C2.62917 2.6439 2.70742 2.21245 2.91896 1.79728C3.23454 1.17792 3.7381 0.674356 4.35747 0.358773C4.77263 0.147235 5.20408 0.0689856 5.63786 0.0335443C6.04884 -3.40568e-05 6.54785 -1.78758e-05 7.12623 8.82225e-07ZM7.16852 2.19445H9.875V9.50926H4.75463V4.60834C4.75463 3.97573 4.75549 3.56726 4.78089 3.25638C4.80524 2.9583 4.84658 2.84779 4.87422 2.79354C4.97942 2.58709 5.14727 2.41923 5.35373 2.31404C5.40798 2.2864 5.51849 2.24505 5.81656 2.2207C6.12745 2.1953 6.53591 2.19445 7.16852 2.19445ZM12.8009 2.19453V9.50926H14.9954V4.60834C14.9954 3.97573 14.9945 3.56726 14.9691 3.25638C14.9448 2.9583 14.9034 2.84779 14.8758 2.79354C14.7706 2.58709 14.6027 2.41923 14.3963 2.31404C14.342 2.2864 14.2315 2.24505 13.9334 2.2207C13.6601 2.19837 13.3112 2.19501 12.8009 2.19453ZM2.19444 13.8981C2.19444 12.8882 3.01318 12.0694 4.02315 12.0694H15.7269C16.7368 12.0694 17.5556 12.8882 17.5556 13.8981V16.8241C17.5556 17.0261 17.3918 17.1898 17.1898 17.1898H2.56018C2.35819 17.1898 2.19444 17.0261 2.19444 16.8241V13.8981Z" fill="#4A4A4A"/>
</svg>',
			'module-inactive-tab-message' => '<svg width="21" height="17" viewBox="0 0 21 17" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M0.9 0C0.402944 0 0 0.402944 0 0.9V11.7C0 12.1971 0.402944 12.6 0.9 12.6C1.39706 12.6 1.8 12.1971 1.8 11.7V1.8H14.1C14.5971 1.8 15 1.39706 15 0.9C15 0.402944 14.5971 0 14.1 0H0.9Z" fill="#4A4A4A"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M3 3.9C3 3.40294 3.40294 3 3.9 3H16.5C16.9971 3 17.4 3.40294 17.4 3.9V9.3C17.4 9.79706 16.9971 10.2 16.5 10.2C16.0029 10.2 15.6 9.79706 15.6 9.3V7.8H4.8V13.8H8.7C9.19706 13.8 9.6 14.2029 9.6 14.7C9.6 15.1971 9.19706 15.6 8.7 15.6H3.9C3.40294 15.6 3 15.1971 3 14.7V3.9ZM15.6 4.8V6H4.8V4.8H15.6Z" fill="#4A4A4A"/>
<path d="M15.4142 13.063L15.2684 13.1368C15.126 13.208 14.9611 13.2204 14.81 13.17C14.659 13.1197 14.5341 13.0114 14.4629 12.8689C14.3917 12.7265 14.38 12.5616 14.4303 12.4106C14.4807 12.2595 14.589 12.1346 14.7314 12.0634L15.9314 11.4634C16.0304 11.4134 16.1413 11.3918 16.2518 11.4011C16.3623 11.4104 16.4681 11.4502 16.5573 11.5161C16.6465 11.582 16.7157 11.6714 16.7571 11.7743C16.7985 11.8772 16.8105 11.9895 16.7918 12.0988L16.1918 15.6988C16.1684 15.8387 16.0962 15.9658 15.988 16.0575C15.8798 16.1492 15.7426 16.1997 15.6008 16.1998C15.5136 16.1998 15.4275 16.1808 15.3484 16.1441C15.2693 16.1074 15.1991 16.054 15.1427 15.9875C15.0863 15.921 15.045 15.843 15.0218 15.759C14.9985 15.675 14.9938 15.5869 15.008 15.5008L15.4142 13.063Z" fill="#4A4A4A"/>
<path d="M12.3705 12.5546C12.2977 12.5243 12.2316 12.4799 12.176 12.424L11.576 11.824C11.5203 11.7683 11.4761 11.7022 11.446 11.6294C11.4158 11.5566 11.4003 11.4786 11.4003 11.3998C11.4003 11.3211 11.4158 11.243 11.446 11.1703C11.4761 11.0975 11.5203 11.0313 11.576 10.9756C11.6317 10.9199 11.6978 10.8757 11.7706 10.8456C11.8434 10.8154 11.9214 10.7999 12.0002 10.7999C12.079 10.7999 12.157 10.8154 12.2298 10.8456C12.3026 10.8757 12.3687 10.9199 12.4244 10.9756L13.0244 11.5756C13.0802 11.6313 13.1244 11.6974 13.1546 11.7702C13.1848 11.843 13.2003 11.921 13.2003 11.9998C13.2003 12.0786 13.1848 12.1567 13.1546 12.2295C13.1244 12.3022 13.0802 12.3684 13.0244 12.424C12.9688 12.4799 12.9027 12.5243 12.8299 12.5546C12.7571 12.5849 12.679 12.6005 12.6002 12.6005C12.5214 12.6005 12.4433 12.5849 12.3705 12.5546Z" fill="#4A4A4A"/>
<path d="M18.8298 12.5543C18.757 12.5844 18.679 12.5999 18.6002 12.5998C18.4814 12.6001 18.3652 12.5651 18.2664 12.4992C18.1676 12.4333 18.0905 12.3395 18.0451 12.2298C17.9996 12.1201 17.9878 11.9993 18.0111 11.8828C18.0344 11.7664 18.0918 11.6594 18.176 11.5756L18.776 10.9756C18.8885 10.8631 19.0411 10.7999 19.2002 10.7999C19.3593 10.7999 19.5119 10.8631 19.6244 10.9756C19.7369 11.0881 19.8001 11.2407 19.8001 11.3998C19.8001 11.5589 19.7369 11.7115 19.6244 11.824L19.0244 12.424C18.9688 12.4798 18.9026 12.5241 18.8298 12.5543Z" fill="#4A4A4A"/>
<path d="M18.7759 14.8241C18.6634 14.7116 18.6002 14.559 18.6002 14.3998C18.6002 14.2407 18.6634 14.0881 18.7759 13.9756C18.8885 13.8631 19.0411 13.7998 19.2002 13.7998H20.4002C20.5593 13.7998 20.7119 13.8631 20.8245 13.9756C20.937 14.0881 21.0002 14.2407 21.0002 14.3998C21.0002 14.559 20.937 14.7116 20.8245 14.8241C20.7119 14.9366 20.5593 14.9998 20.4002 14.9998H19.2002C19.0411 14.9998 18.8885 14.9366 18.7759 14.8241Z" fill="#4A4A4A"/>
<path d="M12.0002 14.9998H10.8002C10.6411 14.9998 10.4885 14.9366 10.3759 14.8241C10.2634 14.7116 10.2002 14.559 10.2002 14.3998C10.2002 14.2407 10.2634 14.0881 10.3759 13.9756C10.4885 13.8631 10.6411 13.7998 10.8002 13.7998H12.0002C12.1593 13.7998 12.3119 13.8631 12.4245 13.9756C12.537 14.0881 12.6002 14.2407 12.6002 14.3998C12.6002 14.559 12.537 14.7116 12.4245 14.8241C12.3119 14.9366 12.1593 14.9998 12.0002 14.9998Z" fill="#4A4A4A"/>
</svg>',
			'module-cart-count-favicon' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M5 2C4.44772 2 4 2.44772 4 3C4 3.55228 4.44772 4 5 4H7.14931C7.31817 4 7.46035 4.12626 7.48031 4.29393L8.86704 15.9425C9.00677 17.1162 10.002 18 11.184 18H18.3333C18.8856 18 19.3333 17.5523 19.3333 17C19.3333 16.4477 18.8856 16 18.3333 16H11.184C11.0152 16 10.873 15.8737 10.853 15.7061L10.7293 14.6667H17.8639C19.7799 14.6667 21.3728 13.1915 21.5198 11.2812L21.9971 5.0767C22.0184 4.79897 21.923 4.52492 21.7337 4.32055C21.5445 4.11618 21.2785 4 21 4H9.45873C9.29387 2.85507 8.3119 2 7.14931 2H5ZM17.8639 12.6667H10.4912L9.69754 6H19.9201L19.5257 11.1278C19.4589 11.9962 18.7348 12.6667 17.8639 12.6667Z" fill="#4A4A4A"/>
<path d="M12.6667 20.6667C12.6667 21.403 12.0697 22 11.3333 22C10.597 22 10 21.403 10 20.6667C10 19.9303 10.597 19.3333 11.3333 19.3333C12.0697 19.3333 12.6667 19.9303 12.6667 20.6667Z" fill="#4A4A4A"/>
<path d="M19.3333 20.6667C19.3333 21.403 18.7364 22 18 22C17.2636 22 16.6667 21.403 16.6667 20.6667C16.6667 19.9303 17.2636 19.3333 18 19.3333C18.7364 19.3333 19.3333 19.9303 19.3333 20.6667Z" fill="#4A4A4A"/>
<circle cx="18.4985" cy="5.49854" r="5.49854" fill="white"/>
<path d="M18.345 5.88592L18.2235 5.94742C18.1048 6.00677 17.9674 6.01703 17.8415 5.97507C17.7157 5.93311 17.6116 5.84286 17.5522 5.72417C17.4929 5.60549 17.4831 5.46809 17.5251 5.34221C17.5671 5.21633 17.6573 5.11227 17.776 5.05292L18.776 4.55292C18.8585 4.51122 18.9509 4.49325 19.043 4.501C19.1351 4.50875 19.2232 4.54193 19.2976 4.59684C19.3719 4.65174 19.4296 4.72621 19.4641 4.81195C19.4986 4.89769 19.5086 4.99133 19.493 5.08242L18.993 8.08242C18.9735 8.199 18.9133 8.3049 18.8232 8.38132C18.733 8.45775 18.6187 8.49977 18.5005 8.49992C18.4278 8.49988 18.3561 8.48403 18.2901 8.45347C18.2242 8.42291 18.1657 8.37838 18.1187 8.32297C18.0717 8.26755 18.0374 8.20258 18.018 8.13255C17.9986 8.06252 17.9947 7.98912 18.0065 7.91742L18.345 5.88592Z" fill="#4A4A4A"/>
<path d="M15.8086 5.46222C15.7479 5.43699 15.6928 5.40002 15.6465 5.35342L15.1465 4.85342C15.1001 4.807 15.0633 4.75189 15.0381 4.69124C15.013 4.63058 15.0001 4.56558 15.0001 4.49992C15.0001 4.43427 15.013 4.36927 15.0381 4.30861C15.0633 4.24796 15.1001 4.19285 15.1465 4.14642C15.1929 4.1 15.248 4.06318 15.3087 4.03805C15.3693 4.01293 15.4343 4 15.5 4C15.5657 4 15.6307 4.01293 15.6913 4.03805C15.752 4.06318 15.8071 4.1 15.8535 4.14642L16.3535 4.64642C16.4 4.69282 16.4368 4.74792 16.462 4.80858C16.4872 4.86924 16.5001 4.93426 16.5001 4.99992C16.5001 5.06559 16.4872 5.13061 16.462 5.19127C16.4368 5.25193 16.4 5.30703 16.3535 5.35342C16.3072 5.40002 16.2521 5.43699 16.1914 5.46222C16.1308 5.48745 16.0657 5.50044 16 5.50044C15.9343 5.50044 15.8692 5.48745 15.8086 5.46222Z" fill="#4A4A4A"/>
<path d="M21.1914 5.46194C21.1307 5.48709 21.0657 5.49999 21 5.49992C20.901 5.50014 20.8042 5.47095 20.7218 5.41605C20.6395 5.36114 20.5753 5.28301 20.5374 5.19156C20.4995 5.10011 20.4897 4.99947 20.5091 4.90241C20.5285 4.80536 20.5764 4.71626 20.6465 4.64642L21.1465 4.14642C21.2403 4.05267 21.3674 4 21.5 4C21.6326 4 21.7597 4.05267 21.8535 4.14642C21.9473 4.24018 21.9999 4.36734 21.9999 4.49992C21.9999 4.63251 21.9473 4.75967 21.8535 4.85342L21.3535 5.35342C21.3071 5.39992 21.252 5.4368 21.1914 5.46194Z" fill="#4A4A4A"/>
<path d="M21.1464 7.35348C21.0527 7.25971 21 7.13253 21 6.99992C21 6.86732 21.0527 6.74014 21.1464 6.64637C21.2402 6.5526 21.3674 6.49992 21.5 6.49992H22.5C22.6326 6.49992 22.7598 6.5526 22.8536 6.64637C22.9473 6.74014 23 6.86732 23 6.99992C23 7.13253 22.9473 7.25971 22.8536 7.35348C22.7598 7.44725 22.6326 7.49992 22.5 7.49992H21.5C21.3674 7.49992 21.2402 7.44725 21.1464 7.35348Z" fill="#4A4A4A"/>
<path d="M15.5 7.49992H14.5C14.3674 7.49992 14.2402 7.44725 14.1464 7.35348C14.0527 7.25971 14 7.13253 14 6.99992C14 6.86732 14.0527 6.74014 14.1464 6.64637C14.2402 6.5526 14.3674 6.49992 14.5 6.49992H15.5C15.6326 6.49992 15.7598 6.5526 15.8536 6.64637C15.9473 6.74014 16 6.86732 16 6.99992C16 7.13253 15.9473 7.25971 15.8536 7.35348C15.7598 7.44725 15.6326 7.49992 15.5 7.49992Z" fill="#4A4A4A"/>
</svg>',
			'module-pre-orders' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.69 5.77185L9.447 5.89485C9.20963 6.01353 8.93484 6.03406 8.68307 5.95014C8.4313 5.86622 8.22318 5.68572 8.1045 5.44835C7.98582 5.21098 7.96629 4.93619 8.05021 4.68442C8.13413 4.43265 8.31463 4.22453 8.552 4.10585L10.552 3.10585C10.717 3.02245 10.9018 2.98649 11.086 3.002C11.2702 3.01751 11.4465 3.08386 11.5952 3.19367C11.7439 3.30348 11.8591 3.45242 11.9281 3.6239C11.9972 3.79538 12.0172 3.98266 11.986 4.16485L10.986 10.1648C10.947 10.398 10.8267 10.6098 10.6463 10.7626C10.466 10.9155 10.2374 10.9995 10.001 10.9998C9.85568 10.9998 9.71212 10.9681 9.58027 10.9069C9.44843 10.8458 9.33145 10.7568 9.23746 10.6459C9.14347 10.5351 9.07471 10.4052 9.03595 10.2651C8.99719 10.125 8.98936 9.97823 9.013 9.83485L9.69 5.77185Z" fill="#4A4A4A"/>
<path d="M4.61715 4.92444C4.49581 4.87398 4.38565 4.80003 4.293 4.70685L3.293 3.70685C3.20016 3.614 3.12651 3.50378 3.07626 3.38247C3.02601 3.26117 3.00015 3.13115 3.00015 2.99985C3.00015 2.86855 3.02601 2.73853 3.07626 2.61722C3.12651 2.49592 3.20016 2.38569 3.293 2.29285C3.38584 2.2 3.49607 2.12636 3.61737 2.07611C3.73868 2.02586 3.8687 2 4 2C4.1313 2 4.26132 2.02586 4.38263 2.07611C4.50393 2.12636 4.61416 2.2 4.707 2.29285L5.707 3.29285C5.79995 3.38564 5.87368 3.49584 5.92399 3.61716C5.9743 3.73847 6.0002 3.86852 6.0002 3.99985C6.0002 4.13118 5.9743 4.26123 5.92399 4.38254C5.87368 4.50386 5.79995 4.61406 5.707 4.70685C5.61435 4.80003 5.50419 4.87398 5.38285 4.92444C5.26152 4.97491 5.13141 5.00088 5 5.00088C4.86859 5.00088 4.73848 4.97491 4.61715 4.92444Z" fill="#4A4A4A"/>
<path d="M15.3827 4.92389C15.2614 4.97417 15.1313 4.99998 15 4.99985C14.802 5.00029 14.6084 4.9419 14.4437 4.83209C14.279 4.72229 14.1506 4.56602 14.0748 4.38312C13.9991 4.20023 13.9794 3.99894 14.0182 3.80483C14.0571 3.61071 14.1527 3.43251 14.293 3.29285L15.293 2.29285C15.4805 2.10534 15.7348 2 16 2C16.2652 2 16.5195 2.10534 16.707 2.29285C16.8945 2.48036 16.9998 2.73467 16.9998 2.99985C16.9998 3.26503 16.8945 3.51934 16.707 3.70685L15.707 4.70685C15.6143 4.79985 15.5041 4.87361 15.3827 4.92389Z" fill="#4A4A4A"/>
<path d="M15.2929 8.70696C15.1054 8.51942 15 8.26507 15 7.99985C15 7.73463 15.1054 7.48028 15.2929 7.29274C15.4804 7.10521 15.7348 6.99985 16 6.99985H18C18.2652 6.99985 18.5196 7.10521 18.7071 7.29274C18.8946 7.48028 19 7.73463 19 7.99985C19 8.26507 18.8946 8.51942 18.7071 8.70696C18.5196 8.89449 18.2652 8.99985 18 8.99985H16C15.7348 8.99985 15.4804 8.89449 15.2929 8.70696Z" fill="#4A4A4A"/>
<path d="M4 8.99985H2C1.73478 8.99985 1.48043 8.89449 1.29289 8.70696C1.10536 8.51942 1 8.26507 1 7.99985C1 7.73463 1.10536 7.48028 1.29289 7.29274C1.48043 7.10521 1.73478 6.99985 2 6.99985H4C4.26522 6.99985 4.51957 7.10521 4.70711 7.29274C4.89464 7.48028 5 7.73463 5 7.99985C5 8.26507 4.89464 8.51942 4.70711 8.70696C4.51957 8.89449 4.26522 8.99985 4 8.99985Z" fill="#4A4A4A"/>
<path d="M1 17.5V12H3V14H6.5C7.27479 14 7.88768 14.6623 8.42584 15.2439C8.46292 15.2839 8.50017 15.3242 8.53657 15.3632C8.90168 15.755 9.42223 16 10 16C10.5778 16 11.0983 15.755 11.4634 15.3632C11.4999 15.3241 11.5367 15.2843 11.5739 15.2441C12.1121 14.6626 12.7252 14 13.5 14H17V12H19V17.5C19 18.3284 18.3284 19 17.5 19H2.5C1.67157 19 1 18.3284 1 17.5Z" fill="#4A4A4A"/>
</svg>',
			'module-product-labels' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.4816 6.89747C15.3282 6.89747 16.0144 6.21123 16.0144 5.3647C16.0144 4.51818 15.3282 3.83193 14.4816 3.83193C13.6351 3.83193 12.9489 4.51818 12.9489 5.3647C12.9489 6.21123 13.6351 6.89747 14.4816 6.89747Z" fill="#4A4A4A"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M11.839 0C10.277 0 8.7822 0.635744 7.6987 1.76092L1.17889 8.53149C-0.414379 10.186 -0.389608 12.8116 1.23458 14.4358L5.67641 18.8777C7.15295 20.3542 9.53986 20.3767 11.044 18.9283L18.3202 11.9215C19.2954 10.9825 19.8463 9.68704 19.8463 8.33327V4.98151C19.8463 2.2303 17.616 0 14.8648 0H11.839ZM9.35483 3.35571C10.0049 2.6806 10.9018 2.29916 11.839 2.29916H14.8648C16.3463 2.29916 17.5472 3.50009 17.5472 4.98151V8.33327C17.5472 9.06222 17.2505 9.75978 16.7254 10.2654L9.4492 17.2722C8.84754 17.8515 7.89278 17.8425 7.30217 17.2519L2.86033 12.8101C2.12206 12.0718 2.11081 10.8783 2.83502 10.1263L9.35483 3.35571Z" fill="#4A4A4A"/>
</svg>',
			'module-quick-view' => '<svg width="20" height="16" viewBox="0 0 20 16" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M14 8C14 10.2091 12.2091 12 10 12C7.79086 12 6 10.2091 6 8C6 5.79086 7.79086 4 10 4C12.2091 4 14 5.79086 14 8ZM12 8C12 9.10457 11.1046 10 10 10C8.89543 10 8 9.10457 8 8C8 6.89543 8.89543 6 10 6C11.1046 6 12 6.89543 12 8Z" fill="#4A4A4A"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M10 0C6.69804 0 4.20204 1.63969 2.56353 3.37622C1.74331 4.2455 1.12023 5.15606 0.697714 5.93929C0.486507 6.33082 0.319639 6.70122 0.202994 7.02893C0.0952411 7.33165 0 7.68026 0 8C0 8.31975 0.0952411 8.66835 0.202994 8.97108C0.319639 9.29878 0.486507 9.66918 0.697714 10.0607C1.12023 10.8439 1.74331 11.7545 2.56353 12.6238C4.20204 14.3603 6.69804 16 10 16C13.302 16 15.798 14.3603 17.4365 12.6238C18.2567 11.7545 18.8798 10.8439 19.3023 10.0607C19.5135 9.66918 19.6804 9.29878 19.797 8.97108C19.9048 8.66835 20 8.31975 20 8C20 7.68026 19.9048 7.33165 19.797 7.02893C19.6804 6.70122 19.5135 6.33082 19.3023 5.93929C18.8798 5.15606 18.2567 4.2455 17.4365 3.37622C15.798 1.63969 13.302 0 10 0ZM2.00188 8.00276L2.00137 8L2.00188 7.99724C2.00678 7.97083 2.02436 7.87611 2.08719 7.69959C2.16358 7.48498 2.28563 7.20825 2.45793 6.88883C2.80244 6.25019 3.3248 5.48366 4.0182 4.74878C5.40693 3.27698 7.41092 2 10 2C12.5891 2 14.5931 3.27698 15.9818 4.74878C16.6752 5.48366 17.1976 6.25019 17.5421 6.88883C17.7144 7.20825 17.8364 7.48498 17.9128 7.69959C17.9756 7.87611 17.9932 7.97083 17.9981 7.99724L17.9986 8L17.9981 8.00276C17.9932 8.02917 17.9756 8.12389 17.9128 8.30041C17.8364 8.51502 17.7144 8.79175 17.5421 9.11117C17.1976 9.74981 16.6752 10.5163 15.9818 11.2512C14.5931 12.723 12.5891 14 10 14C7.41092 14 5.40693 12.723 4.0182 11.2512C3.3248 10.5163 2.80244 9.74981 2.45793 9.11117C2.28563 8.79175 2.16358 8.51502 2.08719 8.30041C2.02436 8.12389 2.00678 8.02917 2.00188 8.00276Z" fill="#4A4A4A"/>
</svg>',
			'module-animated-add-to-cart' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M0 2.625C0 1.17525 1.17525 0 2.625 0H4.125C4.74632 0 5.25 0.50368 5.25 1.125C5.25 1.74632 4.74632 2.25 4.125 2.25H2.625C2.41789 2.25 2.25 2.41789 2.25 2.625V4.125C2.25 4.74632 1.74632 5.25 1.125 5.25C0.50368 5.25 0 4.74632 0 4.125V2.625Z" fill="#4A4A4A"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M0 8.625C0 7.17525 1.17525 6 2.625 6H16.875C18.3247 6 19.5 7.17525 19.5 8.625V10.875C19.5 12.3247 18.3247 13.5 16.875 13.5H2.625C1.17525 13.5 0 12.3247 0 10.875V8.625ZM2.625 8.25C2.41789 8.25 2.25 8.41789 2.25 8.625V10.875C2.25 11.0821 2.41789 11.25 2.625 11.25H16.875C17.0821 11.25 17.25 11.0821 17.25 10.875V8.625C17.25 8.41789 17.0821 8.25 16.875 8.25H2.625Z" fill="#4A4A4A"/>
<path d="M0 16.875C0 18.3247 1.17525 19.5 2.625 19.5H4.125C4.74632 19.5 5.25 18.9963 5.25 18.375C5.25 17.7537 4.74632 17.25 4.125 17.25H2.625C2.41789 17.25 2.25 17.0821 2.25 16.875V15.375C2.25 14.7537 1.74632 14.25 1.125 14.25C0.50368 14.25 0 14.7537 0 15.375V16.875Z" fill="#4A4A4A"/>
<path d="M16.875 0C18.3247 0 19.5 1.17525 19.5 2.625V4.125C19.5 4.74632 18.9963 5.25 18.375 5.25C17.7537 5.25 17.25 4.74632 17.25 4.125V2.625C17.25 2.41789 17.0821 2.25 16.875 2.25H15.375C14.7537 2.25 14.25 1.74632 14.25 1.125C14.25 0.50368 14.7537 0 15.375 0H16.875Z" fill="#4A4A4A"/>
<path d="M16.875 19.5C18.3247 19.5 19.5 18.3247 19.5 16.875V15.375C19.5 14.7537 18.9963 14.25 18.375 14.25C17.7537 14.25 17.25 14.7537 17.25 15.375V16.875C17.25 17.0821 17.0821 17.25 16.875 17.25H15.375C14.7537 17.25 14.25 17.7537 14.25 18.375C14.25 18.9963 14.7537 19.5 15.375 19.5H16.875Z" fill="#4A4A4A"/>
<path d="M12.375 1.125C12.375 1.74632 11.8713 2.25 11.25 2.25L8.25 2.25C7.62868 2.25 7.125 1.74632 7.125 1.125C7.125 0.50368 7.62868 0 8.25 0H11.25C11.8713 0 12.375 0.50368 12.375 1.125Z" fill="#4A4A4A"/>
<path d="M11.25 19.5C11.8713 19.5 12.375 18.9963 12.375 18.375C12.375 17.7537 11.8713 17.25 11.25 17.25H8.25C7.62868 17.25 7.125 17.7537 7.125 18.375C7.125 18.9963 7.62868 19.5 8.25 19.5H11.25Z" fill="#4A4A4A"/>
</svg>',
			'module-buy-now' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M5 2C4.44772 2 4 2.44772 4 3C4 3.55228 4.44772 4 5 4H7.14931C7.31817 4 7.46035 4.12626 7.48031 4.29393L8.86704 15.9425C9.00677 17.1162 10.002 18 11.184 18H18.3333C18.8856 18 19.3333 17.5523 19.3333 17C19.3333 16.4477 18.8856 16 18.3333 16H11.184C11.0152 16 10.873 15.8737 10.853 15.7061L10.7293 14.6667H17.8639C19.7799 14.6667 21.3728 13.1915 21.5198 11.2812L21.9971 5.0767C22.0184 4.79897 21.923 4.52492 21.7337 4.32055C21.5445 4.11618 21.2785 4 21 4H9.45873C9.29387 2.85507 8.3119 2 7.14931 2H5ZM17.8639 12.6667H10.4912L9.69754 6H19.9201L19.5257 11.1278C19.4589 11.9962 18.7348 12.6667 17.8639 12.6667Z" fill="#4A4A4A"/>
<path d="M12.6667 20.6667C12.6667 21.403 12.0697 22 11.3333 22C10.597 22 10 21.403 10 20.6667C10 19.9303 10.597 19.3333 11.3333 19.3333C12.0697 19.3333 12.6667 19.9303 12.6667 20.6667Z" fill="#4A4A4A"/>
<path d="M19.3333 20.6667C19.3333 21.403 18.7364 22 18 22C17.2636 22 16.6667 21.403 16.6667 20.6667C16.6667 19.9303 17.2636 19.3333 18 19.3333C18.7364 19.3333 19.3333 19.9303 19.3333 20.6667Z" fill="#4A4A4A"/>
<circle cx="18.4985" cy="5.49854" r="5.49854" fill="white"/>
<path d="M16.7292 2C16.3265 2 16 2.32646 16 2.72917V4.1875C16 4.59021 16.3265 4.91667 16.7292 4.91667C16.9018 4.91667 17.0417 4.77676 17.0417 4.60417C17.0417 4.43158 16.9018 4.29167 16.7292 4.29167C16.6716 4.29167 16.625 4.24503 16.625 4.1875V2.72917C16.625 2.67164 16.6716 2.625 16.7292 2.625H20.2708C20.3284 2.625 20.375 2.67164 20.375 2.72917V4.1875C20.375 4.24503 20.3284 4.29167 20.2708 4.29167H20.0625C19.8899 4.29167 19.75 4.43158 19.75 4.60417C19.75 4.77676 19.8899 4.91667 20.0625 4.91667H20.2708C20.6735 4.91667 21 4.59021 21 4.1875V2.72917C21 2.32646 20.6735 2 20.2708 2H16.7292Z" fill="#4A4A4A"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M18.3958 3.04167C17.8781 3.04167 17.4583 3.4614 17.4583 3.97917V5.47081L17.2206 5.36349C16.799 5.1732 16.3091 5.41841 16.2088 5.8699L16.1799 6.00006C16.1155 6.28988 16.1921 6.59308 16.3866 6.81743L17.4101 7.99839C17.5486 8.15819 17.7496 8.25 17.9611 8.25H19.8219C20.172 8.25 20.4727 8.00118 20.5382 7.65727L20.8178 6.18918C20.8893 5.81368 20.6587 5.44669 20.2894 5.34819L19.3333 5.09325V3.97917C19.3333 3.4614 18.9136 3.04167 18.3958 3.04167ZM18.0833 3.97917C18.0833 3.80658 18.2233 3.66667 18.3958 3.66667C18.5684 3.66667 18.7083 3.80658 18.7083 3.97917V5.33333C18.7083 5.47491 18.8035 5.5988 18.9403 5.63528L20.1284 5.95209C20.1811 5.96616 20.2141 6.01859 20.2038 6.07223L19.9242 7.54032C19.9149 7.58945 19.8719 7.625 19.8219 7.625H17.9611C17.9309 7.625 17.9022 7.61188 17.8824 7.58906L16.8589 6.4081C16.7941 6.33332 16.7685 6.23225 16.79 6.13564L16.8189 6.00548C16.8332 5.94099 16.9032 5.90596 16.9634 5.93314L17.6423 6.23956C17.739 6.28322 17.8512 6.27482 17.9404 6.21726C18.0295 6.1597 18.0833 6.06084 18.0833 5.95474V3.97917Z" fill="#4A4A4A"/>
</svg>',
			'module-wait-list' => '<svg width="19" height="20" viewBox="0 0 19 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M15.5932 10.5085V6.1017H2.0339V15.2542C2.0339 15.4415 2.18567 15.5932 2.37288 15.5932H7.79661C8.35826 15.5932 8.81356 16.0485 8.81356 16.6102C8.81356 17.1718 8.35826 17.6271 7.79661 17.6271H2.37288C1.06238 17.6271 0 16.5647 0 15.2542V5.9479C0 5.17576 0.239701 4.42266 0.68601 3.79258L2.46051 1.2874C3.03247 0.479923 3.96054 0 4.95007 0H12.8098C13.8299 0 14.7824 0.5098 15.3483 1.35854L17.0009 3.83746C17.4092 4.44998 17.6271 5.16967 17.6271 5.90583V10.5085C17.6271 11.0701 17.1718 11.5254 16.6102 11.5254C16.0485 11.5254 15.5932 11.0701 15.5932 10.5085ZM4.12022 2.46303C4.31087 2.19387 4.62023 2.0339 4.95007 2.0339H9L8.90678 3.05085L8.81356 4.0678H2.98351L4.12022 2.46303ZM14.71 4.0678H8.81356L8.90678 3.05085L9 2.0339H12.8098C13.1498 2.0339 13.4673 2.20383 13.6559 2.48675L14.71 4.0678Z" fill="#4A4A4A"/>
<path d="M18.9831 12.8814C18.9831 12.3197 18.5277 11.8644 17.9661 11.8644C17.4045 11.8644 16.9492 12.3197 16.9492 12.8814V13.5593C16.9492 14.8698 15.8868 15.9322 14.5763 15.9322H13.3026L13.6004 15.6343C13.9976 15.2372 13.9976 14.5933 13.6004 14.1962C13.2033 13.799 12.5594 13.799 12.1623 14.1962L10.1284 16.2301C9.73122 16.6272 9.73122 17.2711 10.1284 17.6682L12.1623 19.7021C12.5594 20.0993 13.2033 20.0993 13.6004 19.7021C13.9976 19.305 13.9976 18.6611 13.6004 18.264L13.3026 17.9661H14.5763C17.0101 17.9661 18.9831 15.9931 18.9831 13.5593V12.8814Z" fill="#4A4A4A"/>
</svg>',
			'module-scroll-to-top-button' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11.0714 15C11.0714 15.5917 10.5917 16.0714 10 16.0714C9.40827 16.0714 8.92857 15.5917 8.92857 15V7.58666L7.18619 9.32904C6.76777 9.74746 6.08938 9.74746 5.67096 9.32904C5.25254 8.91062 5.25254 8.23223 5.67096 7.81381L9.24239 4.24239C9.6608 3.82397 10.3392 3.82397 10.7576 4.24239L14.329 7.81381C14.7475 8.23223 14.7475 8.91062 14.329 9.32904C13.9106 9.74746 13.2322 9.74746 12.8138 9.32904L11.0714 7.58666V15Z" fill="#4A4A4A"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M20 10C20 15.5228 15.5228 20 10 20C4.47715 20 0 15.5228 0 10C0 4.47715 4.47715 0 10 0C15.5228 0 20 4.47715 20 10ZM17.8571 10C17.8571 14.3394 14.3394 17.8571 10 17.8571C5.66062 17.8571 2.14286 14.3394 2.14286 10C2.14286 5.66062 5.66062 2.14286 10 2.14286C14.3394 2.14286 17.8571 5.66062 17.8571 10Z" fill="#4A4A4A"/>
</svg>',
			'module-cookie-banner' => '<svg width="20" height="16" viewBox="0 0 20 16" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4.66667 7.33333C4.11438 7.33333 3.66667 7.78105 3.66667 8.33333C3.66667 8.88562 4.11438 9.33333 4.66667 9.33333H6C6.55229 9.33333 7 8.88562 7 8.33333C7 7.78105 6.55229 7.33333 6 7.33333H4.66667Z" fill="#4A4A4A"/>
<path d="M3.66667 11.3333C3.66667 10.781 4.11438 10.3333 4.66667 10.3333H8.66667C9.21895 10.3333 9.66667 10.781 9.66667 11.3333C9.66667 11.8856 9.21895 12.3333 8.66667 12.3333H4.66667C4.11438 12.3333 3.66667 11.8856 3.66667 11.3333Z" fill="#4A4A4A"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M3.66667 0C1.64162 0 0 1.64162 0 3.66667V12.3333C0 14.3584 1.64162 16 3.66667 16H16.3333C18.3584 16 20 14.3584 20 12.3333V3.66667C20 1.64162 18.3584 0 16.3333 0H3.66667ZM13.2448 2H3.66667C2.74619 2 2 2.74619 2 3.66667V12.3333C2 13.2538 2.74619 14 3.66667 14H13.2452L12.5775 13.6358C11.3996 12.9933 10.6667 11.7587 10.6667 10.4169V5.58291C10.6667 4.24112 11.3996 3.00649 12.5775 2.36396L13.2448 2ZM18 12.0693V3.93049C18 2.91841 16.9167 2.27533 16.0282 2.75996L13.5352 4.11975C12.9998 4.41181 12.6667 4.97301 12.6667 5.58291V10.4169C12.6667 11.0268 12.9998 11.588 13.5352 11.88L16.0282 13.2398C16.9167 13.7245 18 13.0814 18 12.0693Z" fill="#4A4A4A"/>
</svg>',
			'module-auto-external-links' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M9.00001 5.00001C8.44772 5.00001 8.00001 5.44773 8.00001 6.00002C8.00001 6.5523 8.44773 7.00001 9.00002 7.00001L11.5858 7L8.29289 10.2929C7.90237 10.6834 7.90237 11.3166 8.29289 11.7071C8.68342 12.0976 9.31658 12.0976 9.70711 11.7071L13 8.4142L13 11C13 11.5523 13.4477 12 14 12C14.5523 12 15 11.5523 15 11L15 5.99999C15 5.97501 14.9991 5.95013 14.9972 5.92539C14.9794 5.68746 14.877 5.46276 14.7071 5.29288C14.6967 5.28241 14.686 5.2722 14.6751 5.26225C14.5011 5.10281 14.2844 5.01607 14.0639 5.00203C14.0427 5.00068 14.0214 4.99999 14 4.99999L9.00001 5.00001Z" fill="#4A4A4A"/>
<path d="M1 14.5C1 13.6716 1.67157 13 2.5 13H5.5C6.32843 13 7 13.6716 7 14.5V17.5C7 18.3284 6.32843 19 5.5 19H2.5C1.67157 19 1 18.3284 1 17.5V14.5Z" fill="#4A4A4A"/>
<path d="M2.5 1C1.67157 1 1 1.67157 1 2.5V11H3V3H17V17H9V19H17.5C18.3284 19 19 18.3284 19 17.5V2.5C19 1.67157 18.3284 1 17.5 1H2.5Z" fill="#4A4A4A"/>
</svg>',
			'module-real-time-search' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.12068 2.99222e-07H11.0114C12.2077 -1.09969e-05 13.1725 -1.98521e-05 13.9539 0.0638181C14.7583 0.129547 15.465 0.268416 16.1187 0.601521C17.1572 1.13063 18.0014 1.97491 18.5306 3.01335C18.8637 3.66711 19.0025 4.37373 19.0683 5.17822C19.1321 5.95955 19.1321 6.92441 19.1321 8.12065V8.46226C19.1321 9.07186 18.6379 9.56604 18.0283 9.56604C17.4187 9.56604 16.9245 9.07186 16.9245 8.46226V8.16792C16.9245 6.91337 16.9237 6.03884 16.868 5.35798C16.8135 4.69001 16.7117 4.30624 16.5636 4.01556C16.2461 3.39249 15.7396 2.88593 15.1165 2.56846C14.8258 2.42035 14.4421 2.31861 13.7741 2.26403C13.0932 2.20841 12.2187 2.20755 10.9642 2.20755H8.16792C6.91337 2.20755 6.03884 2.20841 5.35798 2.26403C4.69001 2.31861 4.30625 2.42035 4.01556 2.56846C3.3925 2.88593 2.88593 3.39249 2.56846 4.01556C2.42035 4.30624 2.31861 4.69001 2.26403 5.35798C2.20841 6.03883 2.20755 6.91337 2.20755 8.16792V10.9642C2.20755 12.2187 2.20841 13.0932 2.26403 13.7741C2.31861 14.4421 2.42035 14.8258 2.56846 15.1165C2.88593 15.7396 3.3925 16.2461 4.01556 16.5636C4.30625 16.7117 4.69001 16.8135 5.35798 16.868C6.03884 16.9237 6.91337 16.9245 8.16792 16.9245H8.46226C9.07186 16.9245 9.56604 17.4187 9.56604 18.0283C9.56604 18.6379 9.07186 19.1321 8.46226 19.1321H8.12065C6.92441 19.1321 5.95955 19.1321 5.17822 19.0683C4.37373 19.0025 3.66711 18.8637 3.01335 18.5306C1.97491 18.0014 1.13063 17.1572 0.601521 16.1187C0.268416 15.465 0.129547 14.7583 0.0638184 13.9539C-1.95177e-05 13.1725 -1.06597e-05 12.2077 2.85548e-07 11.0114V8.12068C-1.06597e-05 6.92442 -1.95177e-05 5.95956 0.0638184 5.17822C0.129547 4.37373 0.268416 3.66711 0.601521 3.01335C1.13063 1.97491 1.97491 1.13063 3.01335 0.601521C3.66711 0.268416 4.37373 0.129547 5.17822 0.0638181C5.95956 -1.98521e-05 6.92442 -1.09969e-05 8.12068 2.99222e-07Z" fill="#4A4A4A"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M9.93396 13.9811C9.93396 11.7459 11.7459 9.93396 13.9811 9.93396C16.2163 9.93396 18.0283 11.7459 18.0283 13.9811C18.0283 14.6977 17.8421 15.3707 17.5154 15.9545L19.1767 17.6157C19.6078 18.0468 19.6078 18.7457 19.1767 19.1767C18.7457 19.6078 18.0468 19.6078 17.6157 19.1767L15.9545 17.5154C15.3707 17.8421 14.6977 18.0283 13.9811 18.0283C11.7459 18.0283 9.93396 16.2163 9.93396 13.9811ZM13.9811 12.1415C12.9651 12.1415 12.1415 12.9651 12.1415 13.9811C12.1415 14.9971 12.9651 15.8208 13.9811 15.8208C14.9971 15.8208 15.8208 14.9971 15.8208 13.9811C15.8208 12.9651 14.9971 12.1415 13.9811 12.1415Z" fill="#4A4A4A"/>
<path d="M5.15094 6.25472C5.15094 5.64512 5.64512 5.15094 6.25472 5.15094H12.8774C13.487 5.15094 13.9811 5.64512 13.9811 6.25472C13.9811 6.86431 13.487 7.35849 12.8774 7.35849H6.25472C5.64512 7.35849 5.15094 6.86431 5.15094 6.25472Z" fill="#4A4A4A"/>
<path d="M6.25472 9.56604C5.64512 9.56604 5.15094 10.0602 5.15094 10.6698C5.15094 11.2794 5.64512 11.7736 6.25472 11.7736H8.46226C9.07186 11.7736 9.56604 11.2794 9.56604 10.6698C9.56604 10.0602 9.07186 9.56604 8.46226 9.56604H6.25472Z" fill="#4A4A4A"/>
</svg>',
			'module-buy-x-get-y' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M14.5538 0.370369C14.5667 0.37037 14.5796 0.37037 14.5926 0.37037H15.7778C15.7908 0.37037 15.8037 0.37037 15.8166 0.370369C16.1981 0.370341 16.5484 0.370316 16.8413 0.394245C17.157 0.420042 17.5025 0.479098 17.8437 0.652946C18.3315 0.901507 18.7281 1.29812 18.9767 1.78595C19.1505 2.12715 19.2096 2.47259 19.2354 2.78834C19.2593 3.08121 19.2593 3.43155 19.2593 3.81302V5.07587C19.2593 5.45733 19.2593 5.80768 19.2354 6.10055C19.2096 6.4163 19.1505 6.76174 18.9767 7.10294C18.7281 7.59077 18.3315 7.98738 17.8437 8.23594C17.5025 8.40979 17.157 8.46885 16.8413 8.49464C16.5484 8.51857 16.1981 8.51855 15.8166 8.51852H14.5538C14.1723 8.51855 13.8219 8.51857 13.5291 8.49464C13.2133 8.46885 12.8679 8.40979 12.5267 8.23594C12.0389 7.98738 11.6422 7.59077 11.3937 7.10294C11.2198 6.76174 11.1608 6.4163 11.135 6.10055C11.1111 5.80768 11.1111 5.45734 11.1111 5.07588C11.1111 5.06297 11.1111 5.05002 11.1111 5.03704V3.85185C11.1111 3.83887 11.1111 3.82592 11.1111 3.81301C11.1111 3.43155 11.1111 3.08121 11.135 2.78834C11.1608 2.47259 11.2198 2.12715 11.3937 1.78595C11.6422 1.29812 12.0389 0.901507 12.5267 0.652946C12.8679 0.479098 13.2133 0.420042 13.5291 0.394245C13.8219 0.370316 14.1723 0.370341 14.5538 0.370369ZM13.5272 2.63663L13.5295 2.6358L13.5272 2.63663ZM13.5311 2.63529C13.5442 2.63121 13.5933 2.61863 13.71 2.60909C13.9013 2.59346 14.1594 2.59259 14.5926 2.59259H15.7778C16.211 2.59259 16.469 2.59346 16.6603 2.60909C16.7771 2.61863 16.8262 2.63121 16.8393 2.63529C16.9054 2.67014 16.9595 2.72418 16.9943 2.79032C16.9984 2.80347 17.011 2.85254 17.0205 2.9693C17.0362 3.1606 17.037 3.41866 17.037 3.85185V5.03704C17.037 5.47022 17.0362 5.72829 17.0205 5.91959C17.011 6.03635 16.9984 6.08542 16.9943 6.09857C16.9595 6.16471 16.9054 6.21875 16.8393 6.25359C16.8262 6.25768 16.7771 6.27026 16.6603 6.2798C16.469 6.29543 16.211 6.2963 15.7778 6.2963H14.5926C14.1594 6.2963 13.9013 6.29543 13.71 6.2798C13.5933 6.27026 13.5442 6.25768 13.5311 6.25359C13.4649 6.21875 13.4109 6.16471 13.376 6.09857C13.372 6.08542 13.3594 6.03635 13.3498 5.91959C13.3342 5.72829 13.3333 5.47022 13.3333 5.03704V3.85185C13.3333 3.41866 13.3342 3.1606 13.3498 2.9693C13.3594 2.85254 13.372 2.80347 13.376 2.79032C13.4109 2.72418 13.4649 2.67014 13.5311 2.63529ZM13.3774 2.78648L13.3765 2.78872L13.3774 2.78648ZM13.3774 6.10241L13.3765 6.10016L13.3774 6.10241ZM13.5272 6.25226L13.5295 6.25309L13.5272 6.25226ZM16.8431 6.25226L16.8409 6.25309L16.8431 6.25226ZM16.993 6.10241L16.9938 6.10017L16.993 6.10241ZM16.993 2.78648L16.9938 2.78873L16.993 2.78648ZM16.8409 2.6358L16.8431 2.63663L16.8409 2.6358Z" fill="#4A4A4A"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M4.70551 19.6296C4.6926 19.6296 4.67965 19.6296 4.66667 19.6296H3.48148C3.4685 19.6296 3.45555 19.6296 3.44264 19.6296C3.06118 19.6297 2.71084 19.6297 2.41797 19.6058C2.10222 19.58 1.75678 19.5209 1.41558 19.3471C0.927756 19.0985 0.53114 18.7019 0.282579 18.214C0.108731 17.8729 0.0496756 17.5274 0.0238776 17.2117C-5.11193e-05 16.9188 -2.56891e-05 16.5684 1.86147e-06 16.187V14.9241C-2.56891e-05 14.5427 -5.11193e-05 14.1923 0.0238776 13.8994C0.0496756 13.5837 0.108731 13.2383 0.282579 12.8971C0.53114 12.4092 0.927756 12.0126 1.41558 11.7641C1.75678 11.5902 2.10222 11.5312 2.41797 11.5054C2.71084 11.4814 3.06119 11.4815 3.44265 11.4815H4.7055C5.08697 11.4815 5.43731 11.4814 5.73018 11.5054C6.04594 11.5312 6.39138 11.5902 6.73257 11.7641C7.2204 12.0126 7.61701 12.4092 7.86557 12.8971C8.03942 13.2383 8.09848 13.5837 8.12428 13.8994C8.1482 14.1923 8.14818 14.5427 8.14815 14.9241C8.14815 14.937 8.14815 14.95 8.14815 14.963V16.1481C8.14815 16.1611 8.14815 16.1741 8.14815 16.187C8.14818 16.5684 8.1482 16.9188 8.12428 17.2117C8.09848 17.5274 8.03942 17.8729 7.86557 18.214C7.61701 18.7019 7.2204 19.0985 6.73257 19.3471C6.39138 19.5209 6.04594 19.58 5.73018 19.6058C5.43732 19.6297 5.08697 19.6297 4.70551 19.6296ZM5.73204 17.3634L5.7298 17.3642L5.73204 17.3634ZM5.72821 17.3647C5.71505 17.3688 5.66598 17.3814 5.54922 17.3909C5.35792 17.4065 5.09986 17.4074 4.66667 17.4074H3.48148C3.0483 17.4074 2.79023 17.4065 2.59893 17.3909C2.48217 17.3814 2.4331 17.3688 2.41995 17.3647C2.35382 17.3299 2.29977 17.2758 2.26493 17.2097C2.26084 17.1965 2.24826 17.1475 2.23872 17.0307C2.22309 16.8394 2.22223 16.5813 2.22223 16.1481V14.963C2.22223 14.5298 2.22309 14.2717 2.23872 14.0804C2.24826 13.9637 2.26085 13.9146 2.26493 13.9014C2.29977 13.8353 2.35382 13.7812 2.41995 13.7464C2.4331 13.7423 2.48217 13.7297 2.59893 13.7202C2.79023 13.7046 3.0483 13.7037 3.48148 13.7037H4.66667C5.09986 13.7037 5.35792 13.7046 5.54922 13.7202C5.66598 13.7297 5.71505 13.7423 5.72821 13.7464C5.79434 13.7812 5.84838 13.8353 5.88323 13.9014C5.88731 13.9146 5.8999 13.9637 5.90943 14.0804C5.92506 14.2717 5.92593 14.5298 5.92593 14.963V16.1481C5.92593 16.5813 5.92506 16.8394 5.90943 17.0307C5.8999 17.1475 5.88731 17.1965 5.88323 17.2097C5.84838 17.2758 5.79434 17.3299 5.72821 17.3647ZM5.88189 17.2135L5.88272 17.2113L5.88189 17.2135ZM5.88189 13.8976L5.88272 13.8998L5.88189 13.8976ZM5.73204 13.7477L5.7298 13.7469L5.73204 13.7477ZM2.41611 13.7477L2.41836 13.7469L2.41611 13.7477ZM2.26627 13.8976L2.26544 13.8998L2.26627 13.8976ZM2.26627 17.2135L2.26543 17.2113L2.26627 17.2135ZM2.41836 17.3642L2.41611 17.3634L2.41836 17.3642Z" fill="#4A4A4A"/>
<path d="M5.14024 1.89677C4.70633 1.46285 4.70634 0.759334 5.14027 0.325425C5.57419 -0.108484 6.2777 -0.108474 6.71161 0.325449L9.66614 3.28006C9.69844 3.31168 9.72882 3.34526 9.75708 3.3806C9.9091 3.57067 10 3.81176 10 4.07408L9.99995 4.08438C9.99879 4.21234 9.97565 4.34014 9.93054 4.46163C9.87661 4.60688 9.79129 4.74311 9.67456 4.85984L6.7116 7.8228C6.27769 8.25672 5.57417 8.25672 5.14025 7.8228C4.70634 7.38889 4.70634 6.68537 5.14025 6.25145L6.20652 5.18519H5.85185C5.00381 5.18519 4.4346 5.18605 3.99627 5.22186C3.5709 5.25662 3.36752 5.31867 3.23335 5.38703C2.88491 5.56457 2.60161 5.84787 2.42406 6.19631C2.3557 6.33048 2.29366 6.53386 2.2589 6.95923C2.22309 7.39757 2.22222 7.96677 2.22222 8.81482V9.25926C2.22222 9.87291 1.72476 10.3704 1.11111 10.3704C0.497464 10.3704 1.64046e-06 9.87291 1.64046e-06 9.25926V8.76974C-1.39012e-05 7.9784 -2.68745e-05 7.31787 0.0440607 6.77827C0.0900426 6.21548 0.189466 5.6871 0.44405 5.18745C0.834645 4.42086 1.4579 3.79761 2.22448 3.40701C2.72413 3.15243 3.25251 3.053 3.81531 3.00702C4.35491 2.96293 5.01543 2.96295 5.80677 2.96296H6.2064L5.14024 1.89677Z" fill="#4A4A4A"/>
<path d="M15.263 14.7781C14.8247 14.8139 14.2555 14.8148 13.4074 14.8148H13.0527L14.119 13.7485C14.5529 13.3146 14.5529 12.6111 14.119 12.1772C13.6851 11.7433 12.9816 11.7433 12.5477 12.1772L9.5847 15.1402C9.46797 15.2569 9.38265 15.3931 9.32872 15.5384C9.28381 15.659 9.25926 15.7896 9.25926 15.9259C9.25926 16.1882 9.35016 16.4293 9.50218 16.6194C9.53045 16.6547 9.56082 16.6883 9.59312 16.7199L12.5476 19.6746C12.9816 20.1085 13.6851 20.1085 14.119 19.6746C14.5529 19.2407 14.5529 18.5371 14.119 18.1032L13.0529 17.037H13.4525C14.2438 17.0371 14.9044 17.0371 15.444 16.993C16.0067 16.947 16.5351 16.8476 17.0348 16.593C17.8014 16.2024 18.4246 15.5791 18.8152 14.8126C19.0698 14.3129 19.1692 13.7845 19.2152 13.2217C19.2593 12.6821 19.2593 12.0216 19.2593 11.2303V10.7407C19.2593 10.1271 18.7618 9.62963 18.1481 9.62963C17.5345 9.62963 17.037 10.1271 17.037 10.7407V11.1852C17.037 12.0332 17.0362 12.6024 17.0004 13.0408C16.9656 13.4661 16.9036 13.6695 16.8352 13.8037C16.6577 14.1521 16.3744 14.4354 16.0259 14.613C15.8917 14.6813 15.6884 14.7434 15.263 14.7781Z" fill="#4A4A4A"/>
</svg>',
			'module-free-gifts' => '<svg width="20" height="16" viewBox="0 0 20 16" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M17.3333 2H10V3C10 3.55228 9.55229 4 9 4C8.44771 4 8 3.55228 8 3V2H2.66667C2.29848 2 2 2.29848 2 2.66667V6.72357C2.3884 6.86085 2.66667 7.23126 2.66667 7.66667C2.66667 8.10207 2.3884 8.47249 2 8.60977V13.3333C2 13.7015 2.29848 14 2.66667 14H8V12.6667C8 12.1144 8.44771 11.6667 9 11.6667C9.55229 11.6667 10 12.1144 10 12.6667V14H17.3333C17.7015 14 18 13.7015 18 13.3333V8.66667H16.3333C15.781 8.66667 15.3333 8.21895 15.3333 7.66667C15.3333 7.11438 15.781 6.66667 16.3333 6.66667H18V2.66667C18 2.29848 17.7015 2 17.3333 2ZM20 7.66667V2.66667C20 1.19391 18.8061 0 17.3333 0H9H2.66667C1.19391 0 0 1.19391 0 2.66667V13.3333C0 14.8061 1.19391 16 2.66667 16H17.3333C18.8061 16 20 14.8061 20 13.3333V7.66667ZM8.39649 5.32262C7.93809 4.31414 6.93256 3.66667 5.82479 3.66667C4.26164 3.66667 2.99987 4.93862 2.99987 6.49578C2.99987 8.05759 4.26541 9.33333 5.83321 9.33333H6.97724C6.18367 10.0129 5.3029 10.5656 4.52537 10.6767C3.97864 10.7548 3.59874 11.2614 3.67684 11.8081C3.75495 12.3548 4.26148 12.7347 4.80822 12.6566C6.28905 12.4451 7.64575 11.4311 8.54604 10.6165C8.70732 10.4706 8.85914 10.3263 9 10.1872C9.14086 10.3263 9.29268 10.4706 9.45396 10.6165C10.3542 11.4311 11.711 12.4451 13.1918 12.6566C13.7385 12.7347 14.2451 12.3548 14.3232 11.8081C14.4013 11.2614 14.0214 10.7548 13.4746 10.6767C12.6971 10.5656 11.8163 10.0129 11.0228 9.33333H12.1668C13.7346 9.33333 15.0001 8.05759 15.0001 6.49578C15.0001 4.93862 13.7384 3.66667 12.1752 3.66667C11.0674 3.66667 10.0619 4.31414 9.60351 5.32262L9 6.65034L8.39649 5.32262ZM7.11353 7.33333H5.83321C5.37596 7.33333 4.99987 6.95901 4.99987 6.49578C4.99987 6.0372 5.37219 5.66667 5.82479 5.66667C6.14827 5.66667 6.4419 5.85574 6.57576 6.15023L7.11353 7.33333ZM12.1668 7.33333H10.8865L11.4242 6.15023C11.5581 5.85574 11.8517 5.66667 12.1752 5.66667C12.6278 5.66667 13.0001 6.0372 13.0001 6.49578C13.0001 6.95901 12.624 7.33333 12.1668 7.33333Z" fill="#4A4A4A"/>
</svg>',
			'module-frequently-bought-together' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.07692 7.69231C8.71418 7.69231 9.23077 8.2089 9.23077 8.84615V10.7692H11.1538C11.7911 10.7692 12.3077 11.2858 12.3077 11.9231C12.3077 12.5603 11.7911 13.0769 11.1538 13.0769H9.23077V15C9.23077 15.6373 8.71418 16.1538 8.07692 16.1538C7.43967 16.1538 6.92308 15.6373 6.92308 15V13.0769H5C4.36275 13.0769 3.84615 12.5603 3.84615 11.9231C3.84615 11.2858 4.36275 10.7692 5 10.7692H6.92308V8.84615C6.92308 8.2089 7.43967 7.69231 8.07692 7.69231Z" fill="#4A4A4A"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M8.07692 0C5.86458 0 4.04885 1.69809 3.862 3.862C1.69809 4.04885 0 5.86458 0 8.07692V15.7692C0 18.1058 1.89418 20 4.23077 20H11.9231C14.1354 20 15.9512 18.3019 16.138 16.138C18.3019 15.9512 20 14.1354 20 11.9231V4.23077C20 1.89418 18.1058 0 15.7692 0H8.07692ZM11.9231 3.84615H6.19231C6.3705 2.96837 7.14656 2.30769 8.07692 2.30769H15.7692C16.8313 2.30769 17.6923 3.16868 17.6923 4.23077V11.9231C17.6923 12.8534 17.0316 13.6295 16.1538 13.8077V8.07692C16.1538 5.74033 14.2597 3.84615 11.9231 3.84615ZM4.23077 6.15385C3.16868 6.15385 2.30769 7.01484 2.30769 8.07692V15.7692C2.30769 16.8313 3.16868 17.6923 4.23077 17.6923H11.9231C12.9852 17.6923 13.8462 16.8313 13.8462 15.7692V8.07692C13.8462 7.01484 12.9852 6.15385 11.9231 6.15385H4.23077Z" fill="#4A4A4A"/>
</svg>',
			'module-stock-scarcity' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect width="20" height="11.998" rx="2" fill="#4A4A4A"/>
<rect x="5.09473" y="4.58545" width="1.52734" height="11.4685" rx="0.763672" fill="#4A4A4A"/>
<path d="M6.05371 2.06934H17.3174C17.8697 2.06934 18.3174 2.51705 18.3174 3.06934V8.97034C18.3174 9.52262 17.8697 9.97034 17.3174 9.97034H6.05371V2.06934Z" fill="white"/>
<path d="M2.90548 19.6574C2.73278 19.6574 2.57881 19.6256 2.44358 19.562C2.30916 19.4984 2.20244 19.4107 2.12342 19.2989C2.08329 19.2422 2.05293 19.1812 2.03234 19.1161C1.99852 19.0091 2.09234 18.9148 2.20457 18.9148H2.32463C2.43054 18.9148 2.51151 19.0054 2.57536 19.0899C2.59206 19.112 2.61208 19.1323 2.63543 19.1509C2.71119 19.2113 2.80121 19.2414 2.90548 19.2414C2.98858 19.2414 3.0619 19.2231 3.12544 19.1864C3.1898 19.1489 3.2399 19.0971 3.27574 19.031C3.3124 18.9641 3.33073 18.8874 3.33073 18.801C3.33073 18.7129 3.31199 18.6354 3.27452 18.5685C3.23786 18.5016 3.18695 18.4494 3.12177 18.4119C3.0566 18.3744 2.98206 18.3552 2.89815 18.3544C2.82483 18.3544 2.75355 18.3695 2.68431 18.3997C2.6589 18.4109 2.63557 18.4236 2.61431 18.4378C2.55088 18.4804 2.47658 18.5147 2.40142 18.5012L2.234 18.4712C2.13199 18.4529 2.06087 18.3597 2.07013 18.2564L2.15596 17.2996C2.16521 17.1965 2.25163 17.1175 2.35516 17.1175H3.50221C3.61267 17.1175 3.70221 17.207 3.70221 17.3175V17.3506C3.70221 17.461 3.61267 17.5506 3.50221 17.5506H2.78897C2.68646 17.5506 2.60055 17.6281 2.59003 17.73L2.54481 18.1683C2.54426 18.1736 2.54843 18.1782 2.55378 18.1782C2.55671 18.1782 2.55944 18.1768 2.56116 18.1744C2.60515 18.1141 2.67064 18.064 2.75762 18.0241C2.84642 17.9833 2.94581 17.9629 3.05579 17.9629C3.2065 17.9629 3.34091 17.9984 3.45904 18.0693C3.57716 18.1403 3.67044 18.2378 3.73887 18.3617C3.8073 18.4849 3.84111 18.6268 3.8403 18.7875C3.84111 18.9564 3.80201 19.1064 3.72299 19.2378C3.64478 19.3683 3.53521 19.471 3.39427 19.5461C3.25415 19.6203 3.09122 19.6574 2.90548 19.6574Z" fill="#4A4A4A"/>
<path d="M5.01583 17C5.1474 17 5.24313 17.1249 5.20897 17.2519L4.51 19.8519C4.48651 19.9393 4.40732 20 4.31686 20H4.28259C4.15102 20 4.05529 19.8751 4.08945 19.7481L4.78842 17.1481C4.81191 17.0607 4.8911 17 4.98156 17H5.01583Z" fill="#4A4A4A"/>
<path d="M6.38387 17.1175C6.49433 17.1175 6.58387 17.207 6.58387 17.3175V19.4232C6.58387 19.5336 6.49433 19.6232 6.38387 19.6232H6.25475C6.1443 19.6232 6.05475 19.5336 6.05475 19.4232V17.6317C6.05475 17.6254 6.04965 17.6203 6.04337 17.6203C6.04122 17.6203 6.03913 17.6209 6.03731 17.6221L5.7721 17.7885C5.63943 17.8718 5.46698 17.7764 5.46698 17.6198C5.46698 17.5515 5.50191 17.4881 5.55954 17.4515L6.03749 17.1485C6.06952 17.1282 6.10666 17.1175 6.14458 17.1175H6.38387Z" fill="#4A4A4A"/>
<path d="M8.06517 19.6574C7.89247 19.6574 7.7385 19.6256 7.60327 19.562C7.46885 19.4984 7.36213 19.4107 7.28311 19.2989C7.24298 19.2422 7.21262 19.1812 7.19203 19.1161C7.15821 19.0091 7.25203 18.9148 7.36426 18.9148H7.48433C7.59023 18.9148 7.6712 19.0054 7.73505 19.0899C7.75175 19.112 7.77177 19.1323 7.79512 19.1509C7.87088 19.2113 7.9609 19.2414 8.06517 19.2414C8.14827 19.2414 8.22159 19.2231 8.28513 19.1864C8.34949 19.1489 8.39959 19.0971 8.43543 19.031C8.47209 18.9641 8.49042 18.8874 8.49042 18.801C8.49042 18.7129 8.47168 18.6354 8.43421 18.5685C8.39755 18.5016 8.34664 18.4494 8.28146 18.4119C8.21629 18.3744 8.14175 18.3552 8.05784 18.3544C7.98452 18.3544 7.91324 18.3695 7.844 18.3997C7.81859 18.4109 7.79526 18.4236 7.774 18.4378C7.71057 18.4804 7.63627 18.5147 7.56111 18.5012L7.39369 18.4712C7.29168 18.4529 7.22056 18.3597 7.22982 18.2564L7.31565 17.2996C7.3249 17.1965 7.41132 17.1175 7.51485 17.1175H8.6619C8.77236 17.1175 8.8619 17.207 8.8619 17.3175V17.3506C8.8619 17.461 8.77236 17.5506 8.6619 17.5506H7.94866C7.84615 17.5506 7.76024 17.6281 7.74971 17.73L7.7045 18.1683C7.70395 18.1736 7.70812 18.1782 7.71347 18.1782C7.7164 18.1782 7.71913 18.1768 7.72085 18.1744C7.76484 18.1141 7.83033 18.064 7.91732 18.0241C8.00611 17.9833 8.1055 17.9629 8.21548 17.9629C8.36619 17.9629 8.50061 17.9984 8.61873 18.0693C8.73685 18.1403 8.83013 18.2378 8.89856 18.3617C8.96699 18.4849 9.0008 18.6268 8.99999 18.7875C9.0008 18.9564 8.9617 19.1064 8.88268 19.2378C8.80447 19.3683 8.6949 19.471 8.55396 19.5461C8.41385 19.6203 8.25091 19.6574 8.06517 19.6574Z" fill="#4A4A4A"/>
</svg>',
			'module-sticky-add-to-cart' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M1 2C1 1.44772 1.44772 1 2 1L4 1L4 3L3 3L3 4H1L1 2Z" fill="#4A4A4A"/>
<path d="M18 1C18.5523 1 19 1.44772 19 2V4L17 4V3L16 3V1L18 1Z" fill="#4A4A4A"/>
<path d="M19 17.5V11L1 11L1 17.5C1 18.3284 1.67157 19 2.5 19L17.5 19C18.3284 19 19 18.3284 19 17.5Z" fill="#4A4A4A"/>
<path d="M19 6V9H17V6L19 6Z" fill="#4A4A4A"/>
<path d="M3 9L3 6L1 6L1 9H3Z" fill="#4A4A4A"/>
<path d="M14 1V3L11 3V1L14 1Z" fill="#4A4A4A"/>
<path d="M9 3V1L6 1V3L9 3Z" fill="#4A4A4A"/>
</svg>',
			'module-checkout' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M3 0C2.44771 0 2 0.447715 2 1C2 1.55228 2.44771 2 3 2H5.14931C5.31817 2 5.46035 2.12626 5.48031 2.29393L6.86704 13.9425C7.00677 15.1162 8.00204 16 9.18402 16H16.3333C16.8856 16 17.3333 15.5523 17.3333 15C17.3333 14.4477 16.8856 14 16.3333 14H9.18402C9.01517 14 8.87298 13.8737 8.85302 13.7061L8.72928 12.6667H15.8639C17.7799 12.6667 19.3728 11.1915 19.5198 9.28122L19.9971 3.0767C20.0184 2.79897 19.923 2.52492 19.7337 2.32055C19.5445 2.11618 19.2785 2 19 2H7.45873C7.29387 0.855071 6.3119 0 5.14931 0H3ZM15.8639 10.6667H8.49119L7.69754 4H17.9201L17.5257 9.12783C17.4589 9.99616 16.7348 10.6667 15.8639 10.6667Z" fill="#4A4A4A"/>
<path d="M1 4.66667C0.447715 4.66667 0 5.11438 0 5.66667C0 6.21895 0.447715 6.66667 1 6.66667H1.66667C2.21895 6.66667 2.66667 6.21895 2.66667 5.66667C2.66667 5.11438 2.21895 4.66667 1.66667 4.66667H1Z" fill="#4A4A4A"/>
<path d="M1 8.66667C0.447715 8.66667 0 9.11438 0 9.66667C0 10.219 0.447715 10.6667 1 10.6667H3C3.55228 10.6667 4 10.219 4 9.66667C4 9.11438 3.55228 8.66667 3 8.66667H1Z" fill="#4A4A4A"/>
<path d="M0 13.6667C0 13.1144 0.447715 12.6667 1 12.6667H4.33333C4.88562 12.6667 5.33333 13.1144 5.33333 13.6667C5.33333 14.219 4.88562 14.6667 4.33333 14.6667H1C0.447715 14.6667 0 14.219 0 13.6667Z" fill="#4A4A4A"/>
<path d="M10.6667 18.6667C10.6667 19.403 10.0697 20 9.33333 20C8.59695 20 8 19.403 8 18.6667C8 17.9303 8.59695 17.3333 9.33333 17.3333C10.0697 17.3333 10.6667 17.9303 10.6667 18.6667Z" fill="#4A4A4A"/>
<path d="M17.3333 18.6667C17.3333 19.403 16.7364 20 16 20C15.2636 20 14.6667 19.403 14.6667 18.6667C14.6667 17.9303 15.2636 17.3333 16 17.3333C16.7364 17.3333 17.3333 17.9303 17.3333 18.6667Z" fill="#4A4A4A"/>
</svg>',
			'module-recently-viewed-products' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<g clip-path="url(#clip0_2280_6846)">
<path d="M10.0003 18C2.33427 18 0.0612703 10.352 0.0382703 10.274C-0.0127568 10.0949 -0.0127568 9.9051 0.0382703 9.726C0.0612703 9.648 2.33427 2 10.0003 2C17.6333 2 19.9273 8.617 19.9483 8.684C20.0325 8.93529 20.0134 9.20974 19.8953 9.44698C19.7771 9.68421 19.5696 9.86479 19.3183 9.949C19.067 10.0332 18.7925 10.0141 18.5553 9.89599C18.3181 9.77784 18.1375 9.57029 18.0533 9.319C17.4269 7.70771 16.3158 6.33061 14.8733 5.37784C13.4308 4.42507 11.7281 3.94364 10.0003 4C4.53327 4 2.48727 8.772 2.05227 10C2.48627 11.225 4.53127 16 10.0003 16C10.2655 16 10.5198 16.1054 10.7074 16.2929C10.8949 16.4804 11.0003 16.7348 11.0003 17C11.0003 17.2652 10.8949 17.5196 10.7074 17.7071C10.5198 17.8946 10.2655 18 10.0003 18ZM10.0003 14C7.79427 14 6.00027 12.206 6.00027 10C6.00027 7.794 7.79427 6 10.0003 6C12.2063 6 14.0003 7.794 14.0003 10C14.0003 10.2652 13.8949 10.5196 13.7074 10.7071C13.5198 10.8946 13.2655 11 13.0003 11C12.7351 11 12.4807 10.8946 12.2932 10.7071C12.1056 10.5196 12.0003 10.2652 12.0003 10C12.0003 8.897 11.1033 8 10.0003 8C8.89727 8 8.00027 8.897 8.00027 10C8.00027 11.103 8.89727 12 10.0003 12C10.2655 12 10.5198 12.1054 10.7074 12.2929C10.8949 12.4804 11.0003 12.7348 11.0003 13C11.0003 13.2652 10.8949 13.5196 10.7074 13.7071C10.5198 13.8946 10.2655 14 10.0003 14ZM15.0003 18C14.8689 18.0001 14.7389 17.9743 14.6175 17.924C14.4962 17.8738 14.386 17.8 14.2933 17.707L12.2933 15.707C12.2004 15.6142 12.1268 15.5039 12.0765 15.3826C12.0263 15.2613 12.0004 15.1313 12.0004 15C12.0004 14.8687 12.0263 14.7387 12.0765 14.6174C12.1268 14.4961 12.2004 14.3858 12.2933 14.293C12.3861 14.2002 12.4963 14.1265 12.6176 14.0763C12.739 14.026 12.869 14.0002 13.0003 14.0002C13.1316 14.0002 13.2616 14.026 13.3829 14.0763C13.5042 14.1265 13.6144 14.2002 13.7073 14.293L15.0003 15.586L18.2933 12.293C18.4808 12.1055 18.7351 12.0002 19.0003 12.0002C19.2654 12.0002 19.5198 12.1055 19.7073 12.293C19.8948 12.4805 20.0001 12.7348 20.0001 13C20.0001 13.2652 19.8948 13.5195 19.7073 13.707L15.7073 17.707C15.6145 17.8 15.5043 17.8738 15.383 17.924C15.2617 17.9743 15.1316 18.0001 15.0003 18Z" fill="#4A4A4A"/>
</g>
<defs>
<clipPath id="clip0_2280_6846">
<rect width="20" height="20" fill="white"/>
</clipPath>
</defs>
</svg>',
			'module-waitlist' => '<svg width="19" height="20" viewBox="0 0 19 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M15.5932 10.5085V6.1017H2.0339V15.2542C2.0339 15.4415 2.18567 15.5932 2.37288 15.5932H7.79661C8.35826 15.5932 8.81356 16.0485 8.81356 16.6102C8.81356 17.1718 8.35826 17.6271 7.79661 17.6271H2.37288C1.06238 17.6271 0 16.5647 0 15.2542V5.9479C0 5.17576 0.239701 4.42266 0.68601 3.79258L2.46051 1.2874C3.03247 0.479923 3.96054 0 4.95007 0H12.8098C13.8299 0 14.7824 0.5098 15.3483 1.35854L17.0009 3.83746C17.4092 4.44998 17.6271 5.16967 17.6271 5.90583V10.5085C17.6271 11.0701 17.1718 11.5254 16.6102 11.5254C16.0485 11.5254 15.5932 11.0701 15.5932 10.5085ZM4.12022 2.46303C4.31087 2.19387 4.62023 2.0339 4.95007 2.0339H9L8.90678 3.05085L8.81356 4.0678H2.98351L4.12022 2.46303ZM14.71 4.0678H8.81356L8.90678 3.05085L9 2.0339H12.8098C13.1498 2.0339 13.4673 2.20383 13.6559 2.48675L14.71 4.0678Z" fill="#4A4A4A"/>
<path d="M18.9831 12.8814C18.9831 12.3197 18.5277 11.8644 17.9661 11.8644C17.4045 11.8644 16.9492 12.3197 16.9492 12.8814V13.5593C16.9492 14.8698 15.8868 15.9322 14.5763 15.9322H13.3026L13.6004 15.6343C13.9976 15.2372 13.9976 14.5933 13.6004 14.1962C13.2033 13.799 12.5594 13.799 12.1623 14.1962L10.1284 16.2301C9.73122 16.6272 9.73122 17.2711 10.1284 17.6682L12.1623 19.7021C12.5594 20.0993 13.2033 20.0993 13.6004 19.7021C13.9976 19.305 13.9976 18.6611 13.6004 18.264L13.3026 17.9661H14.5763C17.0101 17.9661 18.9831 15.9931 18.9831 13.5593V12.8814Z" fill="#4A4A4A"/>
</svg>',
			'module-advanced-reviews' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M8.26063 1.03565C8.91955 -0.34522 10.8851 -0.345217 11.5441 1.03565L13.5662 5.27331L18.2213 5.88694C19.7382 6.0869 20.3456 7.95628 19.2359 9.00966L15.8305 12.2423L16.6854 16.8592C16.964 18.3637 15.3738 19.519 14.0291 18.7891L9.90234 16.5494L5.77559 18.7891C4.43086 19.519 2.84067 18.3637 3.11925 16.8592L3.97416 12.2423L0.568779 9.00966C-0.540893 7.95628 0.0665075 6.0869 1.58341 5.88694L6.23853 5.27331L8.26063 1.03565ZM9.90234 2.66381L8.12354 6.39158C7.85836 6.94731 7.33004 7.33116 6.71956 7.41163L2.62456 7.95143L5.6202 10.7951C6.06679 11.219 6.26859 11.8401 6.15647 12.4456L5.40443 16.507L9.03464 14.5367C9.57582 14.243 10.2289 14.243 10.7701 14.5367L14.4003 16.507L13.6482 12.4456C13.5361 11.8401 13.7379 11.219 14.1845 10.7951L17.1801 7.95143L13.0851 7.41163C12.4747 7.33116 11.9463 6.94731 11.6811 6.39158L9.90234 2.66381Z" fill="#4A4A4A"/>
</svg>',
			'module-product-brand-image' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M0 4.18826C0 1.87501 1.87526 -0.000244141 4.1885 -0.000244141C4.81939 -0.000244141 5.33082 0.51119 5.33082 1.14208C5.33082 1.77296 4.81939 2.28439 4.1885 2.28439C3.13703 2.28439 2.28464 3.13678 2.28464 4.18826C2.28464 4.81914 1.7732 5.33058 1.14232 5.33058C0.511434 5.33058 0 4.81914 0 4.18826Z" fill="#4A4A4A"/>
<path d="M4.1885 19.8C1.87526 19.8 0 17.9247 0 15.6114C0 14.9806 0.511434 14.4691 1.14232 14.4691C1.7732 14.4691 2.28464 14.9806 2.28464 15.6114C2.28464 16.6629 3.13703 17.5153 4.1885 17.5153C4.81939 17.5153 5.33082 18.0267 5.33082 18.6576C5.33082 19.2885 4.81939 19.8 4.1885 19.8Z" fill="#4A4A4A"/>
<path d="M19.8002 4.18826C19.8002 1.87501 17.9249 -0.000244141 15.6117 -0.000244141C14.9808 -0.000244141 14.4694 0.51119 14.4694 1.14207C14.4694 1.77296 14.9808 2.28439 15.6117 2.28439C16.6632 2.28439 17.5156 3.13678 17.5156 4.18826C17.5156 4.81914 18.027 5.33058 18.6579 5.33058C19.2888 5.33058 19.8002 4.81914 19.8002 4.18826Z" fill="#4A4A4A"/>
<path d="M19.8002 15.6114C19.8002 17.9247 17.9249 19.8 15.6117 19.8C14.9808 19.8 14.4694 19.2885 14.4694 18.6576C14.4694 18.0267 14.9808 17.5153 15.6117 17.5153C16.6632 17.5153 17.5156 16.6629 17.5156 15.6114C17.5156 14.9806 18.027 14.4691 18.6579 14.4691C19.2888 14.4691 19.8002 14.9806 19.8002 15.6114Z" fill="#4A4A4A"/>
<path d="M2.28464 8.37676C2.28464 7.74588 1.7732 7.23444 1.14232 7.23444C0.511434 7.23444 0 7.74588 0 8.37676V11.4229C0 12.0538 0.511434 12.5653 1.14232 12.5653C1.7732 12.5653 2.28464 12.0538 2.28464 11.4229V8.37676Z" fill="#4A4A4A"/>
<path d="M18.6579 7.23444C19.2888 7.23444 19.8002 7.74588 19.8002 8.37676V11.4229C19.8002 12.0538 19.2888 12.5653 18.6579 12.5653C18.027 12.5653 17.5156 12.0538 17.5156 11.4229V8.37676C17.5156 7.74588 18.027 7.23444 18.6579 7.23444Z" fill="#4A4A4A"/>
<path d="M11.4232 2.28439C12.0541 2.28439 12.5655 1.77296 12.5655 1.14208C12.5655 0.51119 12.0541 -0.000244141 11.4232 -0.000244141H8.37701C7.74612 -0.000244141 7.23469 0.51119 7.23469 1.14207C7.23469 1.77296 7.74612 2.28439 8.37701 2.28439L11.4232 2.28439Z" fill="#4A4A4A"/>
<path d="M12.5655 18.6576C12.5655 19.2885 12.0541 19.8 11.4232 19.8H8.37701C7.74612 19.8 7.23469 19.2885 7.23469 18.6576C7.23469 18.0267 7.74612 17.5153 8.37701 17.5153H11.4232C12.0541 17.5153 12.5655 18.0267 12.5655 18.6576Z" fill="#4A4A4A"/>
<path d="M5.40018 12.9231C5.30961 12.9231 5.2259 12.8749 5.18051 12.7965L5.12739 12.7048C5.05706 12.5834 5.0986 12.4279 5.22013 12.3577L6.61217 11.554C6.73356 11.4839 6.88877 11.5255 6.9589 11.6469L7.47626 12.5423C7.57403 12.7115 7.45191 12.9231 7.25646 12.9231H5.40018ZM10.8962 12.5423C10.9939 12.7116 10.8718 12.9231 10.6763 12.9231H8.81975C8.72906 12.9231 8.64526 12.8748 8.59991 12.7962L7.26899 10.4911C7.19889 10.3697 7.24049 10.2144 7.3619 10.1443L8.75417 9.34048C8.87558 9.27038 9.03083 9.31197 9.10093 9.43338L10.8962 12.5423ZM14.3159 12.5423C14.4137 12.7116 14.2915 12.9231 14.0961 12.9231H12.2395C12.1488 12.9231 12.065 12.8748 12.0197 12.7962L9.41063 8.27754C9.34053 8.15613 9.38212 8.00087 9.50354 7.93077L10.8958 7.12692C11.0172 7.05682 11.1725 7.09842 11.2426 7.21982L14.3159 12.5423Z" fill="#4A4A4A"/>
</svg>',
			'module-reasons-to-buy' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M2.85714 0C1.27919 0 0 1.27919 0 2.85714V5.71429C0 7.29224 1.27919 8.57143 2.85714 8.57143H5.71429C7.29224 8.57143 8.57143 7.29224 8.57143 5.71429V2.85714C8.57143 1.27919 7.29224 0 5.71429 0H2.85714ZM2.14286 2.85714C2.14286 2.46265 2.46265 2.14286 2.85714 2.14286H5.71429C6.10877 2.14286 6.42857 2.46265 6.42857 2.85714V5.71429C6.42857 6.10877 6.10877 6.42857 5.71429 6.42857H2.85714C2.46265 6.42857 2.14286 6.10877 2.14286 5.71429V2.85714Z" fill="#4A4A4A"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M2.85714 11.4286C1.27919 11.4286 0 12.7078 0 14.2857V17.1429C0 18.7208 1.27919 20 2.85714 20H5.71429C7.29224 20 8.57143 18.7208 8.57143 17.1429V14.2857C8.57143 12.7078 7.29224 11.4286 5.71429 11.4286H2.85714ZM2.14286 14.2857C2.14286 13.8912 2.46265 13.5714 2.85714 13.5714H5.71429C6.10877 13.5714 6.42857 13.8912 6.42857 14.2857V17.1429C6.42857 17.5373 6.10877 17.8571 5.71429 17.8571H2.85714C2.46265 17.8571 2.14286 17.5373 2.14286 17.1429V14.2857Z" fill="#4A4A4A"/>
<path d="M10 2.5C10 1.90827 10.4797 1.42857 11.0714 1.42857H18.9286C19.5203 1.42857 20 1.90827 20 2.5C20 3.09173 19.5203 3.57143 18.9286 3.57143H11.0714C10.4797 3.57143 10 3.09173 10 2.5Z" fill="#4A4A4A"/>
<path d="M11.0714 5C10.4797 5 10 5.47969 10 6.07143C10 6.66316 10.4797 7.14286 11.0714 7.14286H17.5C18.0917 7.14286 18.5714 6.66316 18.5714 6.07143C18.5714 5.47969 18.0917 5 17.5 5H11.0714Z" fill="#4A4A4A"/>
<path d="M10 13.9286C10 13.3368 10.4797 12.8571 11.0714 12.8571H18.9286C19.5203 12.8571 20 13.3368 20 13.9286C20 14.5203 19.5203 15 18.9286 15H11.0714C10.4797 15 10 14.5203 10 13.9286Z" fill="#4A4A4A"/>
<path d="M11.0714 16.4286C10.4797 16.4286 10 16.9083 10 17.5C10 18.0917 10.4797 18.5714 11.0714 18.5714H16.0714C16.6632 18.5714 17.1429 18.0917 17.1429 17.5C17.1429 16.9083 16.6632 16.4286 16.0714 16.4286H11.0714Z" fill="#4A4A4A"/>
</svg>',
			'module-spending-goal' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M1 0C0.447715 0 0 0.447715 0 1C0 1.55228 0.447715 2 1 2H3.14932C3.31817 2 3.46035 2.12626 3.48031 2.29393L4.86705 13.9425C5.00677 15.1162 6.00205 16 7.18402 16H15.6667C16.219 16 16.6667 15.5523 16.6667 15C16.6667 14.4477 16.219 14 15.6667 14H7.18402C7.01516 14 6.87298 13.8737 6.85302 13.7061L6.72928 12.6667H15.1973C17.1132 12.6667 18.7062 11.1915 18.8531 9.28122L19.3304 3.0767C19.3727 2.52604 18.9607 2.0453 18.41 2.00295C17.8594 1.96059 17.3786 2.37265 17.3363 2.9233L16.859 9.12783C16.7922 9.99616 16.0681 10.6667 15.1973 10.6667H6.49119L5.46629 2.0575C5.32656 0.88382 4.33129 0 3.14932 0H1Z" fill="#4A4A4A"/>
<path d="M8.66667 4.33333C9.40305 4.33333 10 3.73638 10 3C10 2.26362 9.40305 1.66667 8.66667 1.66667C7.93029 1.66667 7.33333 2.26362 7.33333 3C7.33333 3.73638 7.93029 4.33333 8.66667 4.33333Z" fill="#4A4A4A"/>
<path d="M14.3738 4.04044C14.7643 3.64992 14.7643 3.01675 14.3738 2.62623C13.9832 2.2357 13.3501 2.2357 12.9596 2.62623L8.29289 7.29289C7.90237 7.68342 7.90237 8.31658 8.29289 8.70711C8.68342 9.09763 9.31658 9.09763 9.70711 8.70711L14.3738 4.04044Z" fill="#4A4A4A"/>
<path d="M15.3333 8.33333C15.3333 9.06971 14.7364 9.66667 14 9.66667C13.2636 9.66667 12.6667 9.06971 12.6667 8.33333C12.6667 7.59695 13.2636 7 14 7C14.7364 7 15.3333 7.59695 15.3333 8.33333Z" fill="#4A4A4A"/>
<path d="M10 18.6667C10 19.403 9.40305 20 8.66667 20C7.93029 20 7.33333 19.403 7.33333 18.6667C7.33333 17.9303 7.93029 17.3333 8.66667 17.3333C9.40305 17.3333 10 17.9303 10 18.6667Z" fill="#4A4A4A"/>
<path d="M16.6667 18.6667C16.6667 19.403 16.0697 20 15.3333 20C14.597 20 14 19.403 14 18.6667C14 17.9303 14.597 17.3333 15.3333 17.3333C16.0697 17.3333 16.6667 17.9303 16.6667 18.6667Z" fill="#4A4A4A"/>
</svg>',
			'module-volume-discounts' => '<svg width="17" height="20" viewBox="0 0 17 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M7.45764 10C7.45764 10.7364 6.86069 11.3333 6.12431 11.3333C5.38793 11.3333 4.79097 10.7364 4.79097 10C4.79097 9.26362 5.38793 8.66667 6.12431 8.66667C6.86069 8.66667 7.45764 9.26362 7.45764 10Z" fill="#4A4A4A"/>
<path d="M12.1243 15.3333C12.1243 16.0697 11.5274 16.6667 10.791 16.6667C10.0546 16.6667 9.45764 16.0697 9.45764 15.3333C9.45764 14.597 10.0546 14 10.791 14C11.5274 14 12.1243 14.597 12.1243 15.3333Z" fill="#4A4A4A"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M12.0469 9.07741C12.3723 9.40285 12.3723 9.93049 12.0469 10.2559L6.0469 16.2559C5.72146 16.5814 5.19382 16.5814 4.86839 16.2559C4.54295 15.9305 4.54295 15.4028 4.86839 15.0774L10.8684 9.07741C11.1938 8.75197 11.7215 8.75197 12.0469 9.07741Z" fill="#4A4A4A"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M5.82381 0C5.07473 0 4.4588 0.622225 4.60517 1.35686C4.85998 2.63585 5.42306 3.68226 6.16871 4.38006C4.16207 5.06647 2.52378 6.63675 1.78839 8.71314L0.310447 12.8861C-0.918849 16.3571 1.65558 20 5.33779 20H11.5775C15.2597 20 17.8341 16.3571 16.6048 12.8861L15.1269 8.71314C14.3915 6.63676 12.7532 5.06649 10.7466 4.38007C11.4922 3.68227 12.0553 2.63586 12.3101 1.35686C12.4565 0.622226 11.8406 0 11.0915 0H5.82381ZM8.45764 3.33333C8.06379 3.33333 7.35665 3.02499 6.88951 2H10.0258C9.55863 3.02499 8.85149 3.33333 8.45764 3.33333ZM13.2416 9.38083L14.7195 13.5538C15.4879 15.7232 13.8788 18 11.5775 18H5.33779C3.03641 18 1.42739 15.7232 2.1957 13.5538L3.67364 9.38083C4.39133 7.35442 6.30787 6 8.45762 6C10.6074 6 12.5239 7.35442 13.2416 9.38083Z" fill="#4A4A4A"/>
</svg>',
			'module-cart-reserved-timer' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M5 2C4.44772 2 4 2.44772 4 3C4 3.55228 4.44772 4 5 4H7.14931C7.31817 4 7.46035 4.12626 7.48031 4.29393L8.86704 15.9425C9.00677 17.1162 10.002 18 11.184 18H18.3333C18.8856 18 19.3333 17.5523 19.3333 17C19.3333 16.4477 18.8856 16 18.3333 16H11.184C11.0152 16 10.873 15.8737 10.853 15.7061L10.7293 14.6667H17.8639C19.7799 14.6667 21.3728 13.1915 21.5198 11.2812L21.9971 5.0767C22.0184 4.79897 21.923 4.52492 21.7337 4.32055C21.5445 4.11618 21.2785 4 21 4H9.45873C9.29387 2.85507 8.3119 2 7.14931 2H5ZM17.8639 12.6667H10.4912L9.69754 6H19.9201L19.5257 11.1278C19.4589 11.9962 18.7348 12.6667 17.8639 12.6667Z" fill="#4A4A4A"/>
<path d="M12.6667 20.6667C12.6667 21.403 12.0697 22 11.3333 22C10.597 22 10 21.403 10 20.6667C10 19.9303 10.597 19.3333 11.3333 19.3333C12.0697 19.3333 12.6667 19.9303 12.6667 20.6667Z" fill="#4A4A4A"/>
<path d="M19.3333 20.6667C19.3333 21.403 18.7364 22 18 22C17.2636 22 16.6667 21.403 16.6667 20.6667C16.6667 19.9303 17.2636 19.3333 18 19.3333C18.7364 19.3333 19.3333 19.9303 19.3333 20.6667Z" fill="#4A4A4A"/>
<circle cx="18.4985" cy="5.49854" r="5.49854" fill="white"/>
<path d="M20.3282 7.32795C20.2746 7.38181 20.2109 7.42456 20.1407 7.45374C20.0705 7.48294 19.9952 7.49797 19.9192 7.49797C19.8431 7.49797 19.7679 7.48294 19.6976 7.45374C19.6275 7.42455 19.5637 7.38179 19.5101 7.32791C19.5101 7.32788 19.5101 7.32785 19.5101 7.32782L18.1446 5.96233C18.1445 5.9623 18.1445 5.96227 18.1445 5.96224C18.0356 5.85385 17.9749 5.70678 17.9749 5.55322V3.27661C17.9749 3.12323 18.0358 2.97614 18.1443 2.86768C18.2527 2.75923 18.3998 2.6983 18.5532 2.6983C18.7066 2.6983 18.8537 2.75923 18.9622 2.86768C19.0706 2.97614 19.1315 3.12323 19.1315 3.27661V5.31378L20.328 6.51024M20.3282 7.32795C20.3281 7.32801 20.3281 7.32808 20.328 7.32814L20.2411 7.2411L20.3283 7.32782C20.3283 7.32786 20.3282 7.32791 20.3282 7.32795ZM20.3282 7.32795C20.3819 7.27432 20.4244 7.21064 20.4535 7.14055C20.4826 7.07038 20.4976 6.99516 20.4976 6.91919C20.4976 6.84322 20.4826 6.768 20.4535 6.69783C20.4244 6.62765 20.3818 6.56391 20.328 6.51024M20.328 6.51024L20.3281 6.51031L20.2411 6.59728L20.328 6.51024ZM18.5532 0.877011C15.9747 0.877011 13.877 2.97465 13.877 5.55322C13.877 8.13179 15.9747 10.2294 18.5532 10.2294C21.1318 10.2294 23.2294 8.13179 23.2294 5.55322C23.2294 2.97465 21.1318 0.877011 18.5532 0.877011ZM18.5532 9.07281C16.6127 9.07281 15.0336 7.49372 15.0336 5.55322C15.0336 3.61272 16.6127 2.03363 18.5532 2.03363C20.4937 2.03363 22.0728 3.61272 22.0728 5.55322C22.0728 7.49372 20.4937 9.07281 18.5532 9.07281Z" fill="#4A4A4A" stroke="#4A4A4A" stroke-width="0.245977"/>
</svg>',
			'module-login-popup' => '<svg class="stroke-based" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
			<rect x="2.55273" y="2.55347" width="14.8931" height="14.8931" rx="1" stroke="#4A4A4A" stroke-width="2"/>
			<rect x="5.10156" y="7.51056" width="9.84277" height="5.69971" rx="1" fill="#4A4A4A"/>
			</svg>',
			'module-product-audio' => '<svg width="20" height="17" viewBox="0 0 20 17" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M8.0912 0.508445C9.17735 -0.5777 11.0345 0.191549 11.0345 1.7276V14.9494C11.0345 16.4854 9.17735 17.2547 8.0912 16.1685L4.50009 12.5774C4.43542 12.5128 4.34771 12.4764 4.25626 12.4764H2.41379C1.08069 12.4764 0 11.3957 0 10.0626V6.61435C0 5.28125 1.08069 4.20055 2.41379 4.20055H4.25626C4.34771 4.20055 4.43542 4.16422 4.50009 4.09956L8.0912 0.508445ZM8.96552 2.56008L5.96307 5.56254C5.5104 6.01521 4.89644 6.26952 4.25626 6.26952H2.41379C2.22335 6.26952 2.06897 6.4239 2.06897 6.61435V10.0626C2.06897 10.2531 2.22335 10.4075 2.41379 10.4075H4.25626C4.89644 10.4075 5.5104 10.6618 5.96307 11.1144L8.96552 14.1169V2.56008Z" fill="#4A4A4A"/>
<path d="M12.285 4.67624C12.6208 4.21402 13.2677 4.11156 13.7299 4.44738C14.3996 4.9339 14.9558 5.55981 15.3602 6.282C15.7647 7.00418 16.0077 7.80546 16.0727 8.63063C16.1376 9.4558 16.0229 10.2852 15.7364 11.0618C15.4499 11.8384 14.9985 12.5436 14.4132 13.1289C14.0092 13.5329 13.3542 13.5329 12.9502 13.1289C12.5462 12.7249 12.5462 12.0699 12.9502 11.6659C13.324 11.2921 13.6123 10.8417 13.7953 10.3457C13.9783 9.84973 14.0516 9.31998 14.0101 8.79296C13.9686 8.26594 13.8134 7.75418 13.5551 7.29294C13.2968 6.8317 12.9415 6.43194 12.5138 6.1212C12.0516 5.78539 11.9492 5.13845 12.285 4.67624Z" fill="#4A4A4A"/>
<path d="M16.028 1.28466C15.5658 0.948839 14.9188 1.0513 14.583 1.51352C14.2472 1.97573 14.3497 2.62267 14.8119 2.95849C15.6968 3.60141 16.4318 4.42853 16.9662 5.38287C17.5007 6.33721 17.8219 7.39607 17.9077 8.4865C17.9935 9.57693 17.8419 10.673 17.4633 11.6992C17.0848 12.7254 16.4882 13.6573 15.7148 14.4308C15.3108 14.8347 15.3108 15.4897 15.7148 15.8937C16.1187 16.2977 16.7737 16.2977 17.1777 15.8937C18.1626 14.9088 18.9223 13.7221 19.4044 12.4153C19.8865 11.1085 20.0796 9.71275 19.9703 8.32417C19.861 6.93559 19.452 5.58721 18.7714 4.37193C18.0908 3.15665 17.1548 2.10337 16.028 1.28466Z" fill="#4A4A4A"/>
</svg>',
			'module-product-video' => '<svg width="18" height="20" viewBox="0 0 18 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M16.3381 7.36979C18.2206 8.4567 18.2206 11.174 16.3381 12.2609L4.2358 19.2481C2.35322 20.335 -9.50203e-08 18.9764 0 16.8026L6.10845e-07 2.82808C7.05865e-07 0.654264 2.35322 -0.704367 4.2358 0.382539L16.3381 7.36979ZM15.1278 10.1647C15.3968 10.0094 15.3968 9.62124 15.1278 9.46597L3.02557 2.47871C2.75663 2.32344 2.42046 2.51753 2.42046 2.82808L2.42045 16.8026C2.42045 17.1131 2.75663 17.3072 3.02557 17.1519L15.1278 10.1647Z" fill="#4A4A4A"/>
</svg>',
			'google-autocomplete' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M7.5 9C6.675 9 6 8.325 6 7.5C6 6.675 6.675 6 7.5 6C8.325 6 9 6.675 9 7.5C9 8.325 8.325 9 7.5 9ZM7.5 3C5.0175 3 3 5.1525 3 7.8C3 12.3 7.05 14.8125 7.2225 14.9175C7.305 14.97 7.4025 15 7.5 15C7.5975 15 7.695 14.97 7.7775 14.9175C7.95 14.8125 12 12.3 12 7.8C12 5.1525 9.9825 3 7.5 3Z" fill="#4A4A4A"/>
<path d="M17.3919 8.98174L20.0182 11.6088L20.4562 11.1707C21.1813 10.4454 21.1813 9.26952 20.4562 8.54418C19.7308 7.81861 18.5547 7.81861 17.8293 8.54418L17.3919 8.98174Z" fill="#4A4A4A"/>
<path d="M18.8124 12.8123L16.1862 10.1852L7.85249 18.5201L7 22L10.4788 21.1472L18.8124 12.8123Z" fill="#4A4A4A"/>
</svg>',
			'module-size-chart' => '<svg class="stroke-based" width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path d="M1 6H3.5M1 11H4.75M1 16H3.5M6 1V3.5M11 1V4.75M16 1V3.5M2.25 1H19.75C20.0815 1 20.3995 1.1317 20.6339 1.36612C20.8683 1.60054 21 1.91848 21 2.25V8.5C21 8.83152 20.8683 9.14946 20.6339 9.38388C20.3995 9.6183 20.0815 9.75 19.75 9.75H11C10.6685 9.75 10.3505 9.8817 10.1161 10.1161C9.8817 10.3505 9.75 10.6685 9.75 11V19.75C9.75 20.0815 9.6183 20.3995 9.38388 20.6339C9.14946 20.8683 8.83152 21 8.5 21H2.25C1.91848 21 1.60054 20.8683 1.36612 20.6339C1.1317 20.3995 1 20.0815 1 19.75V2.25C1 1.91848 1.1317 1.60054 1.36612 1.36612C1.60054 1.1317 1.91848 1 2.25 1Z" stroke="#4A4A4A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
			</svg>',
			'module-wishlist' => '<svg width="17" height="20" viewBox="0 0 17 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M2.5998 3.3C2.5998 2.47157 3.27138 1.8 4.0998 1.8H6.7998V6.3C6.7998 7.4598 7.74001 8.4 8.8998 8.4H13.3998V10.5C13.3998 10.9971 13.8027 11.4 14.2998 11.4C14.7969 11.4 15.1998 10.9971 15.1998 10.5V7.5C15.1998 7.26131 15.105 7.03239 14.9362 6.8636L8.3362 0.263604C8.16742 0.0948212 7.9385 0 7.6998 0H4.0998C2.27727 0 0.799805 1.47746 0.799805 3.3V14.7C0.799805 16.5225 2.27726 18 4.0998 18H5.5998C6.09686 18 6.4998 17.5971 6.4998 17.1C6.4998 16.6029 6.09686 16.2 5.5998 16.2H4.0998C3.27138 16.2 2.5998 15.5284 2.5998 14.7V3.3ZM12.127 6.6L8.5998 3.07279V6.3C8.5998 6.46569 8.73412 6.6 8.8998 6.6H12.127ZM9.45394 14.3565C9.80352 14.0145 10.3783 14.0145 10.7279 14.3565L11.2706 14.8875C11.6204 15.2297 12.1796 15.2297 12.5294 14.8875L13.0721 14.3565C13.4217 14.0145 13.9965 14.0145 14.3461 14.3565C14.6846 14.6878 14.6846 15.2165 14.3461 15.5478L11.9 17.9409L9.45394 15.5478C9.11535 15.2165 9.11535 14.6878 9.45394 14.3565ZM11.9 12.9887C10.8462 12.0441 9.21593 12.0712 8.19515 13.0699C7.13495 14.1071 7.13495 15.7972 8.19515 16.8344L10.851 19.4328C11.434 20.0032 12.366 20.0032 12.949 19.4328L15.6049 16.8344C16.6651 15.7972 16.6651 14.1071 15.6049 13.0699C14.5841 12.0712 12.9538 12.0441 11.9 12.9887Z" fill="#4A4A4A"/>
</svg>',
			'module-countdown-timer' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11.0714 4.28571C11.0714 3.69398 10.5917 3.21429 9.99999 3.21429C9.40825 3.21429 8.92856 3.69398 8.92856 4.28571L8.92856 10C8.92856 10.2842 9.04144 10.5567 9.24237 10.7576L12.0995 13.6148C12.5179 14.0332 13.1963 14.0332 13.6147 13.6148C14.0332 13.1963 14.0332 12.5179 13.6147 12.0995L11.0714 9.5562V4.28571Z" fill="#4A4A4A"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M20 10C20 15.5228 15.5228 20 10 20C4.47715 20 0 15.5228 0 10C0 4.47715 4.47715 0 10 0C15.5228 0 20 4.47715 20 10ZM17.8571 10C17.8571 14.3394 14.3394 17.8571 10 17.8571C5.66062 17.8571 2.14286 14.3394 2.14286 10C2.14286 5.66062 5.66062 2.14286 10 2.14286C14.3394 2.14286 17.8571 5.66062 17.8571 10Z" fill="#4A4A4A"/>
</svg>',
			'module-product-swatches' => '<svg width="19" height="20" viewBox="0 0 19 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M7.08222 16.6285H3.81071C2.47142 16.6285 1.38571 15.5428 1.38571 14.2036V8.24428C0.528519 7.36953 0 6.17148 0 4.84999C0 2.17142 2.17142 0 4.84999 0C6.78472 0 8.45486 1.13286 9.23326 2.77143H15.5893C16.9286 2.77143 18.0143 3.85713 18.0143 5.19642V14.2036C18.0143 15.0465 17.5842 15.789 16.9315 16.2235L17.8727 17.837C18.0602 18.1585 18.0615 18.5556 17.8762 18.8783C17.6908 19.201 17.3471 19.4 16.975 19.4H7.27499C6.90286 19.4 6.55913 19.201 6.37378 18.8783C6.18844 18.5556 6.18977 18.1585 6.37728 17.837L7.08222 16.6285ZM4.84999 7.62142C6.38061 7.62142 7.62142 6.38061 7.62142 4.84999C7.62142 3.31938 6.38061 2.07857 4.84999 2.07857C3.31938 2.07857 2.07857 3.31938 2.07857 4.84999C2.07857 6.38061 3.31938 7.62142 4.84999 7.62142ZM4.84999 9.69999C7.52857 9.69999 9.69999 7.52857 9.69999 4.84999H15.5893C15.7806 4.84999 15.9357 5.00509 15.9357 5.19642V14.2036C15.9357 14.2788 15.9117 14.3485 15.8709 14.4054L13.0227 9.52275C12.8364 9.20346 12.4946 9.00713 12.125 9.00713C11.7553 9.00713 11.4135 9.20346 11.2273 9.52275L8.29472 14.55H3.81071C3.61938 14.55 3.46428 14.3949 3.46428 14.2036V9.49914C3.90335 9.62982 4.36848 9.69999 4.84999 9.69999ZM12.125 12.109L15.1655 17.3214H9.08442L12.125 12.109Z" fill="#4A4A4A"/>
</svg>',

			'module-add-to-cart-text' => '<svg width="20" height="17" viewBox="0 0 20 17" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.2668 2.54128C14.526 2.28206 14.526 1.86177 14.2668 1.60254L12.8587 0.19442C12.5995 -0.0648068 12.1792 -0.0648068 11.9199 0.19442L10.6493 1.46507L12.9961 3.81194L14.2668 2.54128Z" fill="#4A4A4A"/>
<path d="M12.0574 4.75068L9.71054 2.40382L6.45932 5.65504C5.96364 6.15072 5.68409 6.82232 5.68165 7.52332L5.67844 8.44973C5.6778 8.63393 5.82729 8.78342 6.01149 8.78278L6.9379 8.77957C7.6389 8.77714 8.3105 8.49759 8.80618 8.0019L12.0574 4.75068Z" fill="#4A4A4A"/>
<path d="M1.99138 7.71415C1.99138 6.79765 2.73436 6.05467 3.65086 6.05467H3.98276C4.53266 6.05467 4.97845 5.60888 4.97845 5.05898C4.97845 4.50908 4.53266 4.06329 3.98276 4.06329H3.65086C1.63455 4.06329 0 5.69784 0 7.71415V13.0245C0 15.0408 1.63455 16.6754 3.65086 16.6754H15.5991C17.6155 16.6754 19.25 15.0408 19.25 13.0245V7.38226C19.25 5.54924 17.764 4.06329 15.931 4.06329C15.3811 4.06329 14.9353 4.50908 14.9353 5.05898C14.9353 5.60888 15.3811 6.05467 15.931 6.05467C16.6642 6.05467 17.2586 6.64905 17.2586 7.38226V13.0245C17.2586 13.941 16.5156 14.684 15.5991 14.684H3.65086C2.73436 14.684 1.99138 13.941 1.99138 13.0245V7.71415Z" fill="#4A4A4A"/>
<path d="M4.97845 10.7012C4.42854 10.7012 3.98276 11.147 3.98276 11.6969C3.98276 12.2468 4.42854 12.6926 4.97845 12.6926H10.2888C10.8387 12.6926 11.2845 12.2468 11.2845 11.6969C11.2845 11.147 10.8387 10.7012 10.2888 10.7012H4.97845Z" fill="#4A4A4A"/>
<path d="M12.612 11.6969C12.612 11.147 13.0578 10.7012 13.6077 10.7012H14.2716C14.8215 10.7012 15.2672 11.147 15.2672 11.6969C15.2672 12.2468 14.8215 12.6926 14.2716 12.6926H13.6077C13.0578 12.6926 12.612 12.2468 12.612 11.6969Z" fill="#4A4A4A"/>
</svg>',

			'module-quick-social-links' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect width="24" height="24" rx="2" fill="white"/>
<path d="M11 11H3V4.5C3 4.10218 3.15804 3.72065 3.43934 3.43934C3.72065 3.15804 4.10218 3 4.5 3H11V11ZM11 13V21H4.5C4.10218 21 3.72065 20.842 3.43934 20.5607C3.15804 20.2793 3 19.8978 3 19.5V13H11ZM13 13V21H19.5C19.8978 21 20.2794 20.842 20.5607 20.5607C20.842 20.2793 21 19.8978 21 19.5V13H13Z" fill="#4A4A4A"/>
<path d="M13 11.0004L13 3.00037L19.5 3.00037C19.8978 3.00037 20.2794 3.1584 20.5607 3.43971C20.842 3.72101 21 4.10254 21 4.50037L21 11.0004L13 11.0004Z" fill="#4A4A4A"/>
<circle cx="6.98798" cy="7.00031" r="3.58759" fill="white"/>
<path d="M8.60383 6.04219C8.48478 6.09255 8.35751 6.12656 8.2234 6.14225C8.36025 6.06377 8.46562 5.93952 8.51488 5.79172C8.38693 5.86431 8.2453 5.91728 8.09409 5.9454C7.97298 5.8218 7.80056 5.74463 7.61034 5.74463C7.24429 5.74463 6.94802 6.02846 6.94802 6.37834C6.94802 6.42805 6.95349 6.47644 6.96513 6.52287C6.41433 6.49671 5.9258 6.24428 5.59942 5.86038C5.54263 5.9539 5.50979 6.06312 5.50979 6.17888C5.50979 6.39862 5.62748 6.59285 5.80537 6.70664C5.6959 6.70403 5.59327 6.67525 5.50432 6.62751V6.63536C5.50432 6.94273 5.73285 7.19844 6.03596 7.25665C5.98053 7.27104 5.92169 7.27888 5.86148 7.27888C5.81906 7.27888 5.77732 7.27496 5.73695 7.26711C5.82111 7.5189 6.06606 7.70201 6.35617 7.70725C6.12969 7.87728 5.84369 7.97865 5.53305 7.97865C5.47969 7.97865 5.427 7.97538 5.375 7.9695C5.66716 8.1513 6.01543 8.25594 6.38901 8.25594C7.60898 8.25594 8.27541 7.29 8.27541 6.45224C8.27541 6.42478 8.27472 6.39731 8.27335 6.3705C8.40267 6.2809 8.51488 6.16972 8.60383 6.04219Z" fill="#4A4A4A"/>
<circle cx="17.0007" cy="7.00042" r="3.58758" fill="white"/>
<path d="M18.278 5.56531H15.7249C15.6374 5.56531 15.5664 5.63631 15.5664 5.72376V8.27692C15.5664 8.36437 15.6374 8.43537 15.7249 8.43537H17.0014V7.2993H16.6584V6.88075H17.0014V6.57133C17.0014 6.20061 17.2585 5.99881 17.5897 5.99881C17.7481 5.99881 17.9185 6.01077 17.9581 6.016V6.40316H17.6943C17.5142 6.40316 17.4798 6.48836 17.4798 6.61393V6.88075H17.9088L17.8527 7.2993H17.4798V8.43537H18.278C18.3655 8.43537 18.4365 8.36437 18.4365 8.27692V5.72376C18.4365 5.63631 18.3655 5.56531 18.278 5.56531Z" fill="#4A4A4A"/>
<circle cx="7.02479" cy="16.7587" r="3.71717" fill="white"/>
<path d="M7.09911 15.0888C7.28576 15.0859 7.47135 15.0876 7.65672 15.0859C7.66795 15.2993 7.74647 15.5167 7.90627 15.6676C8.06576 15.8222 8.29135 15.893 8.51084 15.9169V16.4782C8.30515 16.4717 8.09849 16.4298 7.91184 16.3433C7.83054 16.3073 7.75481 16.261 7.68068 16.2136C7.67972 16.621 7.68239 17.0278 7.67801 17.4334C7.66688 17.6283 7.6011 17.8222 7.48515 17.9828C7.2986 18.2502 6.97482 18.4245 6.64226 18.4299C6.43827 18.4413 6.2345 18.3869 6.06069 18.2868C5.77263 18.1207 5.56993 17.8168 5.5404 17.4906C5.53669 17.4215 5.53611 17.3523 5.53869 17.2832C5.56436 17.0179 5.69861 16.7642 5.90698 16.5916C6.14316 16.3905 6.474 16.2948 6.78377 16.3514C6.78666 16.5579 6.77821 16.7642 6.77821 16.9707C6.6367 16.9259 6.47133 16.9385 6.34767 17.0224C6.25721 17.0807 6.18884 17.1664 6.1531 17.2663C6.12358 17.337 6.13203 17.4155 6.13374 17.4906C6.16765 17.7194 6.39271 17.9116 6.63295 17.8908C6.79222 17.8892 6.94486 17.7988 7.02787 17.6666C7.05472 17.6203 7.08478 17.5729 7.08638 17.5184C7.10039 17.2691 7.09483 17.0208 7.09654 16.7714C7.09772 16.2094 7.09483 15.649 7.09922 15.0889L7.09911 15.0888Z" fill="#4A4A4A"/>
<circle cx="16.9969" cy="17.1436" r="3.59064" fill="white"/>
<path d="M16.9962 16.6049C16.6995 16.6049 16.4574 16.847 16.4574 17.1437C16.4574 17.4404 16.6995 17.6826 16.9962 17.6826C17.2929 17.6826 17.535 17.4404 17.535 17.1437C17.535 16.847 17.2929 16.6049 16.9962 16.6049ZM18.6123 17.1437C18.6123 16.9206 18.6143 16.6995 18.6017 16.4768C18.5892 16.2181 18.5302 15.9885 18.341 15.7993C18.1515 15.6097 17.9223 15.5511 17.6636 15.5386C17.4404 15.5261 17.2193 15.5281 16.9966 15.5281C16.7735 15.5281 16.5524 15.5261 16.3297 15.5386C16.071 15.5511 15.8414 15.6101 15.6522 15.7993C15.4626 15.9889 15.404 16.2181 15.3915 16.4768C15.379 16.6999 15.381 16.921 15.381 17.1437C15.381 17.3665 15.379 17.588 15.3915 17.8107C15.404 18.0694 15.463 18.299 15.6522 18.4882C15.8418 18.6778 16.071 18.7364 16.3297 18.7489C16.5528 18.7614 16.7739 18.7594 16.9966 18.7594C17.2197 18.7594 17.4408 18.7614 17.6636 18.7489C17.9223 18.7364 18.1519 18.6774 18.341 18.4882C18.5306 18.2986 18.5892 18.0694 18.6017 17.8107C18.6147 17.588 18.6123 17.3669 18.6123 17.1437ZM16.9962 17.9728C16.5374 17.9728 16.1672 17.6025 16.1672 17.1437C16.1672 16.685 16.5374 16.3147 16.9962 16.3147C17.455 16.3147 17.8253 16.685 17.8253 17.1437C17.8253 17.6025 17.455 17.9728 16.9962 17.9728ZM17.8592 16.4744C17.7521 16.4744 17.6656 16.3879 17.6656 16.2807C17.6656 16.1736 17.7521 16.0871 17.8592 16.0871C17.9663 16.0871 18.0528 16.1736 18.0528 16.2807C18.0529 16.3062 18.0479 16.3314 18.0382 16.3549C18.0284 16.3784 18.0142 16.3997 17.9962 16.4177C17.9782 16.4357 17.9568 16.45 17.9333 16.4597C17.9098 16.4694 17.8846 16.4744 17.8592 16.4744Z" fill="#4A4A4A"/>
</svg>',

			'module-product-navigation-links' => '<svg width="20" height="18" viewBox="0 0 20 18" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M0.000363731 2.18746C0.000363731 0.979359 0.979724 0 2.18782 0H6.25025C7.45835 0 8.43771 0.97936 8.43771 2.18746V5.93739C8.43771 7.14549 7.45835 8.12485 6.25025 8.12485H2.18782C0.979723 8.12485 0.000363731 7.14549 0.000363731 5.93739V2.18746ZM2.18782 1.87497C2.01524 1.87497 1.87533 2.01487 1.87533 2.18746V5.93739C1.87533 6.10998 2.01524 6.24989 2.18782 6.24989H6.25025C6.42284 6.24989 6.56275 6.10998 6.56275 5.93739V2.18746C6.56275 2.01487 6.42284 1.87497 6.25025 1.87497H2.18782Z" fill="#4A4A4A"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M13.7501 0C12.542 0 11.5627 0.979359 11.5627 2.18746V5.93739C11.5627 7.14549 12.542 8.12485 13.7501 8.12485H17.8125C19.0206 8.12485 20 7.14549 20 5.93739V2.18746C20 0.97936 19.0206 0 17.8125 0H13.7501ZM13.4376 2.18746C13.4376 2.01487 13.5775 1.87497 13.7501 1.87497H17.8125C17.9851 1.87497 18.125 2.01487 18.125 2.18746V5.93739C18.125 6.10998 17.9851 6.24989 17.8125 6.24989H13.7501C13.5775 6.24989 13.4376 6.10998 13.4376 5.93739V2.18746Z" fill="#4A4A4A"/>
<path d="M14.4506 14.7251H19.0622C19.5799 14.7251 19.9996 14.3054 19.9996 13.7877C19.9996 13.2699 19.5799 12.8502 19.0622 12.8502H14.4506L15.3501 11.9506C15.7162 11.5845 15.7162 10.9909 15.3501 10.6248C14.984 10.2587 14.3904 10.2587 14.0243 10.6248L11.5244 13.1248C11.1583 13.4909 11.1583 14.0845 11.5244 14.4506L14.0243 16.9505C14.3904 17.3166 14.984 17.3166 15.3501 16.9505C15.7162 16.5844 15.7162 15.9908 15.3501 15.6247L14.4506 14.7251Z" fill="#4A4A4A"/>
<path d="M0 13.7877C0 13.2699 0.419725 12.8502 0.937483 12.8502H5.54907L4.6495 11.9506C4.28339 11.5845 4.28339 10.9909 4.6495 10.6248C5.01561 10.2587 5.60919 10.2587 5.9753 10.6248L8.47526 13.1248C8.65107 13.3006 8.74984 13.539 8.74984 13.7877C8.74984 14.0363 8.65107 14.2748 8.47526 14.4506L5.9753 16.9505C5.60919 17.3166 5.01561 17.3166 4.6495 16.9505C4.28339 16.5844 4.28339 15.9908 4.6495 15.6247L5.54907 14.7251H0.937483C0.419725 14.7251 0 14.3054 0 13.7877Z" fill="#4A4A4A"/>
</svg>',
			'module-clear-cart' => '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M1 0C0.447715 0 0 0.447715 0 1C0 1.55228 0.447715 2 1 2H3.14932C3.31817 2 3.46035 2.12626 3.48031 2.29393L4.86705 13.9425C5.00677 15.1162 6.00205 16 7.18402 16H15.6667C16.219 16 16.6667 15.5523 16.6667 15C16.6667 14.4477 16.219 14 15.6667 14H7.18402C7.01516 14 6.87298 13.8737 6.85302 13.7061L6.72928 12.6667H15.1973C17.1132 12.6667 18.7062 11.1915 18.8531 9.28122L19.3304 3.0767C19.3727 2.52604 18.9607 2.0453 18.41 2.00295C17.8594 1.96059 17.3786 2.37265 17.3363 2.9233L16.859 9.12783C16.7922 9.99616 16.0681 10.6667 15.1973 10.6667H6.49119L5.46629 2.0575C5.32656 0.88382 4.33129 0 3.14932 0H1Z" fill="#4A4A4A"/>
<path d="M8.49286 2.82626C8.10234 3.21679 8.10234 3.84995 8.49286 4.24048L10.2524 6.00005L8.49293 7.75956C8.1024 8.15008 8.1024 8.78325 8.49292 9.17377C8.88345 9.5643 9.51661 9.5643 9.90714 9.17378L11.6667 7.41426L13.4262 9.17378C13.8167 9.5643 14.4499 9.5643 14.8404 9.17377C15.2309 8.78325 15.2309 8.15008 14.8404 7.75956L13.0809 6.00005L14.8405 4.24048C15.231 3.84995 15.231 3.21679 14.8405 2.82626C14.45 2.43574 13.8168 2.43573 13.4263 2.82626L11.6667 4.58584L9.90707 2.82626C9.51655 2.43573 8.88338 2.43574 8.49286 2.82626Z" fill="#4A4A4A"/>
<path d="M10 18.6667C10 19.403 9.40305 20 8.66667 20C7.93029 20 7.33333 19.403 7.33333 18.6667C7.33333 17.9303 7.93029 17.3333 8.66667 17.3333C9.40305 17.3333 10 17.9303 10 18.6667Z" fill="#4A4A4A"/>
<path d="M15.3333 20C16.0697 20 16.6667 19.403 16.6667 18.6667C16.6667 17.9303 16.0697 17.3333 15.3333 17.3333C14.597 17.3333 14 17.9303 14 18.6667C14 19.403 14.597 20 15.3333 20Z" fill="#4A4A4A"/>
</svg>',

			'icon-close' => '<svg width="16" height="16" fill="none" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path d="M2.219.781L.78 2.22 9.562 11l-8.78 8.781 1.437 1.438L11 12.437l8.781 8.782 1.438-1.438L12.437 11l8.782-8.781L19.78.78 11 9.562 2.219.783z"></path></svg>',

			'icon-check'  => '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 512 512"><path d="M173.898 439.404l-166.4-166.4c-9.997-9.997-9.997-26.206 0-36.204l36.203-36.204c9.997-9.998 26.207-9.998 36.204 0L192 312.69 432.095 72.596c9.997-9.997 26.207-9.997 36.204 0l36.203 36.204c9.997 9.997 9.997 26.206 0 36.204l-294.4 294.401c-9.998 9.997-26.207 9.997-36.204-.001z"></path></svg>',
			'check1' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 8C119.033 8 8 119.033 8 256s111.033 248 248 248 248-111.033 248-248S392.967 8 256 8zm0 48c110.532 0 200 89.451 200 200 0 110.532-89.451 200-200 200-110.532 0-200-89.451-200-200 0-110.532 89.451-200 200-200m140.204 130.267l-22.536-22.718c-4.667-4.705-12.265-4.736-16.97-.068L215.346 303.697l-59.792-60.277c-4.667-4.705-12.265-4.736-16.97-.069l-22.719 22.536c-4.705 4.667-4.736 12.265-.068 16.971l90.781 91.516c4.667 4.705 12.265 4.736 16.97.068l172.589-171.204c4.704-4.668 4.734-12.266.067-16.971z"></path></svg>',
			'check2' => '<svg class="feather feather-check-circle" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" viewBox="0 0 24 24" width="24" height="24" xmlns="http://www.w3.org/2000/svg"><path d="M22 11.08V12a10 10 0 1 1-5.93-9.14"/><polyline points="22 4 12 14.01 9 11.01"/></svg>',
			'check3' => '<svg class="feather feather-check-square" fill="none" height="24" stroke="#212121" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><polyline points="9 11 12 14 22 4"/><path d="M21 12v7a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11"/></svg>',

			'heart1' => '<svg width="17" height="17" viewBox="0 1 25 17" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M13.8213 2.50804L13.8216 2.5078C16.1161 0.140222 19.7976 -0.212946 22.2492 1.87607C25.093 4.30325 25.2444 8.66651 22.6933 11.2992L22.6932 11.2993L13.245 21.055C13.245 21.0551 13.245 21.0551 13.2449 21.0551C12.8311 21.4822 12.1652 21.4822 11.7514 21.0551C11.7513 21.0551 11.7513 21.0551 11.7513 21.055L2.30334 11.2995C-0.243225 8.66684 -0.0918835 4.30344 2.75181 1.8762C5.20368 -0.213127 8.88985 0.140465 11.1793 2.50744L11.1799 2.50804L12.1418 3.49925L12.5006 3.86899L12.8594 3.49925L13.8213 2.50804Z" stroke-width="1" stroke="#212121" fill="transparent"/></svg>',
			'heart2' => '<svg class="stroke-based" width="20" height="20" viewBox="0 0 20 15" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M14.5 3C12.8905 3 11.0082 4.70299 10 5.8C8.99175 4.70299 7.1095 3 5.5 3C2.651 3 1 5.07403 1 7.71371C1 12.1 10 17 10 17C10 17 19 12.1 19 7.9C19 5.26032 17.349 3 14.5 3Z" stroke-width="1"/><path d="M14 9.5L11.5 12" stroke-width="1" stroke-linecap="round" stroke="#212121" fill="transparent"/></svg>',

			'icon-cancel'   => '<svg width="16" height="16" fill="none" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="xMidYMid meet"><path d="M2.219.781L.78 2.22 9.562 11l-8.78 8.781 1.437 1.438L11 12.437l8.781 8.782 1.438-1.438L12.437 11l8.782-8.781L19.78.78 11 9.562 2.219.783z"/></svg>',

			// Size Chart Icons
			'cloth-size-guide-icon' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 455.18"><path d="M107.98 331.84h-.23l-.38-.01.31.35.3-.34zM382.62 19.95v415.28h81.71c7.61 0 14.54-3.13 19.56-8.16 5.04-5 8.16-11.92 8.16-19.55V47.67c0-7.61-3.12-14.55-8.15-19.57-5.02-5.03-11.95-8.15-19.57-8.15h-81.71zm-19.94 415.28V19.95H47.67c-7.62 0-14.56 3.12-19.58 8.14-5.02 5.02-8.14 11.96-8.14 19.58v359.85c0 7.6 3.12 14.53 8.15 19.56 5.02 5.03 11.96 8.15 19.57 8.15h315.01zm-44.8-60.66h6.76c7.04-21.8 8.85-22.65 6.67-39.09-5.3-40.07-41.02-60.53-38.67-85.5 2.7-28.66 15.4-37.48 21.79-61.77 3.33-12.67 12.19-49.01 4.98-60.3-4.54-7.12-14.6-8.67-22.25-12.16-25.22-11.46-32.99-23.37-30.75-45.16H232.7c2.24 21.79-5.52 33.7-30.74 45.16-7.67 3.49-17.72 5.04-22.27 12.16-7.2 11.29 1.66 47.63 5 60.3 6.39 24.29 19.07 33.11 21.78 61.77 2.35 24.97-33.36 45.43-38.67 85.5-2.18 16.44-.38 17.29 6.67 39.09h7.16v6.08c0 2.17 1.78 3.94 3.95 3.94h128.36c2.16 0 3.94-1.77 3.94-3.94v-6.08zM47.67 0h416.66c13.11 0 25.04 5.38 33.67 14 8.63 8.64 14 20.57 14 33.67v359.85c0 13.06-5.38 24.99-14.02 33.63-8.63 8.66-20.55 14.03-33.65 14.03H47.67c-13.1 0-25.03-5.37-33.67-14-8.62-8.63-14-20.56-14-33.66V47.67C0 34.56 5.37 22.63 14 14 22.63 5.37 34.56 0 47.67 0zm341.08 44.13h62.93V59.8h-62.93V44.13zm0 39.03h36.41v15.67h-36.41V83.16zm0 312.21h36.41v15.67h-36.41v-15.67zm0-39.02h62.93v15.68h-62.93v-15.68zm0-39.03h36.41v15.67h-36.41v-15.67zm0-39.03h62.93v15.68h-62.93v-15.68zm0-39.01h36.41v15.67h-36.41v-15.67zm0-39.04h62.93v15.67h-62.93v-15.67zm0-39.03h36.41v15.67h-36.41v-15.67zm0-39.03h62.93v15.67h-62.93v-15.67zM133.54 75.83c4.42 0 8 3.58 8 8 0 4.41-3.58 8-8 8H81.96c-4.41 0-7.99-3.59-7.99-8 0-4.42 3.58-8 7.99-8h51.58zm0 287.54c4.42 0 8 3.58 8 8 0 4.41-3.58 7.99-8 7.99H81.96c-4.41 0-7.99-3.58-7.99-7.99 0-4.42 3.58-8 7.99-8h51.58zm.78-233.15c2.88 3.33 2.51 8.37-.82 11.25-3.32 2.88-8.36 2.51-11.24-.81l-6.51-7.52v189.72l6.51-7.52c2.88-3.33 7.92-3.69 11.24-.81 3.33 2.88 3.7 7.91.82 11.25l-20.54 23.71c-2.88 3.33-7.92 3.69-11.25.81l-.73-.72-20.55-23.08c-2.93-3.29-2.64-8.34.65-11.27 3.29-2.94 8.34-2.64 11.28.65l6.58 7.39V132.71l-6.58 7.39c-2.94 3.3-7.99 3.59-11.28.66-3.29-2.93-3.58-7.98-.65-11.27l20.53-23.09.75-.71c3.33-2.88 8.37-2.52 11.25.81l20.54 23.72zm-25.63-5.24-1.01-1.17-1.06 1.2c.37-.05.74-.09 1.13-.09l.94.06z"></path></svg>',
			'icon-size-chart'   => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 18 18"><path d="m8.6 10.2-.4-3.4c-.1-1-.7-1.7-1.5-2.1.6-.5.9-1.2.9-2C7.7 1.2 6.5 0 5 0a2.69 2.69 0 0 0-1.8 4.7c-.7.4-1.3 1.2-1.4 2.1l-.4 3.4c0 .3.1.7.3.9.2.3.6.4.9.4h.2l.2 5.4c0 .6.5 1.1 1.2 1.1h1.7c.6 0 1.1-.5 1.1-1.1l.3-5.4h.2c.3 0 .6-.2.9-.4.2-.2.3-.6.2-.9zM5 .9c1 0 1.8.8 1.8 1.8S6 4.5 5 4.5s-1.8-.8-1.8-1.8S4 .9 5 .9zm2.7 9.6s-.1.1-.2.1h-.7c-.2 0-.4.2-.4.4l-.3 5.8c0 .2-.1.3-.3.3H4.2c-.2 0-.3-.1-.3-.3L3.6 11c0-.2-.2-.4-.4-.4h-.6c-.1 0-.2-.1-.2-.1s-.1-.1-.1-.3l.4-3.4c.1-.8.8-1.4 1.7-1.4h1.2c.9 0 1.6.7 1.7 1.5l.4 3.4c.1.1 0 .2 0 .2z"></path><path d="M15.4 0h-4.8c-.4 0-.8.4-.8.8v16.3c0 .4.4.8.8.8h4.8c.4 0 .8-.4.8-.8V.8c0-.4-.4-.8-.8-.8zm0 17.2h-4.8v-.6h1.6v-.8h-1.6V15h1.6v-.8h-1.6v-.8H13v-.8h-2.4v-.8h1.6V11h-1.6v-.8h1.6v-.8h-1.6v-.8H13v-.8h-2.4V7h1.6v-.8h-1.6v-.8h1.6v-.8h-1.6v-.8H13V3h-2.4v-.8h1.6v-.8h-1.6V.8h4.8v16.4z"></path></svg>',
			'measurement-vertical-icon' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 82.27 122.88"><path d="M39.47,0h40.1a2.68,2.68,0,0,1,1.87.76l.08.08a2.67,2.67,0,0,1,.75,1.86V120.18a2.74,2.74,0,0,1-.76,1.87l-.13.12a2.72,2.72,0,0,1-1.81.71H39.47a2.72,2.72,0,0,1-1.87-.76l-.13-.13a2.72,2.72,0,0,1-.71-1.81V2.7A2.73,2.73,0,0,1,37.52.83l.07-.07A2.69,2.69,0,0,1,39.47,0ZM77.22,15.81H58.14V10.75H77.22V5.06H41.82V117.82h35.4v-5.69H66.7v-5.06H77.22v-5.65H58.14v-5H77.22V90.72H66.7v-5H77.22V80H58.14V75H77.22V69.32H66.7v-5H77.22V58.62H58.14V53.56H77.22V47.92H66.7V42.86H77.22V37.22H58.14V32.16H77.22V26.51H66.7V21.46H77.22V15.81ZM24,.23a3.22,3.22,0,0,1,0,6.43H3.22a3.22,3.22,0,1,1,0-6.43Zm0,115.66a3.22,3.22,0,0,1,0,6.44H3.22a3.22,3.22,0,1,1,0-6.44Zm.31-93.78a3.21,3.21,0,0,1-4.85,4.2l-2.62-3V99.6l2.62-3a3.21,3.21,0,0,1,4.85,4.2L16,110.31a3.21,3.21,0,0,1-4.53.33l-.29-.3-8.27-9.27a3.22,3.22,0,1,1,4.8-4.28l2.64,3V23.11l-2.65,3a3.22,3.22,0,0,1-4.8-4.28l8.26-9.28.3-.29a3.21,3.21,0,0,1,4.53.33l8.26,9.54Z"></path></svg>',
			'measuring-tape-icon'   => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 122.88 89.03"><path d="M118.29,48.22c-29.73,2.45-58.61,3.68-80.22.88C22.76,47.12,11,43.09,4.93,36V47.86c0,1.07,0,2.82-.06,4.54-.18,9.75-.33,18,8.57,24.74V72.49a2.3,2.3,0,1,1,4.59,0V80a37.46,37.46,0,0,0,7,2.56c.59.15,1.18.3,1.79.43V64a2.3,2.3,0,1,1,4.59,0v19.8a79.79,79.79,0,0,0,8.23.66V72.49a2.3,2.3,0,1,1,4.59,0v12h8.23V64a2.3,2.3,0,1,1,4.59,0V84.44h8.24V71.26a2.3,2.3,0,1,1,4.59,0V84.44h8.23V64a2.3,2.3,0,1,1,4.59,0V84.44H91V71.86a2.3,2.3,0,0,1,4.59,0V84.44h8.24s0-.09,0-.13V64a2.3,2.3,0,1,1,4.59,0V84.44h9.9V48.22ZM14.78,83.43a2.49,2.49,0,0,1-.28-.15,31.36,31.36,0,0,1-3.73-2.41C-.07,72.67.1,63.38.3,52.33c0-1.22,0-2.47,0-4.47V27A13.91,13.91,0,0,1,0,24C0,17.12,5.24,11,13.71,6.66,21.75,2.55,32.79,0,44.93,0S68.68,2.58,77.1,6.75,91,16.75,91.38,23.32c0,0,0-.08,0-.13.39,3.69,0,14.74,0,22.27,9.4-.48,19.12-1.18,28.91-2h.28a2.3,2.3,0,0,1,2.29,2.29v41a2.3,2.3,0,0,1-2.29,2.3H41.22a73.16,73.16,0,0,1-17.28-2.08,41.16,41.16,0,0,1-9.16-3.51ZM45.56,12.67c12.23,0,23.19,5.23,23.19,12s-11,11.73-23.19,11.73-22.15-5-22.15-11.73,9.92-12,22.15-12Zm29.09-1.9C66.94,7,56.31,4.6,44.93,4.6s-21.4,2.31-28.71,6.05C9.36,14.17,5.11,18.89,5.11,24s4.25,9.84,11.11,13.35c7.31,3.74,17.45,6,28.71,6s22-2.36,29.72-6.17C81.77,33.71,86.29,29,86.29,24s-4.52-9.71-11.64-13.23Z"></path></svg>',
			'pencil-rule'   => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 48 48"><path d="M43 48H29a1 1 0 0 1-1-1V1a1 1 0 0 1 1-1h14a1 1 0 0 1 1 1v46a1 1 0 0 1-1 1zm-13-2h12V2H30v44z"/><path d="M29 8h5v2h-5zM29 14h5v2h-5zM29 20h5v2h-5zM29 26h5v2h-5zM29 32h5v2h-5zM29 38h5v2h-5zM15 46h-4c-2.757 0-5-2.243-5-5V12c0-.197.059-.391.168-.555l6-9c.371-.557 1.293-.557 1.664 0l6 9c.109.164.168.358.168.555v29c0 2.757-2.243 5-5 5zM8 12.303V41c0 1.654 1.346 3 3 3h4c1.654 0 3-1.346 3-3V12.303l-5-7.5-5 7.5z"/><path d="M19 40H7a1 1 0 1 1 0-2h12a1 1 0 1 1 0 2zM19 36H7a1 1 0 1 1 0-2h12a1 1 0 1 1 0 2z"/><path d="M11 36a1 1 0 0 1-1-1V16a1 1 0 1 1 2 0v19a1 1 0 0 1-1 1zM15 36a1 1 0 0 1-1-1V16a1 1 0 1 1 2 0v19a1 1 0 0 1-1 1zM10 7h6v2h-6z"/><path d="M10 17c-2.206 0-4-1.794-4-4a1 1 0 1 1 2 0c0 1.103.897 2 2 2s2-.897 2-2a1 1 0 1 1 2 0c0 2.206-1.794 4-4 4z"/><path d="M16 17c-2.206 0-4-1.794-4-4a1 1 0 1 1 2 0c0 1.103.897 2 2 2s2-.897 2-2a1 1 0 1 1 2 0c0 2.206-1.794 4-4 4z"/></svg>',
			'scale-ruler-icon'  => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 122.88 122.88"><path d="M91.87.85,122,31a2.94,2.94,0,0,1,.35.44,2.82,2.82,0,0,1,.49,1.6,2.85,2.85,0,0,1-.84,2l-87,87a3,3,0,0,1-.54.41,2.77,2.77,0,0,1-1.49.43,2.9,2.9,0,0,1-2-.84L.84,91.88a2.89,2.89,0,0,1,0-4.07l87-87a2.88,2.88,0,0,1,2-.84,2.82,2.82,0,0,1,2,.85ZM37.27,112.23l-7.91-7.91,3.8-3.8,7.91,7.91,4.25-4.25L31,89.84l3.8-3.8,14.34,14.34,4.25-4.24-7.91-7.92,3.8-3.8,7.91,7.91,4.25-4.24L47.07,73.74l3.8-3.8L65.22,84.29,69.47,80l-7.91-7.91,3.8-3.8,7.91,7.91L77.52,72,63.17,57.64l3.8-3.8L81.32,68.19l4.24-4.25L77.65,56l3.8-3.8,7.91,7.91,4.25-4.25L79.27,41.55l3.8-3.8L97.41,52.09,116.47,33,89.84,6.41,6.41,89.84,33,116.47l4.23-4.24ZM98,28.56a3.69,3.69,0,0,0-3.69-3.69,3.69,3.69,0,0,0-2.61,6.3l.08.09a3.71,3.71,0,0,0,5.14-.09l.08-.08a3.68,3.68,0,0,0,1-2.53Zm1.71-5.4a7.63,7.63,0,0,1,.12,10.68l-.12.13A7.64,7.64,0,0,1,89,34.08L88.91,34a7.64,7.64,0,0,1,10.81-10.8Z"></path></svg>',

			// Cart Icons.
			'cart-icon-1' => '<svg width="22" height="20" viewBox="0 0 22 20" xmlns="http://www.w3.org/2000/svg"><path d="M7.5 19.5C8.3284 19.5 9 18.8284 9 18C9 17.1716 8.3284 16.5 7.5 16.5C6.6716 16.5 6 17.1716 6 18C6 18.8284 6.6716 19.5 7.5 19.5Z" /><path d="M17.25 19.5C18.0784 19.5 18.75 18.8284 18.75 18C18.75 17.1716 18.0784 16.5 17.25 16.5C16.4216 16.5 15.75 17.1716 15.75 18C15.75 18.8284 16.4216 19.5 17.25 19.5Z" /><path fill-rule="evenodd" clip-rule="evenodd" d="M0 0.75C0 0.3358 0.3358 0 0.75 0H2.3271C2.6531 0 2.9702 0.1062 3.2304 0.3025C3.4907 0.4988 3.6799 0.7745 3.7694 1.0879L4.53 3.75H20.7857C21.0211 3.75 21.2428 3.8605 21.3845 4.0484C21.5262 4.2362 21.5715 4.4798 21.5069 4.706L19.032 13.3681C18.8977 13.8383 18.6138 14.2518 18.2235 14.5463C17.8331 14.8407 17.3575 15 16.8685 15H7.8815C7.3925 15 6.9169 14.8407 6.5265 14.5463C6.1362 14.2518 5.8523 13.8383 5.718 13.3681L3.2479 4.7225C3.2445 4.7119 3.2415 4.7011 3.2386 4.6903L2.3271 1.5H0.75C0.3358 1.5 0 1.1642 0 0.75ZM4.9586 5.25L7.1603 12.956C7.2051 13.1128 7.2997 13.2506 7.4298 13.3488C7.5599 13.4469 7.7185 13.5 7.8815 13.5H16.8685C17.0315 13.5 17.1901 13.4469 17.3202 13.3488C17.4503 13.2506 17.5449 13.1128 17.5897 12.956L19.7914 5.25H4.9586Z" /></svg>',
			'cart-icon-2' => '<svg width="21" height="23" viewBox="0 0 21 23" xmlns="http://www.w3.org/2000/svg"><path fill="transparent" stroke="currentColor" d="M6.29128 7.61596V5.32247C6.29128 4.30869 6.694 3.33643 7.41086 2.61958C8.12771 1.90272 9.09997 1.5 10.1138 1.5C11.1275 1.5 12.0998 1.90272 12.8167 2.61958C13.5335 3.33643 13.9362 4.30869 13.9362 5.32247V7.61596M19.1042 19.6797C19.1283 19.8942 19.1067 20.1114 19.0408 20.3169C18.9749 20.5225 18.8663 20.7117 18.722 20.8723C18.5773 21.0326 18.4003 21.1605 18.2026 21.2474C18.005 21.3344 17.7912 21.3785 17.5752 21.3769H2.65229C2.43635 21.3785 2.22252 21.3344 2.02486 21.2474C1.82721 21.1605 1.65022 21.0326 1.50554 20.8723C1.36126 20.7117 1.2526 20.5225 1.18671 20.3169C1.12083 20.1114 1.09922 19.8942 1.1233 19.6797L2.46881 7.61596H17.7587L19.1042 19.6797Z" stroke="black" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>',
			'cart-icon-3' => '<svg width="20" height="17" viewBox="0 0 20 17" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M0 1.5C0 0.6716 0.6716 0 1.5 0H18C18.8284 0 19.5 0.6716 19.5 1.5V15C19.5 15.8284 18.8284 16.5 18 16.5H1.5C0.6716 16.5 0 15.8284 0 15V1.5ZM18 1.5H1.5V15H18V1.5Z" /><path fill-rule="evenodd" clip-rule="evenodd" d="M6 3.75C6.4142 3.75 6.75 4.0858 6.75 4.5C6.75 5.2956 7.0661 6.0587 7.6287 6.6213C8.1913 7.1839 8.9544 7.5 9.75 7.5C10.5456 7.5 11.3087 7.1839 11.8713 6.6213C12.4339 6.0587 12.75 5.2956 12.75 4.5C12.75 4.0858 13.0858 3.75 13.5 3.75C13.9142 3.75 14.25 4.0858 14.25 4.5C14.25 5.6935 13.7759 6.8381 12.932 7.682C12.0881 8.5259 10.9435 9 9.75 9C8.5565 9 7.4119 8.5259 6.568 7.682C5.7241 6.8381 5.25 5.6935 5.25 4.5C5.25 4.0858 5.5858 3.75 6 3.75Z" /></svg>',
			'cart-icon-4' => '<svg width="18" height="19" viewBox="0 0 18 19" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M1.6875 5.5789V17.4211H16.3125V5.5789H1.6875ZM0 5.4605C0 4.6944 0.639899 4 1.5234 4H16.4766C17.3601 4 18 4.6944 18 5.4605V17.5395C18 18.3056 17.3601 19 16.4766 19H1.5234C0.639899 19 0 18.3056 0 17.5395V5.4605Z" /><path fill-rule="evenodd" clip-rule="evenodd" d="M12.75 6.125C12.3358 6.125 12 5.7892 12 5.375C12 4.5794 11.6839 3.8163 11.1213 3.2537C10.5587 2.6911 9.7956 2.375 9 2.375C8.2043 2.375 7.4413 2.6911 6.8787 3.2537C6.3161 3.8163 6 4.5793 6 5.375C6 5.7892 5.6642 6.125 5.25 6.125C4.8358 6.125 4.5 5.7892 4.5 5.375C4.5 4.1815 4.9741 3.0369 5.818 2.193C6.6619 1.3491 7.8065 0.875 9 0.875C10.1935 0.875 11.3381 1.3491 12.182 2.193C13.0259 3.0369 13.5 4.1815 13.5 5.375C13.5 5.7892 13.1642 6.125 12.75 6.125Z" /></svg>',
			'cart-icon-5' => '<svg width="20" height="23" viewBox="0 0 20 23" xmlns="http://www.w3.org/2000/svg"><path d="M18.8622 5.6637C18.8388 5.2986 18.5368 5.0147 18.1708 5.0147H14.5064V3.9321C14.5064 1.7641 12.4502 0 9.9235 0C7.3967 0 5.3406 1.7641 5.3406 3.9321V5.0147H1.6762C1.3102 5.0147 1.0082 5.2986 0.984802 5.6637L0.00130125 21.4182C-0.0103987 21.6093 0.057201 21.7959 0.187901 21.9357C0.318601 22.0745 0.501602 22.1538 0.692702 22.1538H19.1543C19.3454 22.1538 19.5284 22.0745 19.6591 21.9357C19.7898 21.7959 19.8574 21.6093 19.8457 21.4182L18.8622 5.6637ZM6.7252 3.9321C6.7252 2.5276 8.1603 1.3846 9.9235 1.3846C11.6867 1.3846 13.1218 2.5276 13.1218 3.9321V5.0147H6.7252V3.9321ZM5.3406 6.3993V7.9029C5.3406 8.2851 5.6507 8.5952 6.0329 8.5952C6.4151 8.5952 6.7252 8.2851 6.7252 7.9029V6.3993H13.1218V7.9029C13.1218 8.2851 13.4319 8.5952 13.8141 8.5952C14.1963 8.5952 14.5064 8.2851 14.5064 7.9029V6.3993H17.5199L18.1198 15.9997H1.7272L2.327 6.3993H5.3406ZM1.4292 20.7692L1.6695 16.9227H18.1774L18.4178 20.7692H1.4292Z" /></svg>',

			// Quick View.
			'eye' => '<svg width="26" height="17" viewBox="0 0 26 17" xmlns="http://www.w3.org/2000/svg"><path d="M13 0C7.2653 0 2.32275 3.38057 0.0522984 8.25897C-0.0174328 8.4068 -0.0174328 8.57973 0.0522984 8.73035C2.32275 13.6088 7.2653 16.9893 13 16.9893C18.7347 16.9893 23.6773 13.6088 25.9477 8.73035C26.0174 8.58252 26.0174 8.40959 25.9477 8.25897C23.6773 3.38057 18.7347 0 13 0ZM13 14.3563C9.76168 14.3563 7.13978 11.7316 7.13978 8.49606C7.13978 5.25774 9.76447 2.63584 13 2.63584C16.2383 2.63584 18.8602 5.26053 18.8602 8.49606C18.8602 11.7316 16.2355 14.3563 13 14.3563Z" /><path d="M12.9996 12.2453C15.0715 12.2453 16.7511 10.5656 16.7511 8.49373C16.7511 6.42181 15.0715 4.74219 12.9996 4.74219C10.9277 4.74219 9.24805 6.42181 9.24805 8.49373C9.24805 10.5656 10.9277 12.2453 12.9996 12.2453Z" /></svg>',
			'cart' => '<svg width="22" height="22" viewBox="0 0 22 22" xmlns="http://www.w3.org/2000/svg"><path d="M6.6 17.6C5.3845 17.6 4.411 18.5845 4.411 19.8C4.411 21.0155 5.3845 22 6.6 22C7.8155 22 8.8 21.0155 8.8 19.8C8.8 18.5845 7.8155 17.6 6.6 17.6ZM0 0V2.2H2.2L6.1545 10.5435L4.6695 13.2385C4.499 13.5575 4.4 13.915 4.4 14.3C4.4 15.5155 5.3845 16.5 6.6 16.5H19.8V14.3H7.0675C6.9135 14.3 6.7925 14.179 6.7925 14.025C6.7925 13.9755 6.8035 13.9315 6.8255 13.893L7.81 12.1H16.005C16.83 12.1 17.5505 11.6435 17.93 10.967L21.8625 3.828C21.9505 3.674 22 3.4925 22 3.3C22 2.6895 21.505 2.2 20.9 2.2H4.6365L3.5915 0H0ZM17.6 17.6C16.3845 17.6 15.411 18.5845 15.411 19.8C15.411 21.0155 16.3845 22 17.6 22C18.8155 22 19.8 21.0155 19.8 19.8C19.8 18.5845 18.8155 17.6 17.6 17.6Z" /></svg>',

			// Social
			'icon-mail'         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M502.3 190.8c3.9-3.1 9.7-.2 9.7 4.7V400c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V195.6c0-5 5.7-7.8 9.7-4.7 22.4 17.4 52.1 39.5 154.1 113.6 21.1 15.4 56.7 47.8 92.2 47.6 35.7.3 72-32.8 92.3-47.6 102-74.1 131.6-96.3 154-113.7zM256 320c23.2.4 56.6-29.2 73.4-41.4 132.7-96.3 142.8-104.7 173.4-128.7 5.8-4.5 9.2-11.5 9.2-18.9v-19c0-26.5-21.5-48-48-48H48C21.5 64 0 85.5 0 112v19c0 7.4 3.4 14.3 9.2 18.9 30.6 23.9 40.7 32.4 173.4 128.7 16.8 12.2 50.2 41.8 73.4 41.4z"/></svg>',
			'icon-ok'           => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1024 1024"><path d="M1024 512c0 512 0 512-512 512S0 1024 0 512 0 0 512 0s512 0 512 512z"/><path d="M592.2 686.1c40.4-9.2 79.3-25.2 115.101-47.7 27.1-17.1 35.3-52.899 18.199-80.1-17.1-27.2-52.899-35.4-80.1-18.3-81.2 51.1-185.7 51-266.9 0-27.199-17.1-63-8.9-80.1 18.3-17.1 27.1-8.9 63 18.2 80.1 35.8 22.5 74.7 38.5 115.1 47.7L321 796.9c-22.699 22.699-22.699 59.399 0 82.1 11.4 11.3 26.2 17 41 17 14.9 0 29.7-5.7 41.101-17L512 770.1 620.9 879c22.7 22.7 59.4 22.7 82.1 0 22.7-22.7 22.7-59.5 0-82.1L592.2 686.1M512 244.2c45.301 0 82.101 36.8 82.101 82.1 0 45.2-36.8 82-82.101 82-45.199 0-82.1-36.8-82.1-82 0-45.3 36.901-82.1 82.1-82.1zm0 280.2c109.301 0 198.2-88.9 198.2-198.101C710.2 216.9 621.301 128 512 128c-109.3 0-198.199 88.9-198.199 198.2 0 109.3 88.899 198.2 198.199 198.2z" fill="#fff"/></svg>',
			'icon-facebook'     => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M504 256C504 119 393 8 256 8S8 119 8 256c0 123.78 90.69 226.38 209.25 245V327.69h-63V256h63v-54.64c0-62.15 37-96.48 93.67-96.48 27.14 0 55.52 4.84 55.52 4.84v61h-31.28c-30.8 0-40.41 19.12-40.41 38.73V256h68.78l-11 71.69h-57.78V501C413.31 482.38 504 379.78 504 256z"/></svg>',
			'icon-tiktok'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M448,209.91a210.06,210.06,0,0,1-122.77-39.25V349.38A162.55,162.55,0,1,1,185,188.31V278.2a74.62,74.62,0,1,0,52.23,71.18V0l88,0a121.18,121.18,0,0,0,1.86,22.17h0A122.18,122.18,0,0,0,381,102.39a121.43,121.43,0,0,0,67,20.14Z" /></svg>',
			'icon-twitter'      => '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" viewBox="0 0 24 24" style="enable-background:new 0 0 24 24;" xml:space="preserve"><path d="M14.095479,10.316482L22.286354,1h-1.940718l-7.115352,8.087682L7.551414,1H1l8.589488,12.231093L1,23h1.940717  l7.509372-8.542861L16.448587,23H23L14.095479,10.316482z M11.436522,13.338465l-0.871624-1.218704l-6.924311-9.68815h2.981339  l5.58978,7.82155l0.867949,1.218704l7.26506,10.166271h-2.981339L11.436522,13.338465z"/></svg>',
			'icon-discord'      => '<svg viewBox="0 0 22 26" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M14.575 12.375C14.575 13.1375 14.0125 13.7625 13.3 13.7625C12.6 13.7625 12.025 13.1375 12.025 12.375C12.025 11.6125 12.5875 10.9875 13.3 10.9875C14.0125 10.9875 14.575 11.6125 14.575 12.375ZM8.7375 10.9875C8.025 10.9875 7.4625 11.6125 7.4625 12.375C7.4625 13.1375 8.0375 13.7625 8.7375 13.7625C9.45 13.7625 10.0125 13.1375 10.0125 12.375C10.025 11.6125 9.45 10.9875 8.7375 10.9875ZM21.9375 3.075V25.5C18.7884 22.7171 19.7955 23.6383 16.1375 20.2375L16.8 22.55H2.625C1.2125 22.55 0.0625 21.4 0.0625 19.975V3.075C0.0625 1.65 1.2125 0.5 2.625 0.5H19.375C20.7875 0.5 21.9375 1.65 21.9375 3.075ZM18.375 14.925C18.375 10.9 16.575 7.6375 16.575 7.6375C14.775 6.2875 13.0625 6.325 13.0625 6.325L12.8875 6.525C15.0125 7.175 16 8.1125 16 8.1125C13.0307 6.48511 9.54277 6.48481 6.6625 7.75C6.2 7.9625 5.925 8.1125 5.925 8.1125C5.925 8.1125 6.9625 7.125 9.2125 6.475L9.0875 6.325C9.0875 6.325 7.375 6.2875 5.575 7.6375C5.575 7.6375 3.775 10.9 3.775 14.925C3.775 14.925 4.825 16.7375 7.5875 16.825C7.5875 16.825 8.05 16.2625 8.425 15.7875C6.8375 15.3125 6.2375 14.3125 6.2375 14.3125C6.42139 14.4412 6.72461 14.6081 6.75 14.625C8.85986 15.8065 11.8568 16.1937 14.55 15.0625C14.9875 14.9 15.475 14.6625 15.9875 14.325C15.9875 14.325 15.3625 15.35 13.725 15.8125C14.1 16.2875 14.55 16.825 14.55 16.825C17.3125 16.7375 18.375 14.925 18.375 14.925Z" fill="black"/></svg>',
			'icon-github'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 496 512"><path d="M165.9 397.4c0 2-2.3 3.6-5.2 3.6-3.3.3-5.6-1.3-5.6-3.6 0-2 2.3-3.6 5.2-3.6 3-.3 5.6 1.3 5.6 3.6zm-31.1-4.5c-.7 2 1.3 4.3 4.3 4.9 2.6 1 5.6 0 6.2-2s-1.3-4.3-4.3-5.2c-2.6-.7-5.5.3-6.2 2.3zm44.2-1.7c-2.9.7-4.9 2.6-4.6 4.9.3 2 2.9 3.3 5.9 2.6 2.9-.7 4.9-2.6 4.6-4.6-.3-1.9-3-3.2-5.9-2.9zM244.8 8C106.1 8 0 113.3 0 252c0 110.9 69.8 205.8 169.5 239.2 12.8 2.3 17.3-5.6 17.3-12.1 0-6.2-.3-40.4-.3-61.4 0 0-70 15-84.7-29.8 0 0-11.4-29.1-27.8-36.6 0 0-22.9-15.7 1.6-15.4 0 0 24.9 2 38.6 25.8 21.9 38.6 58.6 27.5 72.9 20.9 2.3-16 8.8-27.1 16-33.7-55.9-6.2-112.3-14.3-112.3-110.5 0-27.5 7.6-41.3 23.6-58.9-2.6-6.5-11.1-33.3 2.6-67.9 20.9-6.5 69 27 69 27 20-5.6 41.5-8.5 62.8-8.5s42.8 2.9 62.8 8.5c0 0 48.1-33.6 69-27 13.7 34.7 5.2 61.4 2.6 67.9 16 17.7 25.8 31.5 25.8 58.9 0 96.5-58.9 104.2-114.8 110.5 9.2 7.9 17 22.9 17 46.4 0 33.7-.3 75.4-.3 83.6 0 6.5 4.6 14.4 17.3 12.1C428.2 457.8 496 362.9 496 252 496 113.3 383.5 8 244.8 8zM97.2 352.9c-1.3 1-1 3.3.7 5.2 1.6 1.6 3.9 2.3 5.2 1 1.3-1 1-3.3-.7-5.2-1.6-1.6-3.9-2.3-5.2-1zm-10.8-8.1c-.7 1.3.3 2.9 2.3 3.9 1.6 1 3.6.7 4.3-.7.7-1.3-.3-2.9-2.3-3.9-2-.6-3.6-.3-4.3.7zm32.4 35.6c-1.6 1.3-1 4.3 1.3 6.2 2.3 2.3 5.2 2.6 6.5 1 1.3-1.3.7-4.3-1.3-6.2-2.2-2.3-5.2-2.6-6.5-1zm-11.4-14.7c-1.6 1-1.6 3.6 0 5.9 1.6 2.3 4.3 3.3 5.6 2.3 1.6-1.3 1.6-3.9 0-6.2-1.4-2.3-4-3.3-5.6-2z"/></svg>',
			'icon-linkedin'     => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M416 32H31.9C14.3 32 0 46.5 0 64.3v383.4C0 465.5 14.3 480 31.9 480H416c17.6 0 32-14.5 32-32.3V64.3c0-17.8-14.4-32.3-32-32.3zM135.4 416H69V202.2h66.5V416zm-33.2-243c-21.3 0-38.5-17.3-38.5-38.5S80.9 96 102.2 96c21.2 0 38.5 17.3 38.5 38.5 0 21.3-17.2 38.5-38.5 38.5zm282.1 243h-66.4V312c0-24.8-.5-56.7-34.5-56.7-34.6 0-39.9 27-39.9 54.9V416h-66.4V202.2h63.7v29.2h.9c8.9-16.8 30.6-34.5 62.9-34.5 67.2 0 79.7 44.3 79.7 101.9V416z"/></svg>',
			'icon-youtube'      => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M549.655 124.083c-6.281-23.65-24.787-42.276-48.284-48.597C458.781 64 288 64 288 64S117.22 64 74.629 75.486c-23.497 6.322-42.003 24.947-48.284 48.597-11.412 42.867-11.412 132.305-11.412 132.305s0 89.438 11.412 132.305c6.281 23.65 24.787 41.5 48.284 47.821C117.22 448 288 448 288 448s170.78 0 213.371-11.486c23.497-6.321 42.003-24.171 48.284-47.821 11.412-42.867 11.412-132.305 11.412-132.305s0-89.438-11.412-132.305zm-317.51 213.508V175.185l142.739 81.205-142.739 81.201z"/></svg>',
			'icon-xing'         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M162.7 210c-1.8 3.3-25.2 44.4-70.1 123.5-4.9 8.3-10.8 12.5-17.7 12.5H9.8c-7.7 0-12.1-7.5-8.5-14.4l69-121.3c.2 0 .2-.1 0-.3l-43.9-75.6c-4.3-7.8.3-14.1 8.5-14.1H100c7.3 0 13.3 4.1 18 12.2l44.7 77.5zM382.6 46.1l-144 253v.3L330.2 466c3.9 7.1.2 14.1-8.5 14.1h-65.2c-7.6 0-13.6-4-18-12.2l-92.4-168.5c3.3-5.8 51.5-90.8 144.8-255.2 4.6-8.1 10.4-12.2 17.5-12.2h65.7c8 0 12.3 6.7 8.5 14.1z"/></svg>',
			'icon-instagram'    => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z"/></svg>',
			'icon-flickr'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M400 32H48C21.5 32 0 53.5 0 80v352c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48V80c0-26.5-21.5-48-48-48zM144.5 319c-35.1 0-63.5-28.4-63.5-63.5s28.4-63.5 63.5-63.5 63.5 28.4 63.5 63.5-28.4 63.5-63.5 63.5zm159 0c-35.1 0-63.5-28.4-63.5-63.5s28.4-63.5 63.5-63.5 63.5 28.4 63.5 63.5-28.4 63.5-63.5 63.5z"/></svg>',
			'icon-dribble'      => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 8C119.252 8 8 119.252 8 256s111.252 248 248 248 248-111.252 248-248S392.748 8 256 8zm163.97 114.366c29.503 36.046 47.369 81.957 47.835 131.955-6.984-1.477-77.018-15.682-147.502-6.818-5.752-14.041-11.181-26.393-18.617-41.614 78.321-31.977 113.818-77.482 118.284-83.523zM396.421 97.87c-3.81 5.427-35.697 48.286-111.021 76.519-34.712-63.776-73.185-116.168-79.04-124.008 67.176-16.193 137.966 1.27 190.061 47.489zm-230.48-33.25c5.585 7.659 43.438 60.116 78.537 122.509-99.087 26.313-186.36 25.934-195.834 25.809C62.38 147.205 106.678 92.573 165.941 64.62zM44.17 256.323c0-2.166.043-4.322.108-6.473 9.268.19 111.92 1.513 217.706-30.146 6.064 11.868 11.857 23.915 17.174 35.949-76.599 21.575-146.194 83.527-180.531 142.306C64.794 360.405 44.17 310.73 44.17 256.323zm81.807 167.113c22.127-45.233 82.178-103.622 167.579-132.756 29.74 77.283 42.039 142.053 45.189 160.638-68.112 29.013-150.015 21.053-212.768-27.882zm248.38 8.489c-2.171-12.886-13.446-74.897-41.152-151.033 66.38-10.626 124.7 6.768 131.947 9.055-9.442 58.941-43.273 109.844-90.795 141.978z"/></svg>',
			'icon-vk'           => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M545 117.7c3.7-12.5 0-21.7-17.8-21.7h-58.9c-15 0-21.9 7.9-25.6 16.7 0 0-30 73.1-72.4 120.5-13.7 13.7-20 18.1-27.5 18.1-3.7 0-9.4-4.4-9.4-16.9V117.7c0-15-4.2-21.7-16.6-21.7h-92.6c-9.4 0-15 7-15 13.5 0 14.2 21.2 17.5 23.4 57.5v86.8c0 19-3.4 22.5-10.9 22.5-20 0-68.6-73.4-97.4-157.4-5.8-16.3-11.5-22.9-26.6-22.9H38.8c-16.8 0-20.2 7.9-20.2 16.7 0 15.6 20 93.1 93.1 195.5C160.4 378.1 229 416 291.4 416c37.5 0 42.1-8.4 42.1-22.9 0-66.8-3.4-73.1 15.4-73.1 8.7 0 23.7 4.4 58.7 38.1 40 40 46.6 57.9 69 57.9h58.9c16.8 0 25.3-8.4 20.4-25-11.2-34.9-86.9-106.7-90.3-111.5-8.7-11.2-6.2-16.2 0-26.2.1-.1 72-101.3 79.4-135.6z"/></svg>',
			'icon-weibo'        => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M407 177.6c7.6-24-13.4-46.8-37.4-41.7-22 4.8-28.8-28.1-7.1-32.8 50.1-10.9 92.3 37.1 76.5 84.8-6.8 21.2-38.8 10.8-32-10.3zM214.8 446.7C108.5 446.7 0 395.3 0 310.4c0-44.3 28-95.4 76.3-143.7C176 67 279.5 65.8 249.9 161c-4 13.1 12.3 5.7 12.3 6 79.5-33.6 140.5-16.8 114 51.4-3.7 9.4 1.1 10.9 8.3 13.1 135.7 42.3 34.8 215.2-169.7 215.2zm143.7-146.3c-5.4-55.7-78.5-94-163.4-85.7-84.8 8.6-148.8 60.3-143.4 116s78.5 94 163.4 85.7c84.8-8.6 148.8-60.3 143.4-116zM347.9 35.1c-25.9 5.6-16.8 43.7 8.3 38.3 72.3-15.2 134.8 52.8 111.7 124-7.4 24.2 29.1 37 37.4 12 31.9-99.8-55.1-195.9-157.4-174.3zm-78.5 311c-17.1 38.8-66.8 60-109.1 46.3-40.8-13.1-58-53.4-40.3-89.7 17.7-35.4 63.1-55.4 103.4-45.1 42 10.8 63.1 50.2 46 88.5zm-86.3-30c-12.9-5.4-30 .3-38 12.9-8.3 12.9-4.3 28 8.6 34 13.1 6 30.8.3 39.1-12.9 8-13.1 3.7-28.3-9.7-34zm32.6-13.4c-5.1-1.7-11.4.6-14.3 5.4-2.9 5.1-1.4 10.6 3.7 12.9 5.1 2 11.7-.3 14.6-5.4 2.8-5.2 1.1-10.9-4-12.9z"/></svg>',
			'icon-vimeo'        => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M403.2 32H44.8C20.1 32 0 52.1 0 76.8v358.4C0 459.9 20.1 480 44.8 480h358.4c24.7 0 44.8-20.1 44.8-44.8V76.8c0-24.7-20.1-44.8-44.8-44.8zM377 180.8c-1.4 31.5-23.4 74.7-66 129.4-44 57.2-81.3 85.8-111.7 85.8-18.9 0-34.8-17.4-47.9-52.3-25.5-93.3-36.4-148-57.4-148-2.4 0-10.9 5.1-25.4 15.2l-15.2-19.6c37.3-32.8 72.9-69.2 95.2-71.2 25.2-2.4 40.7 14.8 46.5 51.7 20.7 131.2 29.9 151 67.6 91.6 13.5-21.4 20.8-37.7 21.8-48.9 3.5-33.2-25.9-30.9-45.8-22.4 15.9-52.1 46.3-77.4 91.2-76 33.3.9 49 22.5 47.1 64.7z"/></svg>',
			'icon-mix'          => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M0 64v348.9c0 56.2 88 58.1 88 0V174.3c7.9-52.9 88-50.4 88 6.5v175.3c0 57.9 96 58 96 0V240c5.3-54.7 88-52.5 88 4.3v23.8c0 59.9 88 56.6 88 0V64H0z"/></svg>',
			'icon-behance'      => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M232 237.2c31.8-15.2 48.4-38.2 48.4-74 0-70.6-52.6-87.8-113.3-87.8H0v354.4h171.8c64.4 0 124.9-30.9 124.9-102.9 0-44.5-21.1-77.4-64.7-89.7zM77.9 135.9H151c28.1 0 53.4 7.9 53.4 40.5 0 30.1-19.7 42.2-47.5 42.2h-79v-82.7zm83.3 233.7H77.9V272h84.9c34.3 0 56 14.3 56 50.6 0 35.8-25.9 47-57.6 47zm358.5-240.7H376V94h143.7v34.9zM576 305.2c0-75.9-44.4-139.2-124.9-139.2-78.2 0-131.3 58.8-131.3 135.8 0 79.9 50.3 134.7 131.3 134.7 61.3 0 101-27.6 120.1-86.3H509c-6.7 21.9-34.3 33.5-55.7 33.5-41.3 0-63-24.2-63-65.3h185.1c.3-4.2.6-8.7.6-13.2zM390.4 274c2.3-33.7 24.7-54.8 58.5-54.8 35.4 0 53.2 20.8 56.2 54.8H390.4z"/></svg>',
			'icon-spotify'      => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 496 512"><path d="M248 8C111.1 8 0 119.1 0 256s111.1 248 248 248 248-111.1 248-248S384.9 8 248 8zm100.7 364.9c-4.2 0-6.8-1.3-10.7-3.6-62.4-37.6-135-39.2-206.7-24.5-3.9 1-9 2.6-11.9 2.6-9.7 0-15.8-7.7-15.8-15.8 0-10.3 6.1-15.2 13.6-16.8 81.9-18.1 165.6-16.5 237 26.2 6.1 3.9 9.7 7.4 9.7 16.5s-7.1 15.4-15.2 15.4zm26.9-65.6c-5.2 0-8.7-2.3-12.3-4.2-62.5-37-155.7-51.9-238.6-29.4-4.8 1.3-7.4 2.6-11.9 2.6-10.7 0-19.4-8.7-19.4-19.4s5.2-17.8 15.5-20.7c27.8-7.8 56.2-13.6 97.8-13.6 64.9 0 127.6 16.1 177 45.5 8.1 4.8 11.3 11 11.3 19.7-.1 10.8-8.5 19.5-19.4 19.5zm31-76.2c-5.2 0-8.4-1.3-12.9-3.9-71.2-42.5-198.5-52.7-280.9-29.7-3.6 1-8.1 2.6-12.9 2.6-13.2 0-23.3-10.3-23.3-23.6 0-13.6 8.4-21.3 17.4-23.9 35.2-10.3 74.6-15.2 117.5-15.2 73 0 149.5 15.2 205.4 47.8 7.8 4.5 12.9 10.7 12.9 22.6 0 13.6-11 23.3-23.2 23.3z"/></svg>',
			'icon-soundcloud'   => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M111.4 256.3l5.8 65-5.8 68.3c-.3 2.5-2.2 4.4-4.4 4.4s-4.2-1.9-4.2-4.4l-5.6-68.3 5.6-65c0-2.2 1.9-4.2 4.2-4.2 2.2 0 4.1 2 4.4 4.2zm21.4-45.6c-2.8 0-4.7 2.2-5 5l-5 105.6 5 68.3c.3 2.8 2.2 5 5 5 2.5 0 4.7-2.2 4.7-5l5.8-68.3-5.8-105.6c0-2.8-2.2-5-4.7-5zm25.5-24.1c-3.1 0-5.3 2.2-5.6 5.3l-4.4 130 4.4 67.8c.3 3.1 2.5 5.3 5.6 5.3 2.8 0 5.3-2.2 5.3-5.3l5.3-67.8-5.3-130c0-3.1-2.5-5.3-5.3-5.3zM7.2 283.2c-1.4 0-2.2 1.1-2.5 2.5L0 321.3l4.7 35c.3 1.4 1.1 2.5 2.5 2.5s2.2-1.1 2.5-2.5l5.6-35-5.6-35.6c-.3-1.4-1.1-2.5-2.5-2.5zm23.6-21.9c-1.4 0-2.5 1.1-2.5 2.5l-6.4 57.5 6.4 56.1c0 1.7 1.1 2.8 2.5 2.8s2.5-1.1 2.8-2.5l7.2-56.4-7.2-57.5c-.3-1.4-1.4-2.5-2.8-2.5zm25.3-11.4c-1.7 0-3.1 1.4-3.3 3.3L47 321.3l5.8 65.8c.3 1.7 1.7 3.1 3.3 3.1 1.7 0 3.1-1.4 3.1-3.1l6.9-65.8-6.9-68.1c0-1.9-1.4-3.3-3.1-3.3zm25.3-2.2c-1.9 0-3.6 1.4-3.6 3.6l-5.8 70 5.8 67.8c0 2.2 1.7 3.6 3.6 3.6s3.6-1.4 3.9-3.6l6.4-67.8-6.4-70c-.3-2.2-2-3.6-3.9-3.6zm241.4-110.9c-1.1-.8-2.8-1.4-4.2-1.4-2.2 0-4.2.8-5.6 1.9-1.9 1.7-3.1 4.2-3.3 6.7v.8l-3.3 176.7 1.7 32.5 1.7 31.7c.3 4.7 4.2 8.6 8.9 8.6s8.6-3.9 8.6-8.6l3.9-64.2-3.9-177.5c-.4-3-2-5.8-4.5-7.2zm-26.7 15.3c-1.4-.8-2.8-1.4-4.4-1.4s-3.1.6-4.4 1.4c-2.2 1.4-3.6 3.9-3.6 6.7l-.3 1.7-2.8 160.8s0 .3 3.1 65.6v.3c0 1.7.6 3.3 1.7 4.7 1.7 1.9 3.9 3.1 6.4 3.1 2.2 0 4.2-1.1 5.6-2.5 1.7-1.4 2.5-3.3 2.5-5.6l.3-6.7 3.1-58.6-3.3-162.8c-.3-2.8-1.7-5.3-3.9-6.7zm-111.4 22.5c-3.1 0-5.8 2.8-5.8 6.1l-4.4 140.6 4.4 67.2c.3 3.3 2.8 5.8 5.8 5.8 3.3 0 5.8-2.5 6.1-5.8l5-67.2-5-140.6c-.2-3.3-2.7-6.1-6.1-6.1zm376.7 62.8c-10.8 0-21.1 2.2-30.6 6.1-6.4-70.8-65.8-126.4-138.3-126.4-17.8 0-35 3.3-50.3 9.4-6.1 2.2-7.8 4.4-7.8 9.2v249.7c0 5 3.9 8.6 8.6 9.2h218.3c43.3 0 78.6-35 78.6-78.3.1-43.6-35.2-78.9-78.5-78.9zm-296.7-60.3c-4.2 0-7.5 3.3-7.8 7.8l-3.3 136.7 3.3 65.6c.3 4.2 3.6 7.5 7.8 7.5 4.2 0 7.5-3.3 7.5-7.5l3.9-65.6-3.9-136.7c-.3-4.5-3.3-7.8-7.5-7.8zm-53.6-7.8c-3.3 0-6.4 3.1-6.4 6.7l-3.9 145.3 3.9 66.9c.3 3.6 3.1 6.4 6.4 6.4 3.6 0 6.4-2.8 6.7-6.4l4.4-66.9-4.4-145.3c-.3-3.6-3.1-6.7-6.7-6.7zm26.7 3.4c-3.9 0-6.9 3.1-6.9 6.9L227 321.3l3.9 66.4c.3 3.9 3.1 6.9 6.9 6.9s6.9-3.1 6.9-6.9l4.2-66.4-4.2-141.7c0-3.9-3-6.9-6.9-6.9z"/></svg>',
			'icon-twitch'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M391.17,103.47H352.54v109.7h38.63ZM285,103H246.37V212.75H285ZM120.83,0,24.31,91.42V420.58H140.14V512l96.53-91.42h77.25L487.69,256V0ZM449.07,237.75l-77.22,73.12H294.61l-67.6,64v-64H140.14V36.58H449.07Z"/></svg>',
			'icon-bandcamp'     => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256,8C119,8,8,119,8,256S119,504,256,504,504,393,504,256,393,8,256,8Zm48.2,326.1h-181L207.9,178h181Z"/></svg>',
			'icon-etsy'         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M384 348c-1.75 10.75-13.75 110-15.5 132-117.879-4.299-219.895-4.743-368.5 0v-25.5c45.457-8.948 60.627-8.019 61-35.25 1.793-72.322 3.524-244.143 0-322-1.029-28.46-12.13-26.765-61-36v-25.5c73.886 2.358 255.933 8.551 362.999-3.75-3.5 38.25-7.75 126.5-7.75 126.5H332C320.947 115.665 313.241 68 277.25 68h-137c-10.25 0-10.75 3.5-10.75 9.75V241.5c58 .5 88.5-2.5 88.5-2.5 29.77-.951 27.56-8.502 40.75-65.251h25.75c-4.407 101.351-3.91 61.829-1.75 160.25H257c-9.155-40.086-9.065-61.045-39.501-61.5 0 0-21.5-2-88-2v139c0 26 14.25 38.25 44.25 38.25H263c63.636 0 66.564-24.996 98.751-99.75H384z"/></svg>',
			'icon-pinterest'    => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 496 512"><path d="M496 256c0 137-111 248-248 248-25.6 0-50.2-3.9-73.4-11.1 10.1-16.5 25.2-43.5 30.8-65 3-11.6 15.4-59 15.4-59 8.1 15.4 31.7 28.5 56.8 28.5 74.8 0 128.7-68.8 128.7-154.3 0-81.9-66.9-143.2-152.9-143.2-107 0-163.9 71.8-163.9 150.1 0 36.4 19.4 81.7 50.3 96.1 4.7 2.2 7.2 1.2 8.3-3.3.8-3.4 5-20.3 6.9-28.1.6-2.5.3-4.7-1.7-7.1-10.1-12.5-18.3-35.3-18.3-56.6 0-54.7 41.4-107.6 112-107.6 60.9 0 103.6 41.5 103.6 100.9 0 67.1-33.9 113.6-78 113.6-24.3 0-42.6-20.1-36.7-44.8 7-29.5 20.5-61.3 20.5-82.6 0-19-10.2-34.9-31.4-34.9-24.9 0-44.9 25.7-44.9 60.2 0 22 7.4 36.8 7.4 36.8s-24.5 103.8-29 123.2c-5 21.4-3 51.6-.9 71.2C65.4 450.9 0 361.1 0 256 0 119 111 8 248 8s248 111 248 248z"/></svg>',
			'icon-whatsapp'     => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M380.9 97.1C339 55.1 283.2 32 223.9 32c-122.4 0-222 99.6-222 222 0 39.1 10.2 77.3 29.6 111L0 480l117.7-30.9c32.4 17.7 68.9 27 106.1 27h.1c122.3 0 224.1-99.6 224.1-222 0-59.3-25.2-115-67.1-157zm-157 341.6c-33.2 0-65.7-8.9-94-25.7l-6.7-4-69.8 18.3L72 359.2l-4.4-7c-18.5-29.4-28.2-63.3-28.2-98.2 0-101.7 82.8-184.5 184.6-184.5 49.3 0 95.6 19.2 130.4 54.1 34.8 34.9 56.2 81.2 56.1 130.5 0 101.8-84.9 184.6-186.6 184.6zm101.2-138.2c-5.5-2.8-32.8-16.2-37.9-18-5.1-1.9-8.8-2.8-12.5 2.8-3.7 5.6-14.3 18-17.6 21.8-3.2 3.7-6.5 4.2-12 1.4-32.6-16.3-54-29.1-75.5-66-5.7-9.8 5.7-9.1 16.3-30.3 1.8-3.7.9-6.9-.5-9.7-1.4-2.8-12.5-30.1-17.1-41.2-4.5-10.8-9.1-9.3-12.5-9.5-3.2-.2-6.9-.2-10.6-.2-3.7 0-9.7 1.4-14.8 6.9-5.1 5.6-19.4 19-19.4 46.3 0 27.3 19.9 53.7 22.6 57.4 2.8 3.7 39.1 59.7 94.8 83.8 35.2 15.2 49 16.5 66.6 13.9 10.7-1.6 32.8-13.4 37.4-26.4 4.6-13 4.6-24.1 3.2-26.4-1.3-2.5-5-3.9-10.5-6.6z"/></svg>',
			'icon-wa.me'        => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M380.9 97.1C339 55.1 283.2 32 223.9 32c-122.4 0-222 99.6-222 222 0 39.1 10.2 77.3 29.6 111L0 480l117.7-30.9c32.4 17.7 68.9 27 106.1 27h.1c122.3 0 224.1-99.6 224.1-222 0-59.3-25.2-115-67.1-157zm-157 341.6c-33.2 0-65.7-8.9-94-25.7l-6.7-4-69.8 18.3L72 359.2l-4.4-7c-18.5-29.4-28.2-63.3-28.2-98.2 0-101.7 82.8-184.5 184.6-184.5 49.3 0 95.6 19.2 130.4 54.1 34.8 34.9 56.2 81.2 56.1 130.5 0 101.8-84.9 184.6-186.6 184.6zm101.2-138.2c-5.5-2.8-32.8-16.2-37.9-18-5.1-1.9-8.8-2.8-12.5 2.8-3.7 5.6-14.3 18-17.6 21.8-3.2 3.7-6.5 4.2-12 1.4-32.6-16.3-54-29.1-75.5-66-5.7-9.8 5.7-9.1 16.3-30.3 1.8-3.7.9-6.9-.5-9.7-1.4-2.8-12.5-30.1-17.1-41.2-4.5-10.8-9.1-9.3-12.5-9.5-3.2-.2-6.9-.2-10.6-.2-3.7 0-9.7 1.4-14.8 6.9-5.1 5.6-19.4 19-19.4 46.3 0 27.3 19.9 53.7 22.6 57.4 2.8 3.7 39.1 59.7 94.8 83.8 35.2 15.2 49 16.5 66.6 13.9 10.7-1.6 32.8-13.4 37.4-26.4 4.6-13 4.6-24.1 3.2-26.4-1.3-2.5-5-3.9-10.5-6.6z"/></svg>',
			'icon-telegram'     => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 496 512"><path d="M248,8C111.033,8,0,119.033,0,256S111.033,504,248,504,496,392.967,496,256,384.967,8,248,8ZM362.952,176.66c-3.732,39.215-19.881,134.378-28.1,178.3-3.476,18.584-10.322,24.816-16.948,25.425-14.4,1.326-25.338-9.517-39.287-18.661-21.827-14.308-34.158-23.215-55.346-37.177-24.485-16.135-8.612-25,5.342-39.5,3.652-3.793,67.107-61.51,68.335-66.746.153-.655.3-3.1-1.154-4.384s-3.59-.849-5.135-.5q-3.283.746-104.608,69.142-14.845,10.194-26.894,9.934c-8.855-.191-25.888-5.006-38.551-9.123-15.531-5.048-27.875-7.717-26.8-16.291q.84-6.7,18.45-13.7,108.446-47.248,144.628-62.3c68.872-28.647,83.183-33.623,92.511-33.789,2.052-.034,6.639.474,9.61,2.885a10.452,10.452,0,0,1,3.53,6.716A43.765,43.765,0,0,1,362.952,176.66Z"/></svg>',
			'icon-t.me'         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 496 512"><path d="M248,8C111.033,8,0,119.033,0,256S111.033,504,248,504,496,392.967,496,256,384.967,8,248,8ZM362.952,176.66c-3.732,39.215-19.881,134.378-28.1,178.3-3.476,18.584-10.322,24.816-16.948,25.425-14.4,1.326-25.338-9.517-39.287-18.661-21.827-14.308-34.158-23.215-55.346-37.177-24.485-16.135-8.612-25,5.342-39.5,3.652-3.793,67.107-61.51,68.335-66.746.153-.655.3-3.1-1.154-4.384s-3.59-.849-5.135-.5q-3.283.746-104.608,69.142-14.845,10.194-26.894,9.934c-8.855-.191-25.888-5.006-38.551-9.123-15.531-5.048-27.875-7.717-26.8-16.291q.84-6.7,18.45-13.7,108.446-47.248,144.628-62.3c68.872-28.647,83.183-33.623,92.511-33.789,2.052-.034,6.639.474,9.61,2.885a10.452,10.452,0,0,1,3.53,6.716A43.765,43.765,0,0,1,362.952,176.66Z"/></svg>',
			'icon-reddit'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M201.5 305.5c-13.8 0-24.9-11.1-24.9-24.6 0-13.8 11.1-24.9 24.9-24.9 13.6 0 24.6 11.1 24.6 24.9 0 13.6-11.1 24.6-24.6 24.6zM504 256c0 137-111 248-248 248S8 393 8 256 119 8 256 8s248 111 248 248zm-132.3-41.2c-9.4 0-17.7 3.9-23.8 10-22.4-15.5-52.6-25.5-86.1-26.6l17.4-78.3 55.4 12.5c0 13.6 11.1 24.6 24.6 24.6 13.8 0 24.9-11.3 24.9-24.9s-11.1-24.9-24.9-24.9c-9.7 0-18 5.8-22.1 13.8l-61.2-13.6c-3-.8-6.1 1.4-6.9 4.4l-19.1 86.4c-33.2 1.4-63.1 11.3-85.5 26.8-6.1-6.4-14.7-10.2-24.1-10.2-34.9 0-46.3 46.9-14.4 62.8-1.1 5-1.7 10.2-1.7 15.5 0 52.6 59.2 95.2 132 95.2 73.1 0 132.3-42.6 132.3-95.2 0-5.3-.6-10.8-1.9-15.8 31.3-16 19.8-62.5-14.9-62.5zM302.8 331c-18.2 18.2-76.1 17.9-93.6 0-2.2-2.2-6.1-2.2-8.3 0-2.5 2.5-2.5 6.4 0 8.6 22.8 22.8 87.3 22.8 110.2 0 2.5-2.2 2.5-6.1 0-8.6-2.2-2.2-6.1-2.2-8.3 0zm7.7-75c-13.6 0-24.6 11.1-24.6 24.9 0 13.6 11.1 24.6 24.6 24.6 13.8 0 24.9-11.1 24.9-24.6 0-13.8-11-24.9-24.9-24.9z"/></svg>',
			'icon-bsky'         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M111.8 62.2C170.2 105.9 233 194.7 256 242.4c23-47.6 85.8-136.4 144.2-180.2c42.1-31.6 110.3-56 110.3 21.8c0 15.5-8.9 130.5-14.1 149.2C478.2 298 412 314.6 353.1 304.5c102.9 17.5 129.1 75.5 72.5 133.5c-107.4 110.2-154.3-27.6-166.3-62.9l0 0c-1.7-4.9-2.6-7.8-3.3-7.8s-1.6 3-3.3 7.8l0 0c-12 35.3-59 173.1-166.3 62.9c-56.5-58-30.4-116 72.5-133.5C100 314.6 33.8 298 15.7 233.1C10.4 214.4 1.5 99.4 1.5 83.9c0-77.8 68.2-53.4 110.3-21.8z"></path></svg>',

			'icon-share' => '<svg viewBox="0 0 256 256" xmlns="http://www.w3.org/2000/svg"><rect fill="none" height="256" width="256"/><circle cx="64" cy="128" fill="none" r="32" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/><circle cx="176" cy="200" fill="none" r="32" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/><circle cx="176" cy="56" fill="none" r="32" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"/><line fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16" x1="149.1" x2="90.9" y1="73.3" y2="110.7"/><line fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16" x1="90.9" x2="149.1" y1="145.3" y2="182.7"/></svg>',
			'icon-copy-to-clipboard' => '<svg height="48" viewBox="0 0 48 48" width="48" xmlns="http://www.w3.org/2000/svg"><path d="M0 0h48v48h-48z" fill="none"/><path d="M32 2h-24c-2.21 0-4 1.79-4 4v28h4v-28h24v-4zm6 8h-22c-2.21 0-4 1.79-4 4v28c0 2.21 1.79 4 4 4h22c2.21 0 4-1.79 4-4v-28c0-2.21-1.79-4-4-4zm0 32h-22v-28h22v28z"/></svg>',

			// Free-Gifts Icons.
			'gifts-icon-1' => '<svg viewBox="14.55 10 30.91 40" fill="currentColor" xmlns="http://www.w3.org/2000/svg" width="60" height="60"><path d="M43.948 19.0908H37.3935C39.3687 17.1648 40.5974 14.4767 40.5974 11.5066C40.5974 10.6745 39.9229 10 39.0908 10C35.2352 10 31.8543 12.07 30 15.1568C28.1457 12.07 24.7649 10 20.9093 10C20.0772 10 19.4027 10.6745 19.4027 11.5066C19.4027 14.4767 20.6315 17.1648 22.6067 19.0908H16.052C15.2199 19.0908 14.5454 19.7653 14.5454 20.5974V48.4935C14.5454 49.3256 15.2199 50.0001 16.052 50.0001H43.948C44.7801 50.0001 45.4546 49.3256 45.4546 48.4935V20.5974C45.4546 19.7653 44.7801 19.0908 43.948 19.0908ZM42.4414 33.0388H31.5066V22.104H42.4414V33.0388ZM37.3926 13.2049C36.7448 16.0256 34.5191 18.2513 31.6982 18.8992C32.3461 16.0783 34.5718 13.8526 37.3926 13.2049ZM28.3018 18.8991C25.481 18.2512 23.2553 16.0256 22.6075 13.2048C25.4283 13.8526 27.654 16.0783 28.3018 18.8991ZM28.4934 22.104V33.0388H17.5586V22.104H28.4934ZM17.5586 36.052H28.4934V46.9869H17.5586V36.052ZM31.5066 46.9868V36.052H42.4414V46.9869H31.5066V46.9868Z"></path></svg>',
			'gifts-icon-2' => '<svg viewBox="6 7 48 46" fill="currentColor" xmlns="http://www.w3.org/2000/svg" width="60" height="60"><path d="M50.3077 19.8823H42.2123C42.3023 19.8064 42.3946 19.7328 42.4823 19.6523C43.1832 19.0318 43.748 18.2738 44.1415 17.4257C44.535 16.5777 44.7487 15.6579 44.7692 14.7238C44.7995 13.7019 44.62 12.6846 44.2415 11.7344C43.8631 10.7842 43.2938 9.9211 42.5685 9.1981C41.8432 8.4751 40.9774 7.90745 40.024 7.53001C39.0707 7.15257 38.05 6.9733 37.0246 7.00321C36.0869 7.02334 35.1635 7.23615 34.3122 7.62832C33.4608 8.0205 32.6999 8.58359 32.0769 9.28235C31.215 10.2779 30.5142 11.4015 30 12.6125C29.4858 11.4015 28.785 10.2779 27.9231 9.28235C27.3001 8.58359 26.5392 8.0205 25.6878 7.62832C24.8365 7.23615 23.9131 7.02334 22.9754 7.00321C21.95 6.9733 20.9293 7.15257 19.976 7.53001C19.0226 7.90745 18.1568 8.4751 17.4315 9.1981C16.7062 9.9211 16.1369 10.7842 15.7585 11.7344C15.38 12.6846 15.2005 13.7019 15.2308 14.7238C15.2513 15.6579 15.465 16.5777 15.8585 17.4257C16.252 18.2738 16.8168 19.0318 17.5177 19.6523C17.6054 19.7282 17.6977 19.8018 17.7877 19.8823H9.69231C8.71305 19.8823 7.77389 20.27 7.08145 20.9601C6.38901 21.6502 6 22.5861 6 23.5621V30.9215C6 31.8975 6.38901 32.8334 7.08145 33.5235C7.77389 34.2136 8.71305 34.6013 9.69231 34.6013V49.3203C9.69231 50.2962 10.0813 51.2321 10.7738 51.9222C11.4662 52.6123 12.4054 53 13.3846 53H27.2308C27.4756 53 27.7104 52.9031 27.8835 52.7306C28.0566 52.558 28.1538 52.324 28.1538 52.0801V30.9215H9.69231V23.5621H28.1538V30.9215H31.8462V23.5621H50.3077V30.9215H31.8462V52.0801C31.8462 52.324 31.9434 52.558 32.1165 52.7306C32.2896 52.9031 32.5244 53 32.7692 53H46.6154C47.5946 53 48.5338 52.6123 49.2262 51.9222C49.9187 51.2321 50.3077 50.2962 50.3077 49.3203V34.6013C51.287 34.6013 52.2261 34.2136 52.9185 33.5235C53.611 32.8334 54 31.8975 54 30.9215V23.5621C54 22.5861 53.611 21.6502 52.9185 20.9601C52.2261 20.27 51.287 19.8823 50.3077 19.8823ZM19.9638 16.8925C19.641 16.6012 19.3822 16.2465 19.2035 15.8508C19.0248 15.455 18.9301 15.0267 18.9254 14.5927C18.9137 14.0842 19.004 13.5785 19.1909 13.1052C19.3779 12.6319 19.6577 12.2006 20.014 11.8365C20.3704 11.4724 20.796 11.1828 21.2661 10.9847C21.7362 10.7866 22.2412 10.684 22.7515 10.683H22.8646C23.3001 10.6876 23.7299 10.782 24.127 10.9601C24.5241 11.1382 24.88 11.3962 25.1723 11.7179C27.1085 13.8981 27.7915 17.5135 28.0315 19.7489C25.7792 19.512 22.1538 18.8313 19.9638 16.8925ZM40.0408 16.8925C37.8508 18.8244 34.2162 19.5051 31.9638 19.7443C32.2385 17.3272 33 13.7877 34.8462 11.7202C35.1385 11.3985 35.4944 11.1405 35.8915 10.9624C36.2886 10.7843 36.7184 10.6899 37.1538 10.6853H37.2669C37.7773 10.6884 38.2819 10.7931 38.7512 10.9931C39.2205 11.1932 39.645 11.4845 39.9998 11.8502C40.3547 12.2158 40.6327 12.6483 40.8177 13.1224C41.0026 13.5965 41.0908 14.1026 41.0769 14.6111C41.0694 15.0421 40.9732 15.467 40.7941 15.8594C40.6151 16.2519 40.3571 16.6035 40.0362 16.8925H40.0408Z"></path></svg>',
			'gifts-icon-3' => '<svg viewBox="9 9 43 42" fill="currentColor" xmlns="http://www.w3.org/2000/svg" width="60" height="60"><path d="M48.6923 20.7621H41.4402C41.5208 20.6928 41.6035 20.6256 41.6821 20.5521C42.3099 19.9855 42.8159 19.2935 43.1685 18.5192C43.521 17.7449 43.7124 16.905 43.7308 16.0521C43.7579 15.1191 43.5971 14.1903 43.258 13.3227C42.919 12.4551 42.409 11.6671 41.7593 11.007C41.1096 10.3468 40.3339 9.82854 39.4799 9.48392C38.6258 9.13931 37.7115 8.97563 36.7929 9.00293C35.9529 9.02131 35.1257 9.21562 34.363 9.57369C33.6003 9.93176 32.9186 10.4459 32.3606 11.0839C31.5884 11.9929 30.9606 13.0188 30.5 14.1245C30.0394 13.0188 29.4116 11.9929 28.6394 11.0839C28.0814 10.4459 27.3997 9.93176 26.637 9.57369C25.8743 9.21562 25.0471 9.02131 24.2071 9.00293C23.2885 8.97563 22.3742 9.13931 21.5201 9.48392C20.6661 9.82854 19.8904 10.3468 19.2407 11.007C18.591 11.6671 18.081 12.4551 17.742 13.3227C17.4029 14.1903 17.2421 15.1191 17.2692 16.0521C17.2876 16.905 17.479 17.7449 17.8315 18.5192C18.1841 19.2935 18.6901 19.9855 19.3179 20.5521C19.3965 20.6214 19.4792 20.6886 19.5598 20.7621H12.3077C11.4304 20.7621 10.5891 21.1161 9.9688 21.7462C9.34849 22.3762 9 23.2308 9 24.1219V30.8414C9 31.7325 9.34849 32.587 9.9688 33.2171C10.5891 33.8472 11.4304 34.2012 12.3077 34.2012V47.6402C12.3077 48.5313 12.6562 49.3859 13.2765 50.0159C13.8968 50.646 14.7381 51 15.6154 51H45.3846C46.2619 51 47.1032 50.646 47.7235 50.0159C48.3438 49.3859 48.6923 48.5313 48.6923 47.6402V34.2012C49.5696 34.2012 50.4109 33.8472 51.0312 33.2171C51.6515 32.587 52 31.7325 52 30.8414V24.1219C52 23.2308 51.6515 22.3762 51.0312 21.7462C50.4109 21.1161 49.5696 20.7621 48.6923 20.7621ZM34.8413 13.3097C35.1032 13.016 35.422 12.7804 35.7778 12.6178C36.1335 12.4552 36.5186 12.3691 36.9087 12.3648H37.01C37.4672 12.3677 37.9192 12.4633 38.3396 12.6459C38.76 12.8285 39.1403 13.0946 39.4582 13.4284C39.776 13.7622 40.0251 14.1572 40.1908 14.59C40.3565 15.0229 40.4355 15.485 40.4231 15.9492C40.4189 16.3455 40.3341 16.7366 40.174 17.0979C40.0139 17.4593 39.782 17.7831 39.4928 18.0491C37.5309 19.813 34.2749 20.4345 32.2572 20.6529C32.5053 18.4292 33.1875 15.1975 34.8413 13.3097ZM21.592 13.3853C22.2327 12.7346 23.1005 12.367 24.0066 12.3627H24.1079C24.498 12.367 24.883 12.4531 25.2388 12.6157C25.5945 12.7783 25.9133 13.0139 26.1752 13.3076C27.9097 15.2983 28.5216 18.5993 28.7366 20.6403C26.7272 20.4303 23.4774 19.8004 21.5175 18.0386C21.2284 17.7726 20.9965 17.4488 20.8364 17.0874C20.6763 16.7261 20.5915 16.335 20.5873 15.9387C20.5744 15.4668 20.6562 14.9971 20.8274 14.5581C20.9987 14.1192 21.256 13.7202 21.5837 13.3853H21.592ZM12.3077 24.1219H28.8462V30.8414H12.3077V24.1219ZM15.6154 34.2012H28.8462V47.6402H15.6154V34.2012ZM45.3846 47.6402H32.1538V34.2012H45.3846V47.6402ZM48.6923 30.8414H32.1538V24.1219H48.6923V30.8414Z"></path></svg>',
			'gifts-icon-4' => '<svg viewBox="9 15 42 31" fill="currentColor" xmlns="http://www.w3.org/2000/svg" width="60" height="60"><path d="M45.3883 15C47.2586 15 48.6613 15.4723 49.5973 16.4154C50.4835 17.3104 50.9494 18.6163 50.9959 20.3359L51 20.6259V40.3915C51 42.2552 50.5324 43.6557 49.5965 44.5929C48.7111 45.4821 47.4055 45.9494 45.6796 45.9959L45.3883 46H14.6117C12.7414 46 11.3387 45.531 10.4027 44.5937C9.51653 43.7046 9.05059 42.4011 9.00408 40.6824L9 40.3923V20.6267C9 18.7506 9.46757 17.3443 10.4035 16.4063C11.2889 15.5179 12.5945 15.0505 14.3204 15.0041L14.6117 15H45.3883ZM11.8772 40.2283C11.8772 41.1721 12.1155 41.8831 12.5921 42.3613C13.0327 42.8021 13.6496 43.04 14.4444 43.0739L14.6484 43.0781L28.9098 43.0773V33.4588H28.785C28.4871 34.3902 28.0195 35.2794 27.3814 36.1271C26.7449 36.973 26.0131 37.7403 25.201 38.4135C24.4353 39.0575 23.6023 39.6144 22.7171 40.0741C21.8766 40.5034 21.1177 40.7727 20.438 40.8821C19.9264 40.9542 19.5241 40.839 19.2319 40.5365C18.9398 40.2341 18.7937 39.8835 18.7937 39.4841C18.7937 39.0482 18.9194 38.6944 19.1691 38.4226C19.3886 38.1839 19.6848 38.0314 20.0586 37.9651L20.2242 37.9411C20.8436 37.869 21.5053 37.6362 22.2071 37.2425C22.9366 36.8309 23.6226 36.3444 24.2545 35.7907C24.8941 35.2381 25.486 34.631 26.0236 33.9759C26.4773 33.4198 26.8323 32.8945 27.0901 32.3981L27.1937 32.1876H11.8772V40.2283ZM48.1219 32.1876H32.8054C33.0682 32.7445 33.4582 33.3403 33.9764 33.9759C34.5143 34.631 35.1064 35.2382 35.7463 35.7907C36.4073 36.3658 37.0862 36.8497 37.7831 37.2425C38.4033 37.5922 38.9924 37.8143 39.5506 37.9113L39.7587 37.9411C40.2238 37.99 40.5804 38.1499 40.8309 38.4217C41.0806 38.6952 41.2063 39.0482 41.2063 39.4841C41.2063 39.8835 41.0594 40.2341 40.7681 40.5365C40.4759 40.839 40.0744 40.9542 39.562 40.8821C38.8708 40.7727 38.1079 40.5034 37.2739 40.0741C36.3924 39.6128 35.5626 39.056 34.799 38.4135C33.9829 37.7356 33.2559 36.9732 32.6186 36.1263C32.0722 35.4103 31.6348 34.615 31.3211 33.7671L31.215 33.4588H31.0722V43.0773H45.3524C46.2337 43.0773 46.9159 42.8386 47.3989 42.3613C47.8445 41.9196 48.0844 41.2799 48.1187 40.4421L48.1227 40.2283L48.1219 32.1876ZM45.5523 17.9261L45.3524 17.9219H31.0722V24.1478C31.4426 23.4052 31.9284 22.7281 32.5109 22.1424C33.0508 21.5979 33.684 21.1581 34.3795 20.8447C35.0491 20.5442 35.7732 20.3895 36.5052 20.3905C37.7921 20.3905 38.8619 20.8231 39.7138 21.6883C40.5657 22.5534 40.9916 23.6522 40.9916 24.9823C40.9916 25.7446 40.8309 26.4556 40.5094 27.1153C40.177 27.7885 39.7186 28.3894 39.1597 28.8845C38.6372 29.3514 38.0557 29.7455 37.4306 30.0562L37.1491 30.1913H48.1219V20.79C48.1219 19.8453 47.8812 19.1326 47.3989 18.6478C46.9534 18.2012 46.3381 17.9592 45.5523 17.9261ZM28.9106 17.9219H14.6476C13.7541 17.9219 13.0686 18.1639 12.5921 18.6478C12.1522 19.0953 11.9148 19.7375 11.8821 20.5762L11.8772 20.79V30.1913H22.833C22.1089 29.8579 21.4374 29.4175 20.8403 28.8845C20.2808 28.388 19.8199 27.7875 19.4825 27.1153C19.1541 26.454 18.9854 25.7228 18.9904 24.9823C18.9904 23.6514 19.4196 22.5534 20.2772 21.6883C21.1357 20.8231 22.2014 20.3905 23.476 20.3905C24.2267 20.3905 24.9424 20.5414 25.6213 20.8447C26.3165 21.1582 26.9495 21.598 27.4891 22.1424C27.9946 22.6487 28.4236 23.2281 28.7621 23.8619L28.9098 24.1478L28.9106 17.9219ZM23.6204 22.9677C22.9774 22.9677 22.465 23.1641 22.0831 23.5578C21.702 23.9505 21.5119 24.4925 21.5119 25.182C21.5119 25.7504 21.684 26.3164 22.03 26.8791C22.3752 27.4418 22.8518 27.9497 23.4597 28.4039C24.098 28.8739 24.8022 29.244 25.5487 29.5019C26.2492 29.7476 26.9818 29.8861 27.7225 29.9129L28.0514 29.9195H28.5875V29.4107C28.5925 28.5716 28.4596 27.7376 28.1942 26.9429C27.948 26.1986 27.5794 25.502 27.104 24.8828C26.6389 24.2837 26.1084 23.8146 25.5128 23.4757C24.9357 23.142 24.2829 22.967 23.6188 22.9677M36.3616 22.9677C35.7031 22.9685 35.0563 23.1435 34.4848 23.4757C33.8891 23.8155 33.3587 24.2837 32.8944 24.8828C32.4183 25.503 32.0469 26.1992 31.7952 26.9429C31.5583 27.6333 31.4249 28.356 31.3995 29.0867L31.3929 29.4107V29.9195H31.9299C32.787 29.9255 33.6389 29.7843 34.4497 29.5019C35.1945 29.2455 35.8965 28.8752 36.5313 28.4039C37.1336 27.9497 37.6068 27.4418 37.9528 26.8791C38.298 26.3164 38.471 25.7504 38.471 25.182C38.471 24.4925 38.2833 23.9505 37.9079 23.5578C37.5326 23.1641 37.0169 22.9677 36.3616 22.9677Z"></path></svg>',
			'gifts-icon-5' => '<svg viewBox="5 10 50 40" fill="currentColor" xmlns="http://www.w3.org/2000/svg" width="60" height="60"><path d="M20.6719 12.503C21.0156 11.5266 20.5078 10.4563 19.5312 10.1126C18.5547 9.76889 17.4844 10.2767 17.1406 11.2531L16.3047 13.6123L15.5312 11.2844C15.2031 10.3001 14.1406 9.76889 13.1562 10.097C12.1719 10.4251 11.6406 11.4875 11.9688 12.4718L12.6172 14.4248L10.4766 12.8624C9.64062 12.2531 8.46875 12.4406 7.85938 13.2764C7.25 14.1123 7.4375 15.2841 8.27344 15.8934L10.4844 17.5026H8.75C6.67969 17.5026 5 19.1822 5 21.2523V46.2503C5 48.3204 6.67969 50 8.75 50H20.6719C20.25 49.2657 20 48.4142 20 47.5002V30.0016C20 27.6659 21.6016 25.7051 23.7656 25.1583C23.9062 22.7366 25.1016 20.6118 26.8984 19.2134C26.2266 18.1823 25.0703 17.5026 23.75 17.5026H22.0156L24.2266 15.8934C25.0625 15.2841 25.25 14.1123 24.6406 13.2764C24.0312 12.4406 22.8594 12.2531 22.0234 12.8624L20.0391 14.3076L20.6719 12.503ZM33.3984 24.4943L35.7109 27.5018H31.875C30.8359 27.5018 30 26.666 30 25.627C30 24.6036 30.8438 23.7521 31.8906 23.7521C32.4844 23.7521 33.0391 24.0255 33.3984 24.4943ZM26.25 25.627C26.25 26.2832 26.3594 26.9159 26.5703 27.5018H26.25C24.1797 27.5018 22.5 29.1814 22.5 31.2515V37.501H37.5V30.0016H40V37.501H55V31.2515C55 29.1814 53.3203 27.5018 51.25 27.5018H50.9297C51.1406 26.9159 51.25 26.2832 51.25 25.627C51.25 22.51 48.7109 20.0024 45.6094 20.0024C43.8594 20.0024 42.2031 20.8149 41.1328 22.2054L38.75 25.2989L36.3672 22.2054C35.2969 20.8149 33.6328 20.0024 31.8906 20.0024C28.7891 20.0024 26.25 22.51 26.25 25.627ZM22.5 46.2503C22.5 48.3204 24.1797 50 26.25 50H37.5V40.0008H22.5V46.2503ZM40 50H51.25C53.3203 50 55 48.3204 55 46.2503V40.0008H40V50ZM47.5 25.627C47.5 26.666 46.6641 27.5018 45.625 27.5018H41.7891L44.1016 24.4943C44.4609 24.0334 45.0156 23.7521 45.6094 23.7521C46.6562 23.7521 47.5 24.6036 47.5 25.627Z"></path></svg>',

			// General
			'chevron-right' => '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M10.8626 8.04102L14.2809 12.0291L10.8626 16.0172L9.72363 15.041L12.3053 12.0291L9.72363 9.01721L10.8626 8.04102Z" fill="#757575"/></svg>',
		);
	}
}
