<?php
/**
 * Plugin Name: MenuGate Rules
 * Plugin URI: https://wordpress.org/plugins/menugate-rules/
 * Description: Control WordPress menu item visibility based on login status and device type.
 * Version: 1.0.0
 * Author: MH Arif
 * Author URI: https://fileky.com/
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: menugate-rules
 */


if ( ! defined( 'ABSPATH' ) ) exit;

define( 'MENUGATE_PATH', plugin_dir_path( __FILE__ ) );

add_action( 'admin_enqueue_scripts', function( $hook ) {

    if ( $hook !== 'nav-menus.php' ) {
        return;
    }

    wp_enqueue_style(
        'menugate-admin',
        plugin_dir_url( __FILE__ ) . 'assets/admin.css',
        [],
        '1.0.0'
    );
});


require_once MENUGATE_PATH . 'includes/admin-fields.php';
require_once MENUGATE_PATH . 'includes/visibility-logic.php';