<?php
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Filter menu items on frontend
 */
add_filter( 'wp_get_nav_menu_items', function ( $items ) {

    // DO NOT filter in admin
    if ( is_admin() && ! wp_doing_ajax() ) {
        return $items;
    }

    foreach ( $items as $key => $item ) {

        $logged_in_only  = get_post_meta( $item->ID, '_menugate_logged_in', true );
        $logged_out_only = get_post_meta( $item->ID, '_menugate_logged_out', true );
        $device          = get_post_meta( $item->ID, '_menugate_device', true );

        if ( $logged_in_only && ! is_user_logged_in() ) {
            unset( $items[ $key ] );
            continue;
        }

        if ( $logged_out_only && is_user_logged_in() ) {
            unset( $items[ $key ] );
            continue;
        }

        if ( $device === 'mobile' && ! wp_is_mobile() ) {
            unset( $items[ $key ] );
            continue;
        }

        if ( $device === 'desktop' && wp_is_mobile() ) {
            unset( $items[ $key ] );
            continue;
        }
    }

    return $items;
});

