<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Add custom fields to menu item
 */
add_action( 'wp_nav_menu_item_custom_fields', function ( $item_id, $item ) {

    $logged_in  = get_post_meta( $item_id, '_menugate_logged_in', true );
    $logged_out = get_post_meta( $item_id, '_menugate_logged_out', true );
    $device     = get_post_meta( $item_id, '_menugate_device', true );

    // Nonce field (once per menu item is fine)
    wp_nonce_field( 'menugate_menu_save', 'menugate_menu_nonce' );
    ?>
    
    <div class="description description-wide menugate-panel">

        <h4><?php esc_html_e( 'Visibility Rules', 'menugate-rules' ); ?></h4>

        <label>
            <input type="checkbox" name="menugate_logged_in[<?php echo esc_attr( $item_id ); ?>]" <?php checked( $logged_in ); ?>>
            <?php esc_html_e( 'Show only for logged-in users', 'menugate-rules' ); ?>
        </label>

        <label>
            <input type="checkbox" name="menugate_logged_out[<?php echo esc_attr( $item_id ); ?>]" <?php checked( $logged_out ); ?>>
            <?php esc_html_e( 'Show only for logged-out users', 'menugate-rules' ); ?>
        </label>

        <label>
            <?php esc_html_e( 'Device visibility', 'menugate-rules' ); ?>
            <select name="menugate_device[<?php echo esc_attr( $item_id ); ?>]">
                <option value="all"><?php esc_html_e( 'All devices', 'menugate-rules' ); ?></option>
                <option value="desktop" <?php selected( $device, 'desktop' ); ?>>
                    <?php esc_html_e( 'Desktop only', 'menugate-rules' ); ?>
                </option>
                <option value="mobile" <?php selected( $device, 'mobile' ); ?>>
                    <?php esc_html_e( 'Mobile only', 'menugate-rules' ); ?>
                </option>
            </select>
        </label>

        <div class="menugate-note">
            <?php esc_html_e( 'Rules apply on frontend only.', 'menugate-rules' ); ?>
        </div>

    </div>

    <?php
}, 10, 2 );

/**
 * Save menu item fields
 */
add_action( 'wp_update_nav_menu_item', function ( $menu_id, $item_id ) {

    if ( ! current_user_can( 'edit_theme_options' ) ) {
        return;
    }

    $nonce = isset( $_POST['menugate_menu_nonce'] )
        ? sanitize_text_field( wp_unslash( $_POST['menugate_menu_nonce'] ) )
        : '';

    if ( ! wp_verify_nonce( $nonce, 'menugate_menu_save' ) ) {
        return;
    }

    update_post_meta(
        $item_id,
        '_menugate_logged_in',
        isset( $_POST['menugate_logged_in'][ $item_id ] )
    );

    update_post_meta(
        $item_id,
        '_menugate_logged_out',
        isset( $_POST['menugate_logged_out'][ $item_id ] )
    );

    if ( isset( $_POST['menugate_device'][ $item_id ] ) ) {
        update_post_meta(
            $item_id,
            '_menugate_device',
            sanitize_text_field(
                wp_unslash( $_POST['menugate_device'][ $item_id ] )
            )
        );
    }

}, 10, 2 );
