<?php

if (!defined('ABSPATH')) {
    die('You are not allowed to call this page directly.');
}

return array(

	'members-privacy-caps' => array(
		'url'         => '',
		'title'       => 'Members - Privacy Caps',
		'excerpt'     => 'Creates additional capabilities for control over WordPress’ privacy and personal data features (GDPR).'
	),

	'members-admin-access' => array(
		'url'         => '',
		'title'       => 'Members - Admin Access',
		'excerpt'     => 'Allows site administrators to control which users have access to the WordPress admin via role.',
	),

	'members-core-create-caps' => array(
		'url'         => '',
		'title'       => 'Members - Core Create Caps',
		'excerpt'     => 'Adds the create_posts and create_pages caps to posts/pages to separate them from their edit_* counterparts, providing more flexible editing capabilities.'
	),

	'members-category-and-tag-caps' => array(
		'url'         => '',
		'title'       => 'Members - Category and Tag Caps',
		'excerpt'     => '<p>The Category and Tag Caps add-on creates custom capabilities for the core category and post tag taxonomies.  This allows site owners to have precise control over who can manage, edit, delete, or assign categories/tags.</p>'
	),

	'members-role-levels' => array(
		'url'         => '',
		'title'       => 'Members - Role Levels',
		'excerpt'     => 'Exposes the old user levels system, which fixes the WordPress author drop-down bug when users don’t have a role with one of the assigned levels.'
	),

	'members-role-hierarchy' => array(
		'url'         => '',
		'title'       => 'Members - Role Hierarchy',
		'excerpt'     => 'Add-on plugin for Members, which creates a hierarchical roles system.'
	),

	'members-block-permissions' => array(
		'url'         => '',
		'title'       => 'Members - Block Permissions',
		'excerpt'     => '<p>Hide or show blocks in the WordPress block editor (Gutenberg).</p>'
	),

	'members-acf-integration' => array(
		'url'         => '',
		'title'       => 'Members - ACF Integration',
		'excerpt'     => '<p>The Members - ACF Integration add-on creates custom capabilities for the <a href="https://advancedcustomfields.com" target="_blank">Advanced Custom Fields</a> (ACF) plugin for managing with the Members plugin.</p>'
	),

	'members-edd-integration' => array(
		'url'         => '',
		'title'       => 'Members - EDD Integration',
		'excerpt'     => '<p>The Members - EDD Integration add-on more nicely integrates the <a href="https://easydigitaldownloads.com/" target="_blank">Easy Digital Downloads</a> plugin capabilities into the Members plugin\'s role manager.</p>'
	),

	'members-givewp-integration' => array(
		'url'         => '',
		'title'       => 'Members - GiveWP Integration',
		'excerpt'     => '<p>The Members - GiveWP Integration add-on more nicely integrates the <a href="https://givewp.com/" target="_blank">GiveWP</a> and <a href="https://givewp.com/addons/recurring-donations/" target="_blank">GiveWP Recurring Donations</a> plugin capabilities into the Members plugin\'s role manager.</p>'
	),

	'members-meta-box-integration' => array(
		'url'         => '',
		'title'       => 'Members - Meta Box Integration',
		'excerpt'     => '<p>The Members - Meta Box Integration add-on more nicely integrates the <a href="https://metabox.io/" target="_blank">Meta Box</a> plugin capabilities into the Members plugin\'s role manager.</p>'
	),

	'members-woocommerce-integration' => array(
		'url'         => '',
		'title'       => 'Members - WooCommerce Integration',
		'excerpt'     => '<p>The Members - WooCommerce Integration add-on more nicely integrates the <a href="https://woocommerce.com/" target="_blank">WooCommerce</a> plugin capabilities into the Members plugin\'s role manager.</p>'
	),

	'memberpress-payments' => array(
		'url'         => 'https://memberpress.com/?utm_source=members_plugin&utm_medium=link&utm_campaign=addons&utm_content=activate_payments',
		'title'       => 'Payments',
		'excerpt'     => '<p>Add MemberPress to accept payments for your protected membership content.</p>',
		'is_memberpress' => true,
	),

	'memberpress-subscriptions' => array(
		'url'         => 'https://memberpress.com/?utm_source=members_plugin&utm_medium=link&utm_campaign=addons&utm_content=activate_subscriptions',
		'title'       => 'Subscriptions',
		'excerpt'     => '<p>MemberPress allows you to charge users on a recurring schedule.</p>',
		'is_memberpress' => true,
	),

	'memberpress-email' => array(
		'url'         => 'https://memberpress.com/?utm_source=members_plugin&utm_medium=link&utm_campaign=addons&utm_content=activate_email_marketing',
		'title'       => 'Email Marketing',
		'excerpt'     => '<p>MemberPress can connect with popular email marketing services, such as Mailchimp, to email your members.</p>',
		'is_memberpress' => true,
	),

	'memberpress-advanced' => array(
		'url'         => 'https://memberpress.com/?utm_source=members_plugin&utm_medium=link&utm_campaign=addons&utm_content=activate_advanced_protection',
		'title'       => 'Advanced Content Protection',
		'excerpt'     => '<p>MemberPress allows you to create sophisticated rules to protect your membership content.</p>',
		'is_memberpress' => true,
	)
);
