<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
?>
<div class="mediamoo_dos__page row">
    <div class="col-xs-12 col-sm-12 col-md-8 col-lg-8">
        <h2>MediaMoo For Spaces - Files Sync</h2>
        <div class="sync-buttons">
            <button id="mediamoo-dos-start-upload" class="button button-primary">Upload local files to Spaces</button>
            <button id="mediamoo-dos-start-download" class="button button-secondary">Download files from Spaces to local server</button>
        </div>
        
        <div id="mediamoo-dos-sync-progress" style="display:none;">
            <p>Progress: <span id="mediamoo-dos-sync-count">0</span> / <span id="mediamoo-dos-total-count">0</span></p>
            <div class="progress-bar" style="width:100%; height:20px; background:#f0f0f0; margin-bottom:20px;">
                <div id="mediamoo-dos-progress-bar" style="width:0%; height:100%; background:#0073aa;"></div>
            </div>
            <p id="mediamoo-dos-current-file"></p>
        </div>
        <div id="mediamoo-dos-sync-results" style="display:none;">
            <h3>Sync Results:</h3>
            <p>Successfully synced: <span id="mediamoo-dos-success-count">0</span></p>
            <p>Failed: <span id="mediamoo-dos-failed-count">0</span></p>
            <div id="mediamoo-dos-error-log" style="display:none;">
                <h4>Errors:</h4>
                <pre style="background:#fff; padding:10px; max-height:200px; overflow:auto;"></pre>
            </div>
        </div>
    </div>

    <div class="col-xs-12 col-xs-12 col-md-4 col-lg-4">
    <h4>Upload local files to Spaces</h4>
    <ul>
      <li>Click the button "Upload local files to Spaces"</li>
      <li>Wait on the process to complete. It make take a while depending on your server, location of your server to DigitalOcean Spaces, and the amount of files and size of files.</li>
      <li>Do not close the page or refresh the page. Wait until it has completed.</li>
      <li>If you close the page or it fails, you can resume the process by clicking the button "Upload local files to Spaces" again. It will not upload files that have already been uploaded.</li>
      <li>Once completed all your media files will be uploaded to DigitalOcean Spaces.</li>
    </ul>

    <h4>Download from Spaces to your local server</h4>
    <ul>
      <li>Click the button "Download files from Spaces to local server"</li>
      <li>Wait on the process to complete. It make take a while depending on your server, location of your server to DigitalOcean Spaces, and the amount of files and size of files.</li>
      <li>Do not close the page or refresh the page. Wait until it has completed.</li>
      <li>If you close the page or it fails, you can resume the process by clicking the button "Download files from Spaces to local server" again. It will not download files that have already been downloaded.</li>
      <li>Once completed all your media files will be downloaded from DigitalOcean Spaces to your local server.</li>
    </ul>
    <h4>Plugin Information</h4>
    <p>This plugin is in no way affiliated with DigitalOcean. DigitalOcean name and DigitalOcean logo, are trademarks of DigitalOcean, LLC.</p>
    <p>This plugin is developed by independent developers.</p>
    <p><a href="https://wordpress.org/support/plugin/mediamoo-for-spaces/" target="_blank">Plugin Support</a></p>
    <p>Author: <a href="https://creatorcow.com" target="_blank">CreatorCow, LLC</a></p>
    <p>WordPress Profile: <a href="https://profiles.wordpress.org/creatorcow/" target="_blank">creatorcow</a></p>
    </div>
</div>