<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
?>
<div class="mediamoo_dos__loader"></div>
<div class="mediamoo_dos__page row">
  <div class="col-xs-12 col-sm-12 col-md-8 col-lg-8">
    <div class="mediamoo_dos__message"></div>
    <div class="row">
      <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
        <h2>MediaMoo For Spaces Settings</h2>
      </div>
    </div>
    <div class="row">
      <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
        Type in your DigitalOcean Spaces container access information.
      </div>
    </div>
    <div class="row" style="margin-top: 5px;margin-bottom: 5px;">
      <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
        Don't have an account? <a href="https://m.do.co/c/be9c01e7e4dd" target="_blank">Sign up today!</a>
      </div>
    </div>
    <div class="row" style="margin-top: 5px;margin-bottom: 5px;">
      <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
        <a href="https://www.digitalocean.com/community/tutorials/how-to-store-wordpress-assets-on-digitalocean-spaces" target="_blank">DigitalOcean tutorial on setting up this plugin.</a>
      </div> 
    </div>
    <form method="POST" action="options.php">
      <?php settings_fields('mediamoo_dos_settings'); ?>
      <div class="row">
        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
          <h4>
            Connection settings
          </h4>
        </div>
      </div>
      <div class="mediamoo_dos__block">
        <div class="row">
          <div class="col-xs-12 col-sm-12 col-md-12 col-lg-2">
            <label for="mediamoo_dos_key">
              Spaces Access Key ID:
            </label>
          </div>
          <div class="col-xs-12 col-sm-12 col-md-12 col-lg-10">
            <input id="mediamoo_dos_key" name="mediamoo_dos_key" type="text" class="regular-text code" value="<?php echo esc_attr( defined( 'MEDIAMOO_DOS_KEY' ) ? MEDIAMOO_DOS_KEY : get_option('mediamoo_dos_key')  ); ?>" 
            <?php echo ( defined( 'MEDIAMOO_DOS_KEY' ) ? 'disabled' : '' ); ?>/>
          </div>
        </div>
        <div class="row">
          <div class="col-xs-12 col-sm-12 col-md-12 col-lg-2">
            <label for="mediamoo_dos_secret">
            Spaces Secret Access Key:
            </label>
          </div>
          <div class="col-xs-12 col-sm-12 col-md-12 col-lg-10">
            <input id="mediamoo_dos_secret" name="mediamoo_dos_secret" type="password" class="regular-text code" value="<?php echo esc_attr( defined( 'MEDIAMOO_DOS_SECRET' ) ? MEDIAMOO_DOS_SECRET : get_option('mediamoo_dos_secret')  ); ?>" 
            <?php echo ( defined( 'MEDIAMOO_DOS_SECRET' ) ? 'disabled' : '' ); ?>/>
          </div>
        </div>
        <div class="row">
          <div class="col-xs-12 col-sm-12 col-md-12 col-lg-2">
            <label for="mediamoo_dos_container">
              Spaces Bucket Name:
            </label>
          </div>
          <div class="col-xs-12 col-sm-12 col-md-12 col-lg-10">
            <input id="mediamoo_dos_container" name="mediamoo_dos_container" type="text" class="regular-text code" value="<?php echo esc_attr( defined( 'MEDIAMOO_DOS_CONTAINER' ) ? MEDIAMOO_DOS_CONTAINER : get_option('mediamoo_dos_container')  ); ?>" 
            <?php echo ( defined( 'MEDIAMOO_DOS_CONTAINER' ) ? 'disabled' : '' ); ?>/>
          </div>
        </div>
        <div class="row">
          <div class="col-xs-12 col-sm-12 col-md-12 col-lg-2">
            <label for="mediamoo_dos_endpoint">
              Endpoint:
            </label>
          </div>
          <div class="col-xs-12 col-sm-12 col-md-12 col-lg-10">
            <input id="mediamoo_dos_endpoint" name="mediamoo_dos_endpoint" type="text" class="regular-text code" value="<?php echo esc_attr( defined( 'MEDIAMOO_DOS_ENDPOINT' ) ? MEDIAMOO_DOS_ENDPOINT : get_option('mediamoo_dos_endpoint')  ); ?>" 
            <?php echo ( defined( 'MEDIAMOO_DOS_ENDPOINT' ) ? 'disabled' : '' ); ?>/>
            <div class="mediamoo_dos__description">
            By default: <code>https://ams3.digitaloceanspaces.com</code>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-xs-12 col-sm-12 col-md-12 col-lg-2">
            <input type="button" name="test" class="button button-primary mediamoo_dos__test__connection" value="<?php esc_html_e('Check the connection', 'mediamoo-for-spaces'); ?>" />
          </div>
        </div>
      </div>
      <div class="row">
        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
          <h4>
            Spaces settings
          </h4>
        </div>
      </div>
      <div class="mediamoo_dos__block">
        <div class="row larger">
          <div class="col-xs-12 col-sm-12 col-md-12 col-lg-2">
            <label for="mediamoo_dos_cdn_url">
              CDN/Public URL:
            </label>
          </div>
          <div class="col-xs-12 col-sm-12 col-md-12 col-lg-10">
            <input id="mediamoo_dos_cdn_url" name="mediamoo_dos_cdn_url" type="text" class="regular-text code" value="<?php echo esc_attr( defined( 'MEDIAMOO_DOS_CDN_URL' ) ? MEDIAMOO_DOS_CDN_URL : get_option('mediamoo_dos_cdn_url')  ); ?>"
            <?php echo ( defined( 'MEDIAMOO_DOS_CDN_URL' ) ? 'disabled' : '' ); ?>/>
            <div class="mediamoo_dos__description">
              The base URL where your files are publicly accessible.<br />
              Example: <code>https://bucket.nyc3.cdn.digitaloceanspaces.com</code> or a custom domain like <code>https://cdn.yoursite.com</code>
            </div>
          </div>
        </div>
        <div class="row larger" style="margin-top: 10px;">
          <div class="col-xs-12 col-sm-12 col-md-12 col-lg-2">
            <label for="mediamoo_dos_storage_path">
              Spaces Storage Folder:
            </label>
          </div>
          <div class="col-xs-12 col-sm-12 col-md-12 col-lg-10">
            <input id="mediamoo_dos_storage_path" name="mediamoo_dos_storage_path" type="text" class="regular-text code" value="<?php echo esc_attr( defined( 'MEDIAMOO_DOS_STORAGE_PATH' ) ? MEDIAMOO_DOS_STORAGE_PATH : get_option('mediamoo_dos_storage_path')  ); ?>"
            <?php echo ( defined( 'MEDIAMOO_DOS_STORAGE_PATH' ) ? 'disabled' : '' ); ?>/>
            <div class="mediamoo_dos__description">
              Optional folder prefix within your Spaces bucket. Files will be stored under this folder.<br />
              Example: <code>website</code> will store files as <code>bucket/website/2026/02/image.jpg</code>
            </div>
          </div>
        </div>
      </div>
      <div class="row">
        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
          <h4>
            File settings
          </h4>
        </div>
      </div>
      <div class="mediamoo_dos__block">
        <div class="row" style="margin-top: 10px;margin-bottom: 10px;">
          <div class="col-xs-12 col-sm-12 col-md-12 col-lg-2">
            <label for="mediamoo_dos_filter">
              Filemask/Regex for ignored files:
            </label>
          </div>
          <div class="col-xs-12 col-sm-12 col-md-12 col-lg-10">
            <input id="mediamoo_dos_filter" name="mediamoo_dos_filter" type="text" class="regular-text code" value="<?php echo esc_attr( defined( 'MEDIAMOO_DOS_FILTER' ) ? MEDIAMOO_DOS_FILTER : get_option('mediamoo_dos_filter')  ); ?>"
            <?php echo ( defined( 'MEDIAMOO_DOS_FILTER' ) ? 'disabled' : '' ); ?>/>
            <div class="mediamoo_dos__description">
              By default empty or <code>*</code>
              Will upload all the files by default, you are free to use any Regular Expression to match and ignore the selection you need, for example:
              <code>/^.*\.(zip|rar|docx)$/i</code>
            </div>
          </div>
        </div>
      </div>
      <div class="row">
        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
          <h4>
            Sync settings
          </h4>
        </div>
      </div>
      <div class="row">
        <div class="col-xs-1 col-sm-1 col-md-1 col-lg-1" style="width: 50px;">
          <input id="onlystorage" type="checkbox" name="mediamoo_dos_storage_file_only" value="1" <?php echo checked( defined( 'MEDIAMOO_DOS_STORAGE_FILE_ONLY' ) ? mediamoo_dos_STORAGE_FILE_ONLY : get_option('mediamoo_dos_storage_file_only'), 1 ); ?>" 
          <?php echo ( defined( 'MEDIAMOO_DOS_STORAGE_FILE_ONLY' ) ? 'disabled' : '' ); ?> />
        </div>
        <div class="col-xs-11 col-sm-11 col-md-11 col-lg-11">
          Store all files in on DigitalOcean Spaces
          <br />
          Note: If you deactivate this plugin and this option is enabled, your media files will not be on your server. You must download the files on the <a href="<?php echo esc_html(get_admin_url()); ?>admin.php?page=mediamoo-dos-settings-sync">File Sync page</a>. Once you download the media files, you can deactivate this plugin.
          <br />
          Note: If you want to keep a copy of your media files on your server and on DigitalOcean Spaces, do not enable this option.
        </div>
      </div>
      <div class="row">
        <div class="col-xs-1 col-sm-1 col-md-1 col-lg-1">
          <input id="mediamoo_dos_storage_file_delete" type="checkbox" name="mediamoo_dos_storage_file_delete" value="1" <?php echo checked( defined( 'MEDIAMOO_DOS_STORAGE_FILE_DELETE' ) ? MEDIAMOO_DOS_STORAGE_FILE_DELETE : get_option('mediamoo_dos_storage_file_delete'), 1 ); ?>" 
          <?php echo ( defined( 'mediamoo_dos_STORAGE_FILE_DELETE' ) ? 'disabled' : '' ); ?> />
        </div>
        <div class="col-xs-11 col-sm-11 col-md-11 col-lg-11">
          Delete file from DigitalOcean Spaces as soon as it was removed from your library.
          <br />
          Note: If you enable this option, your media files will be deleted from DigitalOcean Spaces as soon as they are removed from your media library on WordPress. Files are permanently deleted and cannot be recovered.
        </div>
      </div>
      <div class="row">
        <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
          <input type="hidden" name="action" value="update"/>
          <?php submit_button(); ?>
        </div>
      </div>
    </form>
  </div>
  <div class="col-xs-12 col-xs-12 col-md-4 col-lg-4">
    <h4>MediaMoo For DigitalOcean Spaces Sync</h4>
    <p>This plugin is a simple way to sync your WordPress library with DigitalOcean Spaces Container.</p>
    <h4>This plugin can be used 3 ways:</h4>
    <ul>
      <li>Save space on your server and speed up your website by storing your files in Spaces. Files will be displayed using Spaces CDN. </li>
      <li>Backup media files to Spaces.</li>
      <li>Keep a copy of your files in Spaces and locally. Files will be displayed using Spaces CDN.</li>
    </ul>
    <h4>Before Removing This Plugin</h4>
    <p>If you are removing this plugin, please make sure to download all your files from Spaces to your local server. You can do this by clicking the button "Download files from Spaces to local server" on the <a href="<?php echo esc_html(get_admin_url()); ?>admin.php?page=mediamoo-dos-settings-sync">File Sync page</a>.</p>
    <h4>Plugin Information</h4>
    <p>This plugin is in no way affiliated with DigitalOcean. DigitalOcean name and DigitalOcean logo, are trademarks of DigitalOcean, LLC.</p>
    <p>This plugin is developed by independent developers.</p>
    <p><a href="https://wordpress.org/support/plugin/mediamoo-for-spaces/" target="_blank">Plugin Support</a></p>
    <p>Author: <a href="https://creatorcow.com" target="_blank">CreatorCow, LLC</a></p>
    <p>WordPress Profile: <a href="https://profiles.wordpress.org/creatorcow/" target="_blank">creatorcow</a></p>
  </div>
</div>