<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

// Ensure autoloader is loaded
require_once dirname(__FILE__) . DIRECTORY_SEPARATOR . 'vendor' . DIRECTORY_SEPARATOR . 'autoload.php';

use Aws\S3\S3Client;
use League\Flysystem\Filesystem;
use League\Flysystem\AwsS3V3\AwsS3V3Adapter;
use League\Flysystem\Local\LocalFilesystemAdapter;

class MEDIAMOO_DOS_Filesystem {

  public static function get_instance ( $key, $secret, $container, $endpoint ) {
    try {
      $client = new S3Client([
        'credentials' => [
          'key'    => $key,
          'secret' => $secret,
        ],
        'endpoint' => $endpoint, 
        'version' => 'latest',
        'region' => 'us-east-1',
        'use_path_style_endpoint' => false,
      ]);
    
      $adapter = new AwsS3V3Adapter($client, $container);
      $filesystem = new Filesystem($adapter);
    
      return $filesystem;
    } catch (Exception $e) {
      throw $e;
    }
  }

}
