<?php

class MEDIAMOO_DOS {
  
  private static $instance;
  private        $key;
  private        $secret;
  private        $endpoint;
  private        $container;
  private        $storage_path;
  private        $cdn_url;
  private        $storage_file_only;
  private        $storage_file_delete;
  private        $filter;

	/**
	 *
	 * @return MEDIAMOO_DOS
	 */
	public static function get_instance() {
		if ( ! self::$instance ) {
			self::$instance = new MEDIAMOO_DOS(
				defined( 'MEDIAMOO_DOS_KEY' ) ? MEDIAMOO_DOS_KEY : null,
				defined( 'MEDIAMOO_DOS_SECRET' ) ? MEDIAMOO_DOS_SECRET : null,
        defined( 'MEDIAMOO_DOS_CONTAINER' ) ? MEDIAMOO_DOS_CONTAINER : null,
        defined( 'MEDIAMOO_DOS_ENDPOINT' ) ? MEDIAMOO_DOS_ENDPOINT : null,
        defined( 'MEDIAMOO_DOS_STORAGE_PATH' ) ? MEDIAMOO_DOS_STORAGE_PATH : null,
        defined( 'MEDIAMOO_DOS_CDN_URL' ) ? MEDIAMOO_DOS_CDN_URL : null,
        defined( 'MEDIAMOO_DOS_STORAGE_FILE_ONLY' ) ? MEDIAMOO_DOS_STORAGE_FILE_ONLY : null,
        defined( 'MEDIAMOO_DOS_STORAGE_FILE_DELETE' ) ? MEDIAMOO_DOS_STORAGE_FILE_DELETE : null,
        defined( 'MEDIAMOO_DOS_FILTER' ) ? MEDIAMOO_DOS_FILTER : null
			);
		}
		return self::$instance;
  }
  
	public function __construct( $key, $secret, $container, $endpoint, $storage_path, $cdn_url, $storage_file_only, $storage_file_delete, $filter ) {
		$this->key                 = empty($key) ? get_option('mediamoo_dos_key') : $key;
		$this->secret              = empty($secret) ? get_option('mediamoo_dos_secret') : $secret;
    $this->endpoint            = empty($endpoint) ? get_option('mediamoo_dos_endpoint') : $endpoint;
    $this->container           = empty($container) ? get_option('mediamoo_dos_container') : $container;
    $this->storage_path        = empty($storage_path) ? get_option('mediamoo_dos_storage_path') : $storage_path;
    $this->cdn_url             = empty($cdn_url) ? get_option('mediamoo_dos_cdn_url') : $cdn_url;
    $this->storage_file_only   = empty($storage_file_only) ? get_option('mediamoo_dos_storage_file_only') : $storage_file_only;
    $this->storage_file_delete = empty($storage_file_delete) ? get_option('mediamoo_dos_storage_file_delete') : $storage_file_delete;
    $this->filter              = empty($filter) ? get_option('mediamoo_dos_filter') : $filter;
	}

  // SETUP
  public function setup () {
    $this->register_actions();
    $this->register_filters();
  }

  // REGISTRATIONS
  private function register_actions () {
    add_action('admin_menu', array($this, 'register_menu') );
    add_action('admin_init', array($this, 'register_settings' ) );
    add_action('admin_enqueue_scripts', array($this, 'register_scripts'));
    add_action('admin_enqueue_scripts', array($this, 'register_styles' ) );
    add_action('wp_ajax_mediamoo_dos_test_connection', array($this, 'test_connection' ) );
    add_action('add_attachment', array($this, 'action_add_attachment' ), 10, 1);
    add_action('image_make_intermediate_size', array($this, 'action_make_intermediate_size' ), 10, 1);
    add_action('delete_attachment', array($this, 'action_delete_attachment' ), 10, 1);
    add_action('wp_ajax_mediamoo_dos_sync_media', array($this, 'sync_media_to_spaces'));
    add_action('wp_ajax_mediamoo_dos_sync_from_spaces', array($this, 'sync_from_spaces'));
  }

  private function register_filters () {
    add_filter('wp_generate_attachment_metadata',array($this,'filter_wp_generate_attachment_metadata'), 10, 1);
    add_filter('wp_unique_filename',array($this,'filter_wp_unique_filename'));
    add_filter('plugin_action_links_' . plugin_basename(MEDIAMOO_DOS_PLUGIN_FILE), array($this, 'mediamoo_dos_plugin_action_links'));
    add_filter('wp_get_attachment_url', array($this, 'filter_wp_get_attachment_url'), 10, 2);
    add_filter('wp_calculate_image_srcset', array($this, 'filter_wp_calculate_image_srcset'), 10, 5);
  }

  public function register_scripts($hook) {
    // Debug log the current hook and screen

    wp_enqueue_script(
        'mediamoo-dos-core-js',
        plugin_dir_url(__FILE__) . 'assets/scripts/core.js',
        array('jquery'),
        '1.4.0',
        true
    );

    wp_enqueue_script(
      'mediamoo-dos-sync-js',
      plugin_dir_url(__FILE__) . 'assets/scripts/sync.js',
      array('jquery'),
      '1.0.0',
      true
  );

    wp_localize_script('mediamoo-dos-core-js', 'mediamooDos', array(
        'nonce' => wp_create_nonce('mediamoo_dos_test_connection')
    ));

    wp_localize_script('mediamoo-dos-sync-js', 'mediamooDosSync', array(
        'nonce' => wp_create_nonce('mediamoo_dos_sync_media'),
        'ajaxurl' => admin_url('admin-ajax.php')
    ));
  
  }

  public function register_styles () {
    wp_enqueue_style('mediamoo-dos-flexboxgrid', plugin_dir_url( __FILE__ ) . '/assets/styles/flexboxgrid.min.css',array(),'1.0.0');
    wp_enqueue_style('mediamoo-dos-core-css', plugin_dir_url( __FILE__ ) . '/assets/styles/core.css',array(),'1.0.0');
  }

  public function register_settings () {
    register_setting('mediamoo_dos_settings', 'mediamoo_dos_key', array('type' => 'string','sanitize_callback' => 'sanitize_text_field'));
    register_setting('mediamoo_dos_settings', 'mediamoo_dos_secret', array('type' => 'string','sanitize_callback' => 'sanitize_text_field'));
    register_setting('mediamoo_dos_settings', 'mediamoo_dos_endpoint', array('type' => 'string','sanitize_callback' => 'sanitize_text_field'));
    register_setting('mediamoo_dos_settings', 'mediamoo_dos_container', array('type' => 'string','sanitize_callback' => 'sanitize_text_field'));
    register_setting('mediamoo_dos_settings', 'mediamoo_dos_storage_path', array('type' => 'string','sanitize_callback' => 'sanitize_text_field'));
    register_setting('mediamoo_dos_settings', 'mediamoo_dos_cdn_url', array('type' => 'string','sanitize_callback' => 'esc_url_raw'));
    register_setting('mediamoo_dos_settings', 'mediamoo_dos_storage_file_only', array('type' => 'integer','sanitize_callback' => 'absint'));
    register_setting('mediamoo_dos_settings', 'mediamoo_dos_storage_file_delete', array('type' => 'integer','sanitize_callback' => 'absint'));
    register_setting('mediamoo_dos_settings', 'mediamoo_dos_filter', array('type' => 'string','sanitize_callback' => 'sanitize_text_field'));

    // Add settings saved message
    if (isset($_GET['settings-updated']) && sanitize_text_field(wp_unslash($_GET['settings-updated']))) {
      add_action('admin_notices', function() {
          $this->show_message(__('Settings have been successfully saved.', 'mediamoo-for-spaces'));
      });
    }
  }

  public function register_setting_page () {
    include_once('mediamoo_dos_settings_page.php');
  }

  public function register_sync_files_page () {
    include_once('mediamoo_dos_sync_page.php');
  }

  public function register_menu () {
    add_menu_page("MediaMoo For Spaces","MediaMoo For Spaces",'manage_options',"mediamoo-dos-settings",array($this, 'register_setting_page'), plugin_dir_url( __FILE__ ).'assets/images/icon.png');
    add_submenu_page("mediamoo-dos-settings","File Sync","File Sync",'manage_options',"mediamoo-dos-settings-sync",array($this, 'register_sync_files_page'));
  }

  // FILTERS
  public function filter_wp_unique_filename ($filename) {
    $upload_dir = wp_upload_dir();
    $subdir = $upload_dir['subdir'];
    $filesystem = MEDIAMOO_DOS_Filesystem::get_instance($this->key, $this->secret, $this->container, $this->endpoint);
    $number = 1;
    $new_filename = $filename;
    $fileparts = pathinfo($filename);
    $cdnPath = rtrim($this->storage_path,'/') . '/' . ltrim($subdir,'/') . '/' . $new_filename;
    while ( $filesystem->has( $cdnPath ) ) {
      $new_filename = $fileparts['filename'] . "-$number." . $fileparts['extension'];
      $number = (int) $number + 1;
      $cdnPath = rtrim($this->storage_path,'/') . '/' . ltrim($subdir,'/') . '/' . $new_filename;
    }
    return $new_filename;
  }

  public function filter_wp_generate_attachment_metadata ($metadata) {
    ///After generate metadata - delete original file
    ///remove on upload
    if ( $this->storage_file_only == 1 ) {
      $upload_dir = wp_upload_dir();
      // collect original file path
      if ( isset($metadata['file']) ) {
        $OriginFile = $upload_dir['basedir'] . DIRECTORY_SEPARATOR . $metadata['file'];
        if (file_exists($OriginFile)) {              
          wp_delete_file($OriginFile);
        }
      }
    }
    return $metadata;
  }

  public function mediamoo_dos_plugin_action_links($links) {
    $settings_link = '<a href="' . admin_url('admin.php?page=mediamoo-dos-settings') . '">' . __('Settings', 'mediamoo-for-spaces') . '</a>';
    array_unshift($links, $settings_link);
    return $links;
  }

  public function filter_wp_get_attachment_url($url, $post_id) {
    if (empty($this->cdn_url)) {
      return $url;
    }

    $upload_dir = wp_upload_dir();
    $local_baseurl = rtrim($upload_dir['baseurl'], '/');

    $cdn_base = rtrim($this->cdn_url, '/');
    if (!empty($this->storage_path)) {
      $cdn_base .= '/' . trim($this->storage_path, '/');
    }

    if (strpos($url, $local_baseurl) === 0) {
      $relative_path = ltrim(substr($url, strlen($local_baseurl)), '/');
      return $cdn_base . '/' . $relative_path;
    }

    return $url;
  }

  public function filter_wp_calculate_image_srcset($sources, $size_array, $image_src, $image_meta, $attachment_id) {
    if (empty($this->cdn_url)) {
      return $sources;
    }

    $upload_dir = wp_upload_dir();
    $local_baseurl = rtrim($upload_dir['baseurl'], '/');

    $cdn_base = rtrim($this->cdn_url, '/');
    if (!empty($this->storage_path)) {
      $cdn_base .= '/' . trim($this->storage_path, '/');
    }

    foreach ($sources as &$source) {
      if (strpos($source['url'], $local_baseurl) === 0) {
        $relative_path = ltrim(substr($source['url'], strlen($local_baseurl)), '/');
        $source['url'] = $cdn_base . '/' . $relative_path;
      }
    }

    return $sources;
  }

  // ACTIONS
  public function action_add_attachment ($postID) {
    $file = get_attached_file($postID);
    $this->file_upload($file);
  
    return true;
  }

  public function action_make_intermediate_size ($file) {
    $this->file_upload($file);
    ///remove on upload
    if ( $this->storage_file_only == 1 ) {
      ///check if exists
      if (file_exists($file)) {              
        wp_delete_file($file);
      }
    }
    return $file;
  }

  public function action_delete_attachment ($postID) {
    $paths = array();
    $upload_dir = wp_upload_dir();

    if ( wp_attachment_is_image($postID) == false ) {
      $file = get_attached_file($postID);
      $this->file_delete($file);
  
    } else {

      $metadata = wp_get_attachment_metadata($postID);

      // collect original file path
      if ( isset($metadata['file']) ) {

        $path = $upload_dir['basedir'] . DIRECTORY_SEPARATOR . $metadata['file'];

        if ( !in_array($path, $paths) ) {
          array_push($paths, $path);
        }

        // set basepath for other sizes
        $file_info = pathinfo($path);
        $basepath = isset($file_info['extension'])
            ? str_replace($file_info['filename'] . "." . $file_info['extension'], "", $path)
            : $path;

      }

      // collect size files path
      if ( isset($metadata['sizes']) ) {

        foreach ( $metadata['sizes'] as $size ) {

          if ( isset($size['file']) ) {

            $path = $basepath . $size['file'];
            array_push($paths, $path);

          }

        }

      }

      ///handle backup files
      $backup_sizes = get_post_meta($postID, '_wp_attachment_backup_sizes', true);
      if ($backup_sizes) {
        foreach ($backup_sizes as $backup_size) {
          $path = $basepath . $backup_size['file'];
          array_push($paths, $path);
        }
      }


      // process paths
      foreach ($paths as $filepath) {
        // upload file
        $this->file_delete($filepath);
      }

    }

  }

  // METHODS
  public function test_connection () {
    if(isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] === 'POST'){
        // Only process the specific fields we need
        $required_fields = array(
            'mediamoo_dos_key',
            'mediamoo_dos_secret',
            'mediamoo_dos_endpoint',
            'mediamoo_dos_container'
        );

        // Check if all required fields are present
        foreach ($required_fields as $field) {
            if (!isset($_POST[$field]) || empty($_POST[$field])) {
                $this->show_message(__('All fields are required.', 'mediamoo-for-spaces'), true);
                exit();
            }
        }

        // Sanitize and validate specific fields
        if (isset($_POST['mediamoo_dos_key'])) {
          $this->key = sanitize_text_field(wp_unslash($_POST['mediamoo_dos_key']));
        } else {
          $this->key = '';
        }
        if (isset($_POST['mediamoo_dos_secret'])) {
          $this->secret = sanitize_text_field(wp_unslash($_POST['mediamoo_dos_secret']));
        } else {
          $this->secret = '';
        }
        if (isset($_POST['mediamoo_dos_endpoint'])) {
          $this->endpoint = esc_url_raw(wp_unslash($_POST['mediamoo_dos_endpoint']));
        } else {
          $this->endpoint = '';
        }
        if (isset($_POST['mediamoo_dos_container'])) {
          $this->container = sanitize_text_field(wp_unslash($_POST['mediamoo_dos_container']));
        } else {
          $this->container = '';
        }

        // Validate endpoint URL format
        if (!filter_var($this->endpoint, FILTER_VALIDATE_URL)) {
            $this->show_message(__('Invalid endpoint URL format.', 'mediamoo-for-spaces'), true);
            exit();
        }
    }
    try {
    
      $filesystem = MEDIAMOO_DOS_Filesystem::get_instance($this->key, $this->secret, $this->container, $this->endpoint);
      $filesystem->write('test.txt', 'test');
      $filesystem->delete('test.txt');

      $this->show_message(__('Connection is successfully established. Save the settings.', 'mediamoo-for-spaces')); 
      exit();
  
    } catch (Exception $e) {
  
      $this->show_message(__('Connection is not established.','mediamoo-for-spaces') . ' : ' . $e->getMessage() . ($e->getCode() == 0 ? '' : ' - ' . $e->getCode() ), true);
      exit();
  
    }

  }

  public function show_message ($message, $errormsg = false) {

    if ($errormsg) {
  
      echo '<div id="message" class="error">';
  
    } else {
  
      echo '<div id="message" class="updated fade">';
  
    }
  
    echo "<p><strong>".esc_html($message)."</strong></p></div>";
  
  }

  // FILE METHODS
  public function file_path ($file) {
    $upload_dir = wp_upload_dir();
    $path = str_replace($upload_dir['basedir'], '', $file);
    return $this->storage_path . $path;
  }

  public function file_upload ($file) {

    // init cloud filesystem
    $filesystem = MEDIAMOO_DOS_Filesystem::get_instance($this->key, $this->secret, $this->container, $this->endpoint);
    $regex_string = $this->filter;

    // prepare regex
    if ( $regex_string == '*' || !strlen($regex_string)) {
      $regex = false;
    } else {
      $regex = preg_match( $regex_string, $file);
    }

    try {

      // check if readable and regex matched
      if ( is_readable($file) && !$regex ) {

        // create file in storage
        $filesystem->write( $this->file_path($file), file_get_contents($file), [
          'visibility' => 'public'
        ]);

        
      }

      return true;

    } catch (Exception $e) {

      return false;

    }

  }

  public function file_delete ($file) {

    if ( $this->storage_file_delete == 1 ) {

      try {

        $filepath = $this->file_path($file);
        $filesystem = MEDIAMOO_DOS_Filesystem::get_instance($this->key, $this->secret, $this->container, $this->endpoint);

        $filesystem->delete( $filepath );

      } catch (Exception $e) {

        ///error log here

      }      

    }

    return $file;   

  }

public function sync_media_to_spaces() {
    check_ajax_referer('mediamoo_dos_sync_media', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_send_json_error(['message' => 'Unauthorized']);
    }

    $batch_size = 10; // Number of items to process per batch
    $offset = isset($_POST['offset']) ? absint($_POST['offset']) : 0;
    
    $args = array(
        'post_type' => 'attachment',
        'posts_per_page' => $batch_size,
        'offset' => $offset,
        'post_status' => 'any'
    );
    
    $attachments = get_posts($args);
    $total = wp_count_posts('attachment')->inherit;
    $processed = 0;
    $errors = array();

    foreach ($attachments as $attachment) {
        try {
            // Get file path
            $file = get_attached_file($attachment->ID, true);
            
            if (!file_exists($file)) {
                throw new Exception("File not found: " . esc_html($file));
            }

            // Upload original file
            $this->file_upload($file);
            ///delete original file if storage_file_only is true
            if ( $this->storage_file_only == 1 ) {
                wp_delete_file($file);
            }
            
            // Get and upload thumbnails
            $metadata = wp_get_attachment_metadata($attachment->ID);
            if (!empty($metadata['sizes'])) {
                $upload_dir = wp_upload_dir();
                $base_dir = dirname($file);
                
                foreach ($metadata['sizes'] as $size => $size_info) {
                    $size_file = $base_dir . '/' . $size_info['file'];
                    if (file_exists($size_file)) {
                        $this->file_upload($size_file);
                        ///delete original file if storage_file_only is true
                        if ( $this->storage_file_only == 1 ) {
                            wp_delete_file($size_file);
                        }
                    }
                }
            }
            
            $processed++;
            
        } catch (Exception $e) {
            $errors[] = "Error processing " . esc_html($attachment->ID) . ": " . esc_html($e->getMessage());
        }
    }

    $completed = (count($attachments) < $batch_size) || (($offset + $batch_size) >= $total);
    
    wp_send_json_success([
        'processed' => $offset + $processed,
        'total' => $total,
        'offset' => $offset + $batch_size,
        'completed' => $completed,
        'errors' => $errors
    ]);
}

public function sync_from_spaces() {
    check_ajax_referer('mediamoo_dos_sync_media', 'nonce');
    
    if (!current_user_can('manage_options')) {
        wp_send_json_error(['message' => 'Unauthorized']);
    }

    $batch_size = 1; // Process one file at a time
    $offset = isset($_POST['offset']) ? absint($_POST['offset']) : 0;
    
    $args = array(
        'post_type' => 'attachment',
        'posts_per_page' => $batch_size,
        'offset' => $offset,
        'post_status' => 'any'
    );
    
    $attachments = get_posts($args);
    $total = wp_count_posts('attachment')->inherit;
    $processed = 0;
    $errors = array();
    $current_file = '';

    foreach ($attachments as $attachment) {
        try {
            $file = get_attached_file($attachment->ID, true);
            $current_file = basename($file);
            $base_dir = dirname($file);
            
            if (!file_exists($base_dir)) {
                wp_mkdir_p($base_dir);
            }

            if (!file_exists($file)) {
                $file_content = file_get_contents($attachment->guid);
                if ($file_content === false) {
                    throw new Exception("Failed to download file: " . esc_url($attachment->guid));
                }
                file_put_contents($file, $file_content);
            }
            
            $metadata = wp_get_attachment_metadata($attachment->ID);
            if (!empty($metadata['sizes'])) {
                foreach ($metadata['sizes'] as $size => $size_info) {
                    $size_file = $base_dir . '/' . $size_info['file'];
                    $current_file = $size_info['file'];
                    if (!file_exists($size_file)) {
                        $size_url = dirname($attachment->guid) . '/' . $size_info['file'];
                        $size_content = file_get_contents($size_url);
                        if ($size_content === false) {
                            throw new Exception("Failed to download file: " . esc_url($size_url));
                        }
                        file_put_contents($size_file, $size_content);
                    }
                }
            }
            
            $processed++;
            
        } catch (Exception $e) {
            $errors[] = "Error processing " . esc_html($attachment->ID) . ": " . esc_html($e->getMessage());
        }
    }

    $completed = (count($attachments) < $batch_size) || (($offset + $batch_size) >= $total);
    
    wp_send_json_success([
        'processed' => $offset + $processed,
        'total' => $total,
        'offset' => $offset + $batch_size,
        'completed' => $completed,
        'errors' => $errors,
        'current_file' => esc_html($current_file)
    ]);
}

private function download_file($url, $destination) {
    // Initialize DO Spaces client
    $client = MEDIAMOO_DOS_Filesystem::get_instance($this->key, $this->secret, $this->container, $this->endpoint);
    
    try {
        // Get the path relative to the bucket
        $spaces_path = str_replace(
            array(
                rtrim($this->endpoint . '/' . $this->container, '/') . '/',
                'https://' . $this->container . '.' . str_replace('https://', '', $this->endpoint) . '/'
            ),
            '',
            $url
        );

        // Remove any leading slashes
        $spaces_path = ltrim($spaces_path, '/');

        
        // Download the file
        $content = $client->read($spaces_path);
        
        if ($content === false) {
          throw new Exception("Failed to download file from Spaces: " . $spaces_path);
      }
      
      // Save the file locally
      if (file_put_contents($destination, $content) === false) {
          throw new Exception("Failed to save file locally: " . $destination);
      }
      
      return true;
  } catch (Exception $e) {
      ///error log here
      throw $e;
  }

  
}

public function deactivate() {
  /////Get all image attachments
  $args = array(
      'post_type' => 'attachment',
      'posts_per_page' => -1,
      'post_status' => 'any'
  );
  ////Get all image attachments
  $attachments = get_posts($args);
  $upload_dir = wp_upload_dir();
  ////reset GUIDs to default WordPress URLs
  foreach ($attachments as $attachment) {
      ////Get current GUID
      $current_guid = $attachment->guid;

      ////Only update if it's a DO Spaces URL (check if it contains the container name)
      if (strpos($current_guid, $this->container) !== false) {
          ////Convert the DO Spaces URL back to default WordPress URL
          $new_guid = str_replace(
              'https://' . $this->container . '.' . str_replace('https://', '', $this->endpoint),
              $upload_dir['baseurl'],
              $current_guid
          );
          
          ////Update the attachment GUID
          wp_update_post(array(
            'ID' => $attachment->ID,
            'guid' => $new_guid
          ));
      }
  }
  
  ////Clear any scheduled tasks if you have any
  wp_clear_scheduled_hook('mediamoo_dos_sync_cron');

  ////Reset & delete plugin-specific options only
  delete_option('mediamoo_dos_key');
  delete_option('mediamoo_dos_secret');
  delete_option('mediamoo_dos_endpoint');
  delete_option('mediamoo_dos_container');
  delete_option('mediamoo_dos_storage_path');
  delete_option('mediamoo_dos_cdn_url');
  delete_option('mediamoo_dos_storage_file_only');
  delete_option('mediamoo_dos_storage_file_delete');
  delete_option('mediamoo_dos_filter');
  
  ////Remove plugin-specific backup options
  delete_option('mediamoo_dos_original_upload_url_path');
  delete_option('mediamoo_dos_original_upload_path');
  
  ////Flush rewrite rules
  flush_rewrite_rules();
  }

}