<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * Plugin Name: MediaMoo For Spaces
 * Plugin URI: https://wordpress.org/plugins/mediamoo-for-spaces/
 * Description: MediaMoo For Spaces, syncs your media library with DigitalOcean Spaces Container automatically. 
 * Version: 1.0.4
 * Author: creatorcow
 * Author URI: https://creatorcow.com
 * License: MIT
 * Text Domain: mediamoo-for-spaces
 */

define('MEDIAMOO_DOS_PLUGIN_FILE', __FILE__);

require dirname(__FILE__) . DIRECTORY_SEPARATOR . 'mediamoo_dos_class.php';
require dirname(__FILE__) . DIRECTORY_SEPARATOR . 'mediamoo_dos_class_filesystem.php';

// Register activation/deactivation hooks
register_activation_hook(__FILE__, function() {
    // Plugin activation - no global option modifications
});
register_deactivation_hook(__FILE__, function() {
    $instance = MEDIAMOO_DOS::get_instance();
    $instance->deactivate();
});

function mediamoo_dos_incompatibile($msg) {
  require_once ABSPATH . DIRECTORY_SEPARATOR . 'wp-admin' . DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR . 'plugin.php';
  deactivate_plugins(__FILE__);
  wp_die(esc_html($msg));
}

if ( is_admin() && ( !defined('DOING_AJAX') || !DOING_AJAX ) ) {

  if ( version_compare(PHP_VERSION, '7.4.0', '<') ) {

    mediamoo_dos_incompatibile(
      __(
        'Plugin MediaMoo for DigitalOcean Spaces requires PHP 7.4.0 or higher. The plugin has now disabled itself.',
        'mediamoo-for-spaces'
      )
    );

  } elseif ( !function_exists('curl_version')
    || !($curl = curl_version()) || empty($curl['version']) || empty($curl['features'])
    || version_compare($curl['version'], '7.16.2', '<')
  ) {

    mediamoo_dos_incompatibile(
      __('Plugin MediaMoo for DigitalOcean Spaces requires cURL 7.16.2+. The plugin has now disabled itself.', 'mediamoo-for-spaces')
    );

  } elseif (!($curl['features'] & CURL_VERSION_SSL)) {

    mediamoo_dos_incompatibile(
      __(
        'Plugin MediaMoo for DigitalOcean Spaces requires that cURL is compiled with OpenSSL. The plugin has now disabled itself.',
        'mediamoo-for-spaces'
      )
    );

  }

}

// Load admin includes
if (is_admin()) {
    require_once ABSPATH . 'wp-admin/includes/plugin.php';
}

$instance = MEDIAMOO_DOS::get_instance();
$instance->setup();