console.log('Sync script loaded');

jQuery(document).ready(function($) {
    console.log('jQuery ready');
    
    const uploadButton = $('#mediamoo-dos-start-upload');
    const downloadButton = $('#mediamoo-dos-start-download');
    
    console.log('Upload button found:', uploadButton.length > 0);
    console.log('Download button found:', downloadButton.length > 0);
    
    uploadButton.on('click', function(e) {
        console.log('Upload button clicked');
        e.preventDefault();
        startSync('mediamoo_dos_sync_media');
    });
    
    downloadButton.on('click', function(e) {
        console.log('Download button clicked');
        e.preventDefault();
        startSync('mediamoo_dos_sync_from_spaces');
    });
    
    function startSync(action) {
        console.log('Starting sync:', action);
        $('.sync-buttons button').prop('disabled', true);
        $('#mediamoo-dos-sync-progress').show();
        $('#mediamoo-dos-sync-results').hide();
        $('#mediamoo-dos-error-log').hide();
        $('#mediamoo-dos-error-log pre').empty();
        $('#mediamoo-dos-success-count').text('0');
        $('#mediamoo-dos-failed-count').text('0');
        syncMedia(action);
    }

    async function syncMedia(action, offset = 0) {
        console.log('Making AJAX request:', action, 'offset:', offset);
        try {
            const response = await $.ajax({
                url: mediamooDosSync.ajaxurl,
                type: 'POST',
                data: {
                    action: action,
                    offset: offset,
                    nonce: mediamooDosSync.nonce
                }
            });

            console.log('AJAX response:', response);

            if (response.success) {
                updateProgress(response.data);
                
                if (!response.data.completed) {
                    console.log('Not completed, processing next batch...');
                    // Wait a short moment before next batch
                    await new Promise(resolve => setTimeout(resolve, 10000));
                    await syncMedia(action, response.data.offset);
                } else {
                    console.log('Sync completed');
                    syncCompleted();
                }
            } else {
                console.error('Sync error:', response.data.message);
                showError(response.data.message || 'An unknown error occurred');
                syncCompleted();
            }
        } catch (error) {
            console.error('Ajax request failed:', error);
            showError('Ajax request failed: ' + error.message);
            syncCompleted();
        }
    }

    function updateProgress(data) {
        console.log('Updating progress:', data);
        $('#mediamoo-dos-sync-count').text(data.processed);
        $('#mediamoo-dos-total-count').text(data.total);
        
        if (data.current_file) {
            $('#mediamoo-dos-current-file').text('Processing: ' + data.current_file);
        }
        
        var progress = (data.processed / data.total) * 100;
        $('#mediamoo-dos-progress-bar').css('width', progress + '%');
        
        // Update success/failure counts
        $('#mediamoo-dos-success-count').text(data.processed);
        if (data.errors && data.errors.length > 0) {
            $('#mediamoo-dos-failed-count').text(data.errors.length);
            $('#mediamoo-dos-error-log').show();
            data.errors.forEach(function(error) {
                $('#mediamoo-dos-error-log pre').append(error + "\n");
            });
        }
    }

    function syncCompleted() {
        console.log('Sync completed, re-enabling buttons');
        $('.sync-buttons button').prop('disabled', false);
        $('#mediamoo-dos-sync-results').show();
        $('#mediamoo-dos-current-file').text('Sync completed');
    }

    function showError(message) {
        console.error('Showing error:', message);
        $('#mediamoo-dos-error-log').show();
        $('#mediamoo-dos-error-log pre').append(message + "\n");
    }
}); 