jQuery(document).ready(function($){

const postid = tracking.id;
const cpt = tracking.cpt;
var progress = [];	
var prev = [];
var duration = 0;

// make Learndash mark complete disable	
if ( cpt === 'sfwd-lessons' || cpt === 'sfwd-topic' ) $('.learndash_mark_complete_button').prop('disabled', true);
	
if ( tracking.type === 'reading' ) {
	// register variables
	const loadingTime = new Date().getTime()/1000;
	var actualTime,
	  sleep = 0,
	  end = 0;

	// init reading scroller
	$('body').scrollgress({
		height:'10px',
		color:'#ff0000',
		complete: function() {
			end = 1;
			check_reading_time();
		}
	});	

	// check reading progress in every 30 seconds
	setInterval(check_reading_time, 30000);	

	// checking the reading time & scrolled to end once
	function check_reading_time() {
		actualTime = new Date().getTime()/1000;
		const time = $('#reading_time').html();
		if ( sleep == 0 && end == 1 && (time*1 + Math.floor(loadingTime)) <= Math.floor(actualTime) ) {
			saveTrackingPoints(postid, time);
			sleep = 1;
		}
	}	
	
}
else if ( tracking.type === 'watching' ) {
	
	var vimeoPlayerElement = document.getElementById('vimeoplayer'),
	 youtubePlayerElement = document.getElementById('youtubeplayer');

	// Vimeo
	if (vimeoPlayerElement !== null) {

		const iframe = $('#vimeoplayer');
		const vimeo = new Vimeo.Player(iframe);

		let iterations = 0;
		const maxIterations = 5;	
		const intervalId = setInterval(_await, 1000);

		function _await() {
			iterations++;
			if (iterations <= maxIterations) {

				vimeo.getDuration().then(function(duration) {
					if (!$('.cpd_memory').hasClass('populated')) memory_init(duration);
					if (tracking.lastpercent !== '') {
						if (tracking.lastpercent !== 100) vimeo.setCurrentTime(tracking.lastpercent);
					}
				});	

				vimeo.on('timeupdate', function(data) {	
					var currentPercent = (data.duration < 100) ? Math.ceil(data.seconds) : Math.ceil(data.percent * 100);
					if (progress.indexOf(currentPercent) != -1) { 
						return; 
					}

					progress.push(currentPercent);
					memory_color(currentPercent, data.duration);

				});

				vimeo.on('pause', function(data) {
					saveTrackingPoints(postid, Math.floor(data.duration), progress, Math.ceil(data.seconds));

				});	

				iterations = 6;

			}
			else clearInterval(intervalId);

		}

	}
	else if (youtubePlayerElement !== null) { // Youtube
	
		var player;

		// Avoid the 'YT is not a constructor' issue
		$(document).ready(function() {
			$.getScript('https://www.youtube.com/iframe_api', function() {
				onYouTubeIframeAPIReady();
			});
		});	

		function onYouTubeIframeAPIReady() {
			player = new YT.Player('youtubeplayer', {
				events: {
				  'onReady': onPlayerReady,
				  'onStateChange': onPlayerStateChange
				}
			});
		  }

		function onPlayerReady(event) {
			if ( !$('.cpd_memory').hasClass('populated') ) memory_init(player.getDuration());
			if ( tracking.lastpercent !== '' ) {
				if (tracking.lastpercent !== 100) {
					player.seekTo(tracking.lastpercent, true);
					player.pauseVideo();
				}
			}
		}

		function onPlayerStateChange(event) {
			if (event.data == YT.PlayerState.PAUSED) {
				saveTrackingPoints(postid, player.getDuration(), progress, Math.ceil(player.getCurrentTime()));
			}
		}

		window.addEventListener('message', function(event) {
			if (player && typeof player.getCurrentTime === 'function') {
				var currentPercent = Math.ceil(player.getCurrentTime() / player.getDuration() * 100);
				if (progress.indexOf(currentPercent) !== -1) {
					return;
				}
				progress.push(currentPercent);
				memory_color(currentPercent, player.getDuration());

			}
		});
	}
	else { // html5 video tag
	
		const video5 = document.querySelector('video');

		if (video5.preload === 'none') video5.preload = 'auto';
		video5.load();		

		video5.onloadedmetadata = function() {
			if ( !$('.cpd_memory').hasClass('populated') ) memory_init(this.duration);	
			
			if ( tracking.lastpercent !== '' ) {
				if (tracking.lastpercent !== 100) this.currentTime = (tracking.lastpercent);
			}
		};

		video5.addEventListener('timeupdate', (e) => {
			if (!video5 || typeof video5.currentTime !== 'number' || video5.duration === 0 || isNaN(video5.duration)) {
				return;
			}
			
			var currentPercent = (video5.duration >= 100) ? Math.ceil(Math.floor(video5.currentTime) * 100 / video5.duration) : Math.floor(video5.currentTime);

			if (progress.indexOf(currentPercent) != -1) { 
				return; 
			}

			if ( currentPercent >= 1 ) progress.push(currentPercent);
			if (!isNaN(currentPercent) && !isNaN(video5.duration)) memory_color(currentPercent, video5.duration);
		});
		
		video5.addEventListener('pause', function(data) {
			saveTrackingPoints(postid, video5.duration, progress, Math.floor(video5.currentTime));

		});
	}
	
}
else if ( tracking.type === 'listening' ) {
	const music = document.querySelector('audio');

	if (music.preload === 'none') music.preload = 'auto';
	music.load();
	
	music.onloadedmetadata = function() {
		if ( !$('.cpd_memory').hasClass('populated') ) memory_init(this.duration);
		if ( tracking.lastpercent !== '' ) {
			if (tracking.lastpercent !== 100) this.currentTime = (tracking.lastpercent);
		}
	};
	
	music.addEventListener('timeupdate', (e) => {
		var currentPercent = (music.duration >= 100) ? Math.ceil(Math.floor(music.currentTime) * 100 / music.duration) : Math.floor(music.currentTime);

 		if (progress.indexOf(currentPercent) != -1) { 
			return; 
		}

		if ( currentPercent >= 1 ) progress.push(currentPercent);
		if (!isNaN(currentPercent) && !isNaN(music.duration)) memory_color(currentPercent, music.duration);
	});

	music.addEventListener('pause', function(data) {
    	saveTrackingPoints(postid, music.duration, progress, Math.floor(music.currentTime));

	});	

}

// init memory
function memory_init(duration) {
	//add subdivs to the indicator
	var container = $('.cpd_memory');
	var parts = ( duration < 100 ) ? duration : 100;
	var not_watched = $('<div class="percentage"></div>');
	var watched = $('<div class="percentage cleared"></div>');
	var previous_progress = ( tracking.progress === '' ) ? [] : JSON.parse(tracking.progress);
	for (var i = 1; i <= parts; i++) {
		if (previous_progress.includes(i)) container.append(watched.clone());
		else container.append(not_watched.clone());
    }
	
	container.addClass('populated');
}

function memory_color(percentage, duration) {
	$('.populated .percentage:nth-child(' + percentage + ')').addClass('cleared');
}
	
// send the points & progress to the AJAX handler
function saveTrackingPoints(id, time, progress, currentPercent) {
	/*console.log('dur '+time);
	console.log(JSON.stringify(prev));
	console.log(JSON.stringify(progress));
	console.log('last '+currentPercent);*/
	
	// if the previous sent data was not the same
	if ( tracking.type === 'watching' || tracking.type === 'listening' ) {
		if ( equalsCheck(prev, progress) ) {
			return;
		}
	}

	jQuery.ajax({
		type: 'POST',
		dataType: 'json',
		url: tracking.ajax_url,
		data: {
			action: 'mediactr_savepoints',
			id: id,
			time: time,
			progress: JSON.stringify(progress),
			lastpercent: currentPercent,
			nonce: tracking.nonce
		},
		success: function(response) {
			console.log(response);
			if ( response === 'complete' && ( cpt === 'sfwd-lessons' || cpt === 'sfwd-topic' ) ) $('.learndash_mark_complete_button').prop('disabled', false);
			if ( tracking.type === 'watching' || tracking.type === 'listening' ) prev = progress.slice();
		},
		error: function(err){		
			console.log('err', err);
		}
	});
}

// compare arrays
const equalsCheck = (array_a, array_b) => {
	return JSON.stringify(array_a) === JSON.stringify(array_b);
}	
	
});