jQuery(document).ready(function($){

	if ( mediactr_tabledata.rows !== '' ) var rows = JSON.parse(mediactr_tabledata.rows);

	// Initialize DataTable
	var table = $('#datatable').DataTable({
		data: rows,
		language: {
			'paginate': {
				'previous': '',
				'next': ''
			}
		},		
        lengthChange: false,
		info: false,
		columns: [
			{ title: 'Date' },
			{ title: 'CPD Type' },
			{ title: 'CPD Details' },
			{ title: 'CPD Hours' },
			{ title: 'Reflection' }
		]
	});
	
	// Handle date filtering
	$('#date').on('change', function() {
		if ($('#date').val()) {
			var parts = $('#date').val().split('-');
			var filtering = parts[2] + '.' + parts[1] + '.' + parts[0].slice(-2);
			table.column(0).search(filtering).draw();
		}
		else table.column(0).search('').draw();
	});	
	
	// Handle activity filtering
	$('#activity').on('change', function() {
		var searchWord = $('#activity option:selected').text();
		if (searchWord === 'All CPD activities') searchWord = '';
		table.column(1).search(searchWord).draw();
	});	
	
	// Download CSV with filtered
	$('#exportCSV').click(function() {
		var filteredData = table.rows({ filter: 'applied' }).data();  // Get filtered data

		var csvContent = 'data:text/csv;charset=utf-8,';
		csvContent += 'Date;CPD Type;CPD Details;CPD Hours\n';

		filteredData.each(function (valueArray) {
			csvContent += valueArray[0] + ';' + valueArray[1] + ';' + valueArray[2] + ';' + valueArray[3] + '\n';
		});

		var encodedURI = encodeURI(csvContent);
		var link = document.createElement('a');
		link.setAttribute('href', encodedURI);
		link.setAttribute('download', 'filtered_data.csv');
		document.body.appendChild(link);
		link.click();
	});
	
	// open the modal and inject the content
	$('.reflect').on('click', function(e) {
		e.preventDefault();
		
		$('#reflection .msg').text('');		
		
		// copy the content
		$('#reflection h3').text( 'Activity log - ' + $(this).data('title') );
		$('#reflection textarea').val( $(this).data('note') );
		$('#reflection .save').data('rid', $(this).data('rid') );
		
		$('#reflection').toggle();
	});
	
	// close modal
	$('#reflection .modal-footer .cancel').on('click', function(e) {
		e.preventDefault();
		$('#reflection').hide();
	});
	
	// AJAX sending
	$('#reflection .save').on('click', function(e) {
		e.preventDefault();
		jQuery.ajax({
			type: 'POST',
			dataType: 'json',
			url: mediactr_tabledata.ajax_url,
			data: {
				action: 'mediactr_savenote',
				record_id: $('#reflection .save').data('rid'),
				note: $('#reflection textarea').val(),
				nonce: mediactr_tabledata.nonce
			},
			success: function(response) {
				// save message before close the modal
				$('#reflection .msg').text('Comment saved.');
				setTimeout(function() {
					$('#reflection').hide();
					$('#reflection .msg').text('');
				}, 3000);
				
				// change the edited button
				var button = $('[data-rid="' + $('#reflection .save').data('rid') + '"]');
				if ( button.text().includes('Add new') ) button.html( button.html().replace('Add new', 'Edit') );
				button.data('note', response);
			
			}
		});			
		
	});
	
});
