jQuery(document).ready(function($){

// AJAX calendar regenerate	
$('#actualMonth').change(function() {
	const month = $(this).val();
	const selectedOption = $(this).find('option:selected');
	const year = selectedOption.data('year');
	
	jQuery.ajax({
		type: 'POST',
		dataType: 'json',
		url: streakday.ajax_url,
		data: {
			action: 'mediactr_getstreak',
			year: year,
			month: month,
			nonce: streakday.nonce
		},
        success: function(response) {
			console.log(response);
			generateCalendar(parseInt(month)-1, parseInt(year), response);
		}
	});	
});
	
// basic calendar generate	
generateCalendar(null, null, JSON.parse(streakday.stars));	
	
// calendar generate
function generateCalendar(month, year, stars) {
  if ( month === null ) month = new Date().getMonth();
  if ( year === null ) year = new Date().getFullYear();

  const calendarDiv = $('#calendar');
  calendarDiv.empty(); // Clear previous content

  var classOfDay,
    weekDay,
    foundDay;

  // Get the first day of the month and set the date to 1
  const firstDay = new Date(year, month, 1);
  const daysInMonth = new Date(year, month + 1, 0).getDate();

  // Determine the day of the week for the first day of the month (0 = Sunday, 1 = Monday, ..., 6 = Saturday)
  let firstDayOfWeek = firstDay.getDay();
  if (firstDayOfWeek === 0) {
    firstDayOfWeek = 7; // Convert Sunday to 7
  }

  // Create day headers (Mon, Tue, ..., Sun)
  const daysOfWeek = ['M', 'Tu', 'W', 'Th', 'F', 'Sa', 'Su'];
  for (let day of daysOfWeek) {
    calendarDiv.append(`<div class="calendar-day">${day}</div>`);
  }

  // Add empty cells for days before the first day of the month from the previous month
  for (let i = firstDayOfWeek - 2; i >= 0; i--) {
    const prevMonthLastDay = new Date(year, month, 0); // Get the last day of the previous month
    const prevMonthDate = new Date(prevMonthLastDay.getFullYear(), prevMonthLastDay.getMonth(), prevMonthLastDay.getDate() - i);
	const findMonth = parseInt(prevMonthLastDay.getMonth()) + 1; // +1 because JS months starting with 0
    weekDay = prevMonthDate.getDay();
      classOfDay = ( weekDay === 0 || weekDay === 6 ) ? ' weekend' : '';
    if ( stars.length !== 0 ) {
		result = stars.find(star => star[0] === prevMonthDate.getDate() && star[1] === findMonth);
		classOfDay += ( result ) ? ' starlevel' + result[2] : '';		
	}
    calendarDiv.append(`<div class="calendar-day prev-month-day${classOfDay}">${prevMonthDate.getDate()}</div>`);
  }

  // Add the days of the month
  for (let i = 1; i <= daysInMonth; i++) {
	const findMonth = parseInt(month) + 1; // +1 because JS months starting with 0
    weekDay = new Date(year, month, i).getDay();
      classOfDay = ( weekDay === 0 || weekDay === 6 ) ? ' weekend' : '';
    classOfDay += ( new Date().getDate() == i ) ? ' today' : '';
	if ( stars.length !== 0 ) {
		result = stars.find(star => star[0] === i && star[1] === findMonth);
		classOfDay += ( result ) ? ' starlevel' + result[2] : '';		
	}
    calendarDiv.append(`<div class="calendar-day${classOfDay}">${i}</div>`);
  }

  // Fill remaining cells with days from the next month
  const totalCells = 42; // 6 rows and 7 columns
  let remainingCells = totalCells - (firstDayOfWeek - 1) - daysInMonth;
  if ( remainingCells > 6 ) remainingCells = remainingCells - 7;
  for (let i = 1; i <= remainingCells; i++) {
    const nextMonthDate = new Date(year, month + 1, i);
    weekDay = nextMonthDate.getDay();
      classOfDay = ( weekDay === 0 || weekDay === 6 ) ? ' weekend' : '';    
    calendarDiv.append(`<div class="calendar-day next-month-day${classOfDay}">${nextMonthDate.getDate()}</div>`);
  }
}
	
});	