if ( chartdata.stat !== '' ) var dataActivity = JSON.parse(chartdata.stat);
var labels = [];
var datasets = []; 
var colors = [];

for (let i = 0; i < dataActivity.length; i++) {
	switch (dataActivity[i][0]) {
	  case "reading":
		var color = '#C44636';
		break;
	  case "watching":
		var color = '#C47D36';
		break;
	  case "listening":
		var color = '#289244';
		break;
	  case "completion":
		var color = '#246979';
		break;
	  case "quiz":
		var color = '#A42D65';
		break;
	  case "login":
		var color = '#C4BC36';
		break;			
	  default:
		break;
	}
	
	labels.push(dataActivity[i][0]);
	datasets.push(dataActivity[i][1]);
	colors.push(color);
}

const data = {
	labels: labels,
	datasets: [{
		data: datasets,
		backgroundColor: colors,
		borderWidth: 0,
		borderRadius: 25,
		barThickness: 40
	}]
};

const config = {
	type: 'bar',
	data: data,
	options: {
		plugins: {
			legend: {
				display: false
			},
			tooltip: {
				enabled: false
			},
			datalabels: {
				color: '#ffffff',
				display: function(context) {
					return context.dataset.data[context.dataIndex];
				},
				font: {
					weight: 'bold'
				},
				formatter: (value, context) => context.dataset.data[context.dataIndex] + '%'
			}
		},
		indexAxis: 'y',
		scales: {
			x: {
				beginAtZero: true,
				max: 100
			},
			y: {
				display: false
			}
		}
	}
};

Chart.register(ChartDataLabels);
const ctx = document.getElementById('barChart').getContext('2d');
new Chart(ctx, config);