(function () {
    'use strict';

    if (typeof mdihtrebReferrerData === 'undefined') {
        return;
    }

    function getURLParameter(name) {
        var regex = new RegExp('[?&]' + name + '=([^&;]+?)(&|#|;|$)');
        var results = regex.exec(window.location.search) || [null, ''];
        try {
            return decodeURIComponent(results[1].replace(/\+/g, '%20')) || null;
        } catch (e) {
            return null;
        }
    }

    function getReferrer() {
        var ref = getURLParameter('utm_referrer');
        if (!ref) {
            ref = document.referrer || 'direct';
        }
        return ref;
    }

    function cookieSet(name, value, days, path) {
        var expires = '';
        if (days) {
            var date = new Date();
            date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
            expires = '; expires=' + date.toUTCString();
        }
        path = path || '/';
        document.cookie = name + '=' + value + expires + '; path=' + path + '; SameSite=Lax';
    }

    function matchesDomain(ref, domainPattern) {
        if (!domainPattern) {
            return false;
        }
        // treat domainPattern as regex if it contains regex characters
        try {
            var re = new RegExp(domainPattern, 'i');
            return re.test(ref);
        } catch (e) {
            // fallback to simple contains
            return ref.toLowerCase().indexOf(domainPattern.toLowerCase()) !== -1;
        }
    }

    document.addEventListener('DOMContentLoaded', function () {
        var ref = getReferrer();
        var domains = Array.isArray(mdihtrebReferrerData.domains) ? mdihtrebReferrerData.domains : [];
        var matched = domains.some(function (d) {
            return matchesDomain(ref, d);
        });

        if (matched) {
            // set cookie
            cookieSet('mdi_syndicated_ref', '1', mdihtrebReferrerData.cookie_lifetime, mdihtrebReferrerData.cookie_path);

            // hide elements
            if (mdihtrebReferrerData.element_selector) {
                try {
                    var els = document.querySelectorAll(mdihtrebReferrerData.element_selector);
                    Array.prototype.forEach.call(els, function (el) {
                        el.style.display = 'none';
                    });
                } catch (e) {
                    // invalid selector — fail silently
                    console.error('MDI: invalid selector', e);
                }
            }

            // redirect if needed (do after slight delay to allow any DOM changes)
            if (mdihtrebReferrerData.redirect_url) {
                setTimeout(function () {
                    window.location.href = mdihtrebReferrerData.redirect_url;
                }, 10);
            }
        }
    });
})();
