<?php

namespace MbChallengeResponseAuthentication;

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       -
 * @since      1.0.0
 *
 * @package    Mb_Challenge_Response_Authentication
 * @subpackage Mb_Challenge_Response_Authentication/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Mb_Challenge_Response_Authentication
 * @subpackage Mb_Challenge_Response_Authentication/includes
 * @author     Yeora
 */
class Mb_Challenge_Response_Authentication_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain(): void {

		load_plugin_textdomain(
			'mb-challenge-response-authentication',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}


}
