<?php
/**
 * Plugin Name:          Matcha Extra
 * Plugin URI:           https://wpmatcha.com/matcha-extra
 * Description:          Matcha Extra plugin provides enhanced functionality and extra settings for WordPress themes.
 * Version:              1.0.3
 * Author:               WP Matcha
 * Author URI:           https://wpmatcha.com/
 * Tested up to:         6.9
 * Requires:             5.0 or higher
 * License:              GPL v2 or later
 * License URI:          http://www.gnu.org/licenses/gpl-2.0.html
 * Requires PHP:         7.4
 * Text Domain:          matcha-extra
 * Domain Path:          /languages
 *
 * Matcha Extra is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * any later version.
 *
 * Matcha Extra is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Matcha Extra. If not, see <http://www.gnu.org/licenses/gpl-2.0.html>.
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
define('MATCHA_EXTRA_VERSION', '1.0.3');
define('MATCHA_EXTRA_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('MATCHA_EXTRA_PLUGIN_URL', plugin_dir_url(__FILE__));
define('MATCHA_EXTRA_PLUGIN_FILE', __FILE__);

if (!function_exists('matcha_extra_init')) {
    function matcha_extra_init() {
        $activate_theme_data = wp_get_theme(); // getting current theme data.
        $activate_theme = $activate_theme_data->name;

        if ('Pawfect' == $activate_theme || 'pawfect' == $activate_theme_data->get('Template')) {
            require MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/pawfect.php';
        }
    }
    add_action('init', 'matcha_extra_init');
}

// on plugin activation.
function matcha_extra_activate() {
    $activate_theme_data = wp_get_theme(); // getting current theme data.
    $activate_theme = $activate_theme_data->name;
    if ('Pawfect' == $activate_theme || 'pawfect' == $activate_theme_data->get('Template')) {
        require_once MATCHA_EXTRA_PLUGIN_DIR . 'inc/matcha-extra-activator.php';
        Matcha_Extra_Plugin_Activator::activate();
    }
}
register_activation_hook(__FILE__, 'matcha_extra_activate');

// on plugin deactivation.
function matcha_extra_deactivate() {
    flush_rewrite_rules();
}
register_deactivation_hook(__FILE__, 'matcha_extra_deactivate');