<?php
/**
 * Template Name: Front Page (Matcha Extra)
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

get_header(); ?>

<?php
/**
 * Dynamic Front Page Sections with Pawfect Companion
 *
 * Load sections based on the Homepage Layout Manager.
 * This allows users to control sections via the drag-and-drop interface.
 */

// Get enabled sections in order from the Layout Manager
if (class_exists('Helpers')) {
    $enabled_sections = Helpers::get_enabled_frontpage_sections();
} else {
    // Fallback if Helpers class is not available
    $front_page_data = get_theme_mod('front_page_data', 'hero_slider,press_mentions,feature_highlight,why_choose,portfolio,featured_collection,testimonial,mission,pet_shop,promo_timer,crafted,blog,promo_banner,instagram,cta,woocommerce');
    $enabled_sections = array_filter(explode(',', $front_page_data));
}

// Define sections with their companion plugin template paths
$sections_map = [
    'hero_slider' => [
        'template' => MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-hero-slider.php',
        'fallback' => 'template-parts/front-page/hero-slider',
    ],
    'press_mentions' => [
        'template' => MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-press-mentions.php',
        'fallback' => 'template-parts/front-page/press-mentions',
    ],
    'feature_highlight' => [
        'template' => MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-feature-highlight.php',
        'fallback' => 'template-parts/front-page/feature-highlight',
    ],
    'why_choose' => [
        'template' => MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-why-choose.php',
        'fallback' => 'template-parts/front-page/why-choose',
    ],
    'portfolio' => [
        'template' => MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-portfolio.php',
        'fallback' => 'template-parts/front-page/section-category-highlights',
    ],
    'featured_collection' => [
        'template' => MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-featured-collection.php',
        'fallback' => 'template-parts/front-page/featured-collection',
    ],
    'testimonial' => [
        'template' => MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-testimonial.php',
        'fallback' => 'template-parts/front-page/index-testimonial',
    ],
    'mission' => [
        'template' => MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-mission.php',
        'fallback' => 'template-parts/front-page/index-mission',
    ],
    'pet_shop' => [
        'template' => MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-pet-shop.php',
        'fallback' => 'template-parts/front-page/index-shop-by-pet',
    ],
    'promo_timer' => [
        'template' => MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-promo-timer.php',
        'fallback' => 'template-parts/front-page/index-promo-timer',
    ],
    'crafted' => [
        'template' => MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-crafted.php',
        'fallback' => 'template-parts/front-page/index-crafted',
    ],
    'blog' => [
        'template' => MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-blog.php',
        'fallback' => 'template-parts/front-page/index-blog',
    ],
    'promo_banner' => [
        'template' => MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-promo-banner.php',
        'fallback' => 'template-parts/front-page/index-promo-banner',
    ],
    'instagram' => [
        'template' => MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-instagram.php',
        'fallback' => 'template-parts/front-page/index-instagram',
    ],
    'cta' => [
        'template' => MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-cta.php',
        'fallback' => 'template-parts/front-page/cta',
    ],
    'woocommerce' => [
        'template' => MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-woocommerce.php',
        'fallback' => 'template-parts/front-page/section-woocommerce-featured',
    ],
];

// Loop through enabled sections and load their template parts
foreach ($enabled_sections as $section_id) {
    // Skip if section doesn't exist in our mapping
    if (!isset($sections_map[$section_id])) {
        continue;
    }

    $section_data = $sections_map[$section_id];
    $companion_template = $section_data['template'];
    $fallback_template = $section_data['fallback'];

    // Load the companion plugin template if it exists
    if (file_exists($companion_template)) {
        include $companion_template;
    } elseif (locate_template($fallback_template . '.php')) {
        // Fallback to theme template
        get_template_part($fallback_template);
    }
}
?>

<?php get_footer(); ?>
