<?php
/**
 * Pawfect Theme Integration
 *
 * @package Matcha_Extra
 * @since 1.0.0
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

// Different Themes.
$activate_theme_data = wp_get_theme(); // getting current theme data.
$activate_theme = $activate_theme_data->name;

// Customizer Sections.
require MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/customizer/matcha-extra-customizer.php';
require MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/customizer/matcha-extra-customizer-options.php';
require MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/customizer/matcha-extra-customizer-default.php';

// Wishlist Shortcode - Moved from theme to plugin (WordPress best practice)
require MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/wishlist-shortcode.php';

// Wishlist Database Functions - Database operations moved from theme to plugin
// per WordPress.org theme review requirements
require MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/wishlist-functions.php';

// Frontpage Sections.
if (!function_exists('matcha_extra_frontpage_sections')) :
    function matcha_extra_frontpage_sections() {
        // Different Themes.
        $activate_theme_data = wp_get_theme(); // getting current theme data.
        $activate_theme = $activate_theme_data->name;

        require MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-hero-slider.php';
        require MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-press-mentions.php';
        require MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-feature-highlight.php';
        require MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-why-choose.php';
        require MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-portfolio.php';
        require MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-featured-collection.php';
        require MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-testimonial.php';
        require MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-mission.php';
        require MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-pet-shop.php';
        require MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-promo-timer.php';
        require MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-crafted.php';
        require MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-blog.php';
        require MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-promo-banner.php';
        require MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-instagram.php';
        require MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-cta.php';
        require MATCHA_EXTRA_PLUGIN_DIR . 'inc/pawfect/front-page/matcha-extra-woocommerce.php';
    }
    add_action('matcha_extra_frontpage', 'matcha_extra_frontpage_sections');
endif;

// Hook into Pawfect theme's front-page loading system
if (!function_exists('matcha_extra_integrate_sections')) {
    function matcha_extra_integrate_sections() {
        // Enqueue companion styles and scripts
        add_action('wp_enqueue_scripts', 'matcha_extra_enqueue_assets');

        // Add companion-specific functionality without overriding theme templates
        // The plugin adds customizer options and enhances existing functionality
    }
    add_action('init', 'matcha_extra_integrate_sections');
}

// Enqueue companion assets
if (!function_exists('matcha_extra_enqueue_assets')) {
    function matcha_extra_enqueue_assets() {
        // Only enqueue on front-page
        if (is_front_page()) {
            // Note: Swiper CSS/JS should be handled by the theme
            // The theme should enqueue Swiper if it's needed for the slider functionality

            // Enqueue companion styles
            wp_enqueue_style('matcha-extra-style', MATCHA_EXTRA_PLUGIN_URL . 'inc/pawfect/css/companion-style.css', array(), MATCHA_EXTRA_VERSION);
        }
    }
}

// Add admin notice for successful activation
if (!function_exists('matcha_extra_admin_notice')) {
    function matcha_extra_admin_notice() {
        if (get_transient('matcha_extra_activated_notice')) {
            ?>
            <div class="notice notice-success is-dismissible">
                <p>
                    <strong><?php esc_html_e('✨ Matcha Extra Activated!', 'matcha-extra'); ?></strong><br>
                    <?php esc_html_e('Enhanced front-page sections are now available in the Customizer. Go to', 'matcha-extra'); ?>
                    <a href="<?php echo esc_url(admin_url('customize.php')); ?>"><?php esc_html_e('Appearance → Customize', 'matcha-extra'); ?></a>
                    <?php esc_html_e('to access the new "Frontpage Sections" panel.', 'matcha-extra'); ?>
                </p>
            </div>
            <?php
            delete_transient('matcha_extra_activated_notice');
        }
    }
    add_action('admin_notices', 'matcha_extra_admin_notice');
}
