<?php
/**
 * Testimonial Section
 *
 * @package Matcha_Extra
 * @since 1.0.0
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

$activate_theme_data = wp_get_theme();
$activate_theme = $activate_theme_data->name;

$section_name = str_replace('-', '_', basename(__FILE__, '.php'));
$section_name = str_replace('matcha_extra_', '', $section_name);

$enabled_setting = "pawfect_${section_name}_enabled";
$disabled_setting = "pawfect_${section_name}_disabled";

// Check if section is enabled (different sections use different settings)
$is_enabled = get_theme_mod($enabled_setting, true);
$is_disabled = get_theme_mod($disabled_setting, false);

if ($is_enabled == true || $is_disabled == false) :
    // Load the original theme template part if it exists
    $template_name = str_replace('_', '-', $section_name);
    if (locate_template("template-parts/front-page/${template_name}.php")) {
        get_template_part("template-parts/front-page/${template_name}");
    } elseif (locate_template("template-parts/front-page/index-${template_name}.php")) {
        get_template_part("template-parts/front-page/index-${template_name}");
    } elseif (locate_template("template-parts/front-page/section-${template_name}.php")) {
        get_template_part("template-parts/front-page/section-${template_name}");
    }
endif;
?>
