<?php
/**
 * Hero Slider Section
 *
 * @package Matcha_Extra
 * @since 1.0.0
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

$activate_theme_data = wp_get_theme(); // getting current theme data.
$activate_theme = $activate_theme_data->name;

$pawfect_hero_slider_enabled = get_theme_mod('pawfect_hero_slider_enabled', true);
if ($pawfect_hero_slider_enabled == true) :

    // Slider option settings
    $pawfect_hero_slider_autoplay_disable = get_theme_mod('pawfect_hero_slider_autoplay_disable', true);
    $pawfect_hero_slider_animation_speed = get_theme_mod('pawfect_hero_slider_animation_speed', 4000);
    $pawfect_hero_slider_content = get_theme_mod('pawfect_hero_slider_content');

    ?>
    <!-- Hero Slider Section -->
    <section class="pawfect-hero-slider pawfect-relative pawfect-overflow-hidden">
        <div id="pawfect-hero-slider" class="swiper-container">
            <div class="swiper-wrapper">
                <?php
                $slider_content = json_decode($pawfect_hero_slider_content);
                if ($slider_content != '') {
                    foreach ($slider_content as $slide_item) {
                        $title = !empty($slide_item->title) ? $slide_item->title : '';
                        $subtitle = !empty($slide_item->subtitle) ? $slide_item->subtitle : '';
                        $text = !empty($slide_item->text) ? $slide_item->text : '';
                        $button_text = !empty($slide_item->button_text) ? $slide_item->button_text : '';
                        $link = !empty($slide_item->link) ? $slide_item->link : '#';
                        $image_url = !empty($slide_item->image_url) ? $slide_item->image_url : '';
                        $open_new_tab = !empty($slide_item->open_new_tab) ? $slide_item->open_new_tab : 'no';
                        ?>
                        <div class="swiper-slide pawfect-relative pawfect-flex pawfect-items-center pawfect-justify-center pawfect-min-h-screen pawfect-bg-cover pawfect-bg-center" 
                             style="background-image: url('<?php echo esc_url($image_url); ?>');">
                            <div class="pawfect-absolute pawfect-inset-0 pawfect-bg-black pawfect-bg-opacity-40"></div>
                            <div class="pawfect-container pawfect-mx-auto pawfect-px-4 pawfect-relative pawfect-z-10">
                                <div class="pawfect-text-center pawfect-text-white">
                                    <?php if ($subtitle) : ?>
                                        <p class="pawfect-text-lg pawfect-mb-4 pawfect-opacity-90"><?php echo esc_html($subtitle); ?></p>
                                    <?php endif; ?>
                                    <?php if ($title) : ?>
                                        <h1 class="pawfect-text-4xl md:pawfect-text-6xl pawfect-font-bold pawfect-mb-6 pawfect-leading-tight">
                                            <?php echo wp_kses_post($title); ?>
                                        </h1>
                                    <?php endif; ?>
                                    <?php if ($text) : ?>
                                        <p class="pawfect-text-xl pawfect-mb-8 pawfect-max-w-2xl pawfect-mx-auto pawfect-opacity-90">
                                            <?php echo wp_kses_post($text); ?>
                                        </p>
                                    <?php endif; ?>
                                    <?php if ($button_text) : ?>
                                        <div class="pawfect-mt-8">
                                            <a href="<?php echo esc_url($link); ?>" 
                                               class="pawfect-inline-block pawfect-bg-primary pawfect-text-white pawfect-px-8 pawfect-py-4 pawfect-rounded-full pawfect-font-semibold pawfect-text-lg pawfect-transition-all pawfect-duration-300 hover:pawfect-bg-opacity-90 hover:pawfect-transform hover:pawfect-scale-105"
                                               <?php echo ($open_new_tab == 'yes') ? 'target="_blank"' : ''; ?>>
                                                <?php echo esc_html($button_text); ?>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <?php
                    }
                } else {
                    // Default slides if no content is set
                    ?>
                    <div class="swiper-slide pawfect-relative pawfect-flex pawfect-items-center pawfect-justify-center pawfect-min-h-screen pawfect-bg-cover pawfect-bg-center" 
                         style="background-image: url('<?php echo esc_url(MATCHA_EXTRA_PLUGIN_URL); ?>inc/pawfect/img/slider/slide1.jpg');">
                        <div class="pawfect-absolute pawfect-inset-0 pawfect-bg-black pawfect-bg-opacity-40"></div>
                        <div class="pawfect-container pawfect-mx-auto pawfect-px-4 pawfect-relative pawfect-z-10">
                            <div class="pawfect-text-center pawfect-text-white">
                                <p class="pawfect-text-lg pawfect-mb-4 pawfect-opacity-90"><?php esc_html_e('Everything Your Pet Needs', 'matcha-extra'); ?></p>
                                <h1 class="pawfect-text-4xl md:pawfect-text-6xl pawfect-font-bold pawfect-mb-6 pawfect-leading-tight">
                                    <?php esc_html_e('Welcome to Pawfect', 'matcha-extra'); ?>
                                </h1>
                                <p class="pawfect-text-xl pawfect-mb-8 pawfect-max-w-2xl pawfect-mx-auto pawfect-opacity-90">
                                    <?php esc_html_e('Discover premium pet products and services designed to keep your furry friends happy and healthy.', 'matcha-extra'); ?>
                                </p>
                                <div class="pawfect-mt-8">
                                    <a href="#" class="pawfect-inline-block pawfect-bg-primary pawfect-text-white pawfect-px-8 pawfect-py-4 pawfect-rounded-full pawfect-font-semibold pawfect-text-lg pawfect-transition-all pawfect-duration-300 hover:pawfect-bg-opacity-90 hover:pawfect-transform hover:pawfect-scale-105">
                                        <?php esc_html_e('Shop Now', 'matcha-extra'); ?>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="swiper-slide pawfect-relative pawfect-flex pawfect-items-center pawfect-justify-center pawfect-min-h-screen pawfect-bg-cover pawfect-bg-center" 
                         style="background-image: url('<?php echo esc_url(MATCHA_EXTRA_PLUGIN_URL); ?>inc/pawfect/img/slider/slide2.jpg');">
                        <div class="pawfect-absolute pawfect-inset-0 pawfect-bg-black pawfect-bg-opacity-40"></div>
                        <div class="pawfect-container pawfect-mx-auto pawfect-px-4 pawfect-relative pawfect-z-10">
                            <div class="pawfect-text-center pawfect-text-white">
                                <p class="pawfect-text-lg pawfect-mb-4 pawfect-opacity-90"><?php esc_html_e('Quality You Can Trust', 'matcha-extra'); ?></p>
                                <h1 class="pawfect-text-4xl md:pawfect-text-6xl pawfect-font-bold pawfect-mb-6 pawfect-leading-tight">
                                    <?php esc_html_e('Premium Pet Care', 'matcha-extra'); ?>
                                </h1>
                                <p class="pawfect-text-xl pawfect-mb-8 pawfect-max-w-2xl pawfect-mx-auto pawfect-opacity-90">
                                    <?php esc_html_e('From nutritious food to comfortable accessories, we provide everything your pet deserves.', 'matcha-extra'); ?>
                                </p>
                                <div class="pawfect-mt-8">
                                    <a href="#" class="pawfect-inline-block pawfect-bg-primary pawfect-text-white pawfect-px-8 pawfect-py-4 pawfect-rounded-full pawfect-font-semibold pawfect-text-lg pawfect-transition-all pawfect-duration-300 hover:pawfect-bg-opacity-90 hover:pawfect-transform hover:pawfect-scale-105">
                                        <?php esc_html_e('Learn More', 'matcha-extra'); ?>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                }
                ?>
            </div>
            
            <!-- Navigation -->
            <div class="swiper-button-next pawfect-text-white"></div>
            <div class="swiper-button-prev pawfect-text-white"></div>
            
            <!-- Pagination -->
            <div class="swiper-pagination"></div>
        </div>
    </section>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var heroSlider = new Swiper('#pawfect-hero-slider', {
                loop: true,
                <?php if ($pawfect_hero_slider_autoplay_disable) : ?>
                autoplay: {
                    delay: <?php echo esc_js($pawfect_hero_slider_animation_speed); ?>,
                    disableOnInteraction: false,
                },
                <?php endif; ?>
                speed: 800,
                effect: 'fade',
                fadeEffect: {
                    crossFade: true
                },
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev',
                },
                pagination: {
                    el: '.swiper-pagination',
                    clickable: true,
                },
            });
        });
    </script>
    <?php
endif;
?>
<!-- /Hero Slider Section -->
<div class="pawfect-clearfix"></div>
