<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

$activate_theme_data = wp_get_theme(); // getting current theme data.
$activate_theme = $activate_theme_data->name;

$pawfect_cta_enabled = get_theme_mod('pawfect_cta_enabled', true);
if ($pawfect_cta_enabled == true) :

    $pawfect_cta_title = get_theme_mod('pawfect_cta_title', __('Ready to Give Your Pet the Best?', 'matcha-extra'));
    $pawfect_cta_desc = get_theme_mod('pawfect_cta_desc', __('Join thousands of happy pet parents who trust us with their furry family members.', 'matcha-extra'));
    $pawfect_cta_button_text = get_theme_mod('pawfect_cta_button_text', __('Shop Now', 'matcha-extra'));
    $pawfect_cta_button_url = get_theme_mod('pawfect_cta_button_url', '#');

    ?>
    <!-- CTA Section -->
    <section class="pawfect-cta-section pawfect-py-20 pawfect-bg-primary pawfect-text-white pawfect-relative pawfect-overflow-hidden">
        <!-- Background Pattern -->
        <div class="pawfect-absolute pawfect-inset-0 pawfect-opacity-10">
            <svg class="pawfect-w-full pawfect-h-full" viewBox="0 0 100 100" xmlns="http://www.w3.org/2000/svg">
                <defs>
                    <pattern id="paw-pattern" x="0" y="0" width="20" height="20" patternUnits="userSpaceOnUse">
                        <g fill="currentColor">
                            <circle cx="5" cy="5" r="1"/>
                            <circle cx="15" cy="5" r="1"/>
                            <circle cx="10" cy="10" r="1.5"/>
                            <ellipse cx="10" cy="15" rx="2" ry="1.5"/>
                        </g>
                    </pattern>
                </defs>
                <rect width="100%" height="100%" fill="url(#paw-pattern)"/>
            </svg>
        </div>

        <div class="pawfect-container pawfect-mx-auto pawfect-px-4 pawfect-relative pawfect-z-10">
            <div class="pawfect-text-center pawfect-max-w-4xl pawfect-mx-auto">
                <?php if ($pawfect_cta_title) : ?>
                    <h2 class="pawfect-text-3xl md:pawfect-text-5xl pawfect-font-bold pawfect-mb-6 pawfect-leading-tight">
                        <?php echo wp_kses_post($pawfect_cta_title); ?>
                    </h2>
                <?php endif; ?>

                <?php if ($pawfect_cta_desc) : ?>
                    <p class="pawfect-text-lg md:pawfect-text-xl pawfect-mb-8 pawfect-opacity-90 pawfect-max-w-2xl pawfect-mx-auto">
                        <?php echo wp_kses_post($pawfect_cta_desc); ?>
                    </p>
                <?php endif; ?>

                <?php if ($pawfect_cta_button_text) : ?>
                    <div class="pawfect-mt-8">
                        <a href="<?php echo esc_url($pawfect_cta_button_url); ?>" 
                           class="pawfect-inline-block pawfect-bg-white pawfect-text-primary pawfect-px-8 pawfect-py-4 pawfect-rounded-full pawfect-font-semibold pawfect-text-lg pawfect-transition-all pawfect-duration-300 hover:pawfect-bg-opacity-90 hover:pawfect-transform hover:pawfect-scale-105 pawfect-shadow-lg">
                            <?php echo esc_html($pawfect_cta_button_text); ?>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Decorative Elements -->
        <div class="pawfect-absolute pawfect-top-10 pawfect-left-10 pawfect-opacity-20">
            <svg class="pawfect-w-16 pawfect-h-16" fill="currentColor" viewBox="0 0 24 24">
                <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/>
            </svg>
        </div>
        
        <div class="pawfect-absolute pawfect-bottom-10 pawfect-right-10 pawfect-opacity-20">
            <svg class="pawfect-w-20 pawfect-h-20" fill="currentColor" viewBox="0 0 24 24">
                <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
            </svg>
        </div>
    </section>
    <?php
endif;
?>
<!-- /CTA Section -->
<div class="pawfect-clearfix"></div>
