<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

/**
 * Customizer functionality for Pawfect Companion
 *
 * @package matcha-extra
 */

// Customizer Repeater Control
if (class_exists('WP_Customize_Control')) {
    class Matcha_Extra_Repeater_Control extends WP_Customize_Control {
        public $type = 'repeater';
        public $fields = array();

        public function render_content() {
            $values = json_decode($this->value());
            ?>
            <label>
                <span class="customize-control-title"><?php echo esc_html($this->label); ?></span>
                <div class="repeater-wrapper">
                    <div class="repeater-items">
                        <?php if (!empty($values)) : ?>
                            <?php foreach ($values as $index => $item) : ?>
                                <div class="repeater-item">
                                    <div class="repeater-item-header">
                                        <span class="repeater-item-title"><?php echo isset($item->title) ? esc_html($item->title) : 'Item ' . esc_html($index + 1); ?></span>
                                        <button type="button" class="repeater-item-toggle">Toggle</button>
                                        <button type="button" class="repeater-item-remove">Remove</button>
                                    </div>
                                    <div class="repeater-item-content">
                                        <?php foreach ($this->fields as $field_key => $field) : ?>
                                            <div class="repeater-field">
                                                <label><?php echo esc_html($field['label']); ?></label>
                                                <?php if ($field['type'] === 'text') : ?>
                                                    <input type="text" data-field="<?php echo esc_attr($field_key); ?>" value="<?php echo isset($item->$field_key) ? esc_attr($item->$field_key) : ''; ?>" />
                                                <?php elseif ($field['type'] === 'textarea') : ?>
                                                    <textarea data-field="<?php echo esc_attr($field_key); ?>"><?php echo isset($item->$field_key) ? esc_textarea($item->$field_key) : ''; ?></textarea>
                                                <?php elseif ($field['type'] === 'url') : ?>
                                                    <input type="url" data-field="<?php echo esc_attr($field_key); ?>" value="<?php echo isset($item->$field_key) ? esc_url($item->$field_key) : ''; ?>" />
                                                <?php elseif ($field['type'] === 'upload') : ?>
                                                    <div class="upload-field">
                                                        <input type="hidden" data-field="<?php echo esc_attr($field_key); ?>" value="<?php echo isset($item->$field_key) ? esc_url($item->$field_key) : ''; ?>" />
                                                        <button type="button" class="upload-button">Choose Image</button>
                                                        <button type="button" class="remove-image" style="<?php echo !isset($item->$field_key) || empty($item->$field_key) ? 'display:none;' : ''; ?>">Remove</button>
                                                        <div class="image-preview">
                                                            <?php if (isset($item->$field_key) && !empty($item->$field_key)) : ?>
                                                                <img src="<?php echo esc_url($item->$field_key); ?>" style="max-width: 100px; height: auto;" />
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                    <button type="button" class="repeater-add-item">Add Item</button>
                </div>
                <input type="hidden" <?php $this->link(); ?> value="<?php echo esc_attr($this->value()); ?>" />
            </label>
            <?php
        }

        public function enqueue() {
            wp_enqueue_media();
            wp_enqueue_script('matcha-extra-customizer', MATCHA_EXTRA_PLUGIN_URL . 'inc/pawfect/customizer/js/customizer.js', array('jquery', 'customize-controls'), MATCHA_EXTRA_VERSION, true);
            wp_enqueue_style('matcha-extra-customizer', MATCHA_EXTRA_PLUGIN_URL . 'inc/pawfect/customizer/css/customizer.css', array(), MATCHA_EXTRA_VERSION);
        }
    }
}

// Sanitization functions
if (!function_exists('matcha_extra_sanitize_text')) {
    function matcha_extra_sanitize_text($input) {
        return sanitize_text_field($input);
    }
}

if (!function_exists('matcha_extra_sanitize_textarea')) {
    function matcha_extra_sanitize_textarea($input) {
        return sanitize_textarea_field($input);
    }
}

if (!function_exists('matcha_extra_sanitize_url')) {
    function matcha_extra_sanitize_url($input) {
        return esc_url_raw($input);
    }
}

if (!function_exists('matcha_extra_sanitize_checkbox')) {
    function matcha_extra_sanitize_checkbox($input) {
        return (bool) $input;
    }
}

if (!function_exists('matcha_extra_sanitize_repeater')) {
    function matcha_extra_sanitize_repeater($input) {
        $input_decoded = json_decode($input, true);
        if (!empty($input_decoded)) {
            foreach ($input_decoded as $index => $item) {
                foreach ($item as $key => $value) {
                    $input_decoded[$index][$key] = sanitize_text_field($value);
                }
            }
            return json_encode($input_decoded);
        }
        return $input;
    }
}
